/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.obsproject;

import alma.obsprep.bo.obsproject.ObservatoryGoalTargetParameters;
import alma.obsprep.guiutil.mvc.InvalidCoordException;
import alma.obsprep.guiutil.mvc.OutOfRangeException;
import alma.obsprep.util.Convert;
import alma.valuetypes.SkyCoordinates;
import alma.valuetypes.Speed;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class ObservatoryGoalTargetParametersTableModel
extends AbstractTableModel {
    private final List<ObservatoryGoalTargetParameters> targets = new ArrayList<ObservatoryGoalTargetParameters>();

    public ObservatoryGoalTargetParameters get(int n) {
        if (n < 0 || n >= this.targets.size()) {
            return null;
        }
        return this.targets.get(n);
    }

    public int indexOf(ObservatoryGoalTargetParameters observatoryGoalTargetParameters) {
        return this.targets.indexOf(observatoryGoalTargetParameters);
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public int getRowCount() {
        return this.targets.size();
    }

    @Override
    public String getColumnName(int n) {
        switch (n) {
            case 0: {
                return "Source Name";
            }
            case 1: {
                return "RA";
            }
            case 2: {
                return "Dec";
            }
            case 3: {
                return "Source Velocity (km/s)";
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        ObservatoryGoalTargetParameters observatoryGoalTargetParameters = this.targets.get(n);
        return this.getColumnValue(observatoryGoalTargetParameters, n2);
    }

    public Object getColumnValue(ObservatoryGoalTargetParameters observatoryGoalTargetParameters, int n) {
        switch (n) {
            case 0: {
                return observatoryGoalTargetParameters.getSourceName();
            }
            case 1: {
                return this.getHms(observatoryGoalTargetParameters.getSourceCoordinates());
            }
            case 2: {
                return this.getDms(observatoryGoalTargetParameters.getSourceCoordinates());
            }
            case 3: {
                return observatoryGoalTargetParameters.getSourceVelocity().getCenterVelocity().getContentInUnits(Speed.UNIT_KM_S);
            }
        }
        throw new IllegalStateException();
    }

    public void setTargets(Collection<ObservatoryGoalTargetParameters> collection) {
        if (collection != null) {
            this.targets.clear();
            this.targets.addAll(collection);
            this.fireTableStructureChanged();
            this.fireTableDataChanged();
        }
    }

    private String getHms(SkyCoordinates skyCoordinates) {
        try {
            double d = skyCoordinates.getICRSSkyCoordinates().getLongitude().getContentInDeg();
            return Convert.degToHHMMSS(d);
        }
        catch (InvalidCoordException | OutOfRangeException exception) {
            return "N/A";
        }
    }

    private String getDms(SkyCoordinates skyCoordinates) {
        try {
            double d = skyCoordinates.getICRSSkyCoordinates().getLatitude().getContentInDeg();
            return Convert.degToDDMMSS(d);
        }
        catch (InvalidCoordException | OutOfRangeException exception) {
            return "N/A";
        }
    }
}

