/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.jointproposals;

import alma.hla.runtime.obsprep.util.Log;
import alma.observatorycharacteristics.policies.AlmaPolicies;
import alma.obsprep.bo.obsproposal.JointProposal;
import alma.obsprep.bo.obsproposal.JointProposalPartner;
import alma.obsprep.guiutil.ScrollWhenFocusedPane;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.widgets.OTButtonGroup;
import alma.obsprep.guiutil.mvc.widgets.OTTextArea;
import alma.obsprep.ot.boEditors.ComponentCollection;
import alma.obsprep.ot.boEditors.EditorWithGridBagLayout;
import alma.obsprep.ot.editors.jointproposals.JointProposalTable;
import alma.obsprep.ot.editors.jointproposals.JointProposalTableModel;
import alma.obsprep.ot.editors.jointproposals.PartnerJustification;
import alma.obsprep.ot.gui.toplevel.InitServices;
import alma.obsprep.ot.models.obsproject.JointProposalModel;
import alma.obsprep.util.GUIUtilities;
import alma.valuetypes.Time;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

public class JointProposalEditor
extends EditorWithGridBagLayout {
    private final List<PartnerJustification> partnerJustifications = new ArrayList<PartnerJustification>();
    public static final FieldID IS_JOINT_PROPOSAL_FID = new FieldID("JointProposalEditor.isJointProposal");
    public static final FieldID JOINT_PROPOSAL_TYPE_FID = new FieldID("JointProposalEditor.jointProposalType");
    public static final FieldID IS_JOINT_PROPOSAL_TABLE_FID = new FieldID("JointProposalEditor.tableUpdate");
    public static final FieldID IS_JOINT_PROPOSAL_EDITABLE_FID = new FieldID("JointProposalEditor.isJointProposalsPIEditable");
    private JointProposalTableModel jointProposalTableModel;
    private JointProposalTable jointProposalTable;
    private final JointProposalModel jointProposalModel;
    private JPanel jointProposalPanel;
    private JPanel jointProposalJustificationPanel;
    private JButton removePartnerObservatoryButton;

    @Override
    protected void build() {
        super.build("Joint Proposals");
    }

    private JPanel createJustificationUIComponents() {
        this.jointProposalJustificationPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridy = 0;
        this.jointProposalJustificationPanel.setLayout(gridBagLayout);
        for (int i = 0; i < AlmaPolicies.getInstance().getKnownPartnerObservatories().length; ++i) {
            GridBagLayout gridBagLayout2 = new GridBagLayout();
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.anchor = 17;
            gridBagConstraints2.gridy = 0;
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.insets = new Insets(5, 0, 5, 0);
            JPanel jPanel = new JPanel(gridBagLayout2);
            FieldID fieldID = new FieldID("JointPartnerJustification" + i);
            JLabel jLabel = new JLabel("Justification for partner");
            this.addComponent(jPanel, gridBagLayout2, gridBagConstraints2, jLabel);
            OTTextArea oTTextArea = this.addOTTextArea(jPanel, gridBagLayout2, gridBagConstraints2, fieldID, 200, 75, "", "Enter a justification of selecting this partner", true);
            oTTextArea.setPreferredSize(665, 120);
            this.addComponent(jPanel, gridBagLayout2, gridBagConstraints2, oTTextArea);
            this.addComponent(this.jointProposalJustificationPanel, gridBagLayout, gridBagConstraints, jPanel);
            PartnerJustification.PartnerJustificationBuilder partnerJustificationBuilder = new PartnerJustification.PartnerJustificationBuilder();
            PartnerJustification partnerJustification = partnerJustificationBuilder.justificationPanel(jPanel).justificationFID(fieldID).index(i).label(jLabel).textArea(oTTextArea).build();
            this.partnerJustifications.add(partnerJustification);
        }
        return this.jointProposalJustificationPanel;
    }

    private void createJointProposalMainEditorPanel(@NonNull JPanel jPanel, @NonNull GridBagLayout gridBagLayout, @NonNull GridBagConstraints gridBagConstraints) {
        if (jPanel == null) {
            throw new NullPointerException("panelToAddTo is marked non-null but is null");
        }
        if (gridBagLayout == null) {
            throw new NullPointerException("layout is marked non-null but is null");
        }
        if (gridBagConstraints == null) {
            throw new NullPointerException("constraints is marked non-null but is null");
        }
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(0, 0, 0));
        List list = Stream.of(JointProposal.getKnownJointProposalTypeList()).map(string -> StringUtils.capitalize((String)StringUtils.lowerCase((String)string))).collect(Collectors.toList());
        OTButtonGroup oTButtonGroup = this.makeOTButtonGroup(JOINT_PROPOSAL_TYPE_FID, (String[])list.stream().toArray(String[]::new), "Indicate the type of the joint proposal");
        jPanel2.add(new JLabel("Type of Joint Proposal       "));
        jPanel2.add(oTButtonGroup);
        this.addComponent(jPanel, gridBagLayout, gridBagConstraints, jPanel2);
        ScrollWhenFocusedPane scrollWhenFocusedPane = new ScrollWhenFocusedPane();
        this.jointProposalTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        scrollWhenFocusedPane.setViewportView(this.jointProposalTable);
        this.addComponent(jPanel, gridBagLayout, gridBagConstraints, scrollWhenFocusedPane);
        JButton jButton = new JButton("Add Partner Observatory");
        jButton.addActionListener(this::addObservatoryButtonActionPerformed);
        this.removePartnerObservatoryButton = new JButton("Remove Partner Observatory");
        this.removePartnerObservatoryButton.addActionListener(this::removeObservatoryButtonActionPerformed);
        ComponentCollection componentCollection = new ComponentCollection();
        componentCollection.remember(jButton, this.removePartnerObservatoryButton);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 20, 0, 3);
        this.addComponentArray((JComponent)jPanel, gridBagLayout, gridBagConstraints, componentCollection, false);
    }

    public JointProposalEditor(@NonNull JointProposalModel jointProposalModel) {
        if (jointProposalModel == null) {
            throw new NullPointerException("jointProposalModel is marked non-null but is null");
        }
        this.jointProposalModel = jointProposalModel;
        this.setModel(jointProposalModel, true);
        jointProposalModel.subscribe(this);
        this.build();
    }

    @Override
    protected void addComponents(String string) {
        this.jointProposalTableModel = new JointProposalTableModel(this.jointProposalModel);
        this.jointProposalModel.setJointProposalTableModel(this.jointProposalTableModel);
        this.jointProposalTable = new JointProposalTable(this.jointProposalTableModel);
        OTButtonGroup oTButtonGroup = this.makeOTButtonGroup(IS_JOINT_PROPOSAL_FID, new String[]{"Yes", "No"}, "Set to indicate that this is a joint proposal");
        this.constraints.insets = new Insets(0, 4, 0, 4);
        this.addLabeledComponent((JComponent)this, this.layout, this.constraints, "Is this a Joint Proposal?   ", (JComponent)oTButtonGroup);
        this.addVerticalSpace(this, this.layout, this.constraints);
        this.jointProposalPanel = new JPanel();
        this.addComponent(this, this.layout, this.constraints, this.jointProposalPanel);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.jointProposalPanel.setLayout(gridBagLayout);
        this.createJointProposalMainEditorPanel(this.jointProposalPanel, gridBagLayout, gridBagConstraints);
        this.addComponent(this.jointProposalPanel, gridBagLayout, gridBagConstraints, this.createJustificationUIComponents());
    }

    private void addObservatoryButtonActionPerformed(ActionEvent actionEvent) {
        JointProposal jointProposal = this.jointProposalTableModel.getDocument();
        Optional<String> optional = this.findFirstPartnerNotAlreadyInTable();
        if (optional.isEmpty()) {
            GUIUtilities.info(null, "All partners are now represented in the table");
            return;
        }
        JointProposalPartner jointProposalPartner = JointProposalPartner.createJointProposalPartner();
        jointProposalPartner.setObservatory(optional.get());
        jointProposal.addJointProposalPartner(jointProposalPartner);
        this.jointProposalTableModel.resetTableDocument();
    }

    private Optional<String> findFirstPartnerNotAlreadyInTable() {
        String[] stringArray = AlmaPolicies.getInstance().getKnownPartnerObservatories();
        JointProposal jointProposal = this.jointProposalTableModel.getDocument();
        return Stream.of(stringArray).filter(string -> {
            boolean bl = false;
            if (string.equals("ALMA")) {
                return false;
            }
            for (JointProposalPartner jointProposalPartner : jointProposal.getJointProposalPartner()) {
                if (!jointProposalPartner.getObservatory().equals(string)) continue;
                bl = true;
            }
            return !bl;
        }).findFirst();
    }

    private void removeObservatoryButtonActionPerformed(ActionEvent actionEvent) {
        this.jointProposalTableModel.removeRow(this.jointProposalTable.getSelectedRow());
    }

    @Override
    public void update(FieldID fieldID, Object object) {
        if (fieldID.equals(IS_JOINT_PROPOSAL_FID) && object instanceof String) {
            String string = (String)object;
            boolean bl = string.equals("Yes");
            OTButtonGroup oTButtonGroup = (OTButtonGroup)this.getComponent(IS_JOINT_PROPOSAL_FID);
            if (oTButtonGroup != null) {
                oTButtonGroup.setSelectedItem(string);
            }
            if (this.jointProposalPanel != null) {
                this.jointProposalPanel.setVisible(bl);
            }
        } else if (fieldID.equals(IS_JOINT_PROPOSAL_EDITABLE_FID)) {
            this.setJointProposalsComponentsEditability((JointProposalModel.JointProposalUserControl)object);
        } else if (fieldID.equals(JOINT_PROPOSAL_TYPE_FID) && object instanceof String) {
            OTButtonGroup oTButtonGroup = (OTButtonGroup)this.getComponent(JOINT_PROPOSAL_TYPE_FID);
            String string = (String)object;
            if (oTButtonGroup != null) {
                oTButtonGroup.setSelectedItem(StringUtils.capitalize((String)StringUtils.lowerCase((String)string)));
                boolean bl = StringUtils.equalsIgnoreCase((CharSequence)string, (CharSequence)JointProposal.JOINTPROPOSALTYPE_PARTNER);
                this.jointProposalTableModel.setMainObservatoryEditable(bl);
                this.jointProposalTable.setMainObservatoryColumnVisibility(!bl);
            }
        } else if (fieldID.equals(IS_JOINT_PROPOSAL_TABLE_FID) && object instanceof JointProposal) {
            this.configurePartnerJustificationUIComponents((JointProposal)((Object)object));
        }
    }

    private void configurePartnerJustificationUIComponents(@NonNull JointProposal jointProposal) {
        if (jointProposal == null) {
            throw new NullPointerException("jointProposal is marked non-null but is null");
        }
        this.removePartnerObservatoryButton.setEnabled(this.jointProposalTableModel.getRowCount() > 0);
        if (!jointProposal.isMainJointProposal()) {
            this.jointProposalJustificationPanel.setVisible(false);
            return;
        }
        this.jointProposalJustificationPanel.setVisible(true);
        for (int i = 0; i < this.partnerJustifications.size(); ++i) {
            PartnerJustification partnerJustification = this.partnerJustifications.get(i);
            if (i < this.jointProposalTableModel.getRowCount()) {
                JointProposalPartner jointProposalPartner = this.jointProposalTableModel.getPartnerObservatoryAt(i);
                partnerJustification.setVisible(true);
                partnerJustification.getLabel().setText("Please provide the technical justification for the time requested on " + jointProposalPartner.getObservatory() + " as a joint proposal");
                partnerJustification.getTextArea().setText(jointProposalPartner.getJustification());
                partnerJustification.setJointProposalPartner(jointProposalPartner);
                continue;
            }
            partnerJustification.setVisible(false);
        }
    }

    private void setJointProposalsComponentsEditability(@NonNull JointProposalModel.JointProposalUserControl jointProposalUserControl) {
        if (jointProposalUserControl == null) {
            throw new NullPointerException("jointProposalUserControl is marked non-null but is null");
        }
        OTButtonGroup oTButtonGroup = (OTButtonGroup)this.getComponent(IS_JOINT_PROPOSAL_FID);
        oTButtonGroup.setEnabled(jointProposalUserControl.isJointProposalsUserControllable());
        this.jointProposalPanel.setVisible(jointProposalUserControl.isJointPartnerProposal());
        OTButtonGroup oTButtonGroup2 = (OTButtonGroup)this.getComponent(JOINT_PROPOSAL_TYPE_FID);
        oTButtonGroup2.getButtonStream().filter(abstractButton -> abstractButton.getText().equals("Partner")).findFirst().ifPresent(abstractButton2 -> {
            boolean bl = jointProposalUserControl.isRequestedProjectTypePartnerJointProposalsCompatible();
            abstractButton2.setEnabled(bl);
            if (!bl) {
                oTButtonGroup2.getButtonStream().filter(abstractButton -> abstractButton.getText().equals("Main")).findFirst().ifPresent(AbstractButton::doClick);
            }
        });
    }

    public static void main(String[] stringArray) {
        SwingUtilities.invokeLater(() -> {
            try {
                InitServices.init();
            }
            catch (IOException iOException) {
                Log.logger(JointProposalEditor.class).warning(iOException.getMessage());
            }
            JointProposal jointProposal = JointProposal.createJointProposal();
            JointProposalPartner jointProposalPartner = JointProposalPartner.createJointProposalPartner();
            jointProposalPartner.setIsMainObservatory(true);
            jointProposalPartner.setObservatory("JWST");
            jointProposalPartner.setProjectCode("2022.2");
            jointProposalPartner.setRequestedTime(Time.createTimeMin(200.0));
            jointProposal.addJointProposalPartner(jointProposalPartner);
            JointProposalEditor jointProposalEditor = new JointProposalEditor(new JointProposalModel((Object)jointProposal));
            JFrame jFrame = new JFrame("Joint proposal editor");
            jFrame.setContentPane(jointProposalEditor);
            jFrame.pack();
            jFrame.setVisible(true);
        });
    }
}

