/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.investigator;

import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.obsprep.bo.obsproject.ObsProject;
import alma.obsprep.bo.obsproposal.Investigator;
import alma.obsprep.bo.obsproposal.ObsProposal;
import alma.obsprep.guiutil.ScrollWhenFocusedPane;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.ot.actions.OTActions;
import alma.obsprep.ot.boEditors.FieldIDs;
import alma.obsprep.ot.editors.investigator.InvestigatorSearchDialog;
import alma.obsprep.ot.editors.investigator.InvestigatorsListSelectionModel;
import alma.obsprep.ot.editors.investigator.InvestigatorsTableModel;
import alma.obsprep.ot.editors.investigator.TableInvestigator;
import alma.obsprep.ot.editors.obsproject.ObsProposalEditor;
import alma.obsprep.ot.gui.toplevel.InitServices;
import alma.obsprep.ot.gui.toplevel.ObservingToolController;
import alma.obsprep.ot.gui.toplevel.UserAuthenticator;
import alma.obsprep.ot.models.obsproject.ObsProposalModel;
import alma.obsprep.roledirectory.OTOperation;
import alma.obsprep.roledirectory.RoleDirectory;
import alma.obsprep.services.network.roledirectory.RoleDirectoryService;
import alma.obsprep.services.userlookup.UserLookupRemote;
import alma.obsprep.util.GUIUtilities;
import alma.valuetypes.Status;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import lombok.NonNull;

public class InvestigatorsEditor
extends Editor
implements ListSelectionListener,
TableModelListener {
    private final InvestigatorsTableModel investigatorTableModel = new InvestigatorsTableModel();
    private final ObsProposalModel obsProposalModel;
    private final RoleDirectory roleDirectory;
    private JButton addCoPIButton;
    private JButton addCoIButton;
    private JButton importButton;
    private JButton removeCollaboratorButton;
    private JScrollPane scrollPane;
    private JButton setPIButton;
    private JTable investigatorTable;

    public InvestigatorsEditor(ObsProposalModel obsProposalModel, ObservingToolController observingToolController) {
        this.build();
        this.obsProposalModel = obsProposalModel;
        this.setModel(obsProposalModel, true);
        obsProposalModel.subscribe(this);
        this.roleDirectory = observingToolController.getRoleDirectory();
        this.setButtons();
        observingToolController.getUserAuthenticator().addChangeListener(userAuthenticator -> this.setButtons());
    }

    @Override
    protected void build() {
        this.initComponents();
        this.investigatorTable.getTableHeader().setReorderingAllowed(false);
        this.setUpArcColumn(this.investigatorTable, this.investigatorTable.getColumnModel().getColumn(5));
        this.setUpReviewerColumn(this.investigatorTable.getColumnModel().getColumn(6));
        this.investigatorTableModel.addTableModelListener(this);
        this.investigatorTable.getSelectionModel().addListSelectionListener(this);
        this.packRows(this.investigatorTable, 0);
        this.setButtons();
    }

    private void setUpReviewerColumn(TableColumn tableColumn) {
        tableColumn.setCellEditor(new DefaultCellEditor(new JCheckBox()));
        tableColumn.setCellRenderer((jTable, object, bl, bl2, n, n2) -> {
            JCheckBox jCheckBox = new JCheckBox();
            jCheckBox.setToolTipText("Click to select this PI as a reviewer");
            jCheckBox.setSelected((Boolean)object);
            return jCheckBox;
        });
    }

    @Override
    public void modelChanged(Model model, FieldID fieldID, Object object) {
        if (fieldID == FieldIDs.investigatorSetPiFID && object instanceof Investigator) {
            this.investigatorTableModel.setPi((Investigator)((Object)object));
            this.setButtons();
        } else if (fieldID == FieldIDs.investigatorAddCoiFID && object instanceof List) {
            this.investigatorTableModel.addCois((List)object);
        } else if (fieldID == FieldIDs.investigatorRemoveCoiFID && object instanceof List) {
            this.investigatorTableModel.removeCois((List)object);
        } else if (fieldID == FieldIDs.investigatorAddCoPiFID && object instanceof List) {
            this.investigatorTableModel.addCoPis((List)object);
        } else if (fieldID == FieldIDs.investigatorRemoveCoPiFID && object instanceof List) {
            this.investigatorTableModel.removeCoPis((List)object);
        } else if (fieldID == FieldIDs.investigatorClearAllFID) {
            this.investigatorTableModel.clearAll();
        } else if (fieldID == ObsProposalEditor.PROPOSALTYPE_FID) {
            this.setButtons();
        }
        this.packRows(this.investigatorTable, 0);
    }

    private void setButtons() {
        ObsProposal obsProposal;
        boolean bl = true;
        boolean bl2 = false;
        if (this.obsProposalModel != null && (obsProposal = (ObsProposal)((Object)this.obsProposalModel.getDocument())) != null) {
            try {
                String string;
                ObsProject obsProject = obsProposal.getObsProject();
                if (obsProject != null && Status.STATE_PHASE1SUBMITTED.equals(string = obsProject.getStatus())) {
                    bl = false;
                }
            }
            catch (UnknownEntityException unknownEntityException) {
                // empty catch block
            }
            bl2 = obsProposal.isLargeProgram();
        }
        boolean bl3 = false;
        if (!bl && this.roleDirectory != null) {
            try {
                bl3 = this.roleDirectory.canExecute(OTOperation.CHANGE_PI);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.setPIButton.setEnabled(bl || bl3);
        this.addCoPIButton.setEnabled(bl2);
        this.addCoIButton.setEnabled(true);
        if (this.setPIButton.isEnabled()) {
            this.setPIButton.setToolTipText("Set the PI for this proposal");
        } else {
            this.setPIButton.setToolTipText("Cannot change the PI of a submitted project");
        }
        this.addCoPIButton.setToolTipText("Add a CoPI to this proposal");
        this.addCoIButton.setToolTipText("Add a CoI to this proposal");
        this.removeCollaboratorButton.setEnabled(this.investigatorTable.getSelectedRowCount() > 0);
    }

    @Override
    public void update(FieldID fieldID, Object object) {
        if (fieldID.equals(ObsProposalEditor.PROPOSALTYPE_FID)) {
            this.setReviewerColumnVisbility();
            this.setButtons();
        }
        if (fieldID.equals(ObsProposalEditor.CYCLE_FID)) {
            this.setReviewerColumnVisbility();
        }
        super.update(fieldID, object);
    }

    private void setReviewerColumnVisbility() {
        ObsProposal obsProposal;
        if (this.obsProposalModel != null && (obsProposal = (ObsProposal)((Object)this.obsProposalModel.getDocument())) != null) {
            try {
                ObsProject obsProject = obsProposal.getObsProject();
                boolean bl = !obsProject.isDPRRequired();
                this.hideReviewerColumn(bl);
            }
            catch (Exception exception) {
                return;
            }
        }
    }

    private void hideReviewerColumn(boolean bl) {
        TableColumn tableColumn = this.investigatorTable.getColumnModel().getColumn(6);
        int n = bl ? 0 : 70;
        tableColumn.setResizable(false);
        tableColumn.setPreferredWidth(n);
        tableColumn.setWidth(n);
        tableColumn.setMinWidth(n);
        tableColumn.setMaxWidth(n);
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        int n = tableModelEvent.getFirstRow();
        TableInvestigator tableInvestigator = this.investigatorTableModel.getUserAt(n);
        Investigator investigator = tableInvestigator.getInvestigator();
        if (tableModelEvent.getType() == 0 && tableModelEvent.getColumn() == 5) {
            if (n != tableModelEvent.getLastRow()) {
                return;
            }
            if (TableInvestigator.USER_TYPE.PI == tableInvestigator.getUserType()) {
                this.obsProposalModel.setPrincipalInvestigator(investigator);
            } else if (TableInvestigator.USER_TYPE.COPI == tableInvestigator.getUserType()) {
                this.obsProposalModel.setCoPrincipalInvestigator(investigator);
            } else if (TableInvestigator.USER_TYPE.COI == tableInvestigator.getUserType()) {
                this.obsProposalModel.setCoInvestigator(investigator);
            }
            this.obsProposalModel.publish();
        } else if (tableModelEvent.getType() == 0 && tableModelEvent.getColumn() == 6) {
            this.obsProposalModel.setReviewer(Optional.of(investigator));
            this.obsProposalModel.publish();
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.setButtons();
    }

    private JComboBox<Executive> getTaiwanCombobox() {
        JComboBox<Executive> jComboBox = new JComboBox<Executive>();
        jComboBox.addItem(Executive.NORTH_AMERICA);
        jComboBox.addItem(Executive.EAST_ASIA);
        jComboBox.addItem(Executive.TAIWAN);
        return jComboBox;
    }

    private int getPreferredRowHeight(JTable jTable, int n, int n2) {
        int n3 = jTable.getRowHeight();
        for (int i = 0; i < jTable.getColumnCount(); ++i) {
            TableCellRenderer tableCellRenderer = jTable.getCellRenderer(n, i);
            Component component = jTable.prepareRenderer(tableCellRenderer, n, i);
            int n4 = component.getPreferredSize().height + 2 * n2;
            n3 = Math.max(n3, n4);
        }
        return n3;
    }

    private void packRows(JTable jTable, int n) {
        this.packRows(jTable, 0, jTable.getRowCount(), n);
    }

    private void packRows(JTable jTable, int n, int n2, int n3) {
        for (int i = 0; i < jTable.getRowCount(); ++i) {
            int n4 = this.getPreferredRowHeight(jTable, i, n3);
            if (jTable.getRowHeight(i) == n4) continue;
            jTable.setRowHeight(i, n4);
        }
    }

    public void setUpArcColumn(JTable jTable, TableColumn tableColumn) {
        tableColumn.setCellEditor(new DefaultCellEditor(this.getTaiwanCombobox()));
        tableColumn.setCellRenderer(new TableCellRenderer(){
            DefaultTableCellRenderer original = new DefaultTableCellRenderer();

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                if (InvestigatorsEditor.this.investigatorTableModel.isCellEditable(n, n2)) {
                    JComboBox<Executive> jComboBox = InvestigatorsEditor.this.getTaiwanCombobox();
                    jComboBox.setToolTipText("Click to set this the associated ARC for the investigator");
                    jComboBox.setSelectedItem(object);
                    return jComboBox;
                }
                return this.original.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            }
        });
    }

    private void initComponents() {
        this.addCoIButton = new JButton();
        this.addCoPIButton = new JButton();
        this.importButton = new JButton();
        this.scrollPane = new ScrollWhenFocusedPane();
        this.investigatorTable = new JTable();
        this.removeCollaboratorButton = new JButton();
        this.setPIButton = new JButton();
        this.investigatorTable.setModel(this.investigatorTableModel);
        this.investigatorTable.setSelectionModel(new InvestigatorsListSelectionModel());
        this.scrollPane.setViewportView(this.investigatorTable);
        this.addCoIButton.setText("Add CoI");
        this.addCoIButton.addActionListener(this::addCoIButtonActionPerformed);
        this.removeCollaboratorButton.setText("Remove Collaborator");
        this.removeCollaboratorButton.setToolTipText("Remove the selected collaborator from this proposal");
        this.removeCollaboratorButton.setEnabled(false);
        this.removeCollaboratorButton.addActionListener(this::removeCollaboratorButtonActionPerformed);
        this.addCoPIButton.setText("Add CoPI");
        this.addCoPIButton.addActionListener(this::addCoPIButtonActionPerformed);
        this.setPIButton.setText("Select PI");
        this.setPIButton.addActionListener(this::setPIButtonActionPerformed);
        this.importButton.setText("Add from Proposal");
        this.importButton.setToolTipText("Load investigators from a saved project, adding them as CoIs to this proposal");
        this.importButton.addActionListener(this::importButtonActionPerformed);
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.scrollPane, -1, 405, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addComponent(this.setPIButton).addGap(18, 18, 18).addComponent(this.addCoPIButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.addCoIButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.removeCollaboratorButton).addGap(18, 18, 18).addComponent(this.importButton))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addContainerGap().addComponent(this.scrollPane, -1, 217, Short.MAX_VALUE).addGap(18, 18, 18).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.removeCollaboratorButton).addComponent(this.addCoIButton).addComponent(this.addCoPIButton).addComponent(this.setPIButton).addComponent(this.importButton)).addContainerGap()));
    }

    private void setPIButtonActionPerformed(ActionEvent actionEvent) {
        List<Investigator> list = InvestigatorSearchDialog.showDialog(true, "Select PI");
        this.removeDuplicateInvestigators(list);
        if (list.size() > 0) {
            this.getController().widgetUpdated(this, FieldIDs.investigatorSetPiFID, (Object)list.get(0));
        }
    }

    private void addCoPIButtonActionPerformed(ActionEvent actionEvent) {
        List<Investigator> list = InvestigatorSearchDialog.showDialog(false, "Add CoPI");
        this.removeDuplicateInvestigators(list);
        this.getController().widgetUpdated(this, FieldIDs.investigatorAddCoPiFID, list);
    }

    private void addCoIButtonActionPerformed(ActionEvent actionEvent) {
        List<Investigator> list = InvestigatorSearchDialog.showDialog(false, "Add CoI");
        this.removeDuplicateInvestigators(list);
        this.getController().widgetUpdated(this, FieldIDs.investigatorAddCoiFID, list);
    }

    private void importButtonActionPerformed(ActionEvent actionEvent) {
        OTActions.ProjectTiedActions projectTiedActions = ObservingToolController.getOTGui().activeProjectCompartment().getProjectTiedActions();
        projectTiedActions.importInvestigators.actionPerformed(null);
    }

    private void removeDuplicateInvestigators(List<Investigator> list) {
        ArrayList<Investigator> arrayList = new ArrayList<Investigator>();
        arrayList.addAll(this.obsProposalModel.getCoInvestigators());
        arrayList.addAll(this.obsProposalModel.getCoPrincipalInvestigators());
        arrayList.add(this.obsProposalModel.getPrincipalInvestigator());
        arrayList.retainAll(list);
        if (list.size() == 1 && arrayList.size() == 1) {
            GUIUtilities.info(null, "The investigator you selected is already part of your project and will not be duplicated.");
        } else if (arrayList.size() == 1) {
            GUIUtilities.info(null, arrayList.size() + " of the investigators you selected is already part of your project and will not be duplicated.");
        } else if (arrayList.size() > 1) {
            GUIUtilities.info(null, arrayList.size() + " of the investigators you selected are already part of your project and will not be duplicated.");
        }
        list.removeAll(arrayList);
    }

    private void removeCollaboratorButtonActionPerformed(ActionEvent actionEvent) {
        ArrayList<TableInvestigator> arrayList = new ArrayList<TableInvestigator>();
        ArrayList<TableInvestigator> arrayList2 = new ArrayList<TableInvestigator>();
        for (int n : this.investigatorTable.getSelectedRows()) {
            TableInvestigator tableInvestigator = this.investigatorTableModel.getUserAt(n);
            if (TableInvestigator.USER_TYPE.COPI == tableInvestigator.getUserType()) {
                arrayList2.add(tableInvestigator);
            }
            if (TableInvestigator.USER_TYPE.COI != tableInvestigator.getUserType()) continue;
            arrayList.add(tableInvestigator);
        }
        if (!arrayList2.isEmpty()) {
            this.getController().widgetUpdated(this, FieldIDs.investigatorRemoveCoPiFID, arrayList2);
        }
        if (!arrayList.isEmpty()) {
            this.getController().widgetUpdated(this, FieldIDs.investigatorRemoveCoiFID, arrayList);
        }
    }

    public static void main(String[] stringArray) throws Exception {
        UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
        InitServices.initModelSupportClasses();
        ObservingToolController observingToolController = new ObservingToolController();
        UserLookupRemote userLookupRemote = new UserLookupRemote();
        userLookupRemote.setUrl("http://192.168.56.101:8180");
        observingToolController.heap.setUserLookup(userLookupRemote);
        UserAuthenticator userAuthenticator = new UserAuthenticator();
        observingToolController.heap.setUserAuthenticator(userAuthenticator);
        RoleDirectoryService roleDirectoryService = new RoleDirectoryService(userAuthenticator);
        roleDirectoryService.setServerUrl("http://192.168.56.101:8180");
        observingToolController.heap.setRoleDirectory(roleDirectoryService);
        observingToolController.heap.getNetworkServiceHandler().addService(roleDirectoryService);
        userAuthenticator.setNameAndPasswordAndServer("john", "john".toCharArray(), "http://192.168.56.101:8180");
        observingToolController.heap.getNetworkServiceHandler().goOnline();
        ObsProject obsProject = ObsProject.createObsProject();
        obsProject.setStatus(Status.STATE_PHASE1SUBMITTED);
        ObsProposal obsProposal = ObsProposal.createObsProposal();
        obsProposal.setObsProject(obsProject);
        ObsProposalModel obsProposalModel = new ObsProposalModel((Object)obsProposal);
        InvestigatorsEditor investigatorsEditor = new InvestigatorsEditor(obsProposalModel, observingToolController);
        JFrame jFrame = new JFrame("Investigators Editor");
        jFrame.setDefaultCloseOperation(3);
        jFrame.getContentPane().add(investigatorsEditor);
        jFrame.pack();
        jFrame.setVisible(true);
    }

    class ComboTableCellRenderer
    implements ListCellRenderer,
    TableCellRenderer {
        DefaultListCellRenderer listRenderer = new DefaultListCellRenderer();
        DefaultTableCellRenderer tableRenderer = new DefaultTableCellRenderer();

        ComboTableCellRenderer() {
        }

        private void configureRenderer(JLabel jLabel, Object object) {
            jLabel.setText((String)object);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.listRenderer = (DefaultListCellRenderer)this.listRenderer.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            this.configureRenderer(this.listRenderer, object);
            return this.listRenderer;
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.tableRenderer = (DefaultTableCellRenderer)this.tableRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            this.configureRenderer(this.tableRenderer, object);
            return this.tableRenderer;
        }
    }

    public static enum Executive {
        EUROPE(Investigator.ALLOWEDEXEC_EU, "Europe"),
        NORTH_AMERICA(Investigator.ALLOWEDEXEC_NA, "North America"),
        EAST_ASIA(Investigator.ALLOWEDEXEC_EA, "East Asia"),
        CHILE(Investigator.ALLOWEDEXEC_CL, "Chile"),
        TAIWAN(Investigator.ALLOWEDEXEC_NA_EA, "50% NA 50% EA"),
        NON_ALMA(Investigator.ALLOWEDEXEC_OTHER, "Non-ALMA");

        private static final Collection<Executive> executives;
        @NonNull
        private final String soValue;
        @NonNull
        private final String description;

        public String toString() {
            return this.description;
        }

        public static Executive fromSoValue(String string) {
            for (Executive executive : executives) {
                if (!executive.getSoValue().equals(string)) continue;
                return executive;
            }
            return null;
        }

        private Executive(String string2, String string3) {
            if (string2 == null) {
                throw new NullPointerException("soValue is marked non-null but is null");
            }
            if (string3 == null) {
                throw new NullPointerException("description is marked non-null but is null");
            }
            this.soValue = string2;
            this.description = string3;
        }

        @NonNull
        public String getSoValue() {
            return this.soValue;
        }

        @NonNull
        public String getDescription() {
            return this.description;
        }

        static {
            executives = EnumSet.allOf(Executive.class);
        }
    }
}

