/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.actions;

import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.obsprep.bo.obsproject.data.ObsUnitData;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.guiutil.events.Event;
import alma.obsprep.guiutil.events.EventManager;
import alma.obsprep.guiutil.events.EventReceiver;
import alma.obsprep.guiutil.events.EventTypes;
import alma.obsprep.ot.actions.OTAction;
import alma.obsprep.ot.actions.SuspendInteractor;
import alma.obsprep.ot.actions.SuspendPerformer;
import alma.obsprep.ot.gui.toplevel.DialogId;
import alma.obsprep.ot.project.ProjectTree;
import alma.obsprep.ot.project.ProjectTreeNode;
import alma.obsprep.util.GUIUtilities;
import javax.swing.tree.TreePath;

public class Suspend
extends OTAction
implements SuspendInteractor,
EventReceiver {
    private static DialogId DIALOG_SUSPEND = new DialogId("Suspend.Confirm");
    private final ProjectTree projectTree;
    private BusinessObject selectedBO = null;
    private final BusinessObject parentBO = null;
    private ProjectTreeNode selectedNode = null;

    public Suspend(ProjectTree projectTree) {
        this.projectTree = projectTree;
        SuspendPerformer suspendPerformer = new SuspendPerformer(this);
        this.setPerformer(suspendPerformer);
        EventManager.subscribeByType(EventTypes.NODESELECTED, this);
        this.setEnabled(false);
    }

    @Override
    public void receiveEvent(Event event) {
        this.selectedNode = (ProjectTreeNode)event.getSource();
        this.selectedBO = (BusinessObject)this.selectedNode.getUserObject();
        this.enabled = this.projectTree.getTop() != this.selectedNode.getRoot() ? false : (this.projectTree.isDndReadonly() ? false : this.enabledFor(this.selectedBO));
        this.setEnabled(this.enabled);
    }

    @Override
    public BusinessObject getSelectedBO() {
        return this.selectedBO;
    }

    @Override
    public BusinessObject getParentBO() {
        return this.parentBO;
    }

    @Override
    public void error(String string) {
        GUIUtilities.error(null, string);
    }

    @Override
    public void info(String string) {
        GUIUtilities.info(null, string);
    }

    @Override
    public boolean confirmSuspend() {
        String string = String.format("<html>Do you want to suspend<br><br>&nbsp;&nbsp;&nbsp;%s?</html>", this.selectedBO.toTreeString(1, false, false));
        return GUIUtilities.confirm(DIALOG_SUSPEND, string);
    }

    @Override
    public void updateDisplay(BusinessObject businessObject) {
        ProjectTreeNode projectTreeNode;
        if (businessObject != null && (projectTreeNode = this.projectTree.findNodeRepresentingBo(businessObject)) != null) {
            this.projectTree.select(new TreePath(projectTreeNode.getPath()));
        }
    }

    private boolean enabledFor(BusinessObject businessObject) {
        SchedBlock schedBlock;
        return businessObject instanceof SchedBlock && (schedBlock = (SchedBlock)businessObject).getStatus().equals(ObsUnitData.STATUS_CSVREADY);
    }
}

