/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.actions;

import alma.hla.runtime.obsprep.util.UnknownEntityPartException;
import alma.obsprep.bo.obsproject.ObsProject;
import alma.obsprep.ot.actions.ActionLog;
import alma.obsprep.ot.actions.ProjectBackupAction;
import alma.obsprep.ot.gui.toplevel.InitServices;
import alma.obsprep.ot.gui.toplevel.ObservingToolController;
import alma.obsprep.ot.gui.toplevel.ObservingToolGui;
import alma.obsprep.ot.persistence.ImpexFactory;
import alma.obsprep.ot.persistence.PersistenceException;
import alma.obsprep.util.FileUtilities;
import alma.obsprep.util.GUIUtilities;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import jsky.util.gui.DialogUtil;
import lombok.NonNull;
import org.exolab.castor.xml.XMLException;

public class ProjectBackupRecoveryDialogue
implements ActionListener,
TreeSelectionListener {
    private static ProjectBackupRecoveryDialogue projectBackRecoveryDialogue = null;
    private JButton restoreButton;
    private JButton cancelButton;
    private JDialog mainDialog;
    private JTree backupTree;

    private ProjectBackupRecoveryDialogue() {
        this.createBackupRestoreUIFrame();
    }

    private void createBackupRestoreUIFrame() {
        this.mainDialog = new JDialog((Frame)DialogUtil.getActiveFrame(), "Project Backup Recovery");
        this.mainDialog.setLayout(new GridBagLayout());
        this.mainDialog.setDefaultCloseOperation(1);
        this.mainDialog.setPreferredSize(new Dimension(400, 600));
        this.mainDialog.setResizable(false);
        this.buildUI(this.mainDialog);
    }

    private void buildUI(@NonNull Container container) {
        if (container == null) {
            throw new NullPointerException("dialog is marked non-null but is null");
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        JLabel jLabel = new JLabel("<html> This feature will allow the user to restore a project backup file. No files will be overwritten by this process but any changes associated with the existing project will be lost.<P><br>In the case that you are restoring a project that is already in the archive, please ensure that any backup version that you restore is more <b>recent</b> than the version in the archive if the intention is to subsequently resubmit it. If this is not the case, you will be unable to re-submit the restored project. </html>");
        container.add((Component)jLabel, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        this.backupTree = new JTree(new DefaultMutableTreeNode("Project backups"));
        this.backupTree.getSelectionModel().setSelectionMode(1);
        this.backupTree.addTreeSelectionListener(this);
        JScrollPane jScrollPane = new JScrollPane(this.backupTree);
        gridBagConstraints.gridheight = 2;
        container.add((Component)jScrollPane, gridBagConstraints);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridy += 2;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout());
        this.restoreButton = new JButton("Restore Selected Backup");
        this.restoreButton.setEnabled(false);
        this.restoreButton.addActionListener(this);
        this.cancelButton = new JButton("Cancel");
        jPanel.add(this.restoreButton);
        jPanel.add(this.cancelButton);
        this.cancelButton.addActionListener(this);
        container.add((Component)jPanel, gridBagConstraints);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ProjectBackupRecoveryDialogue getInstance() {
        if (projectBackRecoveryDialogue != null) return projectBackRecoveryDialogue;
        Class<ProjectBackupRecoveryDialogue> clazz = ProjectBackupRecoveryDialogue.class;
        synchronized (ProjectBackupRecoveryDialogue.class) {
            if (projectBackRecoveryDialogue != null) return projectBackRecoveryDialogue;
            projectBackRecoveryDialogue = new ProjectBackupRecoveryDialogue();
            // ** MonitorExit[var0] (shouldn't be in output)
            return projectBackRecoveryDialogue;
        }
    }

    public void getFileToRestore() throws IOException {
        this.populateBackupFileTree();
        this.mainDialog.pack();
        this.mainDialog.setVisible(true);
    }

    private void populateBackupFileTree() throws IOException {
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.backupTree.getModel();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)defaultTreeModel.getRoot();
        defaultMutableTreeNode.removeAllChildren();
        defaultTreeModel.reload();
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Project backups");
        defaultTreeModel.setRoot(defaultMutableTreeNode2);
        File file = InitServices.ALMAOT_BACKUP_FOLDER;
        File[] fileArray = file.listFiles(ProjectBackupAction.backupFileFilter);
        for (ProjectWithBackupFiles projectWithBackupFiles : this.getBackUpFilenames(fileArray)) {
            DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(projectWithBackupFiles.getDisplayName());
            defaultTreeModel.insertNodeInto(defaultMutableTreeNode3, defaultMutableTreeNode2, defaultMutableTreeNode.getChildCount());
            for (File file2 : projectWithBackupFiles.getBackupFiles()) {
                BackupTreeNode backupTreeNode = new BackupTreeNode(file2);
                defaultTreeModel.insertNodeInto(backupTreeNode, defaultMutableTreeNode3, defaultMutableTreeNode3.getChildCount());
            }
            this.backupTree.scrollPathToVisible(new TreePath(defaultMutableTreeNode3.getPath()));
        }
        defaultTreeModel.reload();
    }

    private List<ProjectWithBackupFiles> getBackUpFilenames(@NonNull File[] fileArray) {
        if (fileArray == null) {
            throw new NullPointerException("listOfFiles is marked non-null but is null");
        }
        ArrayList<ProjectWithBackupFiles> arrayList = new ArrayList<ProjectWithBackupFiles>();
        for (File file : fileArray) {
            if (!file.isFile()) continue;
            String string = file.getName().replaceAll("_[0-9]{8}_[0-9]{4}", "").replace("~", "");
            String string2 = string.replace(".aot", "");
            if (!arrayList.stream().noneMatch(projectWithBackupFiles -> projectWithBackupFiles.getDisplayName().equals(string2))) continue;
            List<Object> list = new ArrayList();
            for (File file2 : fileArray) {
                if (!file2.getName().contains(string2)) continue;
                list.add(file2);
            }
            list = list.stream().sorted().collect(Collectors.toList());
            arrayList.add(new ProjectWithBackupFiles(string2, list));
        }
        return arrayList;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object.equals(this.cancelButton)) {
            this.mainDialog.setVisible(false);
        } else if (object.equals(this.restoreButton)) {
            this.restoreSelectedProjectFile();
        }
    }

    private void restoreSelectedProjectFile() {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.backupTree.getLastSelectedPathComponent();
        if (defaultMutableTreeNode == null) {
            return;
        }
        Object object = defaultMutableTreeNode.getUserObject();
        if (object instanceof File) {
            URL uRL2;
            File file = (File)object;
            if (!GUIUtilities.confirm(null, "Any unsaved changes will be lost - are you sure you want to restore this file? ")) {
                return;
            }
            ImpexFactory impexFactory = ImpexFactory.getInstance();
            try {
                uRL2 = FileUtilities.makeURL(file);
            }
            catch (MalformedURLException malformedURLException) {
                GUIUtilities.error(null, "Unable to load in the backup file " + malformedURLException.getMessage());
                return;
            }
            ObsProject obsProject = null;
            try {
                obsProject = impexFactory.importObsProject(uRL2, false);
            }
            catch (UnknownEntityPartException | PersistenceException | IOException | XMLException throwable) {
                GUIUtilities.error(null, "Unable to import backup file " + throwable.getMessage());
                return;
            }
            if (obsProject == null) {
                return;
            }
            File file2 = null;
            String string = uRL2.toExternalForm();
            if (string.startsWith("file:")) {
                file2 = new File(string.substring(5));
            }
            ObservingToolGui observingToolGui = ObservingToolController.getOTGui();
            observingToolGui.setPrimaryProject(obsProject, file2, false);
            observingToolGui.flagBrokenSchedBlocks(obsProject);
            impexFactory.getUrlOfLastProjectFileImported().ifPresent(uRL -> impexFactory.setUrlOfLastProjectFileImported(Optional.empty()));
            observingToolGui.primaryProjectCompartment().setFileLocation(null);
            ActionLog.performed("Restore " + file2 + " from disk");
            this.mainDialog.setVisible(false);
        }
    }

    @Override
    public void valueChanged(@NonNull TreeSelectionEvent treeSelectionEvent) {
        if (treeSelectionEvent == null) {
            throw new NullPointerException("e is marked non-null but is null");
        }
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.backupTree.getLastSelectedPathComponent();
        if (defaultMutableTreeNode == null) {
            return;
        }
        this.restoreButton.setEnabled(defaultMutableTreeNode.isLeaf());
    }

    public static void main(String[] stringArray) {
        try {
            ProjectBackupRecoveryDialogue.getInstance().getFileToRestore();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static class ProjectWithBackupFiles {
        private String displayName;
        private List<File> backupFiles;

        public String getDisplayName() {
            return this.displayName;
        }

        public List<File> getBackupFiles() {
            return this.backupFiles;
        }

        public void setDisplayName(String string) {
            this.displayName = string;
        }

        public void setBackupFiles(List<File> list) {
            this.backupFiles = list;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof ProjectWithBackupFiles)) {
                return false;
            }
            ProjectWithBackupFiles projectWithBackupFiles = (ProjectWithBackupFiles)object;
            if (!projectWithBackupFiles.canEqual(this)) {
                return false;
            }
            String string = this.getDisplayName();
            String string2 = projectWithBackupFiles.getDisplayName();
            if (string == null ? string2 != null : !string.equals(string2)) {
                return false;
            }
            List<File> list = this.getBackupFiles();
            List<File> list2 = projectWithBackupFiles.getBackupFiles();
            return !(list == null ? list2 != null : !((Object)list).equals(list2));
        }

        protected boolean canEqual(Object object) {
            return object instanceof ProjectWithBackupFiles;
        }

        public int hashCode() {
            int n = 1;
            String string = this.getDisplayName();
            n = n * 59 + (string == null ? 43 : string.hashCode());
            List<File> list = this.getBackupFiles();
            n = n * 59 + (list == null ? 43 : ((Object)list).hashCode());
            return n;
        }

        public String toString() {
            return "ProjectBackupRecoveryDialogue.ProjectWithBackupFiles(displayName=" + this.getDisplayName() + ", backupFiles=" + this.getBackupFiles() + ")";
        }

        public ProjectWithBackupFiles(String string, List<File> list) {
            this.displayName = string;
            this.backupFiles = list;
        }
    }

    public static class BackupTreeNode
    extends DefaultMutableTreeNode {
        public BackupTreeNode(Object object) {
            super(object);
        }

        @Override
        public String toString() {
            Object object = this.getUserObject();
            if (object instanceof File) {
                File file = (File)object;
                Pattern pattern = Pattern.compile(".*([0-9]{8}_[0-9]{4}).*");
                Matcher matcher = pattern.matcher(file.getName());
                return matcher.find() ? matcher.group(1) : object.toString();
            }
            return object.toString();
        }
    }
}

