/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.actions;

import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.obsprep.bo.obsproject.ObsProject;
import alma.obsprep.bo.obsproposal.Investigator;
import alma.obsprep.bo.obsproposal.ObsProposal;
import alma.obsprep.ot.actions.ImportBase;
import alma.obsprep.ot.gui.toplevel.DialogId;
import alma.obsprep.ot.gui.toplevel.ObservingToolGui;
import alma.obsprep.ot.models.obsproject.ObsProposalModel;
import alma.obsprep.util.GUIUtilities;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ImportInvestigators
extends ImportBase {
    public static final DialogId DIALOG_OVERWRITE_INVESTIGATORS = new DialogId("Import.OverwriteInvestigators");
    private final boolean useFinder;

    public ImportInvestigators(ObservingToolGui observingToolGui, boolean bl) {
        super(observingToolGui);
        this.useFinder = bl;
    }

    @Override
    public URL getImportURL() {
        if (this.useFinder) {
            return this.getImportUrlFromProjectFinder();
        }
        return this.getImportUrlFromFileChooser();
    }

    private void removeDuplicateInvestigators(List<Investigator> list) {
        ObsProposalModel obsProposalModel = (ObsProposalModel)this.gui.getEditors().modelFor(ObsProposal.class);
        ArrayList<Investigator> arrayList = new ArrayList<Investigator>();
        arrayList.add(obsProposalModel.getPrincipalInvestigator());
        arrayList.addAll(obsProposalModel.getCoPrincipalInvestigators());
        arrayList.addAll(obsProposalModel.getCoInvestigators());
        arrayList.retainAll(list);
        list.removeAll(arrayList);
    }

    @Override
    public void display(ObsProject obsProject, File file) {
        try {
            ObsProposal obsProposal = obsProject.getObsProposal();
            ObsProposalModel obsProposalModel = (ObsProposalModel)this.gui.getEditors().modelFor(ObsProposal.class);
            ArrayList<Investigator> arrayList = new ArrayList<Investigator>();
            Collections.addAll(arrayList, obsProposal.getPrincipalInvestigator());
            Collections.addAll(arrayList, obsProposal.getCoPrincipalInvestigator());
            this.removeDuplicateInvestigators(arrayList);
            Investigator[] investigatorArray = arrayList.toArray(new Investigator[arrayList.size()]);
            obsProposalModel.addCoInvestigators(investigatorArray);
            arrayList.clear();
            Collections.addAll(arrayList, obsProposal.getCoInvestigator());
            this.removeDuplicateInvestigators(arrayList);
            Investigator[] investigatorArray2 = arrayList.toArray(new Investigator[arrayList.size()]);
            obsProposalModel.addCoInvestigators(investigatorArray2);
            obsProposalModel.publish();
        }
        catch (UnknownEntityException unknownEntityException) {
            GUIUtilities.error(null, "ObsProject has no attached proposal");
        }
    }
}

