/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.actions;

import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.obsprep.bo.obsattachment.DocumentLink;
import alma.obsprep.bo.obsattachment.ObsAttachment;
import alma.obsprep.bo.obsattachment.data.DocumentLinkData;
import alma.obsprep.bo.obsattachment.data.ObsAttachmentData;
import alma.obsprep.bo.obsproposal.ObsProposal;
import alma.obsprep.ot.actions.ActionLog;
import alma.obsprep.ot.actions.AttachTASummaryInteractor;
import alma.obsprep.ot.actions.Performer;
import alma.obsprep.services.summaryfeedback.FeedbackSummaryJointProposal;
import alma.obsprep.services.summaryfeedback.FeedbackSummaryObsProposal;
import alma.obsprep.services.summaryfeedback.FeedbackSummarySgCollection;
import alma.obsprep.services.summaryfeedback.ObsProposalScienceGoalNavigator;
import alma.obsprep.services.summaryfeedback.PdfExporter;
import alma.obsprep.util.FileUtilities;
import java.io.File;
import java.io.IOException;
import lombok.NonNull;

public class AttachTASummaryPerformer
extends Performer {
    private static final String TA_COVER_PDF_FILENAME = "TA_Cover";
    private static final String TA_JOINTPROPOSAL_PDF_FILENAME = "TA_JointProposal";
    private static final String TA_SCIENCEGOAL_SUMMARY_FILENAME = "TA_ScienceGoals";

    public AttachTASummaryPerformer(@NonNull AttachTASummaryInteractor attachTASummaryInteractor) {
        super(attachTASummaryInteractor);
        if (attachTASummaryInteractor == null) {
            throw new NullPointerException("gui is marked non-null but is null");
        }
    }

    @Override
    public void perform() {
        AttachTASummaryInteractor attachTASummaryInteractor = (AttachTASummaryInteractor)this.getGui();
        ObsProposal obsProposal = attachTASummaryInteractor.getProposal();
        try {
            this.generateAndAttachPdf(obsProposal);
            ActionLog.performed(new Object[]{"Attach TASummary to", obsProposal});
        }
        catch (UnknownEntityException unknownEntityException) {
            Log.logger((Object)this).warning(unknownEntityException.getMessage());
        }
    }

    private void generateAndAttachPdf(ObsProposal obsProposal) throws UnknownEntityException {
        if (obsProposal == null) {
            return;
        }
        ObsAttachment obsAttachment = obsProposal.getDocuments();
        if (obsAttachment == null) {
            obsAttachment = ObsAttachmentData.createObsAttachment();
            obsProposal.setDocuments(obsAttachment);
        }
        this.generateTACoverSheet(obsProposal, obsAttachment);
        this.generateTAJointProposalSummarySheet(obsProposal, obsAttachment);
        this.generateTAScienceGoalSummaries(obsProposal, obsAttachment);
        DocumentLink documentLink = obsAttachment.getDocumentLink(DocumentLinkData.DOCUMENTCLASS_TA_FLAGSHEET);
        if (documentLink != null) {
            obsAttachment.removeDocumentLink(documentLink);
        }
    }

    private void generateTAJointProposalSummarySheet(@NonNull ObsProposal obsProposal, @NonNull ObsAttachment obsAttachment) {
        File file;
        if (obsProposal == null) {
            throw new NullPointerException("proposal is marked non-null but is null");
        }
        if (obsAttachment == null) {
            throw new NullPointerException("proposalDocuments is marked non-null but is null");
        }
        DocumentLink documentLink = obsAttachment.getDocumentLink(DocumentLinkData.DOCUMENTCLASS_TA_JOINTPROPOSAL);
        if (documentLink != null) {
            obsAttachment.removeDocumentLink(documentLink);
        }
        if (obsProposal.getJointProposal().getIsJointProposal() && (file = this.generateTAJointProposalPdf(obsProposal)) != null && file.length() > 0L) {
            obsAttachment.attachDocument(file, DocumentLinkData.DOCUMENTCLASS_TA_JOINTPROPOSAL);
        }
    }

    private File generateTAJointProposalPdf(@NonNull ObsProposal obsProposal) {
        File file;
        if (obsProposal == null) {
            throw new NullPointerException("proposal is marked non-null but is null");
        }
        try {
            file = File.createTempFile(TA_JOINTPROPOSAL_PDF_FILENAME, ".pdf", FileUtilities.getTmpDir());
        }
        catch (IOException iOException) {
            Log.logger((Object)this).warning(iOException.getMessage());
            return null;
        }
        file.deleteOnExit();
        FeedbackSummaryJointProposal feedbackSummaryJointProposal = new FeedbackSummaryJointProposal(obsProposal);
        feedbackSummaryJointProposal.getPdfExporter().exportToPdf(file);
        return file;
    }

    private void generateTAScienceGoalSummaries(@NonNull ObsProposal obsProposal, @NonNull ObsAttachment obsAttachment) {
        File file;
        if (obsProposal == null) {
            throw new NullPointerException("proposal is marked non-null but is null");
        }
        if (obsAttachment == null) {
            throw new NullPointerException("proposalDocuments is marked non-null but is null");
        }
        DocumentLink documentLink = obsAttachment.getDocumentLink(DocumentLinkData.DOCUMENTCLASS_TA_SCIENCEGOALS);
        if (documentLink != null) {
            obsAttachment.removeDocumentLink(documentLink);
        }
        if ((file = this.generateTAScienceGoalsPdf(obsProposal)) != null && file.length() > 0L) {
            obsAttachment.attachDocument(file, DocumentLinkData.DOCUMENTCLASS_TA_SCIENCEGOALS);
        }
    }

    private void generateTACoverSheet(@NonNull ObsProposal obsProposal, @NonNull ObsAttachment obsAttachment) {
        File file;
        if (obsProposal == null) {
            throw new NullPointerException("proposal is marked non-null but is null");
        }
        if (obsAttachment == null) {
            throw new NullPointerException("proposalDocuments is marked non-null but is null");
        }
        DocumentLink documentLink = obsAttachment.getDocumentLink(DocumentLinkData.DOCUMENTCLASS_TA_COVERPAGE);
        if (documentLink != null) {
            obsAttachment.removeDocumentLink(documentLink);
        }
        if ((file = this.generateTACoverPdf(obsProposal)) != null) {
            obsAttachment.attachDocument(file, DocumentLinkData.DOCUMENTCLASS_TA_COVERPAGE);
        }
    }

    private String makeUniqueName(@NonNull ObsProposal obsProposal) {
        if (obsProposal == null) {
            throw new NullPointerException("proposal is marked non-null but is null");
        }
        String string = obsProposal.getPrincipalInvestigator().getUserId();
        String string2 = obsProposal.getTitle();
        string = string.replaceAll("\\W", "");
        string2 = string2.replaceAll("\\W", "");
        int n = Math.min(15, string2.length());
        string2 = string2.substring(0, n);
        return string + "_" + string2 + "_";
    }

    private File generateTACoverPdf(@NonNull ObsProposal obsProposal) {
        File file;
        if (obsProposal == null) {
            throw new NullPointerException("proposal is marked non-null but is null");
        }
        FeedbackSummaryObsProposal feedbackSummaryObsProposal = new FeedbackSummaryObsProposal(obsProposal);
        try {
            file = File.createTempFile(TA_COVER_PDF_FILENAME, ".pdf", FileUtilities.getTmpDir());
        }
        catch (IOException iOException) {
            Log.logger((Object)this).warning(iOException.getMessage());
            return null;
        }
        file.deleteOnExit();
        feedbackSummaryObsProposal.getPdfExporter().exportToPdf(file);
        return file;
    }

    private File generateTAScienceGoalsPdf(@NonNull ObsProposal obsProposal) {
        File file;
        if (obsProposal == null) {
            throw new NullPointerException("proposal is marked non-null but is null");
        }
        ObsProposalScienceGoalNavigator obsProposalScienceGoalNavigator = new ObsProposalScienceGoalNavigator(obsProposal, true);
        FeedbackSummarySgCollection feedbackSummarySgCollection = new FeedbackSummarySgCollection(obsProposal, obsProposalScienceGoalNavigator);
        try {
            file = File.createTempFile(TA_SCIENCEGOAL_SUMMARY_FILENAME, ".pdf", FileUtilities.getTmpDir());
        }
        catch (IOException iOException) {
            Log.logger((Object)this).warning(iOException.getMessage());
            return null;
        }
        file.deleteOnExit();
        PdfExporter pdfExporter = feedbackSummarySgCollection.getPdfExporter();
        pdfExporter.exportToPdf(file);
        return file;
    }
}

