/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.guiutil.perspectives;

import alma.obsprep.guiutil.perspectives.BadLookAndFeelException;
import alma.obsprep.guiutil.perspectives.PerspectivePane;
import alma.obsprep.guiutil.perspectives.PerspectiveRepository;
import alma.obsprep.guiutil.perspectives.UndefinedPerspectiveException;
import alma.obsprep.guiutil.perspectives.ViewPane;
import java.awt.Component;
import java.awt.Container;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Vector;
import javax.swing.JLabel;
import lombok.NonNull;

public class Perspective {
    protected static final boolean dbg = false;
    protected static final boolean dbg2 = false;
    PerspectivePane mountpoint;
    PerspectiveRepository perspectiveRepository;
    protected String currentPerspectiveDescName = null;
    ViewRepository viewRepository = new ViewRepository();
    private Component[] dbg_beforeReplace;

    static void debug(String string) {
    }

    static void debug2(String string) {
    }

    public Perspective(PerspectivePane perspectivePane) {
        this.mountpoint = perspectivePane;
        this.setRepository(new PerspectiveRepository());
    }

    protected void setRepository(@NonNull PerspectiveRepository perspectiveRepository) {
        if (perspectiveRepository == null) {
            throw new NullPointerException("rep is marked non-null but is null");
        }
        if (this.perspectiveRepository != null) {
            this.perspectiveRepository.setRepositoryListener(null);
        }
        this.perspectiveRepository = perspectiveRepository;
        this.perspectiveRepository.setRepositoryListener(this);
    }

    protected PerspectiveRepository getRepository() {
        return this.perspectiveRepository;
    }

    public String getCurrentPrespectiveDescName() {
        return this.currentPerspectiveDescName;
    }

    protected void registerView(Component component, String string) {
        this.viewRepository.register(component, string);
    }

    protected synchronized void activatePerspective(String string) throws BadLookAndFeelException, UndefinedPerspectiveException {
        if (this.currentPerspectiveDescName != null) {
            this.save(this.currentPerspectiveDescName);
        }
        this.load(string);
    }

    protected synchronized void snapshotPerspective(String string) throws BadLookAndFeelException {
        this.save(string);
        this.load(string);
    }

    protected void saveCurrent() throws BadLookAndFeelException {
        this.save(this.currentPerspectiveDescName);
        this.load(this.currentPerspectiveDescName);
    }

    protected synchronized void save(String string) throws BadLookAndFeelException {
        try {
            PerspectiveDesc perspectiveDesc = this.perspectiveRepository.givePerspective(string);
            this.save(this.mountpoint.getChild(), perspectiveDesc);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    protected synchronized void load(String string) throws UndefinedPerspectiveException {
        try {
            PerspectiveDesc perspectiveDesc = this.perspectiveRepository.givePerspective(string);
            if (!perspectiveDesc.isDefined) {
                throw new UndefinedPerspectiveException(string, "perspective not yet defined");
            }
            Container container = this.load(perspectiveDesc);
            this.mountpoint.setChild(container);
            this.mountpoint.validate();
            this.mountpoint.repaint();
            this.currentPerspectiveDescName = string;
        }
        catch (InvalidClassException invalidClassException) {
            throw new UndefinedPerspectiveException(string, "perspective contains incompatible class");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new UndefinedPerspectiveException(string, "perspective contains unknown class");
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    void save(Container container, PerspectiveDesc perspectiveDesc) throws BadLookAndFeelException, IOException {
        this.takeViewsOut(container);
        try {
            this.saveSkeleton(container, perspectiveDesc);
            perspectiveDesc.isDefined = true;
        }
        catch (NotSerializableException notSerializableException) {
            this.putViewsIn(container);
            perspectiveDesc.isDefined = false;
            throw new BadLookAndFeelException("Look-and-Feel contains non-serializable parts", notSerializableException);
        }
    }

    void takeViewsOut(Container container) {
        Component[] componentArray = container.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            Component component = componentArray[i];
            Perspective.debug2("takeoutViews(): " + container.getClass().getName() + " ($" + Integer.toHexString(container.hashCode()) + ") child #" + i + ": " + component);
            if (container instanceof ViewPane) {
                ViewPlaceholder viewPlaceholder = this.createPlaceHolder(component);
                this.replace(container, viewPlaceholder, i);
                continue;
            }
            if (!(component instanceof Container)) continue;
            this.takeViewsOut((Container)component);
        }
    }

    void saveSkeleton(Container container, PerspectiveDesc perspectiveDesc) throws IOException {
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(perspectiveDesc.createOutputStream());
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(bufferedOutputStream);
        objectOutputStream.writeObject(container);
        objectOutputStream.close();
    }

    Container load(PerspectiveDesc perspectiveDesc) throws IOException, ClassNotFoundException {
        Container container = this.loadSkeleton(perspectiveDesc);
        this.putViewsIn(container);
        return container;
    }

    Container loadSkeleton(PerspectiveDesc perspectiveDesc) throws IOException, ClassNotFoundException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(perspectiveDesc.createInputStream());
        ObjectInputStream objectInputStream = new ObjectInputStream(bufferedInputStream);
        Container container = (Container)objectInputStream.readObject();
        objectInputStream.close();
        return container;
    }

    void putViewsIn(Container container) {
        Component[] componentArray = container.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            Component component = componentArray[i];
            if (component instanceof ViewPlaceholder) {
                Component component2 = this.resolvePlaceHolder((ViewPlaceholder)component);
                Perspective.debug("replacing " + component + " with " + component2);
                this.replace(container, component2, i);
            }
            if (!(component instanceof Container)) continue;
            this.putViewsIn((Container)component);
        }
    }

    public void perspectiveRepositoryChanged(String[] stringArray) {
        int n;
        for (n = 0; n < stringArray.length; ++n) {
            PerspectiveDesc perspectiveDesc = this.perspectiveRepository.givePerspective(stringArray[n]);
            try {
                this.loadSkeleton(perspectiveDesc);
                continue;
            }
            catch (Exception exception) {
                perspectiveDesc.isDefined = false;
                if (!(exception instanceof ClassNotFoundException)) continue;
                Perspective.debug("could not instantiate the deserialized perspective " + stringArray[n] + ": " + exception);
            }
        }
        for (n = 0; n < stringArray.length; ++n) {
            if (!stringArray[n].equals(this.currentPerspectiveDescName)) continue;
            if (!this.perspectiveRepository.givePerspective((String)stringArray[n]).isDefined) break;
            this.load(this.currentPerspectiveDescName);
            break;
        }
    }

    ViewPlaceholder createPlaceHolder(Component component) throws IllegalStateException {
        String string = this.viewRepository.resolve(component);
        return new ViewPlaceholder(string);
    }

    Component resolvePlaceHolder(ViewPlaceholder viewPlaceholder) throws IllegalStateException {
        Component component = this.viewRepository.resolve(viewPlaceholder.id);
        return component;
    }

    void replace(Container container, Component component, int n) {
        this.dbg_beforeReplace(container, component, n);
        Component[] componentArray = new Component[container.getComponentCount()];
        container.removeAll();
        for (int i = 0; i < componentArray.length; ++i) {
            Component component2 = i == n ? component : componentArray[i];
            container.add(component2);
        }
        this.dbg_afterReplace(container, n);
    }

    private void dbg_beforeReplace(Container container, Component component, int n) {
    }

    private void dbg_afterReplace(Container container, int n) {
        Object var3_3 = null;
    }

    static class ViewPlaceholder
    extends JLabel {
        protected String id;

        protected ViewPlaceholder(String string) {
            this.id = string;
        }

        @Override
        public String toString() {
            return this.getClass().getName() + " [" + this.id + "]";
        }
    }

    static class MyByteArrayOutputStream
    extends ByteArrayOutputStream {
        MyByteArrayOutputStream(int n) {
            super(n);
        }

        byte[] getBuffer() {
            return this.buf;
        }

        void setCount(int n) {
            this.count = n;
        }
    }

    protected static class PerspectiveDesc {
        boolean isDefined = false;
        MyByteArrayOutputStream stream;

        PerspectiveDesc() {
            this(32768);
        }

        PerspectiveDesc(int n) {
            this.stream = new MyByteArrayOutputStream(n);
        }

        OutputStream createOutputStream() {
            this.stream.reset();
            return this.stream;
        }

        InputStream createInputStream() {
            return new ByteArrayInputStream(this.stream.toByteArray());
        }
    }

    class ViewRepository {
        protected Vector names = new Vector();
        protected Vector views = new Vector();

        ViewRepository() {
        }

        protected synchronized void register(Component component, String string) {
            this.views.add(component);
            this.names.add(string);
        }

        protected synchronized Component resolve(String string) {
            for (int i = 0; i < this.names.size(); ++i) {
                if (!this.names.elementAt(i).equals(string)) continue;
                return (Component)this.views.elementAt(i);
            }
            throw new IllegalStateException("view name has not been registered: '" + string + "'");
        }

        protected synchronized String resolve(Component component) {
            for (int i = 0; i < this.views.size(); ++i) {
                if (this.views.elementAt(i) != component) continue;
                return (String)this.names.elementAt(i);
            }
            throw new IllegalStateException("view component has not been registered: " + component);
        }
    }
}

