/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.guiutil.mvc.examples;

import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.guiutil.mvc.examples.Rect;
import alma.obsprep.guiutil.mvc.examples.RectEditor;

public class RectModel
extends Model {
    public RectModel(Rect rect) {
        super(rect);
    }

    private Rect getRect() {
        return (Rect)this.getDocument();
    }

    @Override
    public void publish() {
        Rect rect = this.getRect();
        Double d = new Double(rect.getWidth());
        Double d2 = new Double(rect.getLength());
        this.publish(RectEditor.WID_VALUE, d);
        this.publish(RectEditor.WID_UNIT, rect.getWUnit());
        this.publish(RectEditor.LEN_VALUE, d2);
        this.publish(RectEditor.LEN_UNIT, rect.getLUnit());
        this.publish(RectEditor.NAME, rect.getName());
    }

    @Override
    public Object update(Editor editor, FieldID fieldID, Object object) {
        Rect rect = this.getRect();
        if (fieldID.equals(RectEditor.WID_VALUE)) {
            String string = (String)object;
            double d = Double.parseDouble(string);
            double d2 = Rect.conversionFactor(rect.getWUnit());
            double d3 = d * d2;
            rect.setWidth(d3);
            return new Double(d3);
        }
        if (fieldID.equals(RectEditor.LEN_VALUE)) {
            String string = (String)object;
            double d = Double.parseDouble(string);
            double d4 = Rect.conversionFactor(rect.getLUnit());
            double d5 = d * d4;
            rect.setLength(d5);
            return new Double(d5);
        }
        if (fieldID.equals(RectEditor.WID_UNIT)) {
            String string = object.toString();
            double d = Rect.conversionFactor(rect.getWUnit(), string);
            double d6 = rect.getWidth() * d;
            rect.setWUnit(string);
            rect.setWidth(d6);
            return object;
        }
        if (fieldID.equals(RectEditor.LEN_UNIT)) {
            String string = object.toString();
            double d = Rect.conversionFactor(rect.getLUnit(), string);
            double d7 = rect.getLength() * d;
            rect.setLUnit(string);
            rect.setLength(d7);
            return object;
        }
        if (fieldID.equals(RectEditor.NAME)) {
            rect.setName(object.toString());
        }
        return object;
    }
}

