/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.guiutil.mvc;

import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.BOInfo;
import alma.obsprep.bo.BOIntrospector;
import alma.obsprep.bo.BOPropertyDescriptor;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import java.beans.IntrospectionException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Level;

public class AutoModel
extends Model {
    private Class documentClass = null;
    private FieldID[] fieldIDs = null;
    private BOInfo boInfo;
    private int propCount = 0;

    public AutoModel(Object object) throws IntrospectionException {
        this(object.getClass());
        this.document = object;
    }

    public AutoModel(Class clazz) throws IntrospectionException {
        super(null);
        this.documentClass = clazz;
        this.boInfo = BOIntrospector.getBOInfo(clazz);
        this.propCount = this.boInfo.getProperties().length;
        this.fieldIDs = new FieldID[this.propCount];
        for (int i = 0; i < this.propCount; ++i) {
            this.fieldIDs[i] = new FieldID("Auto" + i);
        }
    }

    public FieldID getFieldID(int n) {
        return this.fieldIDs[n];
    }

    public Method getGetter(int n) {
        BOPropertyDescriptor[] bOPropertyDescriptorArray = this.boInfo.getProperties();
        return bOPropertyDescriptorArray[n].getReadMethod();
    }

    public int getPropCount() {
        return this.propCount;
    }

    public Method getSetter(int n) {
        BOPropertyDescriptor[] bOPropertyDescriptorArray = this.boInfo.getProperties();
        return bOPropertyDescriptorArray[n].getWriteMethod();
    }

    public Class getSetterArg(int n) {
        Method method = this.getSetter(n);
        Class<?>[] classArray = method.getParameterTypes();
        return classArray[0];
    }

    @Override
    public void publish() {
        for (int i = 0; i < this.propCount; ++i) {
            try {
                this.publish(this.fieldIDs[i], this.getGetter(i).invoke(this.getDocument(), (Object[])null));
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Log.logger((Object)this).log(Level.WARNING, "", (Throwable)illegalArgumentException);
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                Log.logger((Object)this).log(Level.WARNING, "", (Throwable)illegalAccessException);
                continue;
            }
            catch (InvocationTargetException invocationTargetException) {
                Log.logger((Object)this).log(Level.WARNING, "", (Throwable)invocationTargetException);
            }
        }
    }

    @Override
    public Object update(Editor editor, FieldID fieldID, Object object) {
        Object object2;
        Object object3;
        int n = -1;
        for (int i = 0; i < this.propCount; ++i) {
            if (!this.fieldIDs[i].equals(fieldID)) continue;
            n = i;
            break;
        }
        Method method = this.getSetter(n);
        Class clazz = this.getSetterArg(n);
        if (clazz == Integer.TYPE) {
            object3 = new Integer(object.toString());
        } else if (clazz == Short.TYPE) {
            object3 = new Short(object.toString());
        } else if (clazz == Long.TYPE) {
            object3 = new Long(object.toString());
        } else if (clazz == Float.TYPE) {
            object3 = new Float(object.toString());
        } else if (clazz == Double.TYPE) {
            object3 = new Double(object.toString());
        } else if (clazz == String.class) {
            object3 = object.toString();
        } else if (clazz == Character.TYPE) {
            char c = ' ';
            object2 = object.toString();
            if (((String)object2).length() > 0) {
                c = ((String)object2).charAt(0);
            }
            object3 = new Character(c);
        } else if (clazz == Boolean.TYPE) {
            object3 = new Boolean(object.toString());
        } else {
            throw new RuntimeException("Unknown setter arg class " + clazz);
        }
        Object[] objectArray = new Object[]{object3};
        object2 = this.getDocument();
        try {
            method.invoke(object2, objectArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Log.logger((Object)this).log(Level.WARNING, "", (Throwable)illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            Log.logger((Object)this).log(Level.WARNING, "", (Throwable)illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            Log.logger((Object)this).log(Level.WARNING, "", (Throwable)invocationTargetException);
        }
        return object3;
    }
}

