/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.guiutil.events.examples;

import alma.obsprep.guiutil.events.Event;
import alma.obsprep.guiutil.events.EventManager;
import alma.obsprep.guiutil.events.EventReceiver;
import alma.obsprep.guiutil.events.EventType;

public class Example3 {
    public static final EventType MSG = new EventType("msg");

    public void run() {
        Receiver receiver = new Receiver();
        Sender sender = new Sender();
        LowPassFilter lowPassFilter = new LowPassFilter(5);
        EventManager.subscribeBySrc(sender, lowPassFilter);
        EventManager.subscribeBySrc(lowPassFilter, receiver);
        sender.send(1);
        sender.send(6);
        sender.send(9);
        sender.send(0);
        sender.send(7);
        sender.send(5);
        EventManager.finish();
    }

    public static void main(String[] stringArray) {
        Example3 example3 = new Example3();
        example3.run();
    }

    private class Sender {
        private Sender() {
        }

        public void send(int n) {
            Integer n2 = new Integer(n);
            Event event = new Event(MSG, this, n2);
            EventManager.publish(event);
        }
    }

    private class Receiver
    implements EventReceiver {
        private Receiver() {
        }

        @Override
        public void receiveEvent(Event event) {
            System.out.println("Received " + event);
        }
    }

    private class LowPassFilter
    implements EventReceiver {
        int threshold;

        public LowPassFilter(int n) {
            this.threshold = n;
        }

        @Override
        public void receiveEvent(Event event) {
            Integer n = (Integer)event.getData();
            int n2 = n;
            if (n2 <= this.threshold) {
                Event event2 = new Event(MSG, this, new Integer(n2));
                EventManager.publish(event2);
            }
        }
    }
}

