/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.defaulters;

import alma.obsprep.defaulters.Range;

public class NumericRange
implements Range {
    private double lower;
    private boolean lowerIn;
    private double upper;
    private boolean upperIn;

    public NumericRange(double d, double d2, boolean bl, boolean bl2) {
        this.lower = d;
        this.upper = d2;
        this.lowerIn = bl;
        this.upperIn = bl2;
    }

    private boolean isValid(Double d) {
        double d2 = d;
        if (this.lower < d2 && d2 < this.upper) {
            return true;
        }
        if (this.lowerIn && d2 == this.lower) {
            return true;
        }
        return this.upperIn && d2 == this.upper;
    }

    private boolean isValid(Float f) {
        Double d = new Double(f.doubleValue());
        return this.isValid(d);
    }

    private boolean isValid(Integer n) {
        Double d = new Double(n.doubleValue());
        return this.isValid(d);
    }

    @Override
    public boolean isValid(Object object) {
        if (object instanceof Double) {
            return this.isValid((Double)object);
        }
        if (object instanceof Float) {
            return this.isValid((Float)object);
        }
        if (object instanceof Integer) {
            return this.isValid((Integer)object);
        }
        throw new IllegalArgumentException("Unknown type: " + object.getClass().getName());
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.lowerIn ? "[" : "(").append(this.lower).append(",").append(this.upper).append(this.upperIn ? "]" : ")");
        return stringBuffer.toString();
    }
}

