/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.bo.schedblock;

import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.observatorycharacteristics.capabilities.AlmaCapabilities;
import alma.obsprep.bo.enumerations.ReceiverType;
import alma.obsprep.bo.enumerations.Telescope;
import alma.obsprep.bo.obsproject.SpectralScan;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.obsproposal.ObsProposal;
import alma.obsprep.services.generator.BaseBandDeployer;
import alma.obsprep.services.generator.BaseBandNotDeployableException;
import alma.obsprep.util.FrequencyRange;
import alma.obsprep.util.VupRange;
import alma.valuetypes.Frequency;
import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import lombok.NonNull;
import org.apache.commons.jcs3.JCS;
import org.apache.commons.jcs3.access.CacheAccess;

public final class ReceiverBand
implements Comparable<ReceiverBand> {
    private static CacheAccess<Long, ReceiverBand> rxbCache = JCS.getInstance((String)"rxbCache");
    public static final String RECEIVERBAND_ALMA_RB_01 = "ALMA_RB_01";
    public static final String RECEIVERBAND_ALMA_RB_02 = "ALMA_RB_02";
    public static final String RECEIVERBAND_ALMA_RB_03 = "ALMA_RB_03";
    public static final String RECEIVERBAND_ALMA_RB_04 = "ALMA_RB_04";
    public static final String RECEIVERBAND_ALMA_RB_05 = "ALMA_RB_05";
    public static final String RECEIVERBAND_ALMA_RB_06 = "ALMA_RB_06";
    public static final String RECEIVERBAND_ALMA_RB_07 = "ALMA_RB_07";
    public static final String RECEIVERBAND_ALMA_RB_08 = "ALMA_RB_08";
    public static final String RECEIVERBAND_ALMA_RB_09 = "ALMA_RB_09";
    public static final String RECEIVERBAND_ALMA_RB_10 = "ALMA_RB_10";
    public static final String RECEIVERTYPE_DSB = "DSB";
    public static final String RECEIVERTYPE_SSB = "SSB";
    public static final String RECEIVERTYPE_TSB = "TSB";
    private static final ReceiverBand[] ALLBANDS = new ReceiverBand[]{new ReceiverBand(1, "SSB", 35.0, 50.0, 4.0, 12.0, 1, 0.0, false, true, "ALMA_RB_01", 1000.0, 35.0, 52.0), new ReceiverBand(2, "SSB", 67.0, 84.0, 4.0, 12.0, 1, 0.0, true, false, "ALMA_RB_02", 1000.0, 67.0, 84.0), new ReceiverBand(3, "TSB", 84.0, 116.0, 4.0, 8.0, 1, "ALMA_RB_03", 1000.0, 84.0, 116.0), new ReceiverBand(4, "TSB", 125.0, 163.0, 4.0, 8.0, 2, "ALMA_RB_04", 1000.0, 125.0, 163.0), new ReceiverBand(5, "TSB", 158.0, 211.0, 4.0, 8.0, 2, "ALMA_RB_05", 1000.0, 158.0, 211.0), new ReceiverBand(6, "TSB", 211.0, 275.0, 4.5, 10.0, 3, "ALMA_RB_06", 1000.0, 211.0, 275.0), new ReceiverBand(7, "TSB", 275.0, 373.0, 4.0, 8.0, 3, "ALMA_RB_07", 500.0, 275.0, 373.0), new ReceiverBand(8, "TSB", 385.0, 500.0, 4.0, 8.0, 5, "ALMA_RB_08", 500.0, 385.0, 500.0), new ReceiverBand(9, "DSB", 602.0, 720.0, 4.0, 12.0, 5, 1.0, "ALMA_RB_09", 100.0, 602.0, 720.0), new ReceiverBand(10, "DSB", 787.0, 950.0, 4.0, 12.0, 9, 1.0, "ALMA_RB_10", 100.0, 787.0, 950.0)};
    private static Map<Integer, ReceiverBand> bandMap = new HashMap<Integer, ReceiverBand>();
    public static final ReceiverBand ILLEGAL_RECEIVER;
    private static final FrequencyRange B4B5Overlap;
    private final int number;
    private final String type;
    private final String name;
    private final double rfMax;
    private final double rfMin;
    private final double ifMax;
    private final double ifMin;
    private final int nCold;
    private final boolean hasLower;
    private final boolean hasUpper;
    private final double dynRangeLimit;
    private final double sidebandGainRatio;
    private final double hardRFMin;
    private final double hardRFMax;
    private static ReceiverBand[] availableBands;

    public static Set<ReceiverBand> getFullPolarizationReceiverBands() {
        if (Telescope.isOTConfiguredAs(Telescope.CSVALMA)) {
            return Set.of(ReceiverBand.getReceiverBand(1), ReceiverBand.getReceiverBand(3), ReceiverBand.getReceiverBand(4), ReceiverBand.getReceiverBand(5), ReceiverBand.getReceiverBand(6), ReceiverBand.getReceiverBand(7));
        }
        Set<ReceiverBand> set = Set.of();
        try {
            set = ObsProposal.isVLBIRelated() ? Set.of(ReceiverBand.getReceiverBand(1), ReceiverBand.getReceiverBand(3), ReceiverBand.getReceiverBand(4), ReceiverBand.getReceiverBand(5), ReceiverBand.getReceiverBand(6), ReceiverBand.getReceiverBand(7)) : Set.of(ReceiverBand.getReceiverBand(3), ReceiverBand.getReceiverBand(4), ReceiverBand.getReceiverBand(5), ReceiverBand.getReceiverBand(6), ReceiverBand.getReceiverBand(7));
        }
        catch (UnknownEntityException unknownEntityException) {
            Log.logger(ReceiverBand.class).warning("Unable to determine if VLBI " + unknownEntityException.getMessage());
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private static ReceiverBand[] getAvailableBands() {
        if (availableBands == null) {
            Class<ReceiverBand> clazz = ReceiverBand.class;
            // MONITORENTER : alma.obsprep.bo.schedblock.ReceiverBand.class
            if (availableBands == null) {
                List<String> list = AlmaCapabilities.getInstance().getAvailableReceiverBands();
                int n = list.size();
                availableBands = new ReceiverBand[n];
                for (int i = 0; i < n; ++i) {
                    for (int j = 0; j < ALLBANDS.length; ++j) {
                        if (!ReceiverBand.ALLBANDS[j].name.equals(list.get(i))) continue;
                        ReceiverBand.availableBands[i] = ALLBANDS[j];
                    }
                }
            }
            // MONITOREXIT : clazz
        }
        if ($assertionsDisabled) return Arrays.copyOf(availableBands, availableBands.length);
        if (availableBands != null) return Arrays.copyOf(availableBands, availableBands.length);
        throw new AssertionError();
    }

    private static void configureBandMap() {
        for (ReceiverBand receiverBand : ReceiverBand.getKnownReceiverBands()) {
            bandMap.put(receiverBand.getNumber(), receiverBand);
        }
    }

    private ReceiverBand(int n, String string, double d, double d2, double d3, double d4, int n2, double d5, boolean bl, boolean bl2, String string2, double d6, double d7, double d8) {
        this.number = n;
        this.type = string;
        this.rfMin = d;
        this.rfMax = d2;
        this.ifMin = d3;
        this.ifMax = d4;
        this.nCold = n2;
        this.sidebandGainRatio = d5;
        this.hasLower = bl;
        this.hasUpper = bl2;
        this.name = string2;
        this.dynRangeLimit = d6;
        this.hardRFMin = d7;
        this.hardRFMax = d8;
    }

    private ReceiverBand(int n, String string, double d, double d2, double d3, double d4, int n2, String string2, double d5, double d6, double d7) {
        this(n, string, d, d2, d3, d4, n2, 0.0, true, true, string2, d5, d6, d7);
    }

    private ReceiverBand(int n, String string, double d, double d2, double d3, double d4, int n2, double d5, String string2, double d6, double d7, double d8) {
        this(n, string, d, d2, d3, d4, n2, d5, true, true, string2, d6, d7, d8);
    }

    public static String getAllowedFrequencyRangesDesc() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Allowed frequency ranges are (in GHz):\n");
        for (int i = 0; i < ReceiverBand.getAvailableBands().length; ++i) {
            stringBuilder.append(ReceiverBand.getAvailableBands()[i].toString());
            if ((i + 1) % 4 == 0) {
                stringBuilder.append("\n");
                continue;
            }
            stringBuilder.append(" ");
        }
        return stringBuilder.toString();
    }

    public static String[] getKnownReceiverBandNames() {
        String[] stringArray = new String[ReceiverBand.getAvailableBands().length];
        for (int i = 0; i < ReceiverBand.getAvailableBands().length; ++i) {
            stringArray[i] = ReceiverBand.getAvailableBands()[i].getName();
        }
        return stringArray;
    }

    public static Collection<ReceiverBand> getKnownReceiverBands() {
        ArrayList<ReceiverBand> arrayList = new ArrayList<ReceiverBand>(ReceiverBand.getAvailableBands().length);
        for (ReceiverBand receiverBand : ReceiverBand.getAvailableBands()) {
            arrayList.add(receiverBand);
        }
        return arrayList;
    }

    public static ReceiverBand getReceiverBand(VupRange<Frequency> vupRange) throws ReceiverNotFoundException {
        Frequency frequency;
        if (vupRange == null) {
            throw new ReceiverNotFoundException("Frequency range not specified correctly");
        }
        Frequency frequency2 = vupRange.min();
        long l = Objects.hashCode((Object[])new Object[]{frequency2, frequency = vupRange.max()});
        ReceiverBand receiverBand = (ReceiverBand)rxbCache.get((Object)l);
        if (receiverBand != null) {
            return receiverBand;
        }
        if (frequency2 == null || frequency == null || frequency.isEqual((AbstractDoubleWithUnit)frequency2, 1.0E-5)) {
            throw new ReceiverNotFoundException("Frequency range not specified correctly");
        }
        for (ReceiverBand receiverBand2 : ReceiverBand.getAvailableBands()) {
            FrequencyRange frequencyRange = receiverBand2.getRFRange();
            if (!frequencyRange.contains(vupRange)) continue;
            if (vupRange.intersects(B4B5Overlap)) {
                return ReceiverBand.resolveB4B5FrequencyOverlap(vupRange);
            }
            rxbCache.put((Object)l, (Object)receiverBand2);
            return receiverBand2;
        }
        return null;
    }

    private static ReceiverBand resolveB4B5FrequencyOverlap(VupRange<Frequency> vupRange) {
        if (B4B5Overlap.contains(vupRange)) {
            return bandMap.get(5);
        }
        if (bandMap.get(4).getHardRFRange().contains(vupRange)) {
            return bandMap.get(4);
        }
        if (bandMap.get(5).getHardRFRange().contains(vupRange)) {
            return bandMap.get(5);
        }
        return null;
    }

    public static Collection<ReceiverBand> getFullReceiverBands() {
        TreeSet<ReceiverBand> treeSet = new TreeSet<ReceiverBand>();
        for (ReceiverBand receiverBand : ALLBANDS) {
            treeSet.add(receiverBand);
        }
        return treeSet;
    }

    public static ReceiverBand getReceiverBand(String string) {
        for (int i = 0; i < ReceiverBand.getAvailableBands().length; ++i) {
            ReceiverBand receiverBand = ReceiverBand.getAvailableBands()[i];
            if (!receiverBand.getName().equals(string)) continue;
            return receiverBand;
        }
        return null;
    }

    public static ReceiverBand getReceiverBand(@NonNull SpectralSetupParameters spectralSetupParameters) throws ReceiverNotFoundException {
        boolean bl;
        if (spectralSetupParameters == null) {
            throw new NullPointerException("ssp is marked non-null but is null");
        }
        ReceiverBand receiverBand = null;
        boolean bl2 = spectralSetupParameters.getSSPDerivedFromSpectralScanSetup();
        boolean bl3 = bl = bl2 || spectralSetupParameters.isSpectralScan();
        if (bl) {
            SpectralScan spectralScan;
            SpectralScan spectralScan2 = spectralScan = bl2 ? spectralSetupParameters.getScienceGoal().getParentSpectralSetupParameters().getSpectralScan() : spectralSetupParameters.getSpectralScan();
            if (spectralScan == null) {
                throw new ReceiverNotFoundException();
            }
            receiverBand = spectralScan.getSpectralScanReceiverBand();
        } else {
            try {
                BaseBandDeployer baseBandDeployer = new BaseBandDeployer(spectralSetupParameters);
                Optional<ReceiverBand> optional = baseBandDeployer.getReceiverBand(false);
                if (!optional.isPresent()) {
                    optional = baseBandDeployer.getReceiverBand(true);
                }
                if (optional.isPresent()) {
                    receiverBand = optional.get();
                }
            }
            catch (BaseBandNotDeployableException baseBandNotDeployableException) {
                throw new ReceiverNotFoundException(baseBandNotDeployableException);
            }
        }
        if (receiverBand != null) {
            return receiverBand;
        }
        throw new ReceiverNotFoundException();
    }

    @Deprecated(forRemoval=true)
    public static String getReceiverBandName(double d) throws IllegalArgumentException {
        for (int i = 0; i < ReceiverBand.getAvailableBands().length; ++i) {
            ReceiverBand receiverBand = ReceiverBand.getAvailableBands()[i];
            if (!(receiverBand.getRFMin() <= d) || !(d <= receiverBand.getRFMax())) continue;
            return receiverBand.getName();
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Unknown frequency: ").append(d).append("\n").append(ReceiverBand.getAllowedFrequencyRangesDesc());
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    public static ReceiverBand getReceiverBand(Frequency frequency) throws IllegalArgumentException {
        return ReceiverBand.getReceiverBand(frequency.getContentInGHz());
    }

    public static ReceiverBand getReceiverBand(double d) throws IllegalArgumentException {
        for (int i = 0; i < ReceiverBand.getAvailableBands().length; ++i) {
            ReceiverBand receiverBand = ReceiverBand.getAvailableBands()[i];
            if (!(receiverBand.getRFMin() <= d) || !(d <= receiverBand.getRFMax())) continue;
            return receiverBand;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Unknown frequency: ").append(d).append("\n");
        throw new IllegalArgumentException(stringBuffer.toString());
    }

    public static Set<ReceiverBand> getReceiverBands(List<Frequency> list) {
        HashSet<ReceiverBand> hashSet = new HashSet<ReceiverBand>();
        for (Frequency frequency : list) {
            double d = frequency.getContentInGHz();
            ReceiverBand.getKnownReceiverBands().stream().filter(receiverBand -> receiverBand.isValidFrequency(d)).forEach(receiverBand -> hashSet.add((ReceiverBand)receiverBand));
        }
        return hashSet;
    }

    public static Collection<ReceiverBand> getReceiverBands(Integer ... integerArray) {
        ArrayList<ReceiverBand> arrayList = new ArrayList<ReceiverBand>(10);
        for (ReceiverBand receiverBand : ReceiverBand.getKnownReceiverBands()) {
            for (Integer n : integerArray) {
                if (receiverBand.getNumber() != n.intValue()) continue;
                arrayList.add(receiverBand);
            }
        }
        return arrayList;
    }

    public static ReceiverBand getReceiverBand(int n) {
        return bandMap.get(n);
    }

    public ReceiverType getReceiverType() {
        return ReceiverType.valueOf(this.type);
    }

    public double getRFMax() {
        return this.rfMax;
    }

    public double getRFMin() {
        return this.rfMin;
    }

    public double getIFMax() {
        return this.ifMax;
    }

    public double getIFMin() {
        return this.ifMin;
    }

    public double getLOMax() {
        if (this.number == 2) {
            return this.getRFMax() + this.getIFMin();
        }
        return this.getRFMax() - this.getIFMax();
    }

    public double getLOMin() {
        switch (this.number) {
            case 1: {
                return this.getRFMin() - this.getIFMin();
            }
            case 5: {
                return 166.0;
            }
        }
        return this.getRFMin() + this.getIFMax();
    }

    public double getSidebandGainRatio() {
        return this.sidebandGainRatio;
    }

    public int getNCold() {
        return this.nCold;
    }

    public boolean hasLower() {
        return this.hasLower;
    }

    public boolean hasUpper() {
        return this.hasUpper;
    }

    public String getName() {
        return this.name;
    }

    public double getDynamicRangeLimit() {
        return this.dynRangeLimit;
    }

    public FrequencyRange getRFRange() {
        return new FrequencyRange(Frequency.createFrequencyGHZ(this.rfMin), Frequency.createFrequencyGHZ(this.rfMax));
    }

    public FrequencyRange getHardRFRange() {
        return new FrequencyRange(Frequency.createFrequencyGHZ(this.hardRFMin), Frequency.createFrequencyGHZ(this.hardRFMax));
    }

    public FrequencyRange getIFRange() {
        Frequency frequency = Frequency.createFrequencyGHZ(this.ifMin);
        Frequency frequency2 = Frequency.createFrequencyGHZ(this.ifMax);
        return new FrequencyRange(frequency, frequency2);
    }

    public boolean isValidFrequency(double d) {
        return d <= this.getRFMax() && d >= this.getRFMin();
    }

    @Override
    public int compareTo(ReceiverBand receiverBand) {
        return Integer.valueOf(this.number).compareTo(receiverBand.number);
    }

    public double getSuitabilityRating(double d) {
        double d2 = d - this.getRFMin();
        double d3 = this.getRFMax() - d;
        return Math.min(d2, d3);
    }

    public String toString() {
        return this.getRFRangeString();
    }

    public String getRFRangeString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getName()).append(" [").append(this.getRFMin()).append("-").append(this.getRFMax()).append("]");
        return stringBuffer.toString();
    }

    public String getIFRangeString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getName()).append(" [").append(this.getIFMin()).append("-").append(this.getIFMax()).append("]");
        return stringBuffer.toString();
    }

    public static boolean isWalshReceiverSelected(@NonNull SpectralSetupParameters spectralSetupParameters) throws ReceiverNotFoundException {
        if (spectralSetupParameters == null) {
            throw new NullPointerException("ssp is marked non-null but is null");
        }
        ReceiverBand receiverBand = null;
        if (spectralSetupParameters.isSpectralScan()) {
            SpectralScan spectralScan = spectralSetupParameters.getSpectralScan();
            if (spectralScan == null) {
                return false;
            }
            receiverBand = spectralScan.getSpectralScanReceiverBand();
            if (receiverBand == null) {
                throw new ReceiverNotFoundException();
            }
            return ReceiverBand.isReceiverBandInSet(receiverBand, 9, 10);
        }
        receiverBand = spectralSetupParameters.getReceiverBand();
        if (receiverBand == null) {
            throw new ReceiverNotFoundException();
        }
        return ReceiverBand.isReceiverBandInSet(receiverBand, 9, 10);
    }

    public boolean is90DegWalshSwitchingCapable() {
        return this.equals(ReceiverBand.getReceiverBand(9)) || this.equals(ReceiverBand.getReceiverBand(10));
    }

    public static boolean isReceiverBandInSet(@NonNull ReceiverBand receiverBand, int ... nArray) {
        if (receiverBand == null) {
            throw new NullPointerException("receiverBand is marked non-null but is null");
        }
        if (nArray.length == 0) {
            return false;
        }
        for (int n : nArray) {
            if (receiverBand.number != n) continue;
            return true;
        }
        return false;
    }

    public static boolean isHighFrequencyBand(@NonNull ReceiverBand receiverBand) {
        if (receiverBand == null) {
            throw new NullPointerException("receiverBand is marked non-null but is null");
        }
        return ReceiverBand.isReceiverBandInSet(receiverBand, 8, 9, 10);
    }

    public int getNumber() {
        return this.number;
    }

    public String getType() {
        return this.type;
    }

    static {
        ReceiverBand.getAvailableBands();
        ReceiverBand.configureBandMap();
        Frequency[] frequencyArray = new Frequency[]{Frequency.createFrequencyGHZ(ReceiverBand.getReceiverBand((int)5).hardRFMin), Frequency.createFrequencyGHZ(ReceiverBand.getReceiverBand((int)4).hardRFMax)};
        B4B5Overlap = FrequencyRange.wholeRange(frequencyArray);
        ILLEGAL_RECEIVER = new ReceiverBand(0, "N/A", 0.0, 0.0, 0.0, 0.0, 0, "Receiver not specified", 0.0, 0.0, 0.0);
        availableBands = null;
    }

    public static class ReceiverNotFoundException
    extends Exception {
        public ReceiverNotFoundException(String string) {
            super(string);
        }

        public ReceiverNotFoundException() {
        }

        public ReceiverNotFoundException(BaseBandNotDeployableException baseBandNotDeployableException) {
            super(baseBandNotDeployableException);
        }
    }
}

