/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.bo.schedblock;

import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.obsprep.bo.enumerations.CorrBits;
import alma.obsprep.bo.enumerations.CorrFilter;
import alma.obsprep.bo.enumerations.CorrFraction;
import alma.obsprep.bo.enumerations.CorrPolarization;
import alma.obsprep.bo.schedblock.BandwidthLabels;
import alma.obsprep.bo.schedblock.ChannelLabels;
import alma.obsprep.bo.schedblock.ConfigModeDecoder;
import alma.obsprep.bo.schedblock.ConfigModeDecoderImpl;
import alma.obsprep.bo.schedblock.CorrConfigMode;
import alma.obsprep.bo.schedblock.ResolutionLabels;
import alma.obsprep.ot.gui.toplevel.InitServices;
import alma.valuetypes.Frequency;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.jcs3.JCS;
import org.apache.commons.jcs3.access.CacheAccess;

public class OTConfigModeDecoder {
    private static CacheAccess<Double, CorrConfigMode> findModeCache = JCS.getInstance((String)"findMode1Cache");
    static ChannelLabels nominalChannelLabels;
    static BandwidthLabels nominalBandwidthLabels;
    static ResolutionLabels resolutionLabels;
    static SortedSet<Double> knownNominalBandwidthsSet;
    static SortedSet<Integer> knownNominalChannelsSet;
    static SortedSet<Double> knownResolutionSet;
    static Set<CorrConfigMode> availableModeSet;
    static SortedSet<CorrConfigMode> knownFullFractionModeSet;
    static SortedSet<CorrConfigMode> knownNonSensitivityImproveSet;
    private static ConfigModeDecoder decoder;
    private static final Frequency BW31MHZ;
    private static OTConfigModeDecoder instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static OTConfigModeDecoder getInstance() {
        if (instance != null) return instance;
        Class<OTConfigModeDecoder> clazz = OTConfigModeDecoder.class;
        synchronized (OTConfigModeDecoder.class) {
            if (instance != null) return instance;
            instance = new OTConfigModeDecoder();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private static void configure() {
        knownNominalBandwidthsSet = new TreeSet<Double>();
        knownNominalChannelsSet = new TreeSet<Integer>();
        knownResolutionSet = new TreeSet<Double>();
        for (CorrConfigMode corrConfigMode : CorrConfigMode.getAllModes()) {
            if (!availableModeSet.contains(corrConfigMode)) continue;
            knownNominalChannelsSet.add(corrConfigMode.getNominalChannels());
            knownNominalBandwidthsSet.add(corrConfigMode.getNominalBandwidth().getContentInMHz());
            knownResolutionSet.add(corrConfigMode.getResolution().getContentInMHz());
            CorrFilter corrFilter = corrConfigMode.getFilter();
            if (corrFilter != CorrFilter.TFB || corrConfigMode.isSensitivityImproveMode()) continue;
            knownNonSensitivityImproveSet.add(corrConfigMode);
            if (corrConfigMode.getFraction() != CorrFraction.FULL) continue;
            knownFullFractionModeSet.add(corrConfigMode);
        }
        nominalChannelLabels = new ChannelLabels(knownNominalChannelsSet);
        nominalBandwidthLabels = new BandwidthLabels(knownNominalBandwidthsSet);
        resolutionLabels = new ResolutionLabels(knownResolutionSet);
    }

    public static void setAvailableModes(Set<Integer> set) {
        if (set == null) {
            availableModeSet = CorrConfigMode.getAllModes();
        } else {
            availableModeSet = new TreeSet<CorrConfigMode>();
            for (int n : set) {
                CorrConfigMode corrConfigMode = CorrConfigMode.getCorrConfigMode(n);
                if (corrConfigMode == CorrConfigMode.INVALID_CORRCONFIGMODE) continue;
                availableModeSet.add(corrConfigMode);
            }
        }
        OTConfigModeDecoder.configure();
    }

    public String[] getKnownNominalChannelLabels() {
        return nominalChannelLabels.getKnownLabels();
    }

    public String[] getKnownNominalBandwidthLabels() {
        return nominalBandwidthLabels.getKnownLabels();
    }

    public String[] getKnownResolutionLabels() {
        return resolutionLabels.getKnownLabels();
    }

    public int getNominalBandwidthLabelIndex(Frequency frequency) {
        return nominalBandwidthLabels.getIndex(frequency.getContentInMHz());
    }

    public int getNominalChannelLabelIndex(int n) {
        return nominalChannelLabels.getIndex(n);
    }

    public int getResolutionLabelIndex(Frequency frequency) {
        return resolutionLabels.getIndex(frequency.getContentInMHz());
    }

    public boolean[] nominalBandwidthLabelEffectivity(Set<CorrConfigMode> set) {
        HashSet<Double> hashSet = new HashSet<Double>();
        for (CorrConfigMode corrConfigMode : set) {
            hashSet.add(corrConfigMode.getNominalBandwidth().getContentInMHz());
        }
        return nominalBandwidthLabels.effectivity(hashSet);
    }

    public boolean[] nominalChannelLabelEffectivity(Set<CorrConfigMode> set) {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (CorrConfigMode corrConfigMode : set) {
            hashSet.add(corrConfigMode.getNominalChannels());
        }
        return nominalChannelLabels.effectivity(hashSet);
    }

    public boolean[] resolutionLabelEffectivity(Set<CorrConfigMode> set) {
        HashSet<Double> hashSet = new HashSet<Double>();
        for (CorrConfigMode corrConfigMode : set) {
            hashSet.add(corrConfigMode.getResolution().getContentInMHz());
        }
        return resolutionLabels.effectivity(hashSet);
    }

    public CorrConfigMode findMode(Frequency frequency, int n, CorrBits corrBits, boolean bl, CorrPolarization corrPolarization, CorrFilter corrFilter) {
        try {
            int n2 = decoder.findMode((float)frequency.getContentInGHz(), n, corrBits.ebits, bl, corrPolarization.epolarization, corrFilter.getEmode());
            return CorrConfigMode.getCorrConfigMode(n2);
        }
        catch (ConfigModeDecoder.ConfigModeException configModeException) {
            return CorrConfigMode.INVALID_CORRCONFIGMODE;
        }
    }

    public CorrConfigMode findMode(Frequency frequency, int n, CorrBits corrBits, boolean bl, CorrPolarization corrPolarization) {
        CorrConfigMode corrConfigMode = this.findMode(frequency, n, corrBits, bl, corrPolarization, CorrFilter.TFB);
        if (!corrConfigMode.isValid()) {
            corrConfigMode = this.findMode(frequency, n, corrBits, bl, corrPolarization, CorrFilter.TDM);
        }
        return corrConfigMode;
    }

    public CorrConfigMode findMode(Frequency frequency, int n, String string, boolean bl, String string2) {
        Object object;
        Double d = frequency.getContentInGHz() * 11.0 + (double)(n * 31) + (double)(string.hashCode() * 13) + (double)(string2.hashCode() * 19) + (double)(bl ? 71 : 211);
        if (!Double.isNaN(d) && (object = (CorrConfigMode)findModeCache.get((Object)d)) != null) {
            return object;
        }
        object = CorrBits.getCorrBits(string);
        CorrPolarization corrPolarization = CorrPolarization.getCorrPolarization(string2);
        CorrConfigMode corrConfigMode = this.findMode(frequency, n, (CorrBits)((Object)object), bl, corrPolarization);
        findModeCache.put((Object)d, (Object)corrConfigMode);
        return corrConfigMode;
    }

    public Set<CorrConfigMode> getFullFractionModeSet(CorrPolarization corrPolarization) {
        return this.findMode(corrPolarization, knownFullFractionModeSet);
    }

    public Set<CorrConfigMode> getFractionSet(int n) {
        TreeSet<CorrConfigMode> treeSet = new TreeSet<CorrConfigMode>();
        CorrConfigMode corrConfigMode = CorrConfigMode.getCorrConfigMode(n);
        Frequency frequency = corrConfigMode.getNominalBandwidth();
        Frequency frequency2 = corrConfigMode.getResolution();
        Set<CorrConfigMode> set = this.findMode(corrConfigMode.getPolarization());
        for (CorrConfigMode corrConfigMode2 : set) {
            if (corrConfigMode2.getFilter() != CorrFilter.TFB || corrConfigMode2.isSensitivityImproveMode() || !corrConfigMode2.getNominalBandwidth().isEqual((AbstractDoubleWithUnit)frequency) && !corrConfigMode2.getResolution().isEqual((AbstractDoubleWithUnit)frequency2)) continue;
            treeSet.add(corrConfigMode2);
        }
        return treeSet;
    }

    public Set<CorrConfigMode> getSensitivityImprovedGroup(int n) {
        TreeSet<CorrConfigMode> treeSet = new TreeSet<CorrConfigMode>();
        CorrConfigMode corrConfigMode = CorrConfigMode.getCorrConfigMode(n);
        if (!corrConfigMode.isSensitivityImproveMode()) {
            treeSet.add(corrConfigMode);
            CorrPolarization corrPolarization = corrConfigMode.getPolarization();
            int n2 = corrConfigMode.getNominalChannels();
            Frequency frequency = corrConfigMode.getNominalBandwidth();
            CorrFilter corrFilter = CorrFilter.TFB;
            Set<CorrConfigMode> set = this.findMode(corrFilter);
            if (frequency.isEqual((AbstractDoubleWithUnit)BW31MHZ)) {
                treeSet.addAll(this.findMode(frequency, this.findMode(n2 / 4, this.findMode(CorrBits.B4x4, this.findMode(corrPolarization, set)))));
                return treeSet;
            }
            treeSet.add(this.findMode(frequency, n2 / 2, CorrBits.B2x2, true, corrPolarization, corrFilter));
            treeSet.add(this.findMode((Frequency)frequency.divide(2.0), n2 / 2, CorrBits.B2x2, true, corrPolarization, corrFilter));
            treeSet.add(this.findMode(frequency, n2 / 4, CorrBits.B4x4, false, corrPolarization, corrFilter));
            treeSet.add(this.findMode((Frequency)frequency.divide(2.0), n2 / 4, CorrBits.B4x4, false, corrPolarization, corrFilter));
            treeSet.add(this.findMode((Frequency)frequency.divide(4.0), n2 / 4, CorrBits.B4x4, false, corrPolarization, corrFilter));
            treeSet.remove(CorrConfigMode.INVALID_CORRCONFIGMODE);
        }
        return treeSet;
    }

    public Set<CorrConfigMode> getKnownModesSet() {
        return availableModeSet;
    }

    public Set<CorrConfigMode> findMode(CorrPolarization corrPolarization) {
        return this.findMode(corrPolarization, this.getKnownModesSet());
    }

    public Set<CorrConfigMode> findMode(CorrPolarization corrPolarization, Set<CorrConfigMode> set) {
        TreeSet<CorrConfigMode> treeSet = new TreeSet<CorrConfigMode>();
        for (CorrConfigMode corrConfigMode : set) {
            if (corrPolarization != corrConfigMode.getPolarization()) continue;
            treeSet.add(corrConfigMode);
        }
        return treeSet;
    }

    public Set<CorrConfigMode> findMode(CorrFilter corrFilter) {
        return this.findMode(corrFilter, this.getKnownModesSet());
    }

    public Set<CorrConfigMode> findMode(CorrFilter corrFilter, Set<CorrConfigMode> set) {
        TreeSet<CorrConfigMode> treeSet = new TreeSet<CorrConfigMode>();
        for (CorrConfigMode corrConfigMode : set) {
            if (corrFilter != corrConfigMode.getFilter()) continue;
            treeSet.add(corrConfigMode);
        }
        return treeSet;
    }

    public Set<CorrConfigMode> findMode(CorrBits corrBits, Set<CorrConfigMode> set) {
        TreeSet<CorrConfigMode> treeSet = new TreeSet<CorrConfigMode>();
        for (CorrConfigMode corrConfigMode : set) {
            if (corrBits != corrConfigMode.getBits()) continue;
            treeSet.add(corrConfigMode);
        }
        return treeSet;
    }

    public Set<CorrConfigMode> findMode(CorrBits corrBits, boolean bl, CorrPolarization corrPolarization) {
        return this.findMode(corrBits, bl, corrPolarization, this.getKnownModesSet());
    }

    public Set<CorrConfigMode> findMode(CorrBits corrBits, boolean bl, CorrPolarization corrPolarization, Set<CorrConfigMode> set) {
        TreeSet<CorrConfigMode> treeSet = new TreeSet<CorrConfigMode>();
        for (CorrConfigMode corrConfigMode : set) {
            if (corrBits != corrConfigMode.getBits() || bl != corrConfigMode.isOversampling() || corrPolarization != corrConfigMode.getPolarization()) continue;
            treeSet.add(corrConfigMode);
        }
        return treeSet;
    }

    public Set<CorrConfigMode> findMode(boolean bl, CorrPolarization corrPolarization) {
        return this.findMode(bl, corrPolarization, this.getKnownModesSet());
    }

    public Set<CorrConfigMode> findMode(boolean bl, CorrPolarization corrPolarization, Set<CorrConfigMode> set) {
        TreeSet<CorrConfigMode> treeSet = new TreeSet<CorrConfigMode>();
        for (CorrConfigMode corrConfigMode : set) {
            if (bl != corrConfigMode.isOversampling() || corrPolarization != corrConfigMode.getPolarization()) continue;
            treeSet.add(corrConfigMode);
        }
        return treeSet;
    }

    public Set<CorrConfigMode> findMode(Frequency frequency) {
        return this.findMode(frequency, this.getKnownModesSet());
    }

    public Set<CorrConfigMode> findMode(Frequency frequency, Set<CorrConfigMode> set) {
        TreeSet<CorrConfigMode> treeSet = new TreeSet<CorrConfigMode>();
        for (CorrConfigMode corrConfigMode : set) {
            if (!frequency.isEqual((AbstractDoubleWithUnit)corrConfigMode.getNominalBandwidth())) continue;
            treeSet.add(corrConfigMode);
        }
        return treeSet;
    }

    public Set<CorrConfigMode> findModeInBandwidthRange(Frequency frequency, Frequency frequency2, Set<CorrConfigMode> set) {
        TreeSet<CorrConfigMode> treeSet = new TreeSet<CorrConfigMode>();
        Object object = frequency2.deepCopy();
        Frequency frequency3 = frequency.deepCopy();
        if (frequency3.isLessThan((AbstractDoubleWithUnit)object)) {
            Frequency frequency4 = frequency3;
            frequency3 = object;
            object = frequency4;
        }
        for (CorrConfigMode corrConfigMode : set) {
            if (!object.isLessThanOrEqualTo((AbstractDoubleWithUnit)corrConfigMode.getNominalBandwidth()) || !frequency3.isGreaterThanOrEqualTo((AbstractDoubleWithUnit)corrConfigMode.getNominalBandwidth())) continue;
            treeSet.add(corrConfigMode);
        }
        return treeSet;
    }

    public Set<CorrConfigMode> findMode(Frequency frequency, Frequency frequency2, Set<CorrConfigMode> set) {
        TreeSet<CorrConfigMode> treeSet = new TreeSet<CorrConfigMode>();
        for (CorrConfigMode corrConfigMode : set) {
            if (!frequency.isEqual((AbstractDoubleWithUnit)corrConfigMode.getNominalBandwidth()) || !frequency2.isEqual((AbstractDoubleWithUnit)corrConfigMode.getResolution(), 1.0E-12)) continue;
            treeSet.add(corrConfigMode);
        }
        return treeSet;
    }

    public Set<CorrConfigMode> findMode(Frequency frequency, Frequency frequency2, Set<CorrConfigMode> set, Boolean bl, Boolean bl2) {
        TreeSet<CorrConfigMode> treeSet = new TreeSet<CorrConfigMode>();
        for (CorrConfigMode corrConfigMode : set) {
            if (!frequency.isEqual((AbstractDoubleWithUnit)(bl == true ? corrConfigMode.getNominalBandwidth() : corrConfigMode.getEffectiveBandwidth())) || !frequency2.isEqual((AbstractDoubleWithUnit)(bl2 == true ? corrConfigMode.getResolutionSmoothed() : corrConfigMode.getResolution()), 1.0E-12)) continue;
            treeSet.add(corrConfigMode);
        }
        return treeSet;
    }

    public Set<CorrConfigMode> findMode(int n) {
        return this.findMode(n, this.getKnownModesSet());
    }

    public Set<CorrConfigMode> findMode(int n, Set<CorrConfigMode> set) {
        TreeSet<CorrConfigMode> treeSet = new TreeSet<CorrConfigMode>();
        for (CorrConfigMode corrConfigMode : set) {
            if (corrConfigMode.getNominalChannels() != n) continue;
            treeSet.add(corrConfigMode);
        }
        return treeSet;
    }

    public Set<CorrConfigMode> findModeByResolution(Frequency frequency) {
        return this.findModeByResolution(frequency, this.getKnownModesSet());
    }

    public Set<CorrConfigMode> findModeByResolution(Frequency frequency, Set<CorrConfigMode> set) {
        TreeSet<CorrConfigMode> treeSet = new TreeSet<CorrConfigMode>();
        for (CorrConfigMode corrConfigMode : set) {
            double d;
            double d2 = d = frequency.getUnit().equals(Frequency.UNIT_GHZ) ? 1.0E-9 : 1.0E-6;
            if (!frequency.isEqual((AbstractDoubleWithUnit)corrConfigMode.getResolution(), d)) continue;
            treeSet.add(corrConfigMode);
        }
        return treeSet;
    }

    public Set<CorrConfigMode> findMode(CorrFraction corrFraction, Set<CorrConfigMode> set) {
        return this.findMode(corrFraction, false, set);
    }

    public Set<CorrConfigMode> findModeWithStrictImprovedModeCompliance(CorrFraction corrFraction, boolean bl, Set<CorrConfigMode> set) {
        TreeSet<CorrConfigMode> treeSet = new TreeSet<CorrConfigMode>();
        for (CorrConfigMode corrConfigMode : set) {
            if (corrConfigMode.getFraction() != corrFraction || bl != corrConfigMode.isSensitivityImproveMode()) continue;
            treeSet.add(corrConfigMode);
        }
        return treeSet;
    }

    public Set<CorrConfigMode> findMode(CorrFraction corrFraction, boolean bl, Set<CorrConfigMode> set) {
        TreeSet<CorrConfigMode> treeSet = new TreeSet<CorrConfigMode>();
        for (CorrConfigMode corrConfigMode : set) {
            if (corrConfigMode.getFraction() != corrFraction || !bl && corrConfigMode.isSensitivityImproveMode() && !corrConfigMode.isExtraBits()) continue;
            treeSet.add(corrConfigMode);
        }
        return treeSet;
    }

    static {
        availableModeSet = CorrConfigMode.getAllModes();
        knownFullFractionModeSet = new TreeSet<CorrConfigMode>();
        knownNonSensitivityImproveSet = new TreeSet<CorrConfigMode>();
        InitServices.initModelSupportClasses();
        OTConfigModeDecoder.configure();
        decoder = new ConfigModeDecoderImpl();
        BW31MHZ = Frequency.createFrequencyMHZ(31.25);
    }
}

