/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.bo.obsproject;

import alma.entity.xmlbinding.obsproject.ScienceGoalT;
import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.hla.runtime.obsprep.bo.ValueUnitPair;
import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.obsprep.bo.annotations.FieldTargetDocument;
import alma.obsprep.bo.annotations.FieldTargetPart;
import alma.obsprep.bo.annotations.SpatialDocument;
import alma.obsprep.bo.annotations.SpatialPartOfSpatialDocument;
import alma.obsprep.bo.annotations.SpatialPartOfSpectralSpecDocument;
import alma.obsprep.bo.annotations.SpectralSpecDocument;
import alma.obsprep.bo.annotations.SummaryTable;
import alma.obsprep.bo.enumerations.Array;
import alma.obsprep.bo.enumerations.CorrBits;
import alma.obsprep.bo.enumerations.Telescope;
import alma.obsprep.bo.obsproject.AbstractTargetParameters;
import alma.obsprep.bo.obsproject.CalibratedAbstractScienceGoal;
import alma.obsprep.bo.obsproject.ExpectedProperties;
import alma.obsprep.bo.obsproject.ExpectedPropertiesElements;
import alma.obsprep.bo.obsproject.Field;
import alma.obsprep.bo.obsproject.NonOverlappingBandwidthCalculator;
import alma.obsprep.bo.obsproject.ObsProgram;
import alma.obsprep.bo.obsproject.ObsProject;
import alma.obsprep.bo.obsproject.PerformanceParameters;
import alma.obsprep.bo.obsproject.RepresentativeFrequencyChangeEvent;
import alma.obsprep.bo.obsproject.RepresentativeFrequencyListener;
import alma.obsprep.bo.obsproject.ScienceGoalExpertParameterHelper;
import alma.obsprep.bo.obsproject.ScienceSpectralWindow;
import alma.obsprep.bo.obsproject.SpectralScan;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.bo.obsproject.UnableToFindSolutionException;
import alma.obsprep.bo.obsproject.data.ScienceGoalData;
import alma.obsprep.bo.obsproposal.ObsProposal;
import alma.obsprep.bo.schedblock.CorrConfigMode;
import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.ot.boEditors.Wizard;
import alma.obsprep.ot.editors.misc.ScienceGoalSummaryTableColumns;
import alma.obsprep.ot.models.misc.SummaryTableColumns;
import alma.obsprep.ot.models.misc.SummaryTableRow;
import alma.obsprep.ot.models.sciencegoals.SfiControlParameterModel;
import alma.obsprep.ot.models.sciencegoals.TechnicalJustificationModel;
import alma.obsprep.ot.valdef.obsproject.ScienceGoalValidator;
import alma.obsprep.services.etc.ETCTimeCalculator;
import alma.obsprep.services.etc.ObservingTimeCalculator;
import alma.obsprep.services.etc.Phase1DataRateCalculator;
import alma.obsprep.services.etc.SourceNeverVisibleException;
import alma.obsprep.services.etc.editor.WaterVaporColumns;
import alma.obsprep.services.experts.ACANecessityEstimator;
import alma.obsprep.services.experts.Configuration;
import alma.obsprep.services.experts.InvalidConfigurationParametersException;
import alma.obsprep.services.experts.InvalidFrequencyException;
import alma.obsprep.services.experts.SchedBlockExpert;
import alma.obsprep.services.experts.TechnicalJustificationExpert;
import alma.obsprep.services.generator.InvalidObsProgramParametersException;
import alma.obsprep.services.generator.ToBeSupportedException;
import alma.obsprep.services.generator.refactored.MinTuningsCalculator;
import alma.obsprep.services.generator.refactored.RequestedArray;
import alma.obsprep.services.generator.refactored.SchedBlockWorker;
import alma.obsprep.services.sfi.SingleFieldWizard;
import alma.obsprep.services.summaryfeedback.VupComparator;
import alma.obsprep.util.FrequencyRange;
import alma.obsprep.util.MiscUtils;
import alma.obsprep.util.astro.SkyPoint;
import alma.valuetypes.Angle;
import alma.valuetypes.DataRate;
import alma.valuetypes.Flux;
import alma.valuetypes.Frequency;
import alma.valuetypes.Latitude;
import alma.valuetypes.Sensitivity;
import alma.valuetypes.SkyCoordinates;
import alma.valuetypes.StorageVolume;
import alma.valuetypes.Time;
import alma.valuetypes.UserFrequency;
import alma.valuetypes.UserSensitivity;
import alma.valuetypes.Velocity;
import alma.valuetypes.data.SkyCoordinatesData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Vector;
import java.util.stream.Stream;
import lombok.NonNull;

public class ScienceGoal
extends ScienceGoalData
implements SpatialDocument,
FieldTargetDocument,
SpectralSpecDocument,
SpatialPartOfSpectralSpecDocument,
SummaryTable<SummaryTableRow>,
CalibratedAbstractScienceGoal {
    private boolean isTwoBitRepresentationOfFourBitSG = false;
    private static final int KEYTARGETPARAMETER = -1;
    private Optional<Collection<MinTuningsCalculator.TuningResult>> lo1Tunings = Optional.empty();
    private ScienceGoal parentScienceGoal;
    public static final String DEFAULT_NAME = "Science Goal";
    private final SummaryTableColumns summaryTableColumns;
    private ObsProposal obsProposalParent = null;
    private ScienceGoalExpertParameterHelper scienceGoalExpertParameterHelper;
    private Object schedBlockExpert;
    private int lastKeyTargetParameterIndex = 0;
    private ObservingTimeCalculator timeCalculator = null;
    private Integer clusterIndex = null;
    private ScienceGoalType scienceGoalType = ScienceGoalType.USERDEFINED;
    private SpectralSetupParameters parentSpectralSetupParameters;

    public ScienceGoal(ScienceGoalT scienceGoalT) {
        super(scienceGoalT);
        this.summaryTableColumns = new ScienceGoalSummaryTableColumns(this);
    }

    public synchronized ScienceGoal deepCopy() {
        ScienceGoal scienceGoal = super.deepCopy();
        SpectralSetupParameters spectralSetupParameters = scienceGoal.getSpectralSetupParameters();
        spectralSetupParameters.setRepresentativeFrequency(this.getSpectralSetupParameters().getRepresentativeFrequency().deepCopy());
        try {
            scienceGoal.setObsProposalParent(this.getObsProposal());
        }
        catch (UnknownEntityException unknownEntityException) {
            // empty catch block
        }
        this.getSpectralSetupParameters().getOverrideLO1().ifPresent(frequency -> spectralSetupParameters.setOverrideLO1(Optional.of(frequency.deepCopy())));
        scienceGoal.setParentScienceGoal(this);
        scienceGoal.updateLocalReference();
        return scienceGoal;
    }

    public synchronized void initAsNew() {
        super.initAsNew();
        this.setName(DEFAULT_NAME);
        this.updateLocalReference();
        this.setEstimatedTotalTime(Time.createTimeSec(0.0));
        this.getCalibrationSetupParameters();
        this.scienceGoalExpertParameterHelper = new ScienceGoalExpertParameterHelper(this);
    }

    public void setName(String string) {
        if (string == null || "".equals(string)) {
            super.setName(DEFAULT_NAME);
        } else {
            super.setName(string);
        }
    }

    public boolean isPhase1ScienceGoal() {
        return this.getParent() instanceof ObsProposal;
    }

    public boolean isPhase2ScienceGoal() {
        return this.getParent() instanceof ObsProgram;
    }

    public boolean isPolarizationObservation() {
        return SpectralSetupParameters.POLARISATION_FULL.equals(this.getSpectralSetupParameters().getPolarisation());
    }

    public synchronized void updateLocalReference() {
        this.getSpectralSetupParameters().reattachReprFreqCentreFrequencyListeners();
        this.addRepresentativeFrequencyListener(this.getPerformanceParameters());
        for (TargetParameters targetParameters : this.getTargetParameters()) {
            this.addRepresentativeFrequencyListener(targetParameters);
            this.addRepresentativeFrequencyListener(targetParameters.getExpectedProperties());
            for (Field field : targetParameters.getField()) {
                if (!(field instanceof RepresentativeFrequencyListener)) continue;
                this.addRepresentativeFrequencyListener((RepresentativeFrequencyListener)((Object)field));
            }
            TargetParameters.attachSourceVelocityListeners(targetParameters);
        }
        this.getSpectralSetupParameters().reattachReprFreqListener();
    }

    public Collection<BusinessObject> instantiated() {
        Vector<BusinessObject> vector = new Vector<BusinessObject>();
        return vector;
    }

    public ObsProposal getObsProposal() throws UnknownEntityException {
        BusinessObject businessObject = this.getParent();
        if (businessObject == null) {
            return this.obsProposalParent;
        }
        if (businessObject instanceof ObsProgram) {
            if ((businessObject = businessObject.getParent()) == null) {
                return null;
            }
            if (!(businessObject instanceof ObsProject)) {
                throw new RuntimeException("Unable to locate ObsProject associated with science goal");
            }
            ObsProject obsProject = (ObsProject)businessObject;
            return obsProject.getObsProposal();
        }
        if (businessObject instanceof ObsProposal) {
            return (ObsProposal)businessObject;
        }
        throw new RuntimeException("Unable to locate ObsProject associated with science goal");
    }

    public boolean isSpectralScan() {
        return this.getSpectralSetupParameters().isSpectralScan();
    }

    public boolean isSingleContinuum() {
        return this.getSpectralSetupParameters().isSingleContinuum();
    }

    public boolean isSpectral() {
        return true;
    }

    public boolean isSpatial(String string) {
        return "Field Setup".equals(string);
    }

    public boolean isSpectral(String string) {
        return "Spectral Setup".equals(string);
    }

    public Wizard getWizard() {
        if (this.wizard == null) {
            this.wizard = new SingleFieldWizard(this);
        }
        return this.wizard;
    }

    public synchronized void setSchedBlockExpert(Object object) {
        this.schedBlockExpert = object;
    }

    @Override
    public SpatialPartOfSpatialDocument getSpatialPartOfSpatialDocument() {
        return this.getSoleTargetParameters();
    }

    @Override
    public Frequency getSingleFrequency() {
        return this.getRepresentativeFrequencyInSky();
    }

    @Override
    public String getSingleFrequencySource() {
        SpectralSetupParameters spectralSetupParameters = this.getSpectralSetupParameters();
        return spectralSetupParameters.getNameOrDefault() + ":representativeFrequency";
    }

    public Frequency getLO1Frequency() {
        return this.getSpectralSetupParameters().getLO1Frequency();
    }

    public Frequency getRestFrequency() {
        return this.getRepresentativeFrequency();
    }

    @Override
    public FieldTargetPart getFieldTargetPart() {
        return this.getSoleTargetParameters();
    }

    public String getFieldType() {
        String string = TargetParameters.TYPE_F_MULTIPLEPOINTS;
        if (this.getTargetParametersCount() > 0) {
            string = this.getTargetParameters(0).getType();
            for (TargetParameters targetParameters : this.getTargetParameters()) {
                if (targetParameters.getType().equals(string)) continue;
                Log.logger((Object)this).severe("mixed field type is not supported");
                throw new RuntimeException("mixed field type is not supported");
            }
        }
        return string;
    }

    public Frequency getRepresentativeFrequency() {
        SpectralSetupParameters spectralSetupParameters = this.getSpectralSetupParameters();
        Frequency frequency = spectralSetupParameters.gettrueRepresentativeFrequency();
        if (frequency == null || frequency.isZero()) {
            frequency = spectralSetupParameters.getSoleFrequency();
        }
        return frequency;
    }

    public Frequency getRepresentativeFrequencyInSky() {
        SpectralSetupParameters spectralSetupParameters = this.getSpectralSetupParameters();
        Frequency frequency = spectralSetupParameters.gettrueRepresentativeFrequency();
        if (frequency == null || frequency.isZero()) {
            frequency = spectralSetupParameters.getSoleFrequency();
        }
        if (spectralSetupParameters.isSpectralSetupInSky() || spectralSetupParameters.isDerivedSSP()) {
            return frequency;
        }
        return frequency.dopplerShifted(this.getSourceVelocity());
    }

    public Frequency getRepresentativeBandwidth() {
        PerformanceParameters performanceParameters = this.getPerformanceParameters();
        Frequency frequency = null;
        String string = performanceParameters.getDesiredSensitivityFrequencyMeasure();
        frequency = this.getSpectralSetupParameters().getDesiredSensitivityFrequencyWidth(string);
        return frequency;
    }

    public ReceiverBand getReceiverBand() {
        return this.getSpectralSetupParameters().getReceiverBand();
    }

    public TargetParameters getKeyTargetParameters() {
        TargetParameters[] targetParametersArray;
        if (this.getTargetParametersCount() == 0) {
            targetParametersArray = TargetParameters.createTargetParameters();
            this.addTargetParameters((TargetParameters)targetParametersArray);
            targetParametersArray.setIndex(-1);
        }
        if ((targetParametersArray = this.getTargetParameters()).length > this.lastKeyTargetParameterIndex && targetParametersArray[this.lastKeyTargetParameterIndex].getIndex() == -1) {
            return targetParametersArray[this.lastKeyTargetParameterIndex];
        }
        for (int i = 0; i < targetParametersArray.length; ++i) {
            if (targetParametersArray[i].getIndex() != -1) continue;
            this.lastKeyTargetParameterIndex = i;
            return targetParametersArray[i];
        }
        return this.getTargetParameters(0);
    }

    public int getKeyTargetParametersPosition() {
        if (this.getTargetParametersCount() == 0) {
            TargetParameters targetParameters = TargetParameters.createTargetParameters();
            this.addTargetParameters(targetParameters);
            return 0;
        }
        int n = 0;
        for (TargetParameters targetParameters : this.getTargetParameters()) {
            if (targetParameters.getIndex() == -1) {
                return n;
            }
            ++n;
        }
        return 0;
    }

    public synchronized void setKeyTargetParameters(int n) {
        if (this.getTargetParametersCount() == 0) {
            TargetParameters targetParameters = TargetParameters.createTargetParameters();
            this.addTargetParameters(targetParameters);
            targetParameters.setIndex(-1);
        }
        for (int i = 0; i < this.getTargetParametersCount(); ++i) {
            this.getTargetParameters(i).setIndex(0);
            if (i != n) continue;
            this.getTargetParameters(i).setIndex(-1);
        }
    }

    public TargetParameters getSoleTargetParameters() {
        if (this.getTargetParametersCount() == 0) {
            TargetParameters targetParameters = TargetParameters.createTargetParameters();
            this.addTargetParameters(targetParameters);
        }
        return this.getTargetParameters(0);
    }

    public synchronized TargetParameters setTargetParameters(TargetParameters targetParameters) {
        if (this.getTargetParametersCount() > 1) {
            throw new RuntimeException("unexpected multiple TargetParameters");
        }
        if (this.getTargetParametersCount() == 0) {
            this.addTargetParameters(targetParameters);
        } else {
            this.clearTargetParameters();
            this.addTargetParameters(targetParameters);
        }
        return this.getTargetParameters(0);
    }

    @Override
    public Iterator<SummaryTableRow> iterator() {
        ArrayList<TargetParameters> arrayList = new ArrayList<TargetParameters>();
        arrayList.addAll(Arrays.asList(this.getTargetParameters()));
        return arrayList.iterator();
    }

    @Override
    public boolean expandsRow() {
        return true;
    }

    @Override
    public boolean isSummaryTableEditable() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ObservingTimeCalculator getTimeCalculator() {
        if (this.timeCalculator == null) {
            ScienceGoal scienceGoal = this;
            synchronized (scienceGoal) {
                this.timeCalculator = new ObservingTimeCalculator(this);
            }
        }
        return this.timeCalculator;
    }

    public int getNumberOf12mConfigurations() throws InvalidObsProgramParametersException {
        return this.getTimeCalculator().getNumberOfAntennaConfigurations(RequestedArray.TWELVE_M);
    }

    public Time getTotalRequestedTime(Array array) throws InvalidObsProgramParametersException {
        return this.getTimeCalculator().getRequestedTimeForAllConfigurations(array, true);
    }

    public Time getTotalRequestedTime(Array array, boolean bl) throws InvalidObsProgramParametersException {
        return this.getTimeCalculator().getRequestedTimeForAllConfigurations(array, bl);
    }

    public Time getTotalRequestedTimeCompact() throws InvalidObsProgramParametersException {
        Time time = this.getTimeCalculator().getTotalRequestedTime(Array.ARRAY_12M);
        return this.getTimeCalculator().getTimeForSecond12mCompactArray(time, true, false);
    }

    public Time getTotalOnSourceTime(Array array) throws InvalidObsProgramParametersException {
        return this.getTimeCalculator().getTotalOnSourceTime(array, true);
    }

    public Time getTotalTimeForScienceGoal() throws ObservingTimeCalculator.UnableToCalculateTimeEstimateException {
        return this.getTotalTimeForScienceGoal(false);
    }

    public Time getTotalTimeForScienceGoal(boolean bl) throws ObservingTimeCalculator.UnableToCalculateTimeEstimateException {
        return this.getTimeCalculator().getTotalTimeForScienceGoal(false, bl, false, true);
    }

    public Time getTotalTimeForSGWithoutACA(boolean bl) throws ObservingTimeCalculator.UnableToCalculateTimeEstimateException {
        return this.getTimeCalculator().getTotalTimeForScienceGoal(true, bl, false, true);
    }

    public Time getTotal12mExtendedTimeForSG() throws InvalidObsProgramParametersException {
        return this.getTimeCalculator().getTheoreticalOnSourceTimeForArray(Array.ARRAY_12M);
    }

    public Time getSinglePointOnSourceTime(Array array, TargetParameters targetParameters) throws InvalidObsProgramParametersException {
        return this.getTimeCalculator().getSinglePointOnSourceTime(array, targetParameters, true);
    }

    public Time getSinglePointOnSourceTimeFromSB(Array array) throws InvalidObsProgramParametersException, UnknownEntityException {
        TargetParameters targetParameters = this.getSoleTargetParameters();
        return this.getTimeCalculator().singlePointOnSourceTimeFromSB(targetParameters, array);
    }

    public Time getSinglePointOnSourceTimeFromSB(Array array, TargetParameters targetParameters) throws InvalidObsProgramParametersException {
        Time time = this.getTimeCalculator().getSinglePointOnSourceTime(array, targetParameters, true);
        try {
            time = this.getTimeCalculator().singlePointOnSourceTimeFromSB(targetParameters, array);
        }
        catch (UnknownEntityException unknownEntityException) {
            // empty catch block
        }
        return time;
    }

    public Sensitivity getSinglePointOnSourceSensitivity(Array array, Time time, TargetParameters targetParameters, Frequency frequency, Frequency frequency2) throws InvalidFrequencyException, SourceNeverVisibleException {
        return this.getTimeCalculator().singlePointOnSourceSensitivity(array, time, targetParameters, frequency, frequency2, ETCTimeCalculator.CorrelatorModeConversionEnum.NoCorrelatorConversion);
    }

    public Sensitivity getSinglePointOnSourceSensitivity(Array array, Time time, Frequency frequency, Frequency frequency2) throws InvalidFrequencyException, SourceNeverVisibleException {
        TargetParameters targetParameters = this.getSoleTargetParameters();
        return this.getTimeCalculator().singlePointOnSourceSensitivity(array, time, targetParameters, frequency, frequency2, ETCTimeCalculator.CorrelatorModeConversionEnum.NoCorrelatorConversion);
    }

    public Sensitivity getSinglePointOnSourceSensitivity(Array array, Time time, TargetParameters targetParameters, Frequency frequency) throws InvalidFrequencyException, SourceNeverVisibleException {
        return this.getTimeCalculator().singlePointOnSourceSensitivity(array, time, targetParameters, frequency, CorrConfigMode.getCorrelatorConversionMode(array));
    }

    public DataRate getDataRate(Array array) throws Phase1DataRateCalculator.UnableToDetermineInstantaneousDataRateException {
        return this.getTimeCalculator().getPeakDataRate(array, false);
    }

    public DataRate getAverageDataRate(Array array) {
        DataRate dataRate = DataRate.createDataRate();
        try {
            dataRate = this.getTimeCalculator().getAverageDataRate(array);
        }
        catch (Phase1DataRateCalculator.UnableToDetermineInstantaneousDataRateException unableToDetermineInstantaneousDataRateException) {
            Log.logger(ScienceGoal.class).warning("Unable to determine the average data rate " + unableToDetermineInstantaneousDataRateException);
        }
        return dataRate;
    }

    public Map<SpectralSpec, DataRate> getInstantaneousDataRates(RequestedArray requestedArray) throws Phase1DataRateCalculator.UnableToDetermineInstantaneousDataRateException {
        return this.getTimeCalculator().getInstantaneousSpectralSpecBasedDataRates(requestedArray);
    }

    public List<Phase1DataRateCalculator.SpectralSpecDataRate> getInstantaneousBasebandDataRates(RequestedArray requestedArray) throws Phase1DataRateCalculator.UnableToDetermineInstantaneousDataRateException {
        return this.getTimeCalculator().getInstantaneousBaseBandBasedDataRates(requestedArray);
    }

    public StorageVolume getDataVolume(Array array) throws InvalidObsProgramParametersException, ToBeSupportedException {
        return this.getTimeCalculator().getDataVolume(array);
    }

    public int getRecommendedWVCIndex() {
        int n = 0;
        Frequency frequency = this.getRepresentativeFrequencyInSky();
        Optional<ReceiverBand> optional = Optional.ofNullable(this.getSpectralSetupParameters().getReceiverBand());
        for (TargetParameters targetParameters : this.getTargetParameters()) {
            SkyCoordinates skyCoordinates = targetParameters.getSourceCoordinates();
            Latitude latitude = null;
            latitude = skyCoordinates.getSystem().equals(SkyCoordinatesData.SYSTEM_ICRS) ? skyCoordinates.getLatitude() : skyCoordinates.getJ2000SkyCoordinates().getLatitude();
            n = Math.max(WaterVaporColumns.wvindexSelector(frequency, latitude, optional), n);
        }
        return n;
    }

    @Override
    public SpatialPartOfSpectralSpecDocument getSpatialPartOfSpectralSpecDocument() {
        return this.getSoleTargetParameters();
    }

    @Override
    public SpectralSpec getSpectralSpec() {
        return null;
    }

    @Override
    public Velocity getSourceVelocity() {
        return this.getSpectralSetupParameters().isSpectralLine() ? this.getSoleTargetParameters().getSourceVelocityInDefaultReferenceFrame(Optional.of(this)) : this.getSoleTargetParameters().getSourceVelocity();
    }

    public void addRepresentativeFrequencyListener(RepresentativeFrequencyListener representativeFrequencyListener) {
        this.getSpectralSetupParameters().addRepresentativeFrequencyListener(representativeFrequencyListener);
    }

    public boolean removeRepresentativeFrequencyListener(RepresentativeFrequencyListener representativeFrequencyListener) {
        return this.getSpectralSetupParameters().removeRepresentativeFrequencyListener(representativeFrequencyListener);
    }

    public void addTargetParameters(int n, TargetParameters targetParameters) {
        super.addTargetParameters(n, targetParameters);
        this.addRepresentativeFrequencyListener(targetParameters);
        targetParameters.representativeFrequencyUpdated(new RepresentativeFrequencyChangeEvent(this));
    }

    public boolean removeTargetParameters(TargetParameters targetParameters) {
        this.removeRepresentativeFrequencyListener(targetParameters);
        return super.removeTargetParameters(targetParameters);
    }

    public void setPerformanceParameters(PerformanceParameters performanceParameters) {
        PerformanceParameters performanceParameters2 = this.gettruePerformanceParameters();
        this.removeRepresentativeFrequencyListener(performanceParameters2);
        super.setPerformanceParameters(performanceParameters);
        this.addRepresentativeFrequencyListener(performanceParameters);
        Frequency frequency = this.getSpectralSetupParameters().getRepresentativeFrequency();
        performanceParameters.representativeFrequencyUpdated(new RepresentativeFrequencyChangeEvent((Object)frequency));
    }

    public ExpectedPropertiesElements getConsolidatedExpectedProperties() {
        Map<String, SchedBlock> map = null;
        try {
            Array array = this.isStandAloneACA() ? Array.ARRAY_7M : Array.ARRAY_12M;
            map = SchedBlockWorker.createTargetParametersSBMap(array, this.getTimeCalculator().generateSBs(this));
        }
        catch (UnknownEntityException | InvalidObsProgramParametersException throwable) {
            Log.logger(ScienceGoal.class).warning("Unable to generate target mapping " + throwable.getMessage());
            return null;
        }
        return this.getConsolidatedExpectedProperties(map);
    }

    public ExpectedPropertiesElements getConsolidatedExpectedProperties(Map<String, SchedBlock> map) {
        Object object;
        ExpectedPropertiesElements expectedPropertiesElements = new ExpectedPropertiesElements();
        SpectralSetupParameters spectralSetupParameters = this.getSpectralSetupParameters();
        TargetParameters[] targetParametersArray = this.getTargetParameters();
        if (targetParametersArray.length == 0) {
            return expectedPropertiesElements;
        }
        TargetParameters targetParameters = targetParametersArray[0];
        Velocity velocity = targetParameters.getSourceVelocity();
        ExpectedProperties expectedProperties = targetParameters.getExpectedProperties();
        expectedPropertiesElements.setVelocity(velocity);
        expectedPropertiesElements.setResolvedVelocity(spectralSetupParameters.getVelocityResolutionInSky(velocity));
        UserFrequency userFrequency = expectedProperties.getExpectedLineWidth();
        double d = userFrequency.getKms();
        expectedPropertiesElements.setExpectedLineWidth(userFrequency);
        expectedPropertiesElements.setResPerLineWidth(this.numberOfResolutionsPerLinewidth(d, spectralSetupParameters, velocity));
        expectedPropertiesElements.setExpectedPeakLineFluxDensity(expectedProperties.getExpectedPeakLineFluxDensity());
        expectedPropertiesElements.setExpectedPeakFluxDensity(expectedProperties.getExpectedPeakFluxDensity());
        expectedPropertiesElements.setDesiredLinePolarizationPercentage(MiscUtils.minClosestToZero(expectedProperties.getDesiredLinePolarizationPercentage(), expectedProperties.getDesiredLineCircularPolarizationPercentage()));
        expectedPropertiesElements.setDesiredContPolarizationPercentage(MiscUtils.minClosestToZero(expectedProperties.getDesiredPolarizationPercentage(), expectedProperties.getDesiredCircularPolarizationPercentage()));
        double d2 = expectedProperties.getExpectedPeakLineFluxDensity().getContentInDefaultUnits();
        expectedPropertiesElements.setLowestPolLineFluxFactor(d2 * expectedPropertiesElements.getDesiredLinePolarizationPercentage());
        expectedPropertiesElements.setLowestPolContFluxFactor(d2 * expectedPropertiesElements.getDesiredContPolarizationPercentage());
        PerformanceParameters performanceParameters = this.getPerformanceParameters();
        UserFrequency userFrequency2 = performanceParameters.getSensitivityFrequencyWidthAsUF();
        expectedPropertiesElements.setBandwidthForLineRMS(userFrequency.divide(3.0));
        expectedPropertiesElements.setAggregateBandwidth(this.getAggregateBandwidthForTarget(targetParameters));
        UserSensitivity userSensitivity = this.calculateSensitivityForBandwidth(targetParameters, (Frequency)((Object)expectedPropertiesElements.getBandwidthForLineRMS()), map);
        expectedPropertiesElements.setLineRMS(userSensitivity);
        UserSensitivity userSensitivity2 = this.calculateSensitivityForBandwidth(targetParameters, expectedPropertiesElements.getAggregateBandwidth(), map);
        expectedPropertiesElements.setSensitivityForBW(userSensitivity2);
        expectedPropertiesElements.getAchievedSensitivities().put(targetParameters, userSensitivity2);
        targetParameters.getExpectedProperties().setSensitivityForBW(expectedPropertiesElements.getSensitivityForBW().deepCopy());
        expectedPropertiesElements.setBandwidthRMS(this.calculateSensitivityForBandwidth(targetParameters, (Frequency)((Object)userFrequency2), map));
        SpectralDynamicRange spectralDynamicRange = this.calculateSpectralDynamicRange(d, userFrequency2, expectedPropertiesElements.getExpectedPeakFluxDensity(), expectedPropertiesElements.getLineRMS(), expectedPropertiesElements.getBandwidthRMS());
        double d3 = spectralDynamicRange.getDynamicRange();
        expectedPropertiesElements.setSpectralDynamicRange(d3);
        UserFrequency userFrequency3 = spectralDynamicRange.getRMSUsed().equals((Object)RMSEnum.LINE_RMS) ? expectedPropertiesElements.getBandwidthForLineRMS() : userFrequency2;
        expectedPropertiesElements.setBandwidthForSpectralDynamicRange(userFrequency3.deepCopy());
        expectedPropertiesElements.setTargetUsedForSpectralDynamicRange(targetParameters);
        expectedProperties.setExpectedSpectralDynamicRange(d3);
        double d4 = this.calculateLineFluxSNR(targetParameters, map);
        double d5 = this.calculateExpectedImageDynamicRange(targetParameters, d4);
        expectedPropertiesElements.setImagingDynamicRange(d5);
        expectedPropertiesElements.setTargetUsedForImagingDynamicRange(targetParameters);
        expectedProperties.setExpectedImageDynamicRange(expectedPropertiesElements.imagingDynamicRange);
        if (Log.logger((Object)this).fine()) {
            Log.logger((Object)this).fine("Spectral Dynamic Range : " + expectedPropertiesElements.spectralDynamicRange);
            Log.logger((Object)this).fine("Imaging Dynamic Range : " + expectedPropertiesElements.imagingDynamicRange);
        }
        for (int i = 1; i < targetParametersArray.length; ++i) {
            targetParameters = targetParametersArray[i];
            expectedProperties = targetParameters.getExpectedProperties();
            object = expectedProperties.getExpectedLineWidth().divide(3.0);
            UserSensitivity userSensitivity3 = this.calculateSensitivityForBandwidth(targetParameters, (Frequency)((Object)object), map);
            Frequency frequency = this.getAggregateBandwidthForTarget(targetParameters);
            UserSensitivity userSensitivity4 = this.calculateSensitivityForBandwidth(targetParameters, frequency, map);
            expectedProperties.setSensitivityForBW(userSensitivity4.deepCopy());
            UserSensitivity userSensitivity5 = this.calculateSensitivityForBandwidth(targetParameters, (Frequency)((Object)userFrequency2), map);
            Flux flux = expectedProperties.getExpectedPeakFluxDensity();
            spectralDynamicRange = this.calculateSpectralDynamicRange(d, userFrequency2, flux, userSensitivity3, userSensitivity5);
            d3 = spectralDynamicRange.getDynamicRange();
            expectedProperties.setExpectedSpectralDynamicRange(d3);
            Log.logger((Object)this).fine("Current spectral dynamic Range : " + d3);
            d4 = this.calculateLineFluxSNR(targetParameters, map);
            d5 = this.calculateExpectedImageDynamicRange(targetParameters, d4);
            expectedProperties.setExpectedImageDynamicRange(d5);
            if (expectedPropertiesElements.getSpectralDynamicRange() < d3) {
                expectedPropertiesElements.setSpectralDynamicRange(d3);
                userFrequency3 = spectralDynamicRange.getRMSUsed().equals((Object)RMSEnum.LINE_RMS) ? expectedPropertiesElements.getBandwidthForLineRMS() : userFrequency2;
                expectedPropertiesElements.setBandwidthForSpectralDynamicRange(userFrequency3.deepCopy());
                expectedPropertiesElements.setTargetUsedForSpectralDynamicRange(targetParameters);
            }
            if (expectedPropertiesElements.getImagingDynamicRange() < d5) {
                expectedPropertiesElements.setImagingDynamicRange(d5);
                expectedPropertiesElements.setTargetUsedForImagingDynamicRange(targetParameters);
            }
            Log.logger((Object)this).fine("Largest Spectral Dynamic Range : " + expectedPropertiesElements.spectralDynamicRange);
            if (expectedPropertiesElements.getExpectedPeakFluxDensity().getContentInDefaultUnits() > expectedProperties.getExpectedPeakFluxDensity().getContentInDefaultUnits()) {
                expectedPropertiesElements.setExpectedPeakFluxDensity(expectedProperties.getExpectedPeakFluxDensity());
            }
            if (expectedPropertiesElements.getExpectedPeakLineFluxDensity().getContentInDefaultUnits() > flux.getContentInDefaultUnits()) {
                expectedPropertiesElements.setExpectedPeakLineFluxDensity(expectedProperties.getExpectedPeakLineFluxDensity());
            }
            d = userFrequency.getKms();
            velocity = targetParametersArray[i].getSourceVelocity();
            expectedPropertiesElements.setResolvedVelocity(spectralSetupParameters.getVelocityResolutionInSky(velocity));
            double d6 = this.numberOfResolutionsPerLinewidth(d, expectedPropertiesElements.getResolvedVelocity());
            double d7 = expectedPropertiesElements.getResPerLineWidth();
            if (d7 > d6 || d7 == d6 && d < expectedPropertiesElements.getExpectedLineWidth().getKms()) {
                expectedPropertiesElements.setExpectedLineWidth(userFrequency);
                expectedPropertiesElements.setResPerLineWidth(d6);
                expectedPropertiesElements.setVelocity(velocity);
                expectedPropertiesElements.setLineRMS(userSensitivity3);
                expectedPropertiesElements.setBandwidthForLineRMS((UserFrequency)object);
                expectedPropertiesElements.setBandwidthRMS(userSensitivity5);
            } else {
                expectedPropertiesElements.setAggregateBandwidth(frequency);
            }
            expectedPropertiesElements.getAchievedSensitivities().put(targetParameters, userSensitivity4);
            this.getPolarizationTJData(expectedPropertiesElements, expectedProperties, d2);
        }
        TechnicalJustificationExpert.TechnicalJustificationCalculations technicalJustificationCalculations = new TechnicalJustificationExpert.TechnicalJustificationCalculations();
        TechnicalJustificationExpert.TechnicalJustificationCalculations.setTJDesiredResolution(technicalJustificationCalculations, this);
        TechnicalJustificationExpert.TechnicalJustificationCalculations.setTJRepresentativeFreq(technicalJustificationCalculations, this);
        object = TechnicalJustificationExpert.TechnicalJustificationCalculations.calculateSourceWithPoorestSNR(expectedPropertiesElements, technicalJustificationCalculations, this);
        expectedPropertiesElements.setSensitivityForBW(((TechnicalJustificationExpert.SNR)object).getAchievedBWForSensitivity());
        if (Log.logger((Object)this).fine()) {
            Log.logger((Object)this).fine("Consolidated spectral dynamic Range : " + expectedPropertiesElements.getSpectralDynamicRange());
            Log.logger((Object)this).fine("Consolidated imaging dynamic Range : " + expectedPropertiesElements.getImagingDynamicRange());
            Log.logger((Object)this).fine("Source for spectral + dynamic range : " + expectedPropertiesElements.getTargetUsedForSpectralDynamicRange() + " " + expectedPropertiesElements.getTargetUsedForImagingDynamicRange());
        }
        return expectedPropertiesElements;
    }

    private void getPolarizationTJData(@NonNull ExpectedPropertiesElements expectedPropertiesElements, @NonNull ExpectedProperties expectedProperties, double d) {
        if (expectedPropertiesElements == null) {
            throw new NullPointerException("consolidatedProperties is marked non-null but is null");
        }
        if (expectedProperties == null) {
            throw new NullPointerException("expectedProperties is marked non-null but is null");
        }
        double d2 = MiscUtils.minClosestToZero(expectedProperties.getDesiredLinePolarizationPercentage(), expectedProperties.getDesiredLineCircularPolarizationPercentage());
        double d3 = MiscUtils.minClosestToZero(expectedProperties.getDesiredPolarizationPercentage(), expectedProperties.getDesiredCircularPolarizationPercentage());
        double d4 = expectedPropertiesElements.getLowestPolLineFluxFactor();
        if (d2 != 0.0 && (d4 == 0.0 || d4 > d * d2)) {
            expectedPropertiesElements.setDesiredLinePolarizationPercentage(d2);
            expectedPropertiesElements.setLowestPolLineFluxFactor(d * d2);
        }
        double d5 = expectedPropertiesElements.getLowestPolContFluxFactor();
        if (d3 != 0.0 && (d5 == 0.0 || d5 > d * d3)) {
            expectedPropertiesElements.setDesiredContPolarizationPercentage(d3);
            expectedPropertiesElements.setLowestPolContFluxFactor(d * d3);
        }
    }

    private double calculateExpectedImageDynamicRange(@NonNull TargetParameters targetParameters, double d) {
        if (targetParameters == null) {
            throw new NullPointerException("targetParameter is marked non-null but is null");
        }
        double d2 = this.calculateContinuumImagingSNR(targetParameters);
        return d > d2 ? d : d2;
    }

    private double calculateContinuumImagingSNR(@NonNull TargetParameters targetParameters) {
        if (targetParameters == null) {
            throw new NullPointerException("targetParameter is marked non-null but is null");
        }
        UserSensitivity userSensitivity = this.createUserSensitivityWithDefinedBeamsizeAndObsFreq(targetParameters);
        ExpectedProperties expectedProperties = targetParameters.getExpectedProperties();
        userSensitivity.setContentAndUnit((ValueUnitPair)expectedProperties.getExpectedPeakFluxDensity());
        double d = userSensitivity.getContentInUnits(Flux.UNIT_MJY);
        UserSensitivity userSensitivity2 = this.createUserSensitivityWithDefinedBeamsizeAndObsFreq(targetParameters);
        userSensitivity2.setContentAndUnit(expectedProperties.getSensitivityForBW());
        userSensitivity2.convertToUnit(userSensitivity2.getFriendlyUnit());
        double d2 = userSensitivity2.getContentInUnits(Sensitivity.UNIT_MJY);
        return d / d2;
    }

    private double calculateLineFluxSNR(@NonNull TargetParameters targetParameters, @NonNull Map<String, SchedBlock> map) {
        if (targetParameters == null) {
            throw new NullPointerException("targetParameter is marked non-null but is null");
        }
        if (map == null) {
            throw new NullPointerException("targetSBMapping is marked non-null but is null");
        }
        ExpectedProperties expectedProperties = targetParameters.getExpectedProperties();
        UserSensitivity userSensitivity = this.createUserSensitivityWithDefinedBeamsizeAndObsFreq(targetParameters);
        userSensitivity.setContentAndUnit((ValueUnitPair)expectedProperties.getExpectedPeakLineFluxDensity());
        UserFrequency userFrequency = expectedProperties.getExpectedLineWidth().divide(3.0);
        UserSensitivity userSensitivity2 = this.calculateSensitivityForBandwidth(targetParameters, (Frequency)((Object)userFrequency), map);
        return userSensitivity.getContentInUnits(TechnicalJustificationModel.FLUX_CALC_UNIT) / userSensitivity2.getContentInUnits(TechnicalJustificationModel.SENSITIVITY_CALC_UNIT);
    }

    private UserSensitivity createUserSensitivityWithDefinedBeamsizeAndObsFreq(@NonNull TargetParameters targetParameters) {
        if (targetParameters == null) {
            throw new NullPointerException("targetParameter is marked non-null but is null");
        }
        UserSensitivity userSensitivity = UserSensitivity.createUserSensitivity();
        userSensitivity.setBeamsize((Angle)((Object)this.getPerformanceParameters().getDesiredAngularResolution()));
        SpectralSetupParameters spectralSetupParameters = this.getSpectralSetupParameters();
        Frequency frequency = spectralSetupParameters.isDerivedSSP() || spectralSetupParameters.isSpectralSetupInSky() ? spectralSetupParameters.getRepresentativeFrequency() : spectralSetupParameters.getRepresentativeFrequency().dopplerShifted(targetParameters.getSourceVelocityInDefaultReferenceFrame(Optional.empty()));
        userSensitivity.setObservingFrequency(frequency);
        return userSensitivity;
    }

    private SpectralDynamicRange calculateSpectralDynamicRange(double d, UserFrequency userFrequency, Flux flux, UserSensitivity userSensitivity, UserSensitivity userSensitivity2) {
        SpectralDynamicRange spectralDynamicRange = new SpectralDynamicRange();
        SpectralSetupParameters spectralSetupParameters = this.getSpectralSetupParameters();
        double d2 = userFrequency.getContentInUnits(UserFrequency.USERUNIT_KM_S);
        if (spectralSetupParameters.isSingleContinuum() || d2 > 2.0 * d) {
            spectralDynamicRange.setRMSUsed(RMSEnum.LINE_RMS);
            spectralDynamicRange.setDynamicRange(flux.getContentInUnits(Sensitivity.UNIT_MJY) / userSensitivity.getContentInUnits(Sensitivity.UNIT_MJY));
        } else {
            Log.logger((Object)this).fine("using calculated RMS of " + userSensitivity2.getContentInUnits(Sensitivity.UNIT_MJY));
            spectralDynamicRange.setRMSUsed(RMSEnum.BANDWIDTH_RMS);
            spectralDynamicRange.setDynamicRange(flux.getContentInUnits(Sensitivity.UNIT_MJY) / userSensitivity2.getContentInUnits(Sensitivity.UNIT_MJY));
        }
        return spectralDynamicRange;
    }

    private double numberOfResolutionsPerLinewidth(double d, double d2) {
        Double d3 = null;
        if (d2 != 0.0) {
            d3 = d / d2;
        }
        Log.logger((Object)this).finest("sum = linewidth " + d + " / resolution  :" + d2);
        return d3 == null ? 0.0 : d3;
    }

    public Time calculateSinglePointOnSourceTimeArray(Array array, TargetParameters targetParameters) throws InvalidObsProgramParametersException {
        Time time = this.getSinglePointOnSourceTime(array, targetParameters);
        time.convertToUnit(Time.UNIT_H);
        return time;
    }

    public Time calculateOnSourceTimeArray(Array array) throws InvalidObsProgramParametersException {
        Time time = this.getTotalOnSourceTime(array);
        time.convertToUnit(Time.UNIT_H);
        return time;
    }

    public Flux getMaxContinuumFlux() {
        ArrayList<Flux> arrayList = new ArrayList<Flux>();
        for (TargetParameters targetParameters : this.getTargetParameters()) {
            ExpectedProperties expectedProperties = targetParameters.getExpectedProperties();
            arrayList.add(expectedProperties.getExpectedPeakFluxDensity());
        }
        if (arrayList.isEmpty()) {
            return Flux.createFlux();
        }
        VupComparator vupComparator = new VupComparator();
        Collections.sort(arrayList, vupComparator);
        return (Flux)((Object)arrayList.get(arrayList.size() - 1));
    }

    @Override
    public synchronized void setSpectralSetupParameters(SpectralSetupParameters spectralSetupParameters) {
        SpectralSetupParameters spectralSetupParameters2 = this.gettrueSpectralSetupParameters();
        if (spectralSetupParameters2 != null) {
            this.removeRepresentativeFrequencyListener(this.getPerformanceParameters());
            for (TargetParameters targetParameters : this.getTargetParameters()) {
                this.removeRepresentativeFrequencyListener(targetParameters);
                this.removeRepresentativeFrequencyListener(targetParameters.getExpectedProperties());
                for (Field field : targetParameters.getField()) {
                    if (!(field instanceof RepresentativeFrequencyListener)) continue;
                    this.removeRepresentativeFrequencyListener((RepresentativeFrequencyListener)((Object)field));
                }
            }
        }
        super.setSpectralSetupParameters(spectralSetupParameters);
        if (spectralSetupParameters == null) {
            return;
        }
        this.updateLocalReference();
        Frequency frequency = spectralSetupParameters.getRepresentativeFrequency();
        spectralSetupParameters.getRepresentativeFrequency().setContentAndUnit((ValueUnitPair)frequency);
    }

    public Time getOverheadTimes(EnumSet<ObservingTimeCalculator.CalibrationOverheads> enumSet, Array array, TargetParameters targetParameters, boolean bl) throws InvalidObsProgramParametersException {
        return this.getTimeCalculator().getOverheadTimes(bl, enumSet, array, targetParameters);
    }

    private double numberOfResolutionsPerLinewidth(double d, SpectralSetupParameters spectralSetupParameters, Velocity velocity) {
        Double d2 = null;
        double d3 = spectralSetupParameters.getVelocityResolutionInSky(velocity);
        if (d3 != 0.0) {
            d2 = d / d3;
        }
        Log.logger((Object)this).finest("sum = linewidth " + d + " / resolution  :" + d3);
        return d2 == null ? 0.0 : d2;
    }

    public Integer getNumberOf12MAntennaConfigurations() throws InvalidObsProgramParametersException {
        PerformanceParameters performanceParameters = this.getPerformanceParameters();
        Frequency frequency = this.getRepresentativeFrequencyInSky();
        Configuration configuration = null;
        int n = 0;
        try {
            if (this.getObsProposal().isVLBIorPhasedArray() || this.isSolarScienceGoal()) {
                return 1;
            }
        }
        catch (UnknownEntityException unknownEntityException) {
            return 1;
        }
        try {
            configuration = Configuration.getBestConfiguration(performanceParameters.getDesiredAngularResolution(), frequency, RequestedArray.TWELVE_M, this);
        }
        catch (InvalidConfigurationParametersException invalidConfigurationParametersException) {
            String string = "Cannot establish the best array configuration for a desired angular resolution of " + performanceParameters.getDesiredAngularResolution() + " with a rep. freq of " + frequency;
            Log.logger((Object)this).severe(string);
            throw new InvalidObsProgramParametersException(string);
        }
        ++n;
        if (Configuration.getIsSecondConfigurationRequired(configuration, performanceParameters.getDesiredLargestScale(), frequency, this)) {
            try {
                Configuration.getSecondCompactConfiguration(configuration);
                ++n;
            }
            catch (InvalidConfigurationParametersException invalidConfigurationParametersException) {
                // empty catch block
            }
        }
        return n;
    }

    public boolean isSolarScienceGoal() throws UnknownEntityException {
        return this.getScienceGoalMode() == ScienceGoalMode.SOLAR;
    }

    public boolean isFullPolarization() {
        return this.getSpectralSetupParameters().isFullPolarisation();
    }

    public boolean isStandAloneACA() {
        ScienceGoalMode scienceGoalMode;
        try {
            scienceGoalMode = this.getScienceGoalMode();
        }
        catch (UnknownEntityException unknownEntityException) {
            throw new RuntimeException("Unable to determine if the ACA is in standalone mode");
        }
        return scienceGoalMode == ScienceGoalMode.STANDALONEACA;
    }

    public ScienceGoalMode getScienceGoalMode() throws UnknownEntityException {
        ObsProposal obsProposal = this.getObsProposal();
        if (obsProposal != null && "V".equals(obsProposal.getProposalTypeCode())) {
            return ScienceGoalMode.STANDARD;
        }
        if (!(obsProposal == null || "T".equals(obsProposal.getProposalTypeCode()) && "V".equals(obsProposal.getProposalTypeCode()))) {
            for (TargetParameters targetParameters : this.getTargetParameters()) {
                if (!targetParameters.getNonSiderealMotion() || targetParameters.getSolarSystemObject() != TargetParameters.SOLARSYSTEMOBJECT_SUN) continue;
                return ScienceGoalMode.SOLAR;
            }
        }
        if (this.getPerformanceParameters().isAngularResolutionModeSACA()) {
            return ScienceGoalMode.STANDALONEACA;
        }
        return ScienceGoalMode.STANDARD;
    }

    public List<SourcePoint> getAllSiderealSourceFieldCentres() {
        ArrayList<SourcePoint> arrayList = new ArrayList<SourcePoint>();
        for (TargetParameters targetParameters : this.getTargetParameters()) {
            SkyCoordinates skyCoordinates = targetParameters.getSourceCoordinates().getJ2000SkyCoordinates();
            if (targetParameters.getNonSiderealMotion()) continue;
            SkyPoint skyPoint = skyCoordinates.getAbsoluteSkyPointInICRSDeg();
            arrayList.add(new SourcePoint(targetParameters, skyPoint));
        }
        return arrayList;
    }

    public BusinessObject getParent() {
        Object object = super.getParent();
        if (object == null) {
            object = this.obsProposalParent;
        }
        return object;
    }

    public int getClusterIndex() throws NotClusteredScienceGoalException {
        if (this.clusterIndex == null) {
            throw new NotClusteredScienceGoalException();
        }
        return this.clusterIndex;
    }

    public synchronized void setScienceGoalType(ScienceGoalType scienceGoalType) {
        this.scienceGoalType = scienceGoalType;
    }

    public static boolean determineACAScheduling(ScienceGoal scienceGoal) {
        Object object;
        if (scienceGoal == null) {
            return false;
        }
        PerformanceParameters performanceParameters = scienceGoal.getPerformanceParameters();
        if (performanceParameters == null) {
            return false;
        }
        boolean bl = true;
        boolean bl2 = false;
        SpectralSetupParameters spectralSetupParameters = scienceGoal.getSpectralSetupParameters();
        boolean bl3 = false;
        try {
            bl3 = scienceGoal.isSolarScienceGoal();
        }
        catch (UnknownEntityException unknownEntityException) {
            Log.logger(SfiControlParameterModel.class).warning("Unable to determine if science goal is solar : " + unknownEntityException.getMessage());
        }
        boolean bl4 = false;
        try {
            object = scienceGoal.getObsProposal();
            if (object == null) {
                return false;
            }
            bl4 = ((ObsProposal)((Object)object)).isVLBIorPhasedArray();
        }
        catch (UnknownEntityException unknownEntityException) {
            Log.logger(SfiControlParameterModel.class).warning("Unable to determine if project is VLBI: " + unknownEntityException.getMessage());
        }
        if (bl4) {
            Log.logger(SfiControlParameterModel.class).finer("ACA is not scheduled for VLBI");
            bl = false;
        } else if (bl3) {
            Log.logger(SfiControlParameterModel.class).finer("ACA is scheduled for solar");
            if (spectralSetupParameters.getReceiverBand() == null || spectralSetupParameters.getReceiverBand().getNumber() == 3 && spectralSetupParameters.isFullPolarisation()) {
                bl = true;
                bl2 = true;
            } else {
                bl = !spectralSetupParameters.isFullPolarisation();
                bl2 = bl;
            }
        } else {
            if (spectralSetupParameters.isFullPolarisation() && !Telescope.isOTConfiguredAs(Telescope.CSVALMA) && !scienceGoal.isStandAloneACA()) {
                bl = false;
            }
            if (!scienceGoal.isStandAloneACA() && bl) {
                object = new ACANecessityEstimator(performanceParameters.getDesiredLargestScale(), (Angle)((Object)performanceParameters.getDesiredAngularResolution()), performanceParameters.getRepresentativeFrequencyWithSkyOffset());
                bl = ((ACANecessityEstimator)object).acaNecessity(scienceGoal);
            }
            if (bl) {
                bl2 = SchedBlockExpert.determineIfTPArrayIsToBeUsed(bl, scienceGoal);
            }
        }
        boolean bl5 = performanceParameters.getUseACA() != bl;
        boolean bl6 = performanceParameters.getUseTP() != bl2;
        performanceParameters.setUseACA(bl);
        performanceParameters.setUseTP(bl2);
        Log.logger(SfiControlParameterModel.class).finer("ACA 7m: " + bl + " ACA TP : " + bl2);
        return bl5 || bl6;
    }

    public synchronized Optional<Collection<MinTuningsCalculator.TuningResult>> getLo1Tunings() {
        return this.lo1Tunings;
    }

    public synchronized void setLo1Tunings(Optional<Collection<MinTuningsCalculator.TuningResult>> optional) {
        this.lo1Tunings = optional;
    }

    public synchronized void clearLo1Tunings() {
        this.lo1Tunings = Optional.empty();
    }

    private UserSensitivity calculateSensitivityForBandwidth(TargetParameters targetParameters, Frequency frequency, Map<String, SchedBlock> map) {
        Object object;
        Object object2;
        if (map == null || targetParameters == null) {
            return UserSensitivity.createUserSensitivity();
        }
        Sensitivity sensitivity = Sensitivity.createSensitivity();
        SpectralSetupParameters spectralSetupParameters = this.getSpectralSetupParameters();
        Frequency frequency2 = spectralSetupParameters.isDerivedSSP() || spectralSetupParameters.isSingleContinuumSkyFrequency() ? spectralSetupParameters.getRepresentativeFrequency() : spectralSetupParameters.getRepresentativeFrequency().dopplerShifted(targetParameters.getSourceVelocity());
        Log.logger(ScienceGoal.class).fine("representativeFrequency: " + frequency2);
        try {
            object2 = this.getTimeCalculator().singlePointOnSourceTimeFromSB(targetParameters, map);
            Log.logger((Object)this).fine("On source time is :" + (Time)object2);
            Object object3 = object = this.isStandAloneACA() ? Array.ARRAY_7M : Array.ARRAY_12M;
            if (frequency != null) {
                Frequency frequency3 = (Frequency)frequency.multiply(spectralSetupParameters.getPolarizationFactor());
                sensitivity = this.getTimeCalculator().singlePointOnSourceSensitivity((Array)((Object)object), (Time)object2, targetParameters, frequency2, frequency3, ETCTimeCalculator.CorrelatorModeConversionEnum.NoCorrelatorConversion);
            } else {
                sensitivity = this.getTimeCalculator().singlePointOnSourceSensitivity((Array)((Object)object), (Time)object2, targetParameters, frequency2, ETCTimeCalculator.CorrelatorModeConversionEnum.NoCorrelatorConversion);
            }
            Log.logger((Object)this).fine("lineSensitivity :" + sensitivity);
        }
        catch (SourceNeverVisibleException | InvalidFrequencyException | NoSuchElementException exception) {
            Log.logger((Object)this).finest("Incomplete info for calculating sensitivity : " + exception.getMessage());
        }
        object2 = this.getPerformanceParameters();
        object = UserSensitivity.createUserSensitivity();
        ((UserSensitivity)object).setBeamsize((Angle)((Object)object2.getDesiredAngularResolution()));
        object.setContentAndUnit((ValueUnitPair)sensitivity);
        object.convertToUnit(((UserSensitivity)object).getFriendlyUnit());
        ((UserSensitivity)object).setObservingFrequency(frequency2);
        Log.logger((Object)this).fine("thisRms :" + (UserSensitivity)object);
        return object;
    }

    Frequency getAggregateBandwidthForTarget(TargetParameters targetParameters) {
        SpectralSetupParameters spectralSetupParameters = this.getSpectralSetupParameters();
        Frequency frequency = NonOverlappingBandwidthCalculator.getCalculator(spectralSetupParameters, targetParameters).calculate();
        try {
            if (spectralSetupParameters.isSpectralScan()) {
                SpectralScan spectralScan = spectralSetupParameters.getSpectralScan();
                SpectralScan.SpectralScanTunings spectralScanTunings = spectralScan.getTunings();
                FrequencyRange frequencyRange = spectralScanTunings.getAchievedScanRange();
                frequency = (Frequency)((Object)frequencyRange.range());
            } else {
                frequency = spectralSetupParameters.getDesiredSensitivityFrequencyWidth(PerformanceParameters.DESIREDSENSITIVITYFREQUENCYMEASURE_AGGREGATEBANDWIDTH);
            }
        }
        catch (SpectralScan.SpectralScanTunings.SpectralScanTuningException | UnableToFindSolutionException exception) {
            Log.logger((Object)this).finest("Incomplete info for calculating aggregate bandwidth : " + exception.getMessage());
        }
        return frequency;
    }

    public void resetAllSolarSources() {
        Arrays.asList(this.getTargetParameters()).stream().filter(TargetParameters::isSun).forEach(targetParameters -> targetParameters.setSolarSystemObject(AbstractTargetParameters.SOLARSYSTEMOBJECT_UNSPECIFIED));
    }

    public void resetTechnicalJustifications() {
        Log.logger(ScienceGoalValidator.class).finest("Forcing a refresh of the Technical Justifications to ensure they match the current SG details.");
        TechnicalJustificationModel technicalJustificationModel = new TechnicalJustificationModel(this);
        technicalJustificationModel.publish();
    }

    public RequestedArray getPrincipalArray() {
        return this.isStandAloneACA() ? RequestedArray.SEVEN_M : RequestedArray.TWELVE_M;
    }

    public boolean getIsTPSolarRegionalMappingEnabled() {
        return Stream.of(this.getTargetParameters()).anyMatch(targetParameters -> targetParameters.getSolarMapping() != null && targetParameters.getSolarMapping().equals(AbstractTargetParameters.SOLARMAPPING_REGIONALMAPPING));
    }

    public static Optional<ScienceGoal> getBOsParentScienceGoal(@NonNull BusinessObject businessObject) {
        if (businessObject == null) {
            throw new NullPointerException("bo is marked non-null but is null");
        }
        BusinessObject businessObject2 = businessObject;
        while (businessObject2.getParent() != null) {
            if (businessObject2.getParent() instanceof ScienceGoal) {
                return Optional.of((ScienceGoal)businessObject2.getParent());
            }
            businessObject2 = businessObject2.getParent();
        }
        return Optional.empty();
    }

    public boolean isUsing4bitCorrelatorModes() {
        ScienceSpectralWindow scienceSpectralWindow = this.getSpectralSetupParameters().getRepresentativeSpectralWindow();
        if (scienceSpectralWindow != null && scienceSpectralWindow.getCorrConfigMode() != null) {
            return CorrBits.is4x4(scienceSpectralWindow.getCorrConfigMode().getBits());
        }
        return false;
    }

    public boolean isTwoBitRepresentationOfFourBitSG() {
        return this.isTwoBitRepresentationOfFourBitSG;
    }

    public void setTwoBitRepresentationOfFourBitSG(boolean bl) {
        this.isTwoBitRepresentationOfFourBitSG = bl;
    }

    public ScienceGoal getParentScienceGoal() {
        return this.parentScienceGoal;
    }

    public void setParentScienceGoal(ScienceGoal scienceGoal) {
        this.parentScienceGoal = scienceGoal;
    }

    public SummaryTableColumns getSummaryTableColumns() {
        return this.summaryTableColumns;
    }

    public void setObsProposalParent(ObsProposal obsProposal) {
        this.obsProposalParent = obsProposal;
    }

    public ScienceGoalExpertParameterHelper getScienceGoalExpertParameterHelper() {
        return this.scienceGoalExpertParameterHelper;
    }

    public Object getSchedBlockExpert() {
        return this.schedBlockExpert;
    }

    public void setClusterIndex(Integer n) {
        this.clusterIndex = n;
    }

    public ScienceGoalType getScienceGoalType() {
        return this.scienceGoalType;
    }

    public SpectralSetupParameters getParentSpectralSetupParameters() {
        return this.parentSpectralSetupParameters;
    }

    public void setParentSpectralSetupParameters(SpectralSetupParameters spectralSetupParameters) {
        this.parentSpectralSetupParameters = spectralSetupParameters;
    }

    public static class UnableToFindTargetParametersException
    extends Exception {
        public UnableToFindTargetParametersException(String string) {
            super(string);
        }
    }

    public static class SourcePoint {
        private final TargetParameters targetParameters;
        private final SkyPoint skyPoint;

        public SourcePoint(TargetParameters targetParameters, SkyPoint skyPoint) {
            this.targetParameters = targetParameters;
            this.skyPoint = skyPoint;
        }

        public TargetParameters getTargetParameters() {
            return this.targetParameters;
        }

        public SkyPoint getSkyPoint() {
            return this.skyPoint;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof SourcePoint)) {
                return false;
            }
            SourcePoint sourcePoint = (SourcePoint)object;
            if (!sourcePoint.canEqual(this)) {
                return false;
            }
            TargetParameters targetParameters = this.getTargetParameters();
            TargetParameters targetParameters2 = sourcePoint.getTargetParameters();
            if (targetParameters == null ? targetParameters2 != null : !targetParameters.equals(targetParameters2)) {
                return false;
            }
            SkyPoint skyPoint = this.getSkyPoint();
            SkyPoint skyPoint2 = sourcePoint.getSkyPoint();
            return !(skyPoint == null ? skyPoint2 != null : !((Object)skyPoint).equals(skyPoint2));
        }

        protected boolean canEqual(Object object) {
            return object instanceof SourcePoint;
        }

        public int hashCode() {
            int n = 1;
            TargetParameters targetParameters = this.getTargetParameters();
            n = n * 59 + (targetParameters == null ? 43 : targetParameters.hashCode());
            SkyPoint skyPoint = this.getSkyPoint();
            n = n * 59 + (skyPoint == null ? 43 : ((Object)skyPoint).hashCode());
            return n;
        }

        public String toString() {
            return "ScienceGoal.SourcePoint(targetParameters=" + this.getTargetParameters() + ", skyPoint=" + this.getSkyPoint() + ")";
        }
    }

    public static class NotClusteredScienceGoalException
    extends Exception {
    }

    public static enum ScienceGoalMode {
        STANDARD,
        SOLAR,
        STANDALONEACA;

    }

    public static enum ScienceGoalType {
        TUNINGSPECIFIC,
        USERDEFINED;

    }

    public class SpectralDynamicRange {
        private RMSEnum RMSUsed;
        private double dynamicRange;

        public RMSEnum getRMSUsed() {
            return this.RMSUsed;
        }

        public double getDynamicRange() {
            return this.dynamicRange;
        }

        public void setRMSUsed(RMSEnum rMSEnum) {
            this.RMSUsed = rMSEnum;
        }

        public void setDynamicRange(double d) {
            this.dynamicRange = d;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof SpectralDynamicRange)) {
                return false;
            }
            SpectralDynamicRange spectralDynamicRange = (SpectralDynamicRange)object;
            if (!spectralDynamicRange.canEqual(this)) {
                return false;
            }
            if (Double.compare(this.getDynamicRange(), spectralDynamicRange.getDynamicRange()) != 0) {
                return false;
            }
            RMSEnum rMSEnum = this.getRMSUsed();
            RMSEnum rMSEnum2 = spectralDynamicRange.getRMSUsed();
            return !(rMSEnum == null ? rMSEnum2 != null : !((Object)((Object)rMSEnum)).equals((Object)rMSEnum2));
        }

        protected boolean canEqual(Object object) {
            return object instanceof SpectralDynamicRange;
        }

        public int hashCode() {
            int n = 1;
            long l = Double.doubleToLongBits(this.getDynamicRange());
            n = n * 59 + (int)(l >>> 32 ^ l);
            RMSEnum rMSEnum = this.getRMSUsed();
            n = n * 59 + (rMSEnum == null ? 43 : ((Object)((Object)rMSEnum)).hashCode());
            return n;
        }

        public String toString() {
            return "ScienceGoal.SpectralDynamicRange(RMSUsed=" + this.getRMSUsed() + ", dynamicRange=" + this.getDynamicRange() + ")";
        }
    }

    private static enum RMSEnum {
        BANDWIDTH_RMS,
        LINE_RMS;

    }
}

