/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.bo.obsproject;

import alma.entity.xmlbinding.obsproject.OpticalPointingTargetQueryParametersT;
import alma.obsprep.bo.obsproject.data.OpticalPointingTargetQueryParametersData;
import alma.valuetypes.Angle;
import alma.valuetypes.Latitude;
import alma.valuetypes.Longitude;
import alma.valuetypes.Magnitude;
import alma.valuetypes.SkyCoordinates;
import java.util.Calendar;

public class OpticalPointingTargetQueryParameters
extends OpticalPointingTargetQueryParametersData {
    public static final String ARCHIVE = "Archive";
    public static final String LOCALFILE = "Local File";
    public static final String LOCALCATALOGUE = "Local Catalogue";

    public static String[] getKnownLocationList() {
        return new String[]{ARCHIVE, LOCALFILE, LOCALCATALOGUE};
    }

    public OpticalPointingTargetQueryParameters(OpticalPointingTargetQueryParametersT opticalPointingTargetQueryParametersT) {
        super(opticalPointingTargetQueryParametersT);
    }

    protected void initAsNew() {
        super.initAsNew();
        SkyCoordinates skyCoordinates = SkyCoordinates.createSkyCoordinates();
        Longitude longitude = Longitude.createLongitude((double)0.0, (String)Longitude.UNIT_DEG);
        Latitude latitude = Latitude.createLatitude((double)-90.0, (String)Latitude.UNIT_DEG);
        skyCoordinates.setLongitude(longitude);
        skyCoordinates.setLatitude(latitude);
        this.setMinCoordinates(skyCoordinates);
        SkyCoordinates skyCoordinates2 = SkyCoordinates.createSkyCoordinates();
        Longitude longitude2 = Longitude.createLongitude((double)359.9958333, (String)Longitude.UNIT_DEG);
        Latitude latitude2 = Latitude.createLatitude((double)90.0, (String)Latitude.UNIT_DEG);
        skyCoordinates2.setLongitude(longitude2);
        skyCoordinates2.setLatitude(latitude2);
        this.setMaxCoordinates(skyCoordinates2);
        this.setMinMagnitude(0.0);
        this.setMaxMagnitude(10.0);
        Angle angle = Angle.createAngle((double)0.0, (String)Angle.UNIT_DEG);
        this.setMinAzimuth(angle);
        Angle angle2 = Angle.createAngle((double)360.0, (String)Angle.UNIT_DEG);
        this.setMaxAzimuth(angle2);
        Angle angle3 = Angle.createAngle((double)0.0, (String)Angle.UNIT_DEG);
        this.setMinElevation(angle3);
        Angle angle4 = Angle.createAngle((double)90.0, (String)Angle.UNIT_DEG);
        this.setMaxElevation(angle4);
        Angle angle5 = Angle.createAngle((double)0.0, (String)Angle.UNIT_ARCMIN);
        this.setFieldMinSeparation(angle5);
        Angle angle6 = Angle.createAngle((double)0.0, (String)Angle.UNIT_ARCMIN);
        this.setListMinSeparation(angle6);
        this.setLst(null);
        this.setMaxTargets(100);
        this.setSelectionFactor(1);
        this.setCatalogLocation(LOCALCATALOGUE);
    }

    public void setMinMagnitude(double d) {
        this.setMinMagnitude(Magnitude.createMagnitude(d));
    }

    public void setMaxMagnitude(double d) {
        this.setMaxMagnitude(Magnitude.createMagnitude(d));
    }

    public double getMaxRA() {
        Longitude longitude = this.getMaxCoordinates().getLongitude();
        return longitude.getContentInUnits(Longitude.UNIT_DEG);
    }

    public double getMaxDec() {
        return this.getMaxCoordinates().getLatitude().getContentInUnits(Latitude.UNIT_DEG);
    }

    public double getMinRA() {
        return this.getMinCoordinates().getLongitude().getContentInUnits(Longitude.UNIT_DEG);
    }

    public double getMinDec() {
        return this.getMinCoordinates().getLatitude().getContentInUnits(Latitude.UNIT_DEG);
    }

    public void setMinRA(double d) {
        this.getMinCoordinates().getLongitude().setContent(d);
    }

    public void setMinDec(double d) {
        this.getMinCoordinates().getLatitude().setContent(d);
    }

    public void setMaxRA(double d) {
        this.getMaxCoordinates().getLongitude().setContent(d);
    }

    public void setMaxDec(double d) {
        this.getMaxCoordinates().getLatitude().setContent(d);
    }

    public void setLst(Calendar calendar) {
        this.setLst(String.valueOf(calendar.getTimeInMillis()));
    }

    public Calendar getLstCalendar() {
        Calendar calendar = null;
        String string = this.getLst();
        if (string == null || string.length() == 0) {
            return calendar;
        }
        calendar = Calendar.getInstance();
        calendar.setTimeInMillis(Long.parseLong(string));
        return calendar;
    }
}

