/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.bo.enumerations;

import alma.observatorycharacteristics.capabilities.AlmaCapabilities;
import alma.obsprep.obstooluserprefs.types.TelescopeType;
import java.util.ArrayList;
import lombok.NonNull;

public enum Telescope {
    ATF(TelescopeType.ATF, "A 2 antenna test facility at Magdalena", false),
    ALMA(TelescopeType.ALMA, "The full featured ALMA", true),
    ESALMA(TelescopeType.ESALMA, "Early Science ALMA", true),
    Cycle2(TelescopeType.CYCLE2, "Cycle2 ALMA", true),
    CSVALMA(TelescopeType.CSVALMA, "CSV ALMA", true),
    Cycle3(TelescopeType.CYCLE3, "Cycle3 ALMA", true),
    Cycle4(TelescopeType.CYCLE4, "Cycle4 ALMA", true),
    Cycle5(TelescopeType.CYCLE5, "Cycle5 ALMA", true),
    Cycle6(TelescopeType.CYCLE6, "Cycle6 ALMA", true),
    Cycle7(TelescopeType.CYCLE7, "Cycle7 ALMA", true),
    Cycle8(TelescopeType.CYCLE8, "Cycle8 ALMA", true),
    Cycle9(TelescopeType.CYCLE9, "Cycle9 ALMA", true),
    Cycle10(TelescopeType.CYCLE10, "Cycle10 ALMA", true);

    private final TelescopeType telescopeType;
    private final String description;
    private final boolean isValidTelescope;
    private static Telescope[] validTelescopes;

    public static boolean isOTConfiguredAs(@NonNull Telescope telescope) {
        if (telescope == null) {
            throw new NullPointerException("telescope is marked non-null but is null");
        }
        String string = System.getProperty("Telescope");
        if (string == null) {
            throw new IllegalArgumentException("Illegal argument: currentTelescopeConfiguration (" + string + ") did not pass the test: currentTelescopeConfiguration == null");
        }
        return string.equalsIgnoreCase(telescope.name());
    }

    public static Telescope getTelescopeSelection() {
        return Telescope.getTelescope(AlmaCapabilities.getInstance().getTelescope());
    }

    public static Telescope getTelescope(String string) {
        for (Telescope telescope : Telescope.values()) {
            if (!telescope.name().equals(string) && !telescope.getDescription().equals(string) && !telescope.getLabel().equals(string)) continue;
            return telescope;
        }
        throw new IllegalArgumentException("Can not identify telescope : " + string);
    }

    public static Telescope[] getValidTelescopes() {
        if (validTelescopes == null) {
            ArrayList<Telescope> arrayList = new ArrayList<Telescope>();
            for (Telescope telescope : Telescope.values()) {
                if (!telescope.isValidTelescope) continue;
                arrayList.add(telescope);
            }
            validTelescopes = arrayList.toArray(new Telescope[arrayList.size()]);
        }
        return validTelescopes;
    }

    public String getLabel() {
        return this.name() + " - " + this.getDescription();
    }

    private Telescope(TelescopeType telescopeType, String string2, boolean bl) {
        this.telescopeType = telescopeType;
        this.description = string2;
        this.isValidTelescope = bl;
    }

    public TelescopeType getTelescopeType() {
        return this.telescopeType;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isValidTelescope() {
        return this.isValidTelescope;
    }
}

