/*
 * Decompiled with CFR 0.152.
 */
package alma.observatorycharacteristics.capabilities;

import alma.hla.runtime.obsprep.util.Log;
import alma.observatorycharacteristics.capabilities.OTConfigurationHelper;
import alma.observatorycharacteristics.configuration.AntennaAssignment;
import alma.observatorycharacteristics.configuration.OTConfiguration;
import alma.observatorycharacteristics.configuration.OTXMLConfigurationReader;
import alma.observatorycharacteristics.configuration.SpectralScanBandsType;
import alma.observatorycharacteristics.configuration.VLBIFrequencyBands;
import alma.obsprep.bo.enumerations.Array;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.schedblock.AbstractCorrelatorConfiguration;
import alma.obsprep.bo.schedblock.OTConfigModeDecoder;
import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.services.experts.ObservingModeProperties;
import alma.obsprep.services.generator.InvalidObsProgramParametersException;
import alma.obsprep.util.FrequencyRange;
import alma.obsprep.util.MiscUtils;
import alma.valuetypes.Angle;
import alma.valuetypes.Frequency;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBException;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

public class AlmaCapabilities {
    private static AlmaCapabilities almaCapabilitiesSingleton = null;
    private final Map<Array, Map<Integer, Integer>> bandSpecificNoOfAntennas = new HashMap<Array, Map<Integer, Integer>>();
    private final Map<Array, Map<Integer, Integer>> bandSpecificNoOfAntennasForDataRates = new HashMap<Array, Map<Integer, Integer>>();
    private final Map<Array, Integer> nominalNumberOfAntennas = new HashMap<Array, Integer>();
    private final Angle elevationLimit;
    private final Angle minElevationWarning;
    private final Angle maxElevationWarning;
    private final Angle minElevationWarnThreshold;
    private final String modelistFileName;
    private final List<Frequency> standardHolographyFrequencies;
    private final List<String> availableReceiverBands;
    private final SpectralScanBandsType spectralScanReceiverBands;
    private final List<ReceiverBand> spectralScanBands = new ArrayList<ReceiverBand>();
    private final List<ReceiverBand> tpSpectralScanBands = new ArrayList<ReceiverBand>();
    private final int maxNumberSpectralWindows;
    private boolean isFullPolarizationAllowed = false;
    private boolean isFullPolarizationRestricted = true;
    private final List<Frequency> continuumFrequencies;
    private final List<Frequency> continuumPolarizationFrequencies;
    private final String telescope;
    private OTConfiguration.TelescopeCapabilities telescopeCapabilities;
    private final List<OTConfiguration.TelescopeCapabilities.SolarBands.SolarBand> solarBands;
    private final List<String> dgcB2BReceiverbands;
    private final List<ReceiverBand> dgcB2BBands = new ArrayList<ReceiverBand>();

    private AlmaCapabilities() throws InvalidObsProgramParametersException {
        Integer n;
        Integer n2;
        Array array;
        this.telescope = System.getProperty("Telescope", "Cycle10");
        try {
            this.telescopeCapabilities = OTXMLConfigurationReader.getInstance().getOTConfiguration().getTelescopeCapabilities();
        }
        catch (OTXMLConfigurationReader.InvalidOTCOnfigurationException | JAXBException throwable) {
            throw new RuntimeException("Unable to parse the " + this.telescope + "OTConfiguration.xml file " + throwable.getMessage());
        }
        this.availableReceiverBands = this.telescopeCapabilities.getAvailableReceiverBands().getBand().stream().map(Enum::toString).collect(Collectors.toList());
        this.nominalNumberOfAntennas.put(Array.ARRAY_12M, this.telescopeCapabilities.getNoOf12MAntennas().intValue());
        this.nominalNumberOfAntennas.put(Array.ARRAY_7M, this.telescopeCapabilities.getNoOf7MAntennas().intValue());
        this.nominalNumberOfAntennas.put(Array.ARRAY_TP, this.telescopeCapabilities.getNoOfTPAntennas().intValue());
        this.modelistFileName = StringUtils.trim((String)this.telescopeCapabilities.getStandardObservingModeList());
        this.standardHolographyFrequencies = OTConfigurationHelper.getFrequencyList(this.telescopeCapabilities.getStandardHolographyFrequencies());
        this.elevationLimit = OTConfigurationHelper.getAngle(this.telescopeCapabilities.getElevationLimit());
        this.minElevationWarnThreshold = OTConfigurationHelper.getAngle(this.telescopeCapabilities.getMinElevationWarningThreshold());
        this.minElevationWarning = OTConfigurationHelper.getAngle(this.telescopeCapabilities.getMinElevationWarning());
        this.maxElevationWarning = OTConfigurationHelper.getAngle(this.telescopeCapabilities.getMaxElevationWarning());
        this.spectralScanReceiverBands = this.telescopeCapabilities.getSpectralScanReceiverBands();
        this.dgcB2BReceiverbands = this.telescopeCapabilities.getDGCB2BReceiverBands().getBand().stream().map(Enum::toString).collect(Collectors.toList());
        List<BigInteger> list = this.telescopeCapabilities.getAvailableCorrelatorModes().getMode();
        OTConfigModeDecoder.getInstance();
        OTConfigModeDecoder.setAvailableModes(list.stream().map(BigInteger::intValue).collect(Collectors.toSet()));
        this.maxNumberSpectralWindows = this.telescopeCapabilities.getMaxNumberSPWs().intValue();
        this.isFullPolarizationAllowed = this.telescopeCapabilities.isFullPolarisationAllowed();
        this.isFullPolarizationRestricted = this.telescopeCapabilities.isFullPolarisationRestricted();
        this.continuumFrequencies = OTConfigurationHelper.getFrequencyList(this.telescopeCapabilities.getStandardContinuumLO1Frequencies());
        this.continuumPolarizationFrequencies = OTConfigurationHelper.getFrequencyList(this.telescopeCapabilities.getStandardContinuumLO1PolarisationFrequencies());
        for (AntennaAssignment.AntennasAssignedToBand antennasAssignedToBand : this.telescopeCapabilities.getAntennaBandAssignment().getAntennasAssignedToBand()) {
            array = OTConfigurationHelper.mapPrincipalArray(antennasAssignedToBand.getArray());
            if (!this.bandSpecificNoOfAntennas.containsKey((Object)array)) {
                this.bandSpecificNoOfAntennas.put(array, new HashMap());
            }
            n2 = antennasAssignedToBand.getBand();
            n = antennasAssignedToBand.getNoAntennas().intValue();
            if (this.bandSpecificNoOfAntennas.get((Object)array).containsKey(n2)) {
                throw new InvalidObsProgramParametersException("The number of antennas for receiver band " + n2 + " has already been specified");
            }
            this.bandSpecificNoOfAntennas.get((Object)array).put(n2, n);
        }
        for (AntennaAssignment.AntennasAssignedToBand antennasAssignedToBand : this.telescopeCapabilities.getAntennaBandAssignmentForDataRates().getAntennasAssignedToBand()) {
            array = OTConfigurationHelper.mapPrincipalArray(antennasAssignedToBand.getArray());
            if (!this.bandSpecificNoOfAntennasForDataRates.containsKey((Object)array)) {
                this.bandSpecificNoOfAntennasForDataRates.put(array, new HashMap());
            }
            n2 = antennasAssignedToBand.getBand();
            n = antennasAssignedToBand.getNoAntennas().intValue();
            if (this.bandSpecificNoOfAntennasForDataRates.get((Object)array).containsKey(n2)) {
                throw new InvalidObsProgramParametersException("The number of antennas for receiver band " + n2 + " has already been specified");
            }
            this.bandSpecificNoOfAntennasForDataRates.get((Object)array).put(n2, n);
        }
        this.solarBands = this.telescopeCapabilities.getSolarBands().getSolarBand();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AlmaCapabilities getInstance() {
        if (almaCapabilitiesSingleton != null) return almaCapabilitiesSingleton;
        Class<AlmaCapabilities> clazz = AlmaCapabilities.class;
        synchronized (AlmaCapabilities.class) {
            if (almaCapabilitiesSingleton != null) return almaCapabilitiesSingleton;
            try {
                almaCapabilitiesSingleton = new AlmaCapabilities();
                Log.logger(AlmaCapabilities.class).config("Telescope = " + AlmaCapabilities.almaCapabilitiesSingleton.telescope);
            }
            catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
                Log.logger(AlmaCapabilities.class).log(Level.WARNING, invalidObsProgramParametersException.getMessage(), (Throwable)invalidObsProgramParametersException);
            }
            return almaCapabilitiesSingleton;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void refreshCapabilities() {
        if (almaCapabilitiesSingleton == null) return;
        Class<AlmaCapabilities> clazz = AlmaCapabilities.class;
        synchronized (AlmaCapabilities.class) {
            if (almaCapabilitiesSingleton == null) return;
            almaCapabilitiesSingleton = null;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public int getNumAntennas(@NonNull Array array, ReceiverBand receiverBand) throws ReceiverBand.ReceiverNotFoundException {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        if (receiverBand == null) {
            return this.getNominalNumAntennas(array);
        }
        Integer n = receiverBand.getNumber();
        if (!this.bandSpecificNoOfAntennas.containsKey((Object)array)) {
            throw new ReceiverBand.ReceiverNotFoundException("Unable to find the number of antennas for receiver band " + n + " for array " + array);
        }
        Map<Integer, Integer> map = this.bandSpecificNoOfAntennas.get((Object)array);
        if (map == null || !map.containsKey(n)) {
            throw new ReceiverBand.ReceiverNotFoundException("Unable to find the number of antennas for receiver band " + n + " for array " + array);
        }
        return map.get(n);
    }

    public Angle getElLimit() {
        return this.elevationLimit.deepCopy();
    }

    public Angle getElLoWarn() {
        return this.minElevationWarning.deepCopy();
    }

    public Angle getElLoWarnThreshold() {
        return this.minElevationWarnThreshold.deepCopy();
    }

    public Angle getElHiWarn() {
        return this.maxElevationWarning.deepCopy();
    }

    public int getMaxNumberSw() {
        return this.maxNumberSpectralWindows;
    }

    public ObservingModeProperties[] getObservingModeList() {
        URL uRL = MiscUtils.findResource(null, this.modelistFileName);
        BufferedReader bufferedReader = null;
        ArrayList<ObservingModeProperties> arrayList = new ArrayList<ObservingModeProperties>();
        try {
            String string;
            InputStream inputStream = uRL.openStream();
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            while ((string = bufferedReader.readLine()) != null) {
                String string2 = string.trim();
                if (string2.startsWith("#") || string2.equals("")) continue;
                try {
                    String[] stringArray = string2.split("=");
                    String string3 = stringArray[0].trim();
                    String string4 = stringArray[1].trim();
                    ObservingModeProperties observingModeProperties = new ObservingModeProperties(string3, string4);
                    observingModeProperties.readObservingModeDocument();
                    arrayList.add(observingModeProperties);
                }
                catch (Exception exception) {
                    Log.logger((Object)this).log(Level.SEVERE, "Problems reading standard modes - check the input file", (Throwable)exception);
                }
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            Log.Logger logger = Log.logger((Object)this);
            logger.log(Level.WARNING, "Failed to open standard mode list, using a dummy", (Throwable)exception);
            arrayList.add(new ObservingModeProperties("Tower Holography", "config/TowerHolographyMode.xml"));
            arrayList.add(new ObservingModeProperties("Optical Pointing", "config/OpticalPointingMode.xml"));
            arrayList.add(new ObservingModeProperties("Standard Interferometry", "config/StandardInterferometryMode.xml"));
        }
        Log.logger((Object)this).config("Loaded " + arrayList.size() + " Observing modes");
        return arrayList.toArray(new ObservingModeProperties[arrayList.size()]);
    }

    public List<Frequency> getStandardHolographyFrequencies() {
        return Collections.unmodifiableList(this.standardHolographyFrequencies);
    }

    public List<String> getAvailableReceiverBands() {
        return Collections.unmodifiableList(this.availableReceiverBands);
    }

    public List<ReceiverBand> getSpectralScanReceiverBands() {
        assert (this.spectralScanBands != null);
        if (this.spectralScanBands.isEmpty()) {
            for (SpectralScanBandsType.SpectralScanBand spectralScanBand : this.spectralScanReceiverBands.getSpectralScanBand()) {
                ReceiverBand receiverBand = ReceiverBand.getReceiverBand(spectralScanBand.getBand());
                if (receiverBand == null) {
                    throw new RuntimeException("Unknown receiver band specified in the XML configuration file");
                }
                this.spectralScanBands.add(receiverBand);
            }
        }
        return this.spectralScanBands;
    }

    public List<ReceiverBand> getTPSpectralScanReceiverBands() {
        if (this.tpSpectralScanBands.isEmpty()) {
            for (SpectralScanBandsType.SpectralScanBand spectralScanBand : this.spectralScanReceiverBands.getSpectralScanBand()) {
                ReceiverBand receiverBand = ReceiverBand.getReceiverBand(spectralScanBand.getBand());
                if (receiverBand == null) {
                    throw new RuntimeException("Unknown receiver band specified in the XML configuration file");
                }
                if (!spectralScanBand.isIsTPSpectralScanAllowed().booleanValue()) continue;
                this.tpSpectralScanBands.add(receiverBand);
            }
        }
        return this.tpSpectralScanBands;
    }

    public List<ReceiverBand> getDGCB2BReceiverBands() {
        if (this.dgcB2BBands.isEmpty()) {
            for (String string : this.dgcB2BReceiverbands) {
                ReceiverBand receiverBand = ReceiverBand.getReceiverBand(string);
                if (receiverBand == null) {
                    throw new RuntimeException("Unknown receiver band specified as part of the DGCB2BReceiverBands property");
                }
                this.dgcB2BBands.add(ReceiverBand.getReceiverBand(string));
            }
        }
        return this.dgcB2BBands;
    }

    public List<Frequency> getContinuumFrequencies() {
        return Collections.unmodifiableList(this.continuumFrequencies);
    }

    public List<Frequency> getPolarizationFrequencies() {
        return Collections.unmodifiableList(this.continuumPolarizationFrequencies);
    }

    public List<Frequency> getVLBIFrequencies() {
        return this.telescopeCapabilities.getStandardVLBIFrequencies().getVLBIBands().stream().map(vLBIBands -> OTConfigurationHelper.getFrequency(vLBIBands.getLO1Frequency())).collect(Collectors.toList());
    }

    public List<Frequency> getVLBIPhaserFrequencies() {
        return this.telescopeCapabilities.getVLBIPhaserFrequencies().getVLBIBands().stream().map(vLBIBands -> OTConfigurationHelper.getFrequency(vLBIBands.getLO1Frequency())).collect(Collectors.toList());
    }

    public VLBIFrequencyBands getVLBIPhaserBands() {
        return this.telescopeCapabilities.getVLBIPhaserFrequencies();
    }

    public VLBIFrequencyBands getVLBIBands() {
        return this.telescopeCapabilities.getStandardVLBIFrequencies();
    }

    public List<Frequency> getVLBISPWCentralFrequencies(int n) {
        for (VLBIFrequencyBands.VLBIBands vLBIBands : this.telescopeCapabilities.getStandardVLBIFrequencies().getVLBIBands()) {
            if (vLBIBands.getBand() != n) continue;
            return OTConfigurationHelper.getFrequencyList(vLBIBands.getSPWFrequency());
        }
        throw new IllegalArgumentException("Band " + n + " is not a valid VLBI receiver band");
    }

    public List<Frequency> getVLBIPhaserSPWCentralFrequencies(int n) {
        for (VLBIFrequencyBands.VLBIBands vLBIBands : this.telescopeCapabilities.getVLBIPhaserFrequencies().getVLBIBands()) {
            if (vLBIBands.getBand() != n) continue;
            return OTConfigurationHelper.getFrequencyList(vLBIBands.getSPWFrequency());
        }
        throw new IllegalArgumentException("Band " + n + " is not a valid VLBI receiver band");
    }

    public int getNominalNumAntennas(Array array) {
        return this.nominalNumberOfAntennas.get((Object)array);
    }

    public int getNumAntennas(@NonNull Array array, @NonNull AbstractCorrelatorConfiguration abstractCorrelatorConfiguration) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        if (abstractCorrelatorConfiguration == null) {
            throw new NullPointerException("abstractCorrelatorConfiguration is marked non-null but is null");
        }
        Integer n = null;
        try {
            n = this.getNumAntennas(array, abstractCorrelatorConfiguration.getReceiverBand());
        }
        catch (ReceiverBand.ReceiverNotFoundException receiverNotFoundException) {
            Log.logger(AlmaCapabilities.class).warning("Unable to derive the receiver band from the correlator configuration - defaulting to nominal number of antennas: " + receiverNotFoundException.getMessage());
        }
        if (n == null) {
            n = this.getNominalNumAntennas(array);
        }
        return n;
    }

    public int getNumAntennas(@NonNull Array array, SpectralSetupParameters spectralSetupParameters) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        Integer n = null;
        if (spectralSetupParameters != null) {
            try {
                n = this.getNumAntennas(array, spectralSetupParameters.getReceiverBand());
            }
            catch (ReceiverBand.ReceiverNotFoundException receiverNotFoundException) {
                Log.logger(AlmaCapabilities.class).warning("Unable to derive the receiver band from the ssp - defaulting to nominal number of antennas: " + receiverNotFoundException.getMessage());
            }
        } else {
            Log.logger(AlmaCapabilities.class).warning("Unable to use spectral context to get receiver band: using nominal number of antennas");
        }
        if (n == null) {
            n = this.getNominalNumAntennas(array);
        }
        return n;
    }

    public int getNumAntennas(@NonNull Array array, @NonNull FrequencyRange frequencyRange) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        if (frequencyRange == null) {
            throw new NullPointerException("frequencyRange is marked non-null but is null");
        }
        ReceiverBand receiverBand = null;
        try {
            receiverBand = ReceiverBand.getReceiverBand(frequencyRange);
        }
        catch (ReceiverBand.ReceiverNotFoundException receiverNotFoundException) {
            Log.logger(AlmaCapabilities.class).warning("Unable to deduce receiver band for " + frequencyRange + ": " + receiverNotFoundException.getMessage());
        }
        Integer n = null;
        try {
            n = this.getNumAntennas(array, receiverBand);
        }
        catch (ReceiverBand.ReceiverNotFoundException receiverNotFoundException) {
            Log.logger(AlmaCapabilities.class).warning("Unable to derive the receiver band from the ssp - defaulting to nominal number of antennas : " + receiverNotFoundException.getMessage());
        }
        if (n == null) {
            n = this.getNominalNumAntennas(array);
        }
        return n;
    }

    public int getNumAntennas(@NonNull Array array, SpectralSpec spectralSpec) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        Integer n = null;
        if (spectralSpec != null) {
            try {
                n = this.getNumAntennas(array, spectralSpec.getReceiverBand());
            }
            catch (ReceiverBand.ReceiverNotFoundException receiverNotFoundException) {
                Log.logger(AlmaCapabilities.class).warning("Unable to derive the receiver band from the spectralSpec: defaulting to nominal number of antennas : " + receiverNotFoundException.getMessage());
            }
        } else {
            Log.logger(AlmaCapabilities.class).warning("Unable to use spectral setup to determine the receiver band: defaulting to nominal number of antennas : ");
        }
        if (n == null) {
            n = this.getNominalNumAntennas(array);
        }
        Log.logger(AlmaCapabilities.class).fine("Array " + array + "antennas: " + n);
        return n;
    }

    public List<OTConfiguration.TelescopeCapabilities.SolarBands.SolarBand> getSolarBands() {
        return Collections.unmodifiableList(this.solarBands);
    }

    public int getNumAntennasForDataRates(@NonNull Array array, @NonNull AbstractCorrelatorConfiguration abstractCorrelatorConfiguration) throws ReceiverBand.ReceiverNotFoundException {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        if (abstractCorrelatorConfiguration == null) {
            throw new NullPointerException("abstractCorrelatorConfiguration is marked non-null but is null");
        }
        return this.getNumAntennasForDataRates(array, abstractCorrelatorConfiguration.getReceiverBand());
    }

    private int getNumAntennasForDataRates(@NonNull Array array, ReceiverBand receiverBand) throws ReceiverBand.ReceiverNotFoundException {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        if (receiverBand == null) {
            return this.getNominalNumAntennas(array);
        }
        Integer n = receiverBand.getNumber();
        if (!this.bandSpecificNoOfAntennas.containsKey((Object)array)) {
            throw new ReceiverBand.ReceiverNotFoundException("Unable to find the number of antennas for receiver band " + n + " for array " + array);
        }
        Map<Integer, Integer> map = this.bandSpecificNoOfAntennasForDataRates.get((Object)array);
        if (map == null || !map.containsKey(n)) {
            throw new ReceiverBand.ReceiverNotFoundException("Unable to find the number of antennas for receiver band " + n + " for array " + array);
        }
        return map.get(n);
    }

    public int getNumAntennasForDataRates(@NonNull Array array, @NonNull SpectralSetupParameters spectralSetupParameters) throws ReceiverBand.ReceiverNotFoundException {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        if (spectralSetupParameters == null) {
            throw new NullPointerException("ssp is marked non-null but is null");
        }
        Integer n = null;
        n = this.getNumAntennasForDataRates(array, spectralSetupParameters.getReceiverBand());
        if (n == null) {
            throw new RuntimeException("The number of antennas should not be null");
        }
        return n;
    }

    @NonNull
    public List<OTConfiguration.TelescopeCapabilities.SolarBands.SolarBand> getSolarBandsForFullPolarization() {
        return Collections.unmodifiableList(this.solarBands.stream().filter(OTConfiguration.TelescopeCapabilities.SolarBands.SolarBand::isIsFullPolarizationEnabled).collect(Collectors.toList()));
    }

    public boolean isFullPolarizationAllowed() {
        return this.isFullPolarizationAllowed;
    }

    public boolean isFullPolarizationRestricted() {
        return this.isFullPolarizationRestricted;
    }

    public String getTelescope() {
        return this.telescope;
    }
}

