/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.util;

import java.net.MalformedURLException;
import java.net.URL;
import java.text.DecimalFormat;

public class CgiQuery {
    private final StringBuffer sbuf_;
    private int narg;
    private static final String QUERY_CHARS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-_.!~*'()";

    public CgiQuery(String base) {
        base = base.trim();
        try {
            new URL(base);
        }
        catch (MalformedURLException e) {
            throw (IllegalArgumentException)new IllegalArgumentException("Not a url: " + base).initCause(e);
        }
        this.sbuf_ = new StringBuffer(base);
    }

    public CgiQuery addArgument(String name, long value) {
        return this.addArgument(name, Long.toString(value));
    }

    public CgiQuery addArgument(String name, double value) {
        return this.addArgument(name, CgiQuery.formatDouble(value));
    }

    public CgiQuery addArgument(String name, float value) {
        return this.addArgument(name, CgiQuery.formatFloat(value));
    }

    public CgiQuery addArgument(String name, String value) {
        if (this.narg++ == 0) {
            char lastChar = this.sbuf_.charAt(this.sbuf_.length() - 1);
            if (lastChar != '?' && lastChar != '&') {
                this.sbuf_.append(this.sbuf_.indexOf("?") >= 0 ? (char)'&' : '?');
            }
        } else {
            this.sbuf_.append('&');
        }
        this.sbuf_.append(name).append('=');
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (QUERY_CHARS.indexOf(c) >= 0) {
                this.sbuf_.append(c);
                continue;
            }
            if (c >= '\u0010' && c <= '\u007f') {
                this.sbuf_.append('%').append(Integer.toHexString(c));
                continue;
            }
            throw new IllegalArgumentException("Bad character in \"" + value + "\"");
        }
        return this;
    }

    public URL toURL() {
        try {
            return new URL(this.sbuf_.toString());
        }
        catch (MalformedURLException e) {
            throw new AssertionError();
        }
    }

    public boolean equals(Object o) {
        return o instanceof CgiQuery && o.toString().equals(this.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return this.sbuf_.toString();
    }

    public static String formatDouble(double value) {
        return CgiQuery.formatDouble(value, 16, 32);
    }

    public static String formatFloat(float value) {
        return CgiQuery.formatDouble(value, 7, 32);
    }

    public static String formatDouble(double value, int nsf, int maxleng) {
        String sval = Double.toString(value);
        if (sval.indexOf(69) < 0) {
            return sval;
        }
        int log10 = CgiQuery.log10(value);
        StringBuffer fbuf = new StringBuffer("0.");
        for (int i = 0; i < nsf - log10; ++i) {
            fbuf.append('0');
        }
        String fval = new DecimalFormat(fbuf.toString()).format(value);
        if ((fval = fval.replaceFirst("0+$", "")).length() <= maxleng) {
            return fval;
        }
        return sval;
    }

    private static int log10(double value) {
        return (int)Math.round(Math.log(Math.abs(value)) / Math.log(10.0));
    }
}

