/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.cdb.jdal;

import alma.ACSErrTypeCommon.wrappers.AcsJIllegalArgumentEx;
import alma.Logging.IllegalLogLevelsEx;
import alma.Logging.LoggerDoesNotExistEx;
import alma.Logging.LoggingConfigurablePackage.LogLevels;
import alma.acs.logging.AcsLogLevel;
import alma.acs.logging.ClientLogManager;
import alma.acs.logging.MultipleRepeatGuard;
import alma.acs.logging.RepeatGuard;
import alma.acs.logging.config.LogConfig;
import alma.acs.logging.config.LogConfigException;
import alma.acs.logging.level.AcsLogLevelDefinition;
import alma.acs.monitoring.SimpleCallInterceptor;
import alma.acs.util.StopWatch;
import alma.cdbErrType.CDBRecordDoesNotExistEx;
import alma.cdbErrType.CDBXMLErrorEx;
import alma.cdbErrType.wrappers.AcsJCDBRecordDoesNotExistEx;
import alma.cdbErrType.wrappers.AcsJCDBXMLErrorEx;
import alma.maci.loggingconfig.UnnamedLogger;
import com.cosylab.CDB.DALChangeListener;
import com.cosylab.CDB.DALChangeListenerHelper;
import com.cosylab.CDB.DAO;
import com.cosylab.CDB.DAOHelper;
import com.cosylab.CDB.DAOOperations;
import com.cosylab.CDB.DAOPOATie;
import com.cosylab.CDB.JDALPOA;
import com.cosylab.cdb.jdal.DALNode;
import com.cosylab.cdb.jdal.DAOImpl;
import com.cosylab.cdb.jdal.Recoverer;
import com.cosylab.cdb.jdal.XMLHandler;
import com.cosylab.util.FileHelper;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Random;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.omg.CORBA.NO_RESOURCES;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.Servant;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

public class DALImpl
extends JDALPOA
implements Recoverer {
    public static final String SCHEMA_VALIDATION_FEATURE_ID = "http://apache.org/xml/features/validation/schema";
    public static final String EXTERNAL_SCHEMA_LOCATION_PROPERTY_ID = "http://apache.org/xml/properties/schema/external-schemaLocation";
    public static final String USE_XSD_CACHE_PROPERTYNAME = "cdb.useXsdCache";
    public final boolean useXsdCache;
    private ORB orb;
    private POA poa;
    private SAXParserFactory factory;
    private SAXParser saxParser;
    private String m_root;
    private HashMap<String, DAO> daoMap = new HashMap();
    private final HashMap<String, ArrayList<Integer>> listenedCurls = new HashMap();
    private File listenersStorageFile = null;
    private Random idPool = new Random();
    private HashMap<Integer, DALChangeListener> regListeners = new HashMap();
    private boolean recoveryRead = true;
    private boolean disableRecoveryFile = false;
    private DALNode rootNode = null;
    private final Logger m_logger;
    private volatile boolean shutdown = false;
    private final java.lang.Object shutdownLock = new java.lang.Object();
    protected final AtomicLong totalDALInvocationCounter;
    private final MultipleRepeatGuard recordNotExistLogRepeatGuard;
    private final int recordNotExistLogRepeatGuardTimeSeconds;
    private final LinkedHashMap<String, java.lang.Object> cache = new LinkedHashMap();
    private boolean cacheDisabled = false;
    private volatile boolean cacheLimitReached = false;
    LogConfig logConfig = ClientLogManager.getAcsLogManager().getLogConfig();

    DALImpl(String[] args, ORB orb_val, POA poa_val, Logger logger) {
        this.orb = orb_val;
        this.poa = poa_val;
        this.m_logger = logger;
        this.useXsdCache = Boolean.getBoolean(USE_XSD_CACHE_PROPERTYNAME);
        this.m_logger.info("DALImpl will use XSD caching for xerces sax parser ? " + this.useXsdCache);
        this.m_root = "CDB";
        this.totalDALInvocationCounter = new AtomicLong();
        this.recordNotExistLogRepeatGuardTimeSeconds = 10;
        this.recordNotExistLogRepeatGuard = new MultipleRepeatGuard((long)this.recordNotExistLogRepeatGuardTimeSeconds, TimeUnit.SECONDS, -1, RepeatGuard.Logic.TIMER, 100);
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-root")) {
                if (i >= args.length - 1) continue;
                this.m_root = args[++i] + File.separator + "CDB";
                continue;
            }
            if (args[i].equals("-n")) {
                this.recoveryRead = false;
                continue;
            }
            if (args[i].equals("-disableCache")) {
                this.cacheDisabled = true;
                continue;
            }
            if (!args[i].equals("-disableRecoveryFile")) continue;
            this.disableRecoveryFile = true;
        }
        File rootF = new File(this.m_root);
        if (!rootF.exists()) {
            throw new IllegalArgumentException("CDB directory '" + this.m_root + "' does not exist.");
        }
        this.m_root = rootF.getAbsolutePath() + "/";
        this.m_logger.log((Level)AcsLogLevel.INFO, "DAL root is: " + this.m_root);
        if (this.cacheDisabled) {
            this.m_logger.log((Level)AcsLogLevel.INFO, "DAL cache is disabled.");
        }
        this.loadFactory();
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (!DALImpl.this.shutdown) {
                    DALImpl.this.checkCache();
                    java.lang.Object object = DALImpl.this.shutdownLock;
                    synchronized (object) {
                        try {
                            DALImpl.this.shutdownLock.wait(15000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            }
        }, "cache-cleanup").start();
    }

    public void loadFactory() {
        if (this.useXsdCache) {
            System.setProperty("org.apache.xerces.xni.parser.XMLParserConfiguration", "org.apache.xerces.parsers.XMLGrammarCachingConfiguration");
        }
        this.factory = SAXParserFactory.newInstance();
        try {
            try {
                this.factory.setNamespaceAware(true);
                this.factory.setValidating(true);
                this.factory.setFeature(SCHEMA_VALIDATION_FEATURE_ID, true);
                this.factory.setFeature("http://apache.org/xml/features/xinclude", true);
            }
            catch (IllegalArgumentException x) {
                this.m_logger.log((Level)AcsLogLevel.NOTICE, "Check to see if parser conforms to JAXP 1.2 spec.", x);
                System.exit(1);
            }
            this.saxParser = this.factory.newSAXParser();
            String allURIs = this.getSchemas();
            this.m_logger.log((Level)AcsLogLevel.DELOUSE, "created parser " + this.saxParser.getClass().getName() + " with schema location: '" + allURIs + "'");
            if (allURIs != null) {
                this.saxParser.setProperty(EXTERNAL_SCHEMA_LOCATION_PROPERTY_ID, allURIs);
            } else {
                this.m_logger.log((Level)AcsLogLevel.NOTICE, "Schema files: NO SCHEMAS!");
            }
            this.saxParser.setProperty("http://apache.org/xml/properties/input-buffer-size", new Integer(10240));
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    @Override
    public void recoverClients() {
        if (this.recoveryRead) {
            this.loadListeners();
            new Thread(){

                @Override
                public void run() {
                    DALImpl.this.clear_cache_all();
                }
            }.start();
        }
    }

    private String getSchemas() {
        return DALImpl.getSchemas(this.m_root, this.m_logger);
    }

    public static String getSchemas(String root, Logger logger) {
        String filePath;
        LinkedHashMap<String, String> filePathMap = new LinkedHashMap<String, String>();
        DALImpl.getFiles(root + "schemas", filePathMap);
        int dbg_nRoot = filePathMap.size();
        logger.log((Level)AcsLogLevel.DEBUG, "- found " + dbg_nRoot + " xsd-files in -root=" + root);
        String pathList = System.getProperty("ACS.cdbpath");
        if (pathList != null) {
            StringTokenizer st = new StringTokenizer(pathList, File.pathSeparator);
            while (st.hasMoreTokens()) {
                filePath = st.nextToken();
                DALImpl.getFiles(filePath, filePathMap);
            }
            logger.log((Level)AcsLogLevel.DEBUG, "- found " + (filePathMap.size() - dbg_nRoot) + " additional xsd-files in ACS.cdbpath=" + pathList);
        } else {
            logger.warning("Property 'ACS.cdbpath' not set.");
        }
        Iterator<String> i = filePathMap.keySet().iterator();
        if (!i.hasNext()) {
            return null;
        }
        StringBuffer allURIs = new StringBuffer(1024);
        while (i.hasNext()) {
            String fileName = i.next();
            filePath = filePathMap.get(fileName);
            fileName = fileName.substring(0, fileName.length() - 4);
            allURIs.append("urn:schemas-cosylab-com:").append(fileName).append(":1.0 ").append(filePath).append(' ');
        }
        String ret = allURIs.toString();
        logger.log(Level.FINEST, "All XSD URIs (max. 1000 chars): " + ret.substring(0, 1000));
        return ret;
    }

    public static void getFiles(String filePath, LinkedHashMap<String, String> map) {
        File base = new File(filePath);
        File[] basefiles = base.listFiles(new Filter());
        if (basefiles == null) {
            return;
        }
        for (int i = 0; i < basefiles.length; ++i) {
            String fileName = basefiles[i].getName();
            if (map.get(fileName) != null) continue;
            map.put(fileName, basefiles[i].getPath());
        }
    }

    public String getRecordPath(String curl) {
        int slashPos = curl.lastIndexOf(47, curl.length() - 1);
        String objectName = slashPos == -1 ? curl : curl.substring(slashPos);
        String path = this.m_root + curl + "/" + objectName + ".xml";
        return path;
    }

    public void parseNode(DALNode node, XMLHandler xmlSolver, String path) throws SAXException, IOException, AcsJCDBXMLErrorEx {
        this.m_logger.finest("parseNode called for " + path + "/" + node.name);
        DALNode[] childs = node.getChilds();
        DALNode curlNode = node.getCurlNode();
        if (curlNode != null) {
            String xmlPath = this.getRecordPath(node.getCurl());
            String xml = null;
            File xmlFile = null;
            if (xml != null) {
                this.saxParser.parse(new InputSource(new StringReader(xml)), (DefaultHandler)xmlSolver);
            } else {
                xmlFile = new File(xmlPath);
                xmlSolver.setFirstElement(node.name);
                this.saxParser.parse(xmlFile, (DefaultHandler)xmlSolver);
            }
            if (xmlSolver.m_errorString != null) {
                java.lang.Object info = "XML parser error: ";
                if (xmlFile != null) {
                    info = (String)info + "file=" + xmlFile.getAbsolutePath() + " ";
                }
                info = (String)info + xmlSolver.m_errorString;
                AcsJCDBXMLErrorEx cdbxmlErr = new AcsJCDBXMLErrorEx();
                cdbxmlErr.setFilename(xmlPath);
                cdbxmlErr.setNodename(node.name);
                cdbxmlErr.setCurl(node.getCurl());
                cdbxmlErr.setErrorString((String)info);
                this.m_logger.log((Level)AcsLogLevel.NOTICE, (String)info);
                throw cdbxmlErr;
            }
        } else {
            xmlSolver.startDocument();
            xmlSolver.startElement(null, null, node.name, new AttributesImpl());
        }
        if (xmlSolver.m_rootNode != null) {
            xmlSolver.m_rootNode.markNodesAsElements();
        }
        for (int i = 0; i < childs.length; ++i) {
            this.parseNode(childs[i], xmlSolver, path + "/" + node.name);
        }
        xmlSolver.closeElement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public XMLHandler loadRecords(String curl, boolean toString) throws AcsJCDBRecordDoesNotExistEx, AcsJCDBXMLErrorEx {
        StopWatch sw = new StopWatch(this.m_logger);
        try {
            XMLHandler xmlSolver;
            DALImpl dALImpl = this;
            synchronized (dALImpl) {
                if (this.rootNode == null) {
                    this.rootNode = DALNode.getRoot(this.m_root);
                }
            }
            String strFileCurl = curl;
            java.lang.Object strNodeCurl = "";
            DALNode curlNode = null;
            boolean isEmbeddedNode = false;
            while (strFileCurl != null && (curlNode = this.rootNode.findNode(strFileCurl)) == null) {
                if (strFileCurl.lastIndexOf(47) > 0) {
                    strNodeCurl = strFileCurl.substring(strFileCurl.lastIndexOf(47) + 1) + "/" + (String)strNodeCurl;
                    strFileCurl = strFileCurl.substring(0, strFileCurl.lastIndexOf(47));
                    isEmbeddedNode = true;
                    continue;
                }
                strFileCurl = null;
            }
            this.m_logger.log((Level)AcsLogLevel.DEBUG, "loadRecords(curl=" + curl + "), strFileCurl=" + strFileCurl + ", strNodeCurl=" + (String)strNodeCurl);
            if (strFileCurl == null || isEmbeddedNode && !curlNode.hasXmlChild()) {
                AcsJCDBRecordDoesNotExistEx recordDoesNotExist = new AcsJCDBRecordDoesNotExistEx();
                recordDoesNotExist.setCurl(curl);
                throw recordDoesNotExist;
            }
            if (curlNode.isSimple()) {
                this.m_logger.log((Level)AcsLogLevel.DEBUG, "loadRecords(curl=" + curl + "); curlNode '" + curlNode.name + "' is simple.");
                if (curl.equals(strFileCurl)) {
                    XMLHandler recordDoesNotExist = this.loadRecord(strFileCurl, toString);
                    return recordDoesNotExist;
                }
                XMLHandler xmlSolver2 = this.loadRecord(strFileCurl, false);
                try {
                    XMLHandler lt = xmlSolver2.getChild((String)strNodeCurl);
                    return lt;
                }
                catch (AcsJCDBRecordDoesNotExistEx e) {
                    e.setCurl(strFileCurl + e.getCurl());
                    throw e;
                }
            }
            this.m_logger.log((Level)AcsLogLevel.DEBUG, "loadRecords(curl=" + curl + "), curlNode is Complex");
            try {
                if (curl.equals(strFileCurl)) {
                    XMLHandler xmlSolver3 = new XMLHandler(toString, this.m_logger);
                    xmlSolver3.setAutoCloseStartingElement(false);
                    this.parseNode(curlNode, xmlSolver3, "");
                    XMLHandler e = xmlSolver3;
                    return e;
                }
                xmlSolver = new XMLHandler(false, this.m_logger);
                xmlSolver.setMarkArrays(1);
                xmlSolver.setAutoCloseStartingElement(false);
            }
            catch (AcsJCDBRecordDoesNotExistEx e) {
                e.setCurl(strFileCurl + e.getCurl());
                throw e;
            }
            catch (SAXParseException e) {
                AcsJCDBXMLErrorEx cdbxmlErr = new AcsJCDBXMLErrorEx();
                cdbxmlErr.setErrorString("SAXParseException: " + e.getMessage());
                cdbxmlErr.setCurl(curl);
                cdbxmlErr.setFilename(e.getSystemId() + ", line=" + e.getLineNumber());
                throw cdbxmlErr;
            }
            catch (Throwable thr) {
                AcsJCDBXMLErrorEx cdbxmlErr = new AcsJCDBXMLErrorEx(thr);
                cdbxmlErr.setCurl(curl);
                throw cdbxmlErr;
            }
            this.parseNode(curlNode, xmlSolver, "");
            XMLHandler e = xmlSolver.getChild((String)strNodeCurl);
            return e;
        }
        finally {
            long lt = sw.getLapTimeMillis();
            this.m_logger.finest("Time spent in loadRecords(" + curl + "): " + lt);
        }
    }

    private XMLHandler loadRecord(String curl, boolean toString) throws AcsJCDBRecordDoesNotExistEx, AcsJCDBXMLErrorEx {
        String xmlPath = this.getRecordPath(curl);
        File xmlFile = new File(xmlPath);
        if (!xmlFile.exists()) {
            AcsJCDBRecordDoesNotExistEx recordDoesNotExist = new AcsJCDBRecordDoesNotExistEx();
            recordDoesNotExist.setCurl(curl);
            throw recordDoesNotExist;
        }
        XMLHandler xmlSolver = new XMLHandler(toString, this.m_logger);
        xmlSolver.setMarkArrays(1);
        try {
            this.m_logger.log((Level)AcsLogLevel.DEBUG, "Parsing xmlFile=" + xmlFile);
            this.saxParser.parse(xmlFile, (DefaultHandler)xmlSolver);
            if (xmlSolver.m_errorString != null) {
                String info = "XML parser error: " + xmlSolver.m_errorString;
                AcsJCDBXMLErrorEx cdbxmlErr = new AcsJCDBXMLErrorEx();
                cdbxmlErr.setFilename(xmlPath);
                cdbxmlErr.setCurl(curl);
                cdbxmlErr.setErrorString(info);
                throw cdbxmlErr;
            }
            return xmlSolver;
        }
        catch (AcsJCDBXMLErrorEx cdbxmlErr) {
            throw cdbxmlErr;
        }
        catch (Throwable t) {
            String info = "SAXException " + t;
            AcsJCDBXMLErrorEx cdbxmlErr = new AcsJCDBXMLErrorEx(t);
            cdbxmlErr.setCurl(curl);
            cdbxmlErr.setErrorString(info);
            throw cdbxmlErr;
        }
    }

    public boolean wasCacheLimitReached() {
        return this.cacheLimitReached || this.cacheDisabled;
    }

    private void checkCache() {
        this.checkCache(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkCache(boolean tryOnly) {
        if (this.cacheDisabled) {
            return false;
        }
        LinkedHashMap<String, java.lang.Object> linkedHashMap = this.cache;
        synchronized (linkedHashMap) {
            long freedEstimation;
            String oldestKey;
            String value;
            System.gc();
            System.runFinalization();
            System.gc();
            Runtime r = Runtime.getRuntime();
            long allocatedMemory = r.totalMemory();
            long freeOfAllocatedMemory = r.freeMemory();
            long maxMemory = r.maxMemory();
            long totalFreeMemory = maxMemory - allocatedMemory + freeOfAllocatedMemory;
            long requiredFreeMemory = (long)((double)maxMemory * 0.2);
            long toFree = requiredFreeMemory - totalFreeMemory;
            if (tryOnly) {
                boolean someFreeLeft = toFree <= 0L;
                this.cacheLimitReached |= someFreeLeft;
                return someFreeLeft;
            }
            if (toFree <= 0L || this.cache.isEmpty()) {
                this.m_logger.log((Level)AcsLogLevel.DELOUSE, "Memory status: " + (double)(1000L * totalFreeMemory / maxMemory) / 10.0 + "% free.");
                return true;
            }
            this.m_logger.log((Level)AcsLogLevel.DEBUG, "Low memory: " + (double)totalFreeMemory / (double)maxMemory * 100.0 + "% free. Cleaning cache...");
            this.cacheLimitReached = true;
            for (freedEstimation = 0L; freedEstimation < toFree && !this.cache.isEmpty(); freedEstimation += (long)(value.length() * 2 + 64 + (oldestKey.length() * 2 + 64) + 68)) {
                oldestKey = this.cache.keySet().iterator().next();
                java.lang.Object cachedObject = this.cache.remove(oldestKey);
                value = cachedObject.toString();
                this.m_logger.log((Level)AcsLogLevel.DELOUSE, "XML record '" + oldestKey + "' removed from cache.");
            }
            System.runFinalization();
            System.gc();
            long l = totalFreeMemory;
            allocatedMemory = r.totalMemory();
            freeOfAllocatedMemory = r.freeMemory();
            totalFreeMemory = maxMemory - allocatedMemory + freeOfAllocatedMemory;
            this.m_logger.log((Level)AcsLogLevel.DEBUG, "Total free memory after cache cleanup: " + (double)totalFreeMemory / (double)maxMemory * 100.0 + "% free (actually freed: " + (totalFreeMemory - l) + " bytes, estimated: " + freedEstimation + " bytes).");
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearCache() {
        LinkedHashMap<String, java.lang.Object> linkedHashMap = this.cache;
        synchronized (linkedHashMap) {
            this.cache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getFromCache(String curl) throws CDBRecordDoesNotExistEx, CDBXMLErrorEx {
        if (curl != null && curl.startsWith("/")) {
            curl = curl.substring(1);
        }
        LinkedHashMap<String, java.lang.Object> linkedHashMap = this.cache;
        synchronized (linkedHashMap) {
            java.lang.Object cachedObject = this.cache.get(curl);
            if (cachedObject != null) {
                this.cache.remove(curl);
                this.cache.put(curl, cachedObject);
                if (cachedObject instanceof String) {
                    this.m_logger.log((Level)AcsLogLevel.DEBUG, "XML record '" + curl + "' retrieved from cache.");
                    return (String)cachedObject;
                }
                if (cachedObject instanceof CDBRecordDoesNotExistEx) {
                    this.m_logger.log((Level)AcsLogLevel.DEBUG, "CDBRecordDoesNotExist exception for record '" + curl + "' retrieved from cache.");
                    throw (CDBRecordDoesNotExistEx)cachedObject;
                }
                if (cachedObject instanceof CDBXMLErrorEx) {
                    this.m_logger.log((Level)AcsLogLevel.DEBUG, "CDBXMLError exception for record '" + curl + "' retrieved from cache.");
                    throw (CDBXMLErrorEx)((java.lang.Object)cachedObject);
                }
                throw new RuntimeException("Unable to handle object of class: " + cachedObject.getClass() + ", value: " + cachedObject);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putToCache(String curl, java.lang.Object xml) {
        if (this.cacheDisabled) {
            return;
        }
        if (curl != null && curl.startsWith("/")) {
            curl = curl.substring(1);
        }
        LinkedHashMap<String, java.lang.Object> linkedHashMap = this.cache;
        synchronized (linkedHashMap) {
            this.checkCache();
            this.cache.put(curl, xml);
            if (xml instanceof String) {
                this.m_logger.log((Level)AcsLogLevel.DEBUG, "XML record '" + curl + "' put to cache.");
            } else {
                this.m_logger.log((Level)AcsLogLevel.DEBUG, "Exception for record '" + curl + "' put to cache.");
            }
        }
    }

    public String get_DAO(String curl) throws CDBRecordDoesNotExistEx, CDBXMLErrorEx {
        return this.internal_get_DAO(curl, false);
    }

    public synchronized String internal_get_DAO(String curl, boolean precacheStage) throws CDBRecordDoesNotExistEx, CDBXMLErrorEx {
        this.totalDALInvocationCounter.incrementAndGet();
        if (this.shutdown) {
            throw new NO_RESOURCES();
        }
        try {
            String xml;
            if (curl.lastIndexOf(47) == curl.length() - 1) {
                curl = curl.substring(0, curl.length() - 1);
            }
            if ((xml = this.getFromCache(curl)) != null) {
                return xml;
            }
            XMLHandler xmlSolver = this.loadRecords(curl, true);
            if (xmlSolver == null) {
                this.m_logger.warning("xmlSolver was null.");
                return null;
            }
            if (!precacheStage) {
                this.m_logger.log((Level)AcsLogLevel.DEBUG, "Returning XML record for: " + curl);
            }
            xml = xmlSolver.toString(false);
            if (!precacheStage || this.checkCache(true)) {
                this.putToCache(curl, xml);
            }
            return xml;
        }
        catch (AcsJCDBXMLErrorEx e) {
            CDBXMLErrorEx ex = e.toCDBXMLErrorEx();
            if (!precacheStage || this.checkCache(true)) {
                this.putToCache(curl, (java.lang.Object)ex);
            }
            if (!precacheStage) {
                this.m_logger.log((Level)AcsLogLevel.NOTICE, "Failed to read curl '" + curl + "'.", e);
            }
            throw ex;
        }
        catch (AcsJCDBRecordDoesNotExistEx e) {
            CDBRecordDoesNotExistEx ex = e.toCDBRecordDoesNotExistEx();
            if (!precacheStage || this.checkCache(true)) {
                this.putToCache(curl, ex);
            }
            if (!precacheStage) {
                this.logRecordNotExistWithRepeatGuard(curl);
            }
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized DAO get_DAO_Servant(String curl) throws CDBRecordDoesNotExistEx, CDBXMLErrorEx {
        XMLHandler xmlSolver;
        this.totalDALInvocationCounter.incrementAndGet();
        if (curl.length() > 1 && curl.charAt(0) == '/') {
            curl = curl.substring(1);
        }
        HashMap<String, DAO> hashMap = this.daoMap;
        synchronized (hashMap) {
            if (this.daoMap.containsKey(curl)) {
                return this.daoMap.get(curl);
            }
        }
        try {
            xmlSolver = this.loadRecords(curl, false);
        }
        catch (AcsJCDBXMLErrorEx e) {
            this.m_logger.log((Level)AcsLogLevel.NOTICE, "Failed to read curl '" + curl + "'.", e);
            throw e.toCDBXMLErrorEx();
        }
        catch (AcsJCDBRecordDoesNotExistEx e) {
            this.logRecordNotExistWithRepeatGuard(curl);
            throw e.toCDBRecordDoesNotExistEx();
        }
        if (xmlSolver == null) {
            return null;
        }
        try {
            DAO href = null;
            HashMap<String, DAO> hashMap2 = this.daoMap;
            synchronized (hashMap2) {
                DAOImpl servantDelegate;
                if (this.daoMap.containsKey(curl)) {
                    return this.daoMap.get(curl);
                }
                DAOImpl topLevelServantDelegate = servantDelegate = new DAOImpl(curl, xmlSolver.m_rootNode, this.poa, this.m_logger);
                if (Boolean.getBoolean("alma.acs.cdb.log_corba_calls")) {
                    DAOOperations interceptingServantDelegate = (DAOOperations)SimpleCallInterceptor.createSimpleInterceptor(DAOOperations.class, (java.lang.Object)servantDelegate, (Logger)this.m_logger);
                    topLevelServantDelegate = interceptingServantDelegate;
                }
                DAOPOATie servant = new DAOPOATie((DAOOperations)topLevelServantDelegate);
                byte[] id = curl.getBytes();
                this.poa.activate_object_with_id(id, (Servant)servant);
                href = DAOHelper.narrow((Object)this.poa.servant_to_reference((Servant)servant));
                this.daoMap.put(curl, href);
            }
            this.m_logger.log((Level)AcsLogLevel.DEBUG, "Returning DAO servant for: " + curl);
            return href;
        }
        catch (Throwable t) {
            String info = "DAO::get_DAO_Servant " + t;
            AcsJCDBXMLErrorEx xmlErr = new AcsJCDBXMLErrorEx(t);
            xmlErr.setErrorString(info);
            this.m_logger.log((Level)AcsLogLevel.NOTICE, info);
            throw xmlErr.toCDBXMLErrorEx();
        }
    }

    public void shutdown() {
        this.totalDALInvocationCounter.incrementAndGet();
        this.shutdownEmbeddedDALImpl();
        ClientLogManager.getAcsLogManager().shutdown(true);
        this.orb.shutdown(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownEmbeddedDALImpl() {
        java.lang.Object object = this.shutdownLock;
        synchronized (object) {
            this.shutdown = true;
            this.shutdownLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void object_changed(String curl) {
        HashMap<String, DAO> hashMap = this.daoMap;
        synchronized (hashMap) {
            if (this.daoMap.containsKey(curl)) {
                DAO dao = this.daoMap.get(curl);
                dao.destroy();
                this.daoMap.remove(curl);
            }
        }
    }

    protected File getStorageFile() {
        if (this.listenersStorageFile != null) {
            return this.listenersStorageFile;
        }
        String filePath = FileHelper.getTempFileName((String)"ACS_RECOVERY_FILE", (String)"CDB_Recovery.txt");
        this.m_logger.log((Level)AcsLogLevel.INFO, "Recovery file: " + filePath);
        this.listenersStorageFile = new File(filePath);
        if (!this.listenersStorageFile.exists()) {
            try {
                this.listenersStorageFile.createNewFile();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        FileHelper.setFileAttributes((String)"g+w", (String)filePath);
        return this.listenersStorageFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadListeners() {
        if (this.disableRecoveryFile) {
            return;
        }
        File storageFile = this.getStorageFile();
        if (storageFile == null || !storageFile.exists()) {
            return;
        }
        BufferedReader reader = null;
        try {
            FileInputStream in = new FileInputStream(storageFile);
            reader = new BufferedReader(new InputStreamReader(in));
            HashMap<String, ArrayList<Integer>> hashMap = this.listenedCurls;
            synchronized (hashMap) {
                String curl;
                String line;
                while ((line = reader.readLine()) != null && line.length() != 0) {
                    Integer id = new Integer(line);
                    line = reader.readLine();
                    if (line == null || line.length() == 0) break;
                    DALChangeListener listener = DALChangeListenerHelper.narrow((Object)this.orb.string_to_object(line));
                    this.regListeners.put(id, listener);
                }
                while ((curl = reader.readLine()) != null) {
                    ArrayList<Integer> arr = new ArrayList<Integer>();
                    while ((line = reader.readLine()) != null && line.length() != 0) {
                        arr.add(new Integer(line));
                    }
                    this.listenedCurls.put(curl, arr);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveListeners() {
        if (this.disableRecoveryFile) {
            return false;
        }
        File storageFile = this.getStorageFile();
        if (storageFile == null) {
            return false;
        }
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(storageFile);
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out));
            for (Integer id : this.regListeners.keySet()) {
                writer.write(id.toString());
                writer.newLine();
                String ior = this.orb.object_to_string((Object)this.regListeners.get(id));
                writer.write(ior);
                writer.newLine();
            }
            for (String key : this.listenedCurls.keySet()) {
                ArrayList<Integer> arr = this.listenedCurls.get(key);
                if (arr.size() == 0) continue;
                writer.newLine();
                writer.write(key);
                writer.newLine();
                for (int i = 0; i < arr.size(); ++i) {
                    writer.write(arr.get(i).toString());
                    writer.newLine();
                }
            }
            writer.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            if (out != null) {
                try {
                    ((OutputStream)out).close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int add_change_listener(DALChangeListener listener) {
        this.totalDALInvocationCounter.incrementAndGet();
        HashMap<String, ArrayList<Integer>> hashMap = this.listenedCurls;
        synchronized (hashMap) {
            int id;
            Integer key;
            while (this.regListeners.containsKey(key = new Integer(id = this.idPool.nextInt(Integer.MAX_VALUE)))) {
            }
            this.regListeners.put(key, listener);
            return id;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void listen_for_changes(String curl, int listenerID) {
        this.totalDALInvocationCounter.incrementAndGet();
        HashMap<String, ArrayList<Integer>> hashMap = this.listenedCurls;
        synchronized (hashMap) {
            ArrayList<Integer> listeners = this.listenedCurls.get(curl);
            if (listeners == null) {
                listeners = new ArrayList();
                this.listenedCurls.put(curl, listeners);
            }
            listeners.add(new Integer(listenerID));
            this.saveListeners();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove_change_listener(int listenerID) {
        this.totalDALInvocationCounter.incrementAndGet();
        HashMap<String, ArrayList<Integer>> hashMap = this.listenedCurls;
        synchronized (hashMap) {
            for (String curl : this.listenedCurls.keySet()) {
                ArrayList<Integer> listeners = this.listenedCurls.get(curl);
                if (listeners == null) continue;
                for (int i = 0; i < listeners.size(); ++i) {
                    Integer id = listeners.get(i);
                    if (id != listenerID) continue;
                    listeners.remove(i);
                    --i;
                }
            }
            this.regListeners.remove(new Integer(listenerID));
            this.saveListeners();
        }
    }

    protected void cleanListenedCurls() {
        for (String curl : this.listenedCurls.keySet()) {
            ArrayList<Integer> listeners = this.listenedCurls.get(curl);
            if (listeners == null) continue;
            for (int i = 0; i < listeners.size(); ++i) {
                DALChangeListener listener = this.regListeners.get(listeners.get(i));
                if (listener != null) continue;
                listeners.remove(i);
                --i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear_cache(String curl) {
        ArrayList<Integer> listeners;
        this.totalDALInvocationCounter.incrementAndGet();
        this.object_changed(curl);
        boolean needToSave = false;
        HashMap<String, ArrayList<Integer>> hashMap = this.listenedCurls;
        synchronized (hashMap) {
            listeners = this.listenedCurls.get(curl);
        }
        if (listeners == null) {
            return;
        }
        ArrayList<Integer> invalidListeners = new ArrayList<Integer>();
        for (int i = 0; i < listeners.size(); ++i) {
            DALChangeListener listener;
            HashMap<String, ArrayList<Integer>> hashMap2 = this.listenedCurls;
            synchronized (hashMap2) {
                listener = this.regListeners.get(listeners.get(i));
            }
            try {
                listener.object_changed(curl);
                continue;
            }
            catch (RuntimeException e) {
                invalidListeners.add(listeners.get(i));
            }
        }
        HashMap<String, ArrayList<Integer>> hashMap3 = this.listenedCurls;
        synchronized (hashMap3) {
            for (int i = 0; i < invalidListeners.size(); ++i) {
                listeners.remove(invalidListeners.get(i));
                this.regListeners.remove(invalidListeners.get(i));
                needToSave = true;
            }
            if (needToSave) {
                this.cleanListenedCurls();
                this.saveListeners();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear_cache_all() {
        java.lang.Object[] curls;
        this.totalDALInvocationCounter.incrementAndGet();
        this.loadFactory();
        DALImpl dALImpl = this;
        synchronized (dALImpl) {
            this.rootNode = DALNode.getRoot(this.m_root);
        }
        this.clearCache();
        HashMap<String, ArrayList<Integer>> hashMap = this.listenedCurls;
        synchronized (hashMap) {
            curls = this.listenedCurls.keySet().toArray();
        }
        for (int i = 0; i < curls.length; ++i) {
            this.clear_cache((String)curls[i]);
        }
    }

    private static String removeXMLs(String list) {
        String XML_ENDING = ".xml";
        int pos = ((String)list).indexOf(".xml");
        while (pos > 0) {
            String after = ((String)list).substring(pos + ".xml".length());
            String before = ((String)list).substring(0, pos);
            int beforePos = before.lastIndexOf(32);
            before = beforePos == -1 ? "" : before.substring(0, beforePos);
            list = before + after;
            pos = ((String)list).indexOf(".xml");
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String list_nodes(String name) {
        this.totalDALInvocationCounter.incrementAndGet();
        DALImpl dALImpl = this;
        synchronized (dALImpl) {
            if (this.rootNode == null || name.length() == 0) {
                this.rootNode = DALNode.getRoot(this.m_root);
            }
        }
        String list = this.rootNode.list(name);
        return DALImpl.removeXMLs(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String list_daos(String name) {
        this.totalDALInvocationCounter.incrementAndGet();
        DALImpl dALImpl = this;
        synchronized (dALImpl) {
            if (this.rootNode == null || name.length() == 0) {
                this.rootNode = DALNode.getRoot(this.m_root);
            }
        }
        String list = this.rootNode.list(name);
        String XML_ENDING = ".xml";
        int pos = list.indexOf(".xml");
        if (pos > 0) {
            list = DALImpl.removeXMLs(list);
            String curl = name;
            if (curl.length() > 1 && curl.charAt(0) == '/') {
                curl = curl.substring(1);
            }
            XMLHandler xmlSolver = null;
            try {
                xmlSolver = this.loadRecord(curl, false);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            StringBuffer internalNodes = null;
            if (xmlSolver != null) {
                internalNodes = new StringBuffer();
                Iterator<String> iter = xmlSolver.m_rootNode.getNodesMap().keySet().iterator();
                while (iter.hasNext()) {
                    internalNodes.append(iter.next().toString());
                    internalNodes.append(' ');
                }
            }
            if (internalNodes != null && internalNodes.length() > 0) {
                return internalNodes.toString();
            }
            return " ";
        }
        return "";
    }

    public String configuration_name() {
        this.totalDALInvocationCounter.incrementAndGet();
        return "XML";
    }

    public SAXParser getSaxParser() {
        return this.saxParser;
    }

    public boolean isShutdown() {
        return this.shutdown;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logRecordNotExistWithRepeatGuard(String curl) {
        MultipleRepeatGuard multipleRepeatGuard = this.recordNotExistLogRepeatGuard;
        synchronized (multipleRepeatGuard) {
            if (this.recordNotExistLogRepeatGuard.checkAndIncrement(curl)) {
                int repeatCount = this.recordNotExistLogRepeatGuard.counterAtLastExecution(curl);
                String msg = "Curl '" + curl + "' does not exist.";
                if (repeatCount > 1) {
                    msg = msg + " (" + repeatCount + " identical logs reduced to this log)";
                }
                this.m_logger.log((Level)AcsLogLevel.NOTICE, msg);
            }
        }
    }

    public LogLevels get_default_logLevels() {
        LogLevels logLevels = new LogLevels();
        logLevels.useDefault = false;
        logLevels.minLogLevel = (short)this.logConfig.getDefaultMinLogLevel().value;
        logLevels.minLogLevelLocal = (short)this.logConfig.getDefaultMinLogLevelLocal().value;
        return logLevels;
    }

    public void set_default_logLevels(LogLevels levels) throws IllegalLogLevelsEx {
        try {
            this.logConfig.setDefaultMinLogLevel(AcsLogLevelDefinition.fromInteger((int)levels.minLogLevel));
            this.logConfig.setDefaultMinLogLevelLocal(AcsLogLevelDefinition.fromInteger((int)levels.minLogLevelLocal));
        }
        catch (AcsJIllegalArgumentEx ex) {
            IllegalLogLevelsEx ille = new IllegalLogLevelsEx(ex.getErrorDesc());
            throw ille;
        }
    }

    public String[] get_logger_names() {
        Set loggerNames = this.logConfig.getLoggerNames();
        return loggerNames.toArray(new String[loggerNames.size()]);
    }

    public LogLevels get_logLevels(String logger_name) throws LoggerDoesNotExistEx {
        LogConfig.LockableUnnamedLogger xsdLevels = this.logConfig.getNamedLoggerConfig(logger_name);
        boolean useDefault = !this.logConfig.hasCustomConfig(logger_name);
        LogLevels ret = AcsLogLevelDefinition.createIdlLogLevelsFromXsd((boolean)useDefault, (UnnamedLogger)xsdLevels);
        return ret;
    }

    public void set_logLevels(String logger_name, LogLevels levels) throws LoggerDoesNotExistEx, IllegalLogLevelsEx {
        if (levels.useDefault) {
            this.logConfig.clearNamedLoggerConfig(logger_name);
        } else {
            try {
                UnnamedLogger config = AcsLogLevelDefinition.createXsdLogLevelsFromIdl((LogLevels)levels);
                this.logConfig.setNamedLoggerConfig(logger_name, config);
            }
            catch (AcsJIllegalArgumentEx ex) {
                IllegalLogLevelsEx ille = new IllegalLogLevelsEx(ex.getErrorDesc());
                throw ille;
            }
        }
    }

    public void refresh_logging_config() {
        try {
            this.logConfig.initialize(true);
        }
        catch (LogConfigException ex) {
            this.m_logger.log(Level.FINE, "Failed to configure logging (default values will be used).", ex);
        }
    }

    public static class Filter
    implements FilenameFilter {
        @Override
        public boolean accept(File arg0, String arg1) {
            return arg1.endsWith(".xsd");
        }
    }
}

