/*
 * Decompiled with CFR 0.152.
 */
package skyview.geometry.sampler;

import skyview.executive.Settings;
import skyview.geometry.Projecter;
import skyview.geometry.Sampler;
import skyview.geometry.Scaler;
import skyview.geometry.TransformationException;
import skyview.survey.Image;

public class Clip
extends Sampler {
    protected int recurse = 0;
    double[] depthArray;
    protected double drizzOffset = 0.0;
    protected double drizzArea = 1.0;
    private double tArea;
    private boolean intensive = false;
    private Projecter inProj;
    private Scaler inImgScaler;
    private Scaler inImgScalerInv;
    private double tileX;
    private double tileY;
    private boolean pixelCheck = false;
    private boolean straddleCheck = false;
    private double[] rcX0 = new double[100];
    private double[] rcX1 = new double[100];
    private double[] rcY0 = new double[100];
    private double[] rcY1 = new double[100];
    private double[] rctx = new double[100];
    private double[] rcty = new double[100];
    private double[] psX1 = new double[12];
    private double[] psY1 = new double[12];
    private int lastNVert;
    private double[][] corners = new double[2][4];
    private double[][] xcorners = new double[3][4];

    @Override
    public void setOutput(Image outImage) {
        super.setOutput(outImage);
        this.depthArray = new double[outImage.getDepth()];
    }

    @Override
    public String getName() {
        return "Clip";
    }

    @Override
    public String getDescription() {
        return "Sample by using output pixels as clipping rectangles on input image";
    }

    public void setIntensive(boolean intensive) {
        this.intensive = intensive;
    }

    @Override
    public void setInput(Image in) {
        super.setInput(in);
        try {
            this.inProj = this.inImage.getWCS().getProjection().getProjecter();
            this.pixelCheck = !this.inProj.allValid();
            this.straddleCheck = this.inProj.straddleable();
            this.inImgScaler = this.inImage.getWCS().getScaler();
            this.inImgScalerInv = this.inImgScaler.inverse();
        }
        catch (TransformationException e) {
            System.err.println("Warning: Unable to extract info needed for pixel wrapping checks.  Checks turned off.");
            this.pixelCheck = false;
            this.straddleCheck = false;
        }
    }

    public void setDrizzle(double drizzle) {
        if (drizzle < 0.0) {
            drizzle = 0.0;
        }
        if (drizzle > 1.0) {
            drizzle = 1.0;
        }
        this.drizzArea = drizzle * drizzle;
        this.drizzOffset = (1.0 - drizzle) / 2.0;
    }

    public Clip() {
        if (Settings.has("ClipIntensive")) {
            this.setIntensive(true);
        }
        if (Settings.has("ClipDrizzle")) {
            double driz = Double.parseDouble(Settings.get("ClipDrizzle"));
            if (driz >= 0.0 && driz <= 1.0) {
                this.setDrizzle(driz);
            } else {
                System.err.println("Invalid drizzle value " + driz + " ignored.");
            }
        }
    }

    public static double convexArea(int n, double[] x, double[] y) {
        double area = 0.0;
        for (int i = 1; i < n - 1; ++i) {
            area += Clip.triangleArea(x[0], y[0], x[i], y[i], x[i + 1], y[i + 1]);
        }
        return area;
    }

    private static double triangleArea(double x0, double y0, double x1, double y1, double x2, double y2) {
        double a = x0 - x1;
        double b = y0 - y1;
        double e = x0 - x2;
        double f = y0 - y2;
        double area = (a * a + b * b) * (e * e + f * f) - (a * e + b * f) * (a * e + b * f);
        if (area <= 0.0) {
            return 0.0;
        }
        return Math.sqrt(area) / 2.0;
    }

    private static int lineClip(int n, double[] x, double[] y, double[] nx, double[] ny, double val, boolean dir) {
        int nout = 0;
        boolean last = Clip.inPlane(x[n - 1], val, dir);
        for (int i = 0; i < n; ++i) {
            double ycross;
            if (last) {
                if (Clip.inPlane(x[i], val, dir)) {
                    nx[nout] = x[i];
                    ny[nout] = y[i];
                    ++nout;
                    continue;
                }
                ycross = i == 0 ? y[n - 1] + (y[0] - y[n - 1]) * (val - x[n - 1]) / (x[0] - x[n - 1]) : y[i - 1] + (y[i] - y[i - 1]) * (val - x[i - 1]) / (x[i] - x[i - 1]);
                nx[nout] = val;
                ny[nout] = ycross;
                ++nout;
                last = false;
                continue;
            }
            if (!Clip.inPlane(x[i], val, dir)) continue;
            ycross = i == 0 ? y[n - 1] + (y[0] - y[n - 1]) * (val - x[n - 1]) / (x[i] - x[n - 1]) : y[i - 1] + (y[i] - y[i - 1]) * (val - x[i - 1]) / (x[i] - x[i - 1]);
            nx[nout] = val;
            ny[nout] = ycross;
            nx[++nout] = x[i];
            ny[nout] = y[i];
            ++nout;
            last = true;
        }
        return nout;
    }

    private static boolean inPlane(double test, double divider, boolean direction) {
        if (direction) {
            return test >= divider;
        }
        return test <= divider;
    }

    public int rectClip(int n, double[] x, double[] y, double[] nx, double[] ny, double minX, double minY, double maxX, double maxY) {
        int nCurr = Clip.lineClip(n, x, y, this.rcX0, this.rcY0, minX, true);
        if (nCurr > 0 && (nCurr = Clip.lineClip(nCurr, this.rcX0, this.rcY0, this.rcX1, this.rcY1, maxX, false)) > 0 && (nCurr = Clip.lineClip(nCurr, this.rcY1, this.rcX1, this.rcY0, this.rcX0, minY, true)) > 0) {
            nCurr = Clip.lineClip(nCurr, this.rcY0, this.rcX0, ny, nx, maxY, false);
        }
        return nCurr;
    }

    protected static void printVert(int n, double[] x, double[] y, String label) {
        for (int i = 0; i < n; ++i) {
            System.out.println(label + "   " + x[i] + "  " + y[i]);
        }
    }

    @Override
    public void sample(int pix) {
        double[][] in = this.outImage.getCorners(pix);
        try {
            this.trans.transform(in, this.corners);
        }
        catch (TransformationException e) {
            System.err.println("Error in transformation:" + e);
            return;
        }
        this.samplePixel(pix, this.corners[0], this.corners[1]);
    }

    public double weight() {
        return this.tArea;
    }

    public void samplePixel(int pix, double[] x, double[] y) {
        int z;
        this.recurse = 0;
        for (z = 0; z < this.depthArray.length; ++z) {
            this.depthArray[z] = 0.0;
        }
        this.tArea = 0.0;
        this.accumulate(pix, x, y);
        if (this.intensive && this.tArea > 0.0) {
            z = 0;
            while (z < this.inDepth) {
                int n = z++;
                this.depthArray[n] = this.depthArray[n] / this.tArea;
            }
        }
        for (z = 0; z < this.depthArray.length; ++z) {
            this.outImage.setData(pix + z * this.outWidth * this.outHeight, this.depthArray[z]);
        }
    }

    private void accumulate(int pix, double[] x, double[] y) {
        double minY;
        double minX;
        if (this.straddleCheck) {
            double[][] z = new double[2][x.length];
            try {
                this.inImgScalerInv.transform(new double[][]{x, y}, z);
                int valid = 0;
                for (int i = 0; i < x.length; ++i) {
                    if (!this.inProj.validPosition(new double[]{z[0][i], z[1][i]})) continue;
                    ++valid;
                }
                if (valid == 0) {
                    return;
                }
                if (this.inProj.straddle(z)) {
                    double[][][] fields = this.inProj.straddleComponents(z);
                    for (int i = 0; i < fields.length; ++i) {
                        this.inImgScaler.transform(fields[i], fields[i]);
                        this.accumulate(pix, fields[i][0], fields[i][1]);
                    }
                    return;
                }
            }
            catch (TransformationException e) {
                System.err.println("Unexpected transformation exception in straddle check:" + e);
            }
        }
        double maxX = minX = x[0];
        double maxY = minY = y[0];
        double sum = minX + minY;
        for (int k = 1; k < x.length; ++k) {
            if (x[k] < minX) {
                minX = x[k];
            } else if (x[k] > maxX) {
                maxX = x[k];
            }
            if (y[k] < minY) {
                minY = y[k];
            } else if (y[k] > maxY) {
                maxY = y[k];
            }
            sum += x[k] + y[k];
        }
        if (sum != sum) {
            return;
        }
        minX = Math.floor(minX);
        maxX = Math.ceil(maxX);
        minY = Math.floor(minY);
        maxY = Math.ceil(maxY);
        if (maxX <= 0.0 || minX >= (double)this.inWidth || maxY <= 0.0 || minY >= (double)this.inHeight) {
            return;
        }
        double pArea = Clip.convexArea(x.length, x, y);
        if (minX == maxX - 1.0 && minY == maxY - 1.0) {
            int ix = (int)minX;
            int iy = (int)minY;
            if (!this.pixelCheck || this.checkPixel(ix, iy)) {
                this.tArea += pArea;
                int z = 0;
                while (z < this.inDepth) {
                    double ival = pArea * this.inImage.getData(ix + iy * this.inWidth + z * this.inWidth * this.inHeight);
                    int n = z++;
                    this.depthArray[n] = this.depthArray[n] + ival;
                }
            }
            return;
        }
        if (maxX >= (double)this.inWidth) {
            maxX = this.inWidth;
        }
        if (minX < 0.0) {
            minX = 0.0;
        }
        if (maxY >= (double)this.inHeight) {
            maxY = this.inHeight;
        }
        if (minY < 0.0) {
            minY = 0.0;
        }
        double value = 0.0;
        for (int n = (int)minY; n < (int)maxY; ++n) {
            double vminY = (double)n + this.drizzOffset;
            double vmaxY = (double)(n + 1) - this.drizzOffset;
            for (int m = (int)minX; m < (int)maxX; ++m) {
                double factor;
                double vmaxX;
                double vminX;
                int nv;
                if (this.pixelCheck && !this.checkPixel(m, n) || (nv = this.rectClip(x.length, x, y, this.psX1, this.psY1, vminX = (double)m + this.drizzOffset, vminY, vmaxX = (double)(m + 1) - this.drizzOffset, vmaxY)) <= 0) continue;
                if (this.drizzArea > 0.0) {
                    double area = Clip.convexArea(nv, this.psX1, this.psY1);
                    factor = area / this.drizzArea;
                } else {
                    factor = 1.0;
                }
                this.tArea += factor;
                int z = 0;
                while (z < this.inDepth) {
                    double ival = factor * this.inImage.getData(m + n * this.inWidth + z * this.inWidth * this.inHeight);
                    int n2 = z++;
                    this.depthArray[n2] = this.depthArray[n2] + ival;
                }
            }
        }
    }

    private boolean checkPixel(int x, int y) {
        double[][] p = new double[][]{{x, x + 1, x, x + 1}, {y, y + 1, y + 1, y}};
        double[][] q = new double[2][4];
        if (this.inImgScalerInv == null) {
            return true;
        }
        try {
            this.inImgScalerInv.transform(p, q);
        }
        catch (TransformationException e) {
            System.err.println("Unexpected transformation error");
            return true;
        }
        for (int i = 0; i < q[0].length; ++i) {
            double[] pnt = new double[]{q[0][i], q[1][i]};
            if (this.inProj.validPosition(pnt)) continue;
            return false;
        }
        return true;
    }

    public double clipRectPoly(double xmin, double ymin, double xmax, double ymax, double[] polyx, double[] polyy) {
        this.lastNVert = this.rectClip(polyx.length, polyx, polyy, this.psX1, this.psY1, xmin, ymin, xmax, ymax);
        if (this.lastNVert > 0) {
            return Clip.convexArea(this.lastNVert, this.psX1, this.psY1);
        }
        return 0.0;
    }

    public double[] lastX() {
        double[] val = new double[this.lastNVert];
        System.arraycopy(this.psX1, 0, val, 0, this.lastNVert);
        return val;
    }

    public double[] lastY() {
        double[] val = new double[this.lastNVert];
        System.arraycopy(this.psY1, 0, val, 0, this.lastNVert);
        return val;
    }
}

