/*
 * Decompiled with CFR 0.152.
 */
package alma.common.sensitivitycalculatorcore.lookup;

import alma.common.sensitivitycalculatorcore.utils.CSVReader;
import alma.common.sensitivitycalculatorcore.utils.FindResourceUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;

public class AtmosphereTable {
    private static File configPath;
    private static final String[] atmospheresFileName;
    public static final String[] WV_MAP;
    public static final double[] WV_MAP_VALUES;
    public static final int NUM_WV_POINTS = 7;
    private static Data[][] atmospheres;
    private static float[][] frequencies;
    private static float[] fstart;
    private static float[] fend;
    private static float[] deltaf;
    private static AtmosphereTable INSTANCE;

    public static AtmosphereTable getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new AtmosphereTable();
        }
        return INSTANCE;
    }

    public static void setConfigPath(File configPath) {
        AtmosphereTable.configPath = configPath;
    }

    private AtmosphereTable() {
        if (configPath == null) {
            configPath = new File(System.getProperty("otData.dir"));
        }
        try {
            this.fillAtmTable();
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            System.out.println("Can't fill atmospheric data table!");
            e.printStackTrace();
        }
    }

    public synchronized Data lookup(double frequency, int wvindex) {
        Data result = null;
        Data[] m_data = atmospheres[wvindex];
        if (frequency >= (double)fstart[wvindex] && frequency <= (double)fend[wvindex]) {
            int index = AtmosphereTable.getIndex(frequency, wvindex);
            if (index == 0 || index == frequencies[wvindex].length) {
                return null;
            }
            double lfreq = frequencies[wvindex][index - 1];
            double ufreq = frequencies[wvindex][index];
            double tau = m_data[index - 1].m_tau + (m_data[index].m_tau - m_data[index - 1].m_tau) * (frequency - lfreq) / (ufreq - lfreq);
            double tatm = m_data[index - 1].m_tsky + (m_data[index].m_tsky - m_data[index - 1].m_tsky) * (frequency - lfreq) / (ufreq - lfreq);
            return new Data(tau, tatm);
        }
        return result;
    }

    private static synchronized int getIndex(double frequency, int wvindex) {
        int index = (int)((frequency - (double)fstart[wvindex]) / (double)deltaf[wvindex]);
        while ((double)frequencies[wvindex][index] > frequency) {
            --index;
        }
        while (index < frequencies[wvindex].length && frequency > (double)frequencies[wvindex][index]) {
            ++index;
        }
        return index;
    }

    public DataTable lookup(double minF, double maxF, int wvindex) {
        double findex;
        Vector<Data> collect = new Vector<Data>();
        Data[] m_data = atmospheres[wvindex];
        int lindex = 0;
        int uindex = m_data.length - 1;
        if (minF >= (double)fstart[wvindex] && minF <= (double)fend[wvindex]) {
            findex = (minF - (double)fstart[wvindex]) / (double)deltaf[wvindex];
            lindex = (int)Math.floor(findex);
        }
        if (maxF >= (double)fstart[wvindex] && maxF <= (double)fend[wvindex]) {
            findex = (maxF - (double)fstart[wvindex]) / (double)deltaf[wvindex];
            uindex = (int)Math.ceil(findex);
        }
        for (int i = lindex; i <= uindex; ++i) {
            collect.add(m_data[i]);
        }
        minF = fstart[wvindex] + (float)lindex * deltaf[wvindex];
        maxF = fstart[wvindex] + (float)uindex * deltaf[wvindex];
        return new DataTable(minF, maxF, deltaf[wvindex], collect);
    }

    private void fillAtmTable() throws NumberFormatException, IOException {
        for (int wvindex = 0; wvindex < 7; ++wvindex) {
            String[] nextLine;
            URL config = FindResourceUtils.findResource(configPath, atmospheresFileName[wvindex]);
            if (config == null) {
                throw new IOException(configPath + " was not found.");
            }
            BufferedReader in = new BufferedReader(new InputStreamReader(config.openStream()));
            ArrayList<Data> alData = new ArrayList<Data>();
            ArrayList<Float> alFreq = new ArrayList<Float>();
            int i = 0;
            CSVReader reader = new CSVReader(in, ' ', '\'');
            while ((nextLine = reader.readNext()) != null) {
                float freq = Float.parseFloat(nextLine[0]);
                if (i == 0) {
                    AtmosphereTable.fstart[wvindex] = freq;
                }
                if (i == 1) {
                    AtmosphereTable.deltaf[wvindex] = freq - fstart[wvindex];
                }
                AtmosphereTable.fend[wvindex] = freq;
                float tau = Float.parseFloat(nextLine[1]);
                float tatm = Float.parseFloat(nextLine[2]);
                alData.add(new Data(tau, tatm));
                alFreq.add(new Float(freq));
                ++i;
            }
            reader.close();
            in.close();
            AtmosphereTable.atmospheres[wvindex] = alData.toArray(new Data[alData.size()]);
            Iterator it = alFreq.iterator();
            float[] array = new float[alFreq.size()];
            int j = 0;
            while (it.hasNext()) {
                array[j] = ((Float)it.next()).floatValue();
                ++j;
            }
            AtmosphereTable.frequencies[wvindex] = array;
        }
    }

    public static void main(String[] args) throws NumberFormatException, IOException {
        System.setProperty("otData.dir", "config/otData/");
        AtmosphereTable atbl = AtmosphereTable.getInstance();
        atbl.fillAtmTable();
    }

    static {
        atmospheresFileName = new String[]{"SKY.SPE0001.trim", "SKY.SPE0002.trim", "SKY.SPE0003.trim", "SKY.SPE0004.trim", "SKY.SPE0005.trim", "SKY.SPE0006.trim", "SKY.SPE0007.trim"};
        WV_MAP = new String[]{"0.472mm (1st Octile)", "0.658mm (2nd Octile)", "0.913mm (3rd Octile)", "1.262mm (4th Octile)", "1.796mm (5th Octile)", "2.748mm (6th Octile)", "5.186mm (7th Octile)"};
        WV_MAP_VALUES = new double[]{0.472, 0.658, 0.913, 1.262, 1.796, 2.748, 5.186};
        atmospheres = new Data[7][];
        frequencies = new float[7][];
        fstart = new float[7];
        fend = new float[7];
        deltaf = new float[7];
        INSTANCE = null;
    }

    public static class DataTable {
        private Data[] data;
        private double minF;
        private double maxF;
        private double deltaF;

        private DataTable(double min, double max, double delta, Vector<Data> collect) {
            this.minF = min;
            this.maxF = max;
            this.deltaF = delta;
            this.data = collect.toArray(new Data[collect.size()]);
        }

        public Data getData(int index) {
            return this.data[index];
        }

        public double getTau(int index) {
            return this.getData((int)index).m_tau;
        }

        public double getTatm(int index) {
            return this.getData((int)index).m_tsky;
        }

        public double getF(int index) {
            return this.getMinF() + (double)(index - 1) * this.getDeltaF();
        }

        public double getDeltaF() {
            return this.deltaF;
        }

        public double getMaxF() {
            return this.maxF;
        }

        public double getMinF() {
            return this.minF;
        }

        public int size() {
            return this.data.length;
        }
    }

    public static class Data {
        private double m_tau;
        private double m_tsky;

        private Data(double tau, double tatm) {
            this.m_tau = tau;
            this.m_tsky = tatm;
        }

        public double getTau() {
            return this.m_tau;
        }

        public double getTsky() {
            return this.m_tsky;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("tau=");
            sb.append(String.format("%.3f", this.m_tau));
            sb.append(", Tsky=");
            sb.append(String.format("%.3f", this.m_tsky));
            sb.append(" K");
            return sb.toString();
        }
    }
}

