/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.storage;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.RandomRowSequence;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.RowStore;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.TableFormatException;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.WrapperStarTable;
import uk.ac.starlink.table.storage.Codec;
import uk.ac.starlink.table.storage.ColumnWidth;
import uk.ac.starlink.table.storage.NioDataAccess;
import uk.ac.starlink.table.storage.Offsets;
import uk.ac.starlink.table.storage.SeekableDataInput;

public class DiskRowStore
implements RowStore {
    private final File file_;
    private StarTable template_;
    private Codec[] codecs_;
    private List[] colSizeLists_;
    private DataOutputStream out_;
    private long nrow_;
    private int ncol_;
    private Offsets offsets_;
    private StarTable storedTable_;
    private static Logger logger_ = Logger.getLogger("uk.ac.starlink.table.storage");

    public DiskRowStore(File file) throws IOException {
        this.file_ = file;
        this.out_ = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
    }

    public DiskRowStore() throws IOException {
        this(File.createTempFile("DiskRowStore", ".bin"));
        this.file_.deleteOnExit();
    }

    public void acceptMetadata(StarTable meta) throws TableFormatException {
        if (this.template_ != null) {
            throw new IllegalStateException("Metadata already submitted");
        }
        logger_.info("Storing table data in " + this.file_);
        this.template_ = meta;
        this.ncol_ = meta.getColumnCount();
        this.codecs_ = new Codec[this.ncol_];
        this.colSizeLists_ = new List[this.ncol_];
        for (int icol = 0; icol < this.ncol_; ++icol) {
            ColumnInfo cinfo = meta.getColumnInfo(icol);
            Codec codec = Codec.getCodec(cinfo);
            if (codec == null) {
                throw new TableFormatException("No codec available for " + cinfo);
            }
            this.codecs_[icol] = codec;
            if (codec.getItemSize() >= 0) continue;
            this.colSizeLists_[icol] = new ArrayList();
        }
    }

    public void acceptRow(Object[] row) throws IOException {
        if (this.template_ == null) {
            throw new IllegalStateException("acceptMetadata not called");
        }
        if (this.storedTable_ != null) {
            throw new IllegalStateException("endRows already called");
        }
        for (int icol = 0; icol < this.ncol_; ++icol) {
            int nbyte = this.codecs_[icol].encode(row[icol], this.out_);
            if (this.colSizeLists_[icol] == null) continue;
            this.colSizeLists_[icol].add(new Integer(nbyte));
        }
        ++this.nrow_;
    }

    public void endRows() throws IOException {
        if (this.template_ == null) {
            throw new IllegalStateException("acceptMetadata not called");
        }
        if (this.storedTable_ != null) {
            throw new IllegalStateException("endRows already called");
        }
        this.out_.close();
        ColumnWidth[] colWidths = new ColumnWidth[this.ncol_];
        boolean someVariable = false;
        for (int icol = 0; icol < this.ncol_; ++icol) {
            ColumnWidth cw;
            if (this.colSizeLists_[icol] == null) {
                cw = ColumnWidth.constantColumnWidth(this.codecs_[icol].getItemSize());
            } else {
                int[] widthArray = new int[Tables.checkedLongToInt(this.nrow_)];
                List widthList = this.colSizeLists_[icol];
                int irow = 0;
                while ((long)irow < this.nrow_) {
                    widthArray[irow] = (Integer)widthList.get(irow);
                    ++irow;
                }
                cw = ColumnWidth.variableColumnWidth(widthArray);
                this.colSizeLists_[icol] = null;
            }
            colWidths[icol] = cw;
        }
        this.colSizeLists_ = null;
        this.offsets_ = Offsets.getOffsets(colWidths, this.nrow_);
        logger_.info("Offset type is " + (this.offsets_.isFixed() ? "fixed" : "variable"));
        long fileSize = this.offsets_.getLength();
        FileInputStream istrm = new FileInputStream(this.file_);
        MappedByteBuffer bbuf = istrm.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, fileSize);
        istrm.close();
        logger_.info(this.nrow_ + " rows stored in " + fileSize + " bytes");
        NioDataAccess in = new NioDataAccess(bbuf);
        this.storedTable_ = new DiskStarTable(in);
    }

    public StarTable getStarTable() {
        if (this.storedTable_ == null) {
            throw new IllegalStateException("endRows not called");
        }
        return this.storedTable_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (this.file_.exists()) {
                if (this.file_.delete()) {
                    logger_.info("Deleting temporary file " + this.file_);
                } else {
                    logger_.warning("Failed to delete temporary file " + this.file_);
                }
            }
        }
        finally {
            super.finalize();
        }
    }

    Offsets getOffsets() {
        return this.offsets_;
    }

    private class DiskStarTable
    extends WrapperStarTable {
        final SeekableDataInput in_;

        DiskStarTable(SeekableDataInput in) {
            super(DiskRowStore.this.template_);
            this.in_ = in;
        }

        public boolean isRandom() {
            return true;
        }

        public long getRowCount() {
            return DiskRowStore.this.nrow_;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object[] getRow(long lrow) throws IOException {
            Object[] row = new Object[DiskRowStore.this.ncol_];
            SeekableDataInput seekableDataInput = this.in_;
            synchronized (seekableDataInput) {
                this.in_.seek(DiskRowStore.this.offsets_.getRowOffset(lrow));
                for (int icol = 0; icol < DiskRowStore.this.ncol_; ++icol) {
                    row[icol] = DiskRowStore.this.codecs_[icol].decode(this.in_);
                }
            }
            return row;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getCell(long lrow, int icol) throws IOException {
            Object cell;
            SeekableDataInput seekableDataInput = this.in_;
            synchronized (seekableDataInput) {
                this.in_.seek(DiskRowStore.this.offsets_.getCellOffset(lrow, icol));
                cell = DiskRowStore.this.codecs_[icol].decode(this.in_);
            }
            return cell;
        }

        public RowSequence getRowSequence() throws IOException {
            return new RandomRowSequence(this);
        }
    }
}

