/*
 * Decompiled with CFR 0.152.
 */
package jsky.image.operator;

import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderedImageFactory;
import javax.media.jai.JAI;
import javax.media.jai.OperationDescriptorImpl;
import javax.media.jai.OperationRegistry;
import javax.media.jai.ROI;
import javax.media.jai.registry.RIFRegistry;
import javax.media.jai.util.Range;
import jsky.image.operator.MinMaxOpImage;

public class MinMaxDescriptor
extends OperationDescriptorImpl
implements RenderedImageFactory {
    private static final String[][] resources = new String[][]{{"GlobalName", "minmax"}, {"LocalName", "minmax"}, {"Vendor", "jsky"}, {"Description", "Calculate image min and max values, ignoring the given blank or bad pixel value"}, {"DocURL", "http://archive.eso.org/jsky/jsky-doc/api/jsky/image/operator/MinMaxDescriptor.html"}, {"Version", "1.0"}, {"arg0Desc", "The region of the image to scan"}, {"arg1Desc", "The horizontal sampling rate, may not be less than 1."}, {"arg2Desc", "The vertical sampling rate, may not be less than 1."}, {"arg3Desc", "Ignore pixels with this value."}};
    private static final String[] supportedModes = new String[]{"rendered", "renderable"};
    private static final String[] paramNames = new String[]{"roi", "xPeriod", "yPeriod", "ignore"};
    private static final Class[] paramClasses = new Class[]{ROI.class, Integer.class, Integer.class, Double.class};
    private static final Object[] paramDefaults = new Object[]{null, 1, 1, null};
    private static final Object[] validParamValues = new Object[]{null, new Range(Integer.class, Integer.valueOf(1), null), new Range(Integer.class, Integer.valueOf(1), null), null};

    public MinMaxDescriptor() {
        super(resources, supportedModes, 1, paramNames, paramClasses, paramDefaults, validParamValues);
    }

    public static void register() {
        MinMaxDescriptor MinMaxDescriptor2 = new MinMaxDescriptor();
        String operationName = "minmax";
        String productName = "jsky";
        OperationRegistry or = JAI.getDefaultInstance().getOperationRegistry();
        or.registerDescriptor(MinMaxDescriptor2);
        RIFRegistry.register(or, operationName, productName, MinMaxDescriptor2);
    }

    @Override
    public RenderedImage create(ParameterBlock paramBlock, RenderingHints renderHints) {
        if (!this.validateParameters(paramBlock)) {
            return null;
        }
        return new MinMaxOpImage(paramBlock.getRenderedSource(0), (ROI)paramBlock.getObjectParameter(0), (Integer)paramBlock.getObjectParameter(1), (Integer)paramBlock.getObjectParameter(2), (Double)paramBlock.getObjectParameter(3));
    }

    public boolean validateParameters(ParameterBlock paramBlock) {
        int n = this.getParameterListDescriptor(this.getSupportedModes()[0]).getNumParameters();
        for (int i = 0; i < n; ++i) {
            Object arg = paramBlock.getObjectParameter(i);
            if (arg == null) {
                return false;
            }
            if (i == 0) {
                if (arg instanceof ROI) continue;
                return false;
            }
            if (i == 1 || i == 2) {
                if (!(arg instanceof Integer)) {
                    return false;
                }
                int val = (Integer)arg;
                if (val >= 1) continue;
                return false;
            }
            if (i != 3 || arg instanceof Double) continue;
            return false;
        }
        return true;
    }
}

