/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.nc.sm.generic;

import alma.ACSErrTypeCommon.wrappers.AcsJStateMachineActionEx;
import alma.acs.nc.sm.generic.AcsScxmlActionExecutor;
import alma.acs.nc.sm.generic.AcsScxmlDispatchingAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.scxml.ErrorReporter;
import org.apache.commons.scxml.EventDispatcher;
import org.apache.commons.scxml.SCInstance;
import org.apache.commons.scxml.SCXMLExpressionException;
import org.apache.commons.scxml.TriggerEvent;
import org.apache.commons.scxml.model.CustomAction;
import org.apache.commons.scxml.model.ModelException;

public class AcsScxmlActionDispatcher<A extends Enum<A>> {
    public static final String CUSTOM_ACTIONS_DOMAIN_NAME = "http://my.custom-actions.domain/CUSTOM";
    protected final Logger logger;
    private final Class<A> actionType;
    private final Map<A, AcsScxmlActionExecutor<A>> actionMap;
    private volatile ActionExceptionHandler actionExceptionHandler;

    public AcsScxmlActionDispatcher(Logger logger, Class<A> actionType) {
        this.logger = logger;
        this.actionType = actionType;
        this.actionMap = new EnumMap<A, AcsScxmlActionExecutor<A>>(actionType);
    }

    public void execute(A action, EventDispatcher evtDispatcher, ErrorReporter errRep, SCInstance scInstance, Collection<TriggerEvent> derivedEvents) throws ModelException, SCXMLExpressionException {
        AcsScxmlActionExecutor<A> handler = this.getActionHandler(action);
        if (handler != null) {
            boolean handledAction = false;
            try {
                handledAction = handler.execute(action, evtDispatcher, errRep, scInstance, derivedEvents);
            }
            catch (AcsJStateMachineActionEx ex) {
                handledAction = true;
                if (this.actionExceptionHandler != null) {
                    this.actionExceptionHandler.setActionException(ex);
                }
                this.logger.log(Level.WARNING, "Handler " + handler.getClass() + " failed to execute action " + ((Enum)action).name(), ex);
            }
            if (!handledAction) {
                errRep.onError("UNKNOWN_ACTION", "Handler " + handler.getClass() + " handler unexpectedly did not handle action ", action);
            }
        } else {
            errRep.onError("UNKNOWN_ACTION", "No handler registered for action " + ((Enum)action).name(), null);
        }
    }

    public AcsScxmlActionExecutor<A> getActionHandler(A action) {
        return this.actionMap.get(action);
    }

    public void registerActionHandler(A action, AcsScxmlActionExecutor<A> handler) {
        this.actionMap.put(action, handler);
    }

    public boolean isActionMappingComplete() {
        for (Enum action : (Enum[])this.actionType.getEnumConstants()) {
            if (this.actionMap.containsKey(action)) continue;
            this.logger.warning("No handler has been registered for SM action " + action.name() + ".");
            return false;
        }
        return true;
    }

    public Class<A> getActionType() {
        return this.actionType;
    }

    protected List<CustomAction> getScxmlActionMap() {
        ArrayList<CustomAction> ret = new ArrayList<CustomAction>();
        for (Enum action : this.actionMap.keySet()) {
            ret.add(new CustomAction(CUSTOM_ACTIONS_DOMAIN_NAME, action.name(), AcsScxmlDispatchingAction.class));
        }
        return ret;
    }

    public void setActionExceptionHandler(ActionExceptionHandler handler) {
        this.actionExceptionHandler = handler;
    }

    public static interface ActionExceptionHandler {
        public void setActionException(AcsJStateMachineActionEx var1);
    }
}

