/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot;

import java.util.ArrayList;
import uk.ac.starlink.ttools.plot.PlotData;
import uk.ac.starlink.ttools.plot.PointData;
import uk.ac.starlink.ttools.plot.PointSequence;
import uk.ac.starlink.ttools.plot.Style;

public class ArrayPlotData
implements PlotData {
    private final int nset_;
    private final String[] setNames_;
    private final Style[] setStyles_;
    private final int ndim_;
    private final int nerror_;
    private final boolean hasLabels_;
    private PointData[] points_;

    public ArrayPlotData(int nset, String[] setNames, Style[] setStyles, int ndim, int nerror, boolean hasLabels, PointData[] points) {
        this.nset_ = nset;
        this.setNames_ = setNames;
        this.setStyles_ = setStyles;
        this.ndim_ = ndim;
        this.nerror_ = nerror;
        this.hasLabels_ = hasLabels;
        this.setPoints(points);
    }

    public int getSetCount() {
        return this.nset_;
    }

    public String getSetName(int iset) {
        return this.setNames_[iset];
    }

    public Style getSetStyle(int iset) {
        return this.setStyles_[iset];
    }

    public int getNdim() {
        return this.ndim_;
    }

    public int getNerror() {
        return this.nerror_;
    }

    public boolean hasLabels() {
        return this.hasLabels_;
    }

    public PointSequence getPointSequence() {
        return new ArrayPointSequence();
    }

    public void setPoints(PointData[] points) {
        this.points_ = points;
    }

    public PointData[] getPoints() {
        return this.points_;
    }

    public static ArrayPlotData copyPlotData(PlotData data) {
        int nset = data.getSetCount();
        String[] setNames = new String[nset];
        Style[] setStyles = new Style[nset];
        for (int is = 0; is < nset; ++is) {
            setNames[is] = data.getSetName(is);
            setStyles[is] = data.getSetStyle(is);
        }
        ArrayList<PointData> pointList = new ArrayList<PointData>();
        int ndim = data.getNdim();
        int nerror = data.getNerror();
        PointSequence pseq = data.getPointSequence();
        while (pseq.next()) {
            Object errorsCopy;
            boolean[] isIncluded = new boolean[nset];
            for (int is = 0; is < nset; ++is) {
                isIncluded[is] = pseq.isIncluded(is);
            }
            double[] pointCopy = (double[])pseq.getPoint().clone();
            double[][] errors = pseq.getErrors();
            if (nerror > 0 && errors != null && errors.length > 0) {
                errorsCopy = new double[errors.length][];
                for (int ierr = 0; ierr < errors.length; ++ierr) {
                    double[] error = errors[ierr];
                    if (error == null) continue;
                    errorsCopy[ierr] = (double[])error.clone();
                }
            } else {
                errorsCopy = null;
            }
            pointList.add(new PointData(pointCopy, (double[][])errorsCopy, pseq.getLabel(), isIncluded));
        }
        PointData[] points = pointList.toArray(new PointData[0]);
        return new ArrayPlotData(nset, setNames, setStyles, data.getNdim(), data.getNerror(), data.hasLabels(), points);
    }

    private class ArrayPointSequence
    implements PointSequence {
        private int ip_ = -1;

        ArrayPointSequence() {
        }

        public boolean next() {
            return ++this.ip_ < ArrayPlotData.this.points_.length;
        }

        public double[] getPoint() {
            return ArrayPlotData.this.points_[this.ip_].getPoint();
        }

        public double[][] getErrors() {
            return ArrayPlotData.this.points_[this.ip_].getErrors();
        }

        public String getLabel() {
            return ArrayPlotData.this.points_[this.ip_].getLabel();
        }

        public boolean isIncluded(int iset) {
            return ArrayPlotData.this.points_[this.ip_].isIncluded(iset);
        }

        public void close() {
            this.ip_ = Integer.MIN_VALUE;
        }
    }
}

