/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.logging.settings;

import alma.acs.gui.util.threadsupport.EDTExecutor;
import com.cosylab.logging.engine.ExactFilter;
import com.cosylab.logging.engine.Filter;
import com.cosylab.logging.engine.InvalidFilterConstraintException;
import com.cosylab.logging.engine.MinMaxFilter;
import com.cosylab.logging.settings.FilterParameterException;
import com.cosylab.logging.settings.FilterParameterPanel;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.regex.Pattern;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;

public class FilterIntegerPanel
extends FilterParameterPanel {
    private JTextField minimum;
    private JTextField maximum;
    private JTextField exact;
    protected JCheckBox minimumCheck;
    protected JCheckBox maximumCheck;
    protected JCheckBox exactCheck;
    private JCheckBox notCheck;

    private JTextField buildIntegerTextField(int initialValue) {
        JTextField ret = new JTextField("" + initialValue);
        ret.setColumns(10);
        AbstractDocument document = (AbstractDocument)ret.getDocument();
        document.setDocumentFilter(new FormattedIntDocFilter(9));
        return ret;
    }

    @Override
    protected void createComponents() {
        EDTExecutor.instance().execute(new Runnable(){

            @Override
            public void run() {
                MinmaxChecked mmc = new MinmaxChecked();
                JPanel panelTop = new JPanel(new GridBagLayout());
                FilterIntegerPanel.this.add((Component)panelTop, FilterIntegerPanel.this.newConstraints(0, 4, 4, 4, 4));
                FilterIntegerPanel.this.notCheck = new JCheckBox("Discard entries matching this filter");
                FilterIntegerPanel.this.notCheck.setToolTipText("Keep/discard entries matching this filter");
                panelTop.add((Component)FilterIntegerPanel.this.notCheck, FilterIntegerPanel.this.newConstraints(0, 4, 4, 4, 4));
                FilterIntegerPanel.this.minimumCheck = new JCheckBox("Minimum value");
                FilterIntegerPanel.this.minimumCheck.addItemListener(mmc);
                panelTop.add((Component)FilterIntegerPanel.this.minimumCheck, FilterIntegerPanel.this.newConstraints(1, 4, 0, 0, 0));
                FilterIntegerPanel.this.minimum = FilterIntegerPanel.this.buildIntegerTextField(1);
                panelTop.add((Component)FilterIntegerPanel.this.minimum, FilterIntegerPanel.this.newConstraints(2, 0, 0, 4, 0));
                FilterIntegerPanel.this.maximumCheck = new JCheckBox("Maximum value");
                FilterIntegerPanel.this.maximumCheck.addItemListener(mmc);
                panelTop.add((Component)FilterIntegerPanel.this.maximumCheck, FilterIntegerPanel.this.newConstraints(3, 4, 0, 0, 0));
                FilterIntegerPanel.this.maximum = FilterIntegerPanel.this.buildIntegerTextField(2);
                panelTop.add((Component)FilterIntegerPanel.this.maximum, FilterIntegerPanel.this.newConstraints(4, 0, 0, 4, 0));
                JPanel panelBottom = new JPanel(new GridBagLayout());
                FilterIntegerPanel.this.add((Component)panelBottom, FilterIntegerPanel.this.newConstraints(1, 4, 4, 4, 4));
                FilterIntegerPanel.this.exactCheck = new JCheckBox("Exact value");
                FilterIntegerPanel.this.exactCheck.addItemListener(new ExactChecked());
                panelBottom.add((Component)FilterIntegerPanel.this.exactCheck, FilterIntegerPanel.this.newConstraints(0, 4, 0, 0, 0));
                FilterIntegerPanel.this.exact = FilterIntegerPanel.this.buildIntegerTextField(1);
                panelBottom.add((Component)FilterIntegerPanel.this.exact, FilterIntegerPanel.this.newConstraints(1, 0, 0, 4, 0));
            }
        });
    }

    @Override
    public Filter getFilter() throws FilterParameterException {
        boolean bmin = this.minimumCheck.isSelected();
        boolean bmax = this.maximumCheck.isSelected();
        boolean bexact = this.exactCheck.isSelected();
        Integer min = null;
        Integer max = null;
        if (bexact) {
            try {
                return new ExactFilter(this.getFieldIndex(), this.isLethal(), (Comparable)Integer.valueOf(Integer.parseInt(this.exact.getText())), this.notCheck.isSelected());
            }
            catch (InvalidFilterConstraintException e) {
                throw new FilterParameterException(e.getMessage());
            }
        }
        if (bmin) {
            min = Integer.parseInt(this.minimum.getText());
        }
        if (bmax) {
            max = Integer.parseInt(this.maximum.getText());
        }
        if (min != null && max != null && min.compareTo(max) > -1) {
            throw new FilterParameterException("Minimum must be less than maximum");
        }
        try {
            return new MinMaxFilter(this.getFieldIndex(), this.isLethal(), (Comparable)min, (Comparable)max, this.notCheck.isSelected());
        }
        catch (InvalidFilterConstraintException e) {
            throw new FilterParameterException(e.getMessage());
        }
    }

    @Override
    public void setFilter(Filter f) {
        if (f == null) {
            return;
        }
        switch (f.getConstraint()) {
            case EXACT: {
                this.setField(this.exactCheck, ((Number)((ExactFilter)f).getExact()).intValue(), this.exact);
                break;
            }
            case MINIMUM: {
                this.setField(this.minimumCheck, ((Number)((Object)((MinMaxFilter)f).getMinimum())).intValue(), this.minimum);
                break;
            }
            case MAXIMUM: {
                this.setField(this.maximumCheck, ((Number)((Object)((MinMaxFilter)f).getMaximum())).intValue(), this.maximum);
                break;
            }
            case MINMAX: {
                this.setField(this.minimumCheck, ((Number)((Object)((MinMaxFilter)f).getMinimum())).intValue(), this.minimum);
                this.setField(this.maximumCheck, ((Number)((Object)((MinMaxFilter)f).getMaximum())).intValue(), this.maximum);
            }
        }
        this.notCheck.setSelected(f.notPolicyApplyed());
    }

    private void setField(JCheckBox checkBox, int val, JTextField textField) {
        if (checkBox == null) {
            throw new IllegalArgumentException("The check box can't be null");
        }
        if (textField == null) {
            throw new IllegalArgumentException("The text field can't be null");
        }
        if (val < 0) {
            throw new IllegalArgumentException("The value can't be less then 0! Rejected value is " + val);
        }
        checkBox.setSelected(true);
        textField.setText("" + val);
    }

    private class ExactChecked
    implements ItemListener {
        private ExactChecked() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                FilterIntegerPanel.this.minimumCheck.setSelected(false);
                FilterIntegerPanel.this.maximumCheck.setSelected(false);
            }
        }
    }

    private class MinmaxChecked
    implements ItemListener {
        private MinmaxChecked() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                FilterIntegerPanel.this.exactCheck.setSelected(false);
            }
        }
    }

    private class FormattedIntDocFilter
    extends DocumentFilter {
        private final Pattern digitsRegExp = Pattern.compile("[0-9]*");
        public final int maxNumOfDigits;

        public FormattedIntDocFilter(int size) {
            this.maxNumOfDigits = size;
        }

        @Override
        public void remove(DocumentFilter.FilterBypass fb, int offset, int length) throws BadLocationException {
            super.remove(fb, offset, length);
        }

        @Override
        public void insertString(DocumentFilter.FilterBypass fb, int offset, String string, AttributeSet attr) throws BadLocationException {
            if (string == null || string.isEmpty()) {
                return;
            }
            if (this.digitsRegExp.matcher(string).matches() && fb.getDocument().getLength() + string.length() <= this.maxNumOfDigits) {
                super.insertString(fb, offset, string, attr);
            }
        }

        @Override
        public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
            if (text == null || text.isEmpty()) {
                return;
            }
            if (this.digitsRegExp.matcher(text).matches() && fb.getDocument().getLength() + text.length() - length <= this.maxNumOfDigits) {
                super.replace(fb, offset, length, text, attrs);
            }
        }
    }
}

