/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.logging.io;

import alma.acs.logging.engine.io.IOHelper;
import alma.acs.logging.engine.io.IOPorgressListener;
import alma.acs.logging.io.UrlDownloader;
import com.cosylab.logging.LoggingClient;
import com.cosylab.logging.client.cache.LogCache;
import com.cosylab.logging.engine.ACS.ACSRemoteErrorListener;
import com.cosylab.logging.engine.ACS.ACSRemoteLogListener;
import com.cosylab.logging.engine.ACS.LCEngine;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.JOptionPane;
import javax.swing.ProgressMonitor;
import javax.swing.SwingUtilities;

public class IOLogsHelper
implements IOPorgressListener {
    private final ExecutorService executor = Executors.newSingleThreadExecutor();
    private ProgressMonitor progressMonitor;
    private final IOHelper ioHelper;
    private LoggingClient loggingClient = null;
    private long bytesRead;
    private int logsRead;
    private int logsWritten;
    private volatile boolean isPerformingIO = false;

    public IOLogsHelper(LoggingClient client) throws Exception {
        if (client == null) {
            throw new IllegalArgumentException("Invalid null LoggingClient!");
        }
        this.loggingClient = client;
        this.ioHelper = new IOHelper();
    }

    public void loadLogs(BufferedReader br, ACSRemoteLogListener logListener, ACSRemoteErrorListener errorListener, int progressRange) {
        if (br == null || logListener == null || errorListener == null) {
            throw new IllegalArgumentException("Null parameter received!");
        }
        this.isPerformingIO = true;
        this.executor.submit(new LoadLogs(br, logListener, errorListener, progressRange));
    }

    public void loadLogsFromUrl(URL url, ACSRemoteLogListener logListener, ACSRemoteErrorListener errorListener) {
        if (url == null || logListener == null || errorListener == null) {
            throw new IllegalArgumentException("Null parameter received!");
        }
        this.isPerformingIO = true;
        this.executor.submit(new LoadUrl(url, logListener, errorListener));
    }

    private String formatErrorMsg(String msg) {
        StringBuilder sb = new StringBuilder();
        int count = 0;
        for (int t = 0; t < msg.length(); ++t) {
            char c = msg.charAt(t);
            sb.append(c);
            if (c == '\n') {
                count = 0;
                continue;
            }
            if (++count < 80 || c != ' ') continue;
            count = 0;
            sb.append('\n');
        }
        return sb.toString();
    }

    public void saveLogs(String fileName, boolean compress, int level, LogCache cache) throws IOException {
        if (fileName == null || fileName.isEmpty()) {
            throw new IllegalArgumentException("Invalid file name");
        }
        if (cache == null) {
            throw new IllegalArgumentException("The cache can't be null");
        }
        this.isPerformingIO = true;
        this.executor.submit(new SaveLogs(fileName, compress, level, cache));
    }

    public void done(boolean sync) {
        this.executor.shutdownNow();
    }

    public void bytesRead(long bytes) {
        this.bytesRead = bytes;
        if (this.progressMonitor != null) {
            this.progressMonitor.setProgress((int)this.bytesRead);
        }
    }

    public void bytesWritten(long bytes) {
    }

    public void logsRead(int numOfLogs) {
        this.logsRead = numOfLogs;
        if (this.progressMonitor != null && this.logsRead % 100 == 0) {
            this.progressMonitor.setNote(numOfLogs + " logs read");
            if (this.progressMonitor.isCanceled()) {
                this.ioHelper.stopIO();
            }
        }
    }

    public void logsWritten(int numOfLogs) {
        this.logsWritten = numOfLogs;
        if (this.progressMonitor != null && this.logsWritten % 100 == 0) {
            this.progressMonitor.setProgress(this.logsWritten);
            this.progressMonitor.setNote(this.logsWritten + " logs saved");
            if (this.progressMonitor.isCanceled()) {
                this.ioHelper.stopIO();
            }
        }
    }

    public boolean isPerformingIO() {
        return this.isPerformingIO;
    }

    public IOHelper getIoHelper() {
        return this.ioHelper;
    }

    final class SaveLogs
    implements Callable<Void> {
        private final String fileName;
        private final boolean compress;
        private final int level;
        private final LogCache cache;

        public SaveLogs(String fileName, boolean compress, int level, LogCache cache) {
            this.fileName = fileName;
            this.compress = compress;
            this.level = level;
            this.cache = cache;
        }

        @Override
        public Void call() throws Exception {
            BufferedWriter outBW = null;
            try {
                outBW = IOLogsHelper.this.ioHelper.getBufferedWriter(this.fileName, false, this.compress, this.level);
            }
            catch (IOException e) {
                System.err.println("Exception while saving logs: " + e.getMessage());
                e.printStackTrace(System.err);
                JOptionPane.showInternalMessageDialog(IOLogsHelper.this.loggingClient.getContentPane(), "Exception saving " + e.getMessage(), "Error saving", 0);
                IOLogsHelper.this.isPerformingIO = false;
                return null;
            }
            IOLogsHelper.this.progressMonitor = new ProgressMonitor(IOLogsHelper.this.loggingClient.getContentPane(), "Saving logs...", null, 0, this.cache.getSize());
            IOLogsHelper.this.logsWritten = 0;
            try {
                IOLogsHelper.this.ioHelper.writeHeader(outBW);
                IOLogsHelper.this.ioHelper.saveLogs(outBW, this.cache.iterator(), (IOPorgressListener)IOLogsHelper.this);
                IOLogsHelper.this.ioHelper.terminateSave(outBW, true);
            }
            catch (Throwable e) {
                System.err.println("Exception while saving logs: " + e.getMessage());
                e.printStackTrace(System.err);
                JOptionPane.showInternalMessageDialog(IOLogsHelper.this.loggingClient.getContentPane(), "Exception saving " + e.getMessage(), "Error saving", 0);
            }
            finally {
                IOLogsHelper.this.progressMonitor.close();
                IOLogsHelper.this.progressMonitor = null;
                IOLogsHelper.this.isPerformingIO = false;
            }
            return null;
        }
    }

    public class LoadUrl
    implements Callable<Void> {
        private final URL url;
        private final ACSRemoteLogListener logListener;
        private final ACSRemoteErrorListener errorListener;

        public LoadUrl(URL url, ACSRemoteLogListener logListener, ACSRemoteErrorListener errorListener) {
            if (url == null) {
                throw new IllegalArgumentException("Can't download from a NULL URL!");
            }
            this.url = url;
            this.logListener = logListener;
            this.errorListener = errorListener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws Exception {
            String fileToLoad;
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    IOLogsHelper.this.progressMonitor = new ProgressMonitor(IOLogsHelper.this.loggingClient.getContentPane(), "Downloading from URL...", null, 0, 1);
                    IOLogsHelper.this.progressMonitor.setMillisToPopup(250);
                }
            });
            try {
                UrlDownloader urlDownloader = new UrlDownloader(this.url);
                fileToLoad = urlDownloader.download();
            }
            catch (Throwable t) {
                System.err.println("Exception downloading URL: " + t.getMessage());
                t.printStackTrace(System.err);
                JOptionPane.showInternalMessageDialog(IOLogsHelper.this.loggingClient.getContentPane(), "Exception downloading URL " + t.getMessage(), "Error downloading", 0);
                IOLogsHelper.this.isPerformingIO = false;
                Void void_ = null;
                return void_;
            }
            finally {
                IOLogsHelper.this.progressMonitor.close();
                IOLogsHelper.this.progressMonitor = null;
            }
            System.out.println("File downloaded " + fileToLoad);
            BufferedReader br = null;
            int len = 0;
            try {
                br = IOLogsHelper.this.getIoHelper().getBufferedReader(fileToLoad);
                File f = new File(fileToLoad);
                f.deleteOnExit();
                len = fileToLoad.toLowerCase().endsWith(".gz") ? 0 : (int)f.length();
                IOLogsHelper.this.loadLogs(br, this.logListener, this.errorListener, len);
            }
            catch (Throwable fnfe) {
                JOptionPane.showInternalMessageDialog(IOLogsHelper.this.loggingClient.getContentPane(), fnfe.getMessage(), "Error opening " + fileToLoad, 0);
            }
            return null;
        }
    }

    final class LoadLogs
    implements Callable<Void> {
        private final BufferedReader br;
        private final ACSRemoteLogListener logListener;
        private final ACSRemoteErrorListener errorListener;
        private final int range;

        public LoadLogs(BufferedReader br, ACSRemoteLogListener logListener, ACSRemoteErrorListener errorListener, int progressRange) {
            this.br = br;
            this.logListener = logListener;
            this.errorListener = errorListener;
            this.range = progressRange;
        }

        @Override
        public Void call() throws Exception {
            IOLogsHelper.this.progressMonitor = this.range <= 0 ? new ProgressMonitor(IOLogsHelper.this.loggingClient.getContentPane(), "Loading logs...", null, 0, Integer.MAX_VALUE) : new ProgressMonitor(IOLogsHelper.this.loggingClient.getContentPane(), "Loading logs...", null, 0, this.range);
            IOLogsHelper.this.progressMonitor.setMillisToPopup(500);
            LCEngine engine = IOLogsHelper.this.loggingClient.getEngine();
            IOLogsHelper.this.ioHelper.setDiscardLevel(engine.getDiscardLevel());
            IOLogsHelper.this.ioHelper.setAudience(engine.getAudience());
            IOLogsHelper.this.ioHelper.setFilters(engine.getFilters());
            IOLogsHelper.this.logsRead = 0;
            IOLogsHelper.this.bytesRead = 0L;
            try {
                IOLogsHelper.this.ioHelper.loadLogs(this.br, this.logListener, null, this.errorListener, (IOPorgressListener)IOLogsHelper.this);
            }
            catch (Throwable ioe) {
                System.err.println("Exception loading the logs: " + ioe.getMessage());
                ioe.printStackTrace(System.err);
                JOptionPane.showInternalMessageDialog(IOLogsHelper.this.loggingClient.getContentPane(), "Exception loading " + ioe.getMessage(), "Error loading", 0);
            }
            finally {
                IOLogsHelper.this.progressMonitor.close();
                IOLogsHelper.this.progressMonitor = null;
                IOLogsHelper.this.isPerformingIO = false;
            }
            return null;
        }
    }
}

