/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.logging.dialogs.main;

import alma.acs.util.CmdLineArgs;
import alma.acs.util.CmdLineOption;
import alma.acs.util.CmdLineRegisteredOption;
import com.cosylab.logging.LoggingClient;
import com.cosylab.logging.engine.audience.Audience;
import com.cosylab.logging.engine.log.LogTypeHelper;

public class CommandLineParser {
    private boolean help = false;
    private boolean unlimited = false;
    private boolean doNotConnect = false;
    private String filterFileName = null;
    private String engineFilterFileName = null;
    private LogTypeHelper discardLevel = LoggingClient.DEFAULT_DISCARDLEVEL;
    private String fileToLoad = null;
    private Audience.AudienceInfo audience = null;

    public CommandLineParser(String[] args) throws Exception {
        this.parse(args);
        this.dumpOptions();
    }

    public static void printUsage(String errorMsg) {
        if (errorMsg != null) {
            System.err.println("Error parsing the command line: " + errorMsg);
        }
        StringBuilder str = new StringBuilder("USAGE:\n");
        str.append("jlog [logFileName] ");
        str.append("[-h|--help] ");
        str.append("[(-f|--filter) <filterFileName>] ");
        str.append("[(-e|--engineFilter) <filterFileName>]");
        str.append("[(-d|--discard) (NONE|discard level)] ");
        str.append("[-dnc|--DoNotConnect] ");
        str.append("[-u|--unlimited] ");
        str.append("[(-l|--load) <logFileName>] ");
        str.append("[(-a|--audience) <audience>]\n");
        str.append("Options:\n");
        str.append("-h|--help: print this message and exit\n");
        str.append("-f|--filter <fileName>: load the filters in <fileName> in the table\n");
        str.append("-e|--engineFilter <fileName>: load the filters in <fileName> in the engine\n");
        str.append("-d|--discard <level>: set the discard level at startup; NONE means no discard level\n");
        str.append("  Valid discard levels are:");
        str.append("\tNone");
        for (LogTypeHelper logTypeHelper : LogTypeHelper.values()) {
            str.append('\t');
            str.append(logTypeHelper);
            str.append('\n');
        }
        str.append("-dnc|--DoNotConnect: do not connect to ACS\n");
        str.append("-u|--unlimited: do not limit the number of logs in the table\n");
        str.append("-l|--load <logFileName>: load the <logFileName> file of logs in the table\n");
        str.append("-a|--audience <audience>: set the audience\n");
        str.append("  Available audiences are:\n");
        for (String string : Audience.AudienceInfo.getShortNames()) {
            str.append('\t');
            str.append(string);
            str.append('\n');
        }
        str.append('\n');
        System.out.println(str.toString());
    }

    private void parse(String[] args) throws Exception {
        String[] val;
        CmdLineArgs cmdLineArgs = new CmdLineArgs();
        CmdLineRegisteredOption helpCmd = new CmdLineRegisteredOption("-h", "--help", 0);
        cmdLineArgs.registerOption(helpCmd);
        CmdLineRegisteredOption filterCmd = new CmdLineRegisteredOption("-f", "--filter", 0);
        cmdLineArgs.registerOption(filterCmd);
        CmdLineRegisteredOption engineFilterCmd = new CmdLineRegisteredOption("-e", "--engineFilter", 0);
        cmdLineArgs.registerOption(engineFilterCmd);
        CmdLineRegisteredOption discardCmd = new CmdLineRegisteredOption("-d", "--discard", 0);
        cmdLineArgs.registerOption(discardCmd);
        CmdLineRegisteredOption doNotConnectCmd = new CmdLineRegisteredOption("-dnc", "--DoNotConnect", 0);
        cmdLineArgs.registerOption(doNotConnectCmd);
        CmdLineRegisteredOption unlimitedCmd = new CmdLineRegisteredOption("-u", "--unlimited", 0);
        cmdLineArgs.registerOption(unlimitedCmd);
        CmdLineRegisteredOption loadCmd = new CmdLineRegisteredOption("-l", "--load", 0);
        cmdLineArgs.registerOption(loadCmd);
        CmdLineRegisteredOption audienceCmd = new CmdLineRegisteredOption("-a", "--audience", 0);
        cmdLineArgs.registerOption(audienceCmd);
        cmdLineArgs.parseArgs(args);
        if (cmdLineArgs.isSpecified(helpCmd)) {
            this.help = true;
        }
        if (cmdLineArgs.isSpecified(filterCmd)) {
            val = cmdLineArgs.getValues((CmdLineOption)filterCmd);
            if (val == null || val.length < 1) {
                throw new IllegalStateException("Filter file name missing");
            }
            this.filterFileName = val[0];
        }
        if (cmdLineArgs.isSpecified(engineFilterCmd)) {
            val = cmdLineArgs.getValues((CmdLineOption)engineFilterCmd);
            if (val == null || val.length < 1) {
                throw new IllegalStateException("Engine filter file name missing");
            }
            this.engineFilterFileName = val[0];
        }
        if (cmdLineArgs.isSpecified(discardCmd)) {
            val = cmdLineArgs.getValues((CmdLineOption)discardCmd);
            if (val == null || val.length < 1) {
                throw new IllegalStateException("Discard level missing ");
            }
            this.discardLevel = LogTypeHelper.fromLogTypeDescription((String)val[0]);
            if (this.discardLevel == null && val[0].compareToIgnoreCase("None") != 0) {
                throw new Exception("Invalid discard level " + val[0]);
            }
        }
        if (cmdLineArgs.isSpecified(doNotConnectCmd)) {
            this.doNotConnect = true;
        }
        if (cmdLineArgs.isSpecified(unlimitedCmd)) {
            this.unlimited = true;
        }
        if (cmdLineArgs.isSpecified(loadCmd)) {
            val = cmdLineArgs.getValues((CmdLineOption)loadCmd);
            if (val == null || val.length < 1) {
                throw new IllegalStateException("File name of logs to load mssing");
            }
            this.fileToLoad = val[0];
        }
        if (cmdLineArgs.isSpecified(audienceCmd)) {
            val = cmdLineArgs.getValues((CmdLineOption)audienceCmd);
            if (val == null || val.length < 1) {
                throw new IllegalStateException("Audience mssing");
            }
            this.audience = Audience.AudienceInfo.fromShortName((String)val[0]);
        }
    }

    private void dumpOptions() {
        StringBuilder ret = new StringBuilder("Command line options:\n");
        ret.append("File of logs: " + this.fileToLoad);
        ret.append('\n');
        if (this.audience == null) {
            ret.append("Audience: not set");
        } else {
            ret.append("Audience: " + this.audience.name);
        }
        ret.append('\n');
        ret.append("Filter file: " + this.filterFileName);
        ret.append('\n');
        ret.append("engine filter file: " + this.engineFilterFileName);
        ret.append('\n');
        ret.append("unlimited num. of logs in table: " + this.unlimited);
        ret.append('\n');
        ret.append("Do not connect to ACS: " + this.doNotConnect);
        ret.append('\n');
        ret.append("Discard level: " + this.discardLevel);
        ret.append('\n');
        System.out.println(ret.toString());
    }

    public boolean getHelp() {
        return this.help;
    }

    public boolean isUnlimited() {
        return this.unlimited;
    }

    public boolean isDoNotConnect() {
        return this.doNotConnect;
    }

    public String getFilterFileName() {
        return this.filterFileName;
    }

    public String getEngineFilterFileName() {
        return this.engineFilterFileName;
    }

    public LogTypeHelper getDiscardLevel() {
        return this.discardLevel;
    }

    public String getFileToLoad() {
        return this.fileToLoad;
    }

    public Audience.AudienceInfo getAudience() {
        return this.audience;
    }
}

