/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.container;

import alma.acs.logging.AcsLogLevel;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CleaningDaemonThreadFactory
implements ThreadFactory {
    public static final String LOG_THREAD_CREATION_CALLSTACK_PROPERTYNAME = "alma.acs.threadfactory.trace_creators";
    protected boolean logThreadCreationCallstack = Boolean.getBoolean("alma.acs.threadfactory.trace_creators");
    private final List<Thread> threadList = new ArrayList<Thread>();
    private final AtomicInteger threadNumber = new AtomicInteger(1);
    private final Logger logger;
    private final String name;
    private final String ownerName;
    private LoggingThreadGroup group;
    private ClassLoader newThreadContextCL;

    public CleaningDaemonThreadFactory(String name, Logger logger) {
        this(name, logger, "User");
    }

    public CleaningDaemonThreadFactory(String name, Logger logger, String ownerName) {
        this.logger = logger;
        this.name = name;
        this.ownerName = ownerName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Thread newThread(Runnable command) {
        this.ensureGroupCreated();
        String threadName = this.group.getName() + "-" + this.threadNumber.getAndIncrement();
        Thread t = new Thread(this.group, command, threadName);
        t.setDaemon(true);
        if (this.newThreadContextCL != null) {
            t.setContextClassLoader(this.newThreadContextCL);
        }
        List<Thread> list = this.threadList;
        synchronized (list) {
            this.threadList.add(t);
        }
        if (this.logThreadCreationCallstack) {
            try {
                throw new Exception();
            }
            catch (Exception ex) {
                StackTraceElement[] stack = ex.getStackTrace();
                StringBuilder str = new StringBuilder();
                for (int i = 1; i < stack.length; ++i) {
                    str.append(stack[i].toString());
                    if (i >= stack.length - 1) continue;
                    str.append(" <- ");
                }
                String msg = "Created thread '" + threadName + "'. Call stack: " + str;
                this.logger.log((Level)AcsLogLevel.INFO, msg);
            }
        }
        return t;
    }

    private synchronized void ensureGroupCreated() {
        if (this.group == null) {
            this.group = new LoggingThreadGroup(this.name, this.logger, this.ownerName);
            this.group.setMaxPriority(Thread.currentThread().getPriority());
        }
    }

    void setNewThreadContextClassLoader(ClassLoader cl) {
        if (cl != null) {
            this.newThreadContextCL = cl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Thread> _getAllThreadsCreated() {
        List<Thread> list = this.threadList;
        synchronized (list) {
            return new ArrayList<Thread>(this.threadList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void cleanUp() {
        if (this.group == null) {
            return;
        }
        this.group.setShuttingDown();
        List<Thread> list = this.threadList;
        synchronized (list) {
            for (Thread t : this.threadList) {
                try {
                    if (t.isAlive()) {
                        this.logger.warning("Forcibly terminating surviving thread " + t.getName());
                    }
                    t.interrupt();
                    try {
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
                catch (RuntimeException e) {
                    this.logger.finer("exception while stopping thread '" + t.getName() + "': " + e.toString());
                }
            }
            this.threadList.clear();
        }
        try {
            if (!this.group.isDestroyed() && this.group.activeCount() == 0) {
                this.group.destroy();
            }
        }
        catch (Exception e) {
            this.logger.finer("unexpectedly failed to destroy thread group " + this.group.getName() + e.toString());
        }
        this.group = null;
    }

    private static class LoggingThreadGroup
    extends ThreadGroup {
        private final Logger logger;
        private volatile boolean shuttingDown = false;
        private final String ownerName;

        LoggingThreadGroup(String name, Logger logger, String ownerName) {
            super(name);
            this.logger = logger;
            this.ownerName = ownerName;
        }

        void setShuttingDown() {
            this.shuttingDown = true;
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            if (!this.shuttingDown) {
                this.logger.log(Level.WARNING, this.ownerName + " thread '" + t.getName() + "' terminated with error ", e);
            }
            if (e instanceof ThreadDeath) {
                super.uncaughtException(t, e);
            }
        }
    }
}

