/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.component.client;

import alma.ACS.ACSComponent;
import alma.ACS.ACSComponentHelper;
import alma.acs.component.client.ComponentClient;
import alma.acs.logging.AcsLogger;
import alma.acs.logging.ClientLogManager;
import alma.acs.shutdown.ShutdownHookBase;
import alma.acs.util.ACSPorts;
import alma.acs.util.AcsLocations;
import alma.acs.util.CmdLineArgs;
import alma.acs.util.CmdLineOption;
import alma.acs.util.CmdLineRegisteredOption;
import alma.acs.util.StopWatch;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.omg.CORBA.Object;

public class ComponentRefTracker
extends ComponentClient {
    private String targetCompUrl;
    private ACSComponent targetComp;
    private int pingDelaySec = -1;
    private volatile CountDownLatch shutdownSync = null;
    private boolean checkExists = false;
    private BufferedReader inputReader;

    ComponentRefTracker(Logger logger, String managerLoc, String name) throws Exception {
        super(logger, managerLoc, name);
    }

    @Override
    public void initRemoteLogging() {
    }

    @Override
    protected void registerShutdownHook() {
        this.m_shutdownHook = new ShutdownHookBase((Logger)this.m_logger, "ComponentRefTracker"){

            protected void interruptDetected() {
                try {
                    ComponentRefTracker.this.shutdownSync = new CountDownLatch(1);
                    ComponentRefTracker.this.m_logger.info("SIGINT received. Will terminate...");
                    ComponentRefTracker.this.shutdownSync.await(10L, TimeUnit.SECONDS);
                }
                catch (Exception ex) {
                    ComponentRefTracker.this.m_logger.log(Level.WARNING, "Shutdown error: ", (Throwable)ex);
                }
            }
        };
        Runtime.getRuntime().addShutdownHook((Thread)this.m_shutdownHook);
    }

    boolean setOptions(String[] args) {
        CmdLineArgs cmdArgs = new CmdLineArgs();
        CmdLineRegisteredOption optHelp = new CmdLineRegisteredOption("--help", "-h", 0);
        cmdArgs.registerOption(optHelp);
        CmdLineRegisteredOption optCurl = new CmdLineRegisteredOption("-curl", 1);
        cmdArgs.registerOption(optCurl);
        CmdLineRegisteredOption optPingDelaySec = new CmdLineRegisteredOption("-delaySec", 1);
        cmdArgs.registerOption(optPingDelaySec);
        CmdLineRegisteredOption optCheckExists = new CmdLineRegisteredOption("-checkExists", 0);
        cmdArgs.registerOption(optCheckExists);
        CmdLineRegisteredOption optInteractive = new CmdLineRegisteredOption("-interactive", 0);
        cmdArgs.registerOption(optInteractive);
        cmdArgs.parseArgs(args);
        if (cmdArgs.isSpecified(optHelp)) {
            System.out.println("Usage: acsStartJava " + this.getClass().getName() + "\n\t" + optCurl.getName() + " <curl> \n\t[ " + optInteractive.getName() + " | " + optPingDelaySec.getName() + " <delay in s between component calls> ]\n\t[ " + optCheckExists.getName() + " ]");
            return false;
        }
        if (cmdArgs.isSpecified(optInteractive)) {
            this.inputReader = new BufferedReader(new InputStreamReader(System.in));
        }
        if (cmdArgs.isSpecified(optPingDelaySec)) {
            if (this.inputReader != null) {
                this.m_logger.info("Ignoring setting for ping delay because only manual component calls will be used.");
            } else {
                this.pingDelaySec = Integer.parseInt(cmdArgs.getValues((CmdLineOption)optPingDelaySec)[0].trim());
            }
        } else if (this.inputReader == null) {
            this.pingDelaySec = 5;
        }
        if (!cmdArgs.isSpecified(optCurl)) {
            throw new IllegalArgumentException("Option '" + optCurl.getName() + "' must be specified.");
        }
        this.targetCompUrl = cmdArgs.getValues((CmdLineOption)optCurl)[0].trim();
        if (cmdArgs.isSpecified(optCheckExists)) {
            this.checkExists = true;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run(String[] args) throws Exception {
        try {
            if (!this.setOptions(args)) {
                return;
            }
            try {
                this.targetComp = ACSComponentHelper.narrow((Object)this.getContainerServices().getComponent(this.targetCompUrl));
            }
            catch (Exception ex) {
                this.m_logger.warning("Failed to connect to component '" + this.targetCompUrl + "' in the first place. Will terminate.");
                this.tearDown();
                this.m_shutdownHook.setRegularShutdownExpected();
                this.shutdownSync.countDown();
                return;
            }
            String ior = this.getContainerServices().getAdvancedContainerServices().corbaObjectToString((Object)this.targetComp);
            String msg = "Got reference to component '" + this.targetCompUrl + "', IOR='" + ior + "'.";
            if (this.pingDelaySec > 0) {
                msg = msg + " Will call it every " + this.pingDelaySec + " seconds.";
            }
            this.m_logger.info(msg);
            this.runLoop();
        }
        finally {
            this.tearDown();
            this.m_shutdownHook.setRegularShutdownExpected();
            this.shutdownSync.countDown();
        }
    }

    private void runLoop() throws IOException, InterruptedException {
        long nextCallTime = -1L;
        if (this.inputReader != null) {
            this.m_logger.info("Press ENTER to call " + this.targetCompUrl);
        }
        while (this.shutdownSync == null) {
            if (this.inputReader != null && !this.inputReader.ready() || System.currentTimeMillis() < nextCallTime) {
                Thread.sleep(100L);
                continue;
            }
            if (this.inputReader != null) {
                this.inputReader.readLine();
            }
            StopWatch sw = new StopWatch();
            try {
                if (this.checkExists && this.targetComp._non_existent()) {
                    this.m_logger.info("Component '" + this.targetCompUrl + "' does not exist (see Corba spec 4.3.5.1). Call took " + sw.getLapTimeMillis() + " ms.");
                } else {
                    String currentName = this.targetComp.name();
                    String msg = "Call to " + this.targetCompUrl + "#name() returned fine";
                    if (!this.targetCompUrl.equals(currentName)) {
                        msg = msg + " but with unexpected name '" + currentName;
                    }
                    this.m_logger.info(msg + ". Call took " + sw.getLapTimeMillis() + " ms.");
                }
            }
            catch (Throwable thr) {
                this.m_logger.info("Call to component '" + this.targetCompUrl + "' failed with " + thr.getClass().getName() + ", after " + sw.getLapTimeMillis() + " ms.");
            }
            if (this.inputReader != null) continue;
            nextCallTime = System.currentTimeMillis() + (long)(this.pingDelaySec * 1000);
        }
    }

    public static void main(String[] args) {
        String name = ComponentRefTracker.class.getSimpleName();
        ClientLogManager.getAcsLogManager().suppressRemoteLogging();
        AcsLogger logger = ClientLogManager.getAcsLogManager().getLoggerForApplication(name, false);
        String managerLoc = null;
        if (System.getProperty("ACS.manager") != null) {
            managerLoc = System.getProperty("ACS.manager").trim();
        } else {
            AcsLocations.convertToManagerLocation((String)ACSPorts.getIP(), (String)ACSPorts.getManagerPort());
        }
        try {
            new ComponentRefTracker((Logger)logger, managerLoc, name).run(args);
        }
        catch (Throwable thr) {
            logger.log(Level.SEVERE, "Top-level exception caught:", thr);
        }
    }
}

