/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.fits;

import java.io.DataOutput;
import java.io.IOException;
import uk.ac.starlink.fits.ColumnWriter;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.Tables;

abstract class ScalarColumnWriter
implements ColumnWriter {
    private final char formatChar_;
    private final int nbyte_;
    private final Number badNumber_;

    protected ScalarColumnWriter(char formatChar, int nbyte, Number badNumber) {
        this.formatChar_ = formatChar;
        this.nbyte_ = nbyte;
        this.badNumber_ = badNumber;
    }

    public String getFormat() {
        return new String(new char[]{this.formatChar_});
    }

    public char getFormatChar() {
        return this.formatChar_;
    }

    public int getLength() {
        return this.nbyte_;
    }

    public int[] getDims() {
        return null;
    }

    public double getZero() {
        return 0.0;
    }

    public double getScale() {
        return 1.0;
    }

    public Number getBadNumber() {
        return this.badNumber_;
    }

    public static ScalarColumnWriter createColumnWriter(ColumnInfo cinfo, boolean nullableInt, boolean allowSignedByte) {
        Object blankObj;
        DescribedValue blankVal;
        Class clazz = cinfo.getContentClass();
        Number blankNum = null;
        if (nullableInt && (blankVal = cinfo.getAuxDatum(Tables.NULL_VALUE_INFO)) != null && (blankObj = blankVal.getValue()) instanceof Number) {
            blankNum = (Number)blankObj;
        }
        if (clazz == Boolean.class) {
            return new ScalarColumnWriter('L', 1, null){

                public void writeValue(DataOutput stream, Object value) throws IOException {
                    int b = Boolean.TRUE.equals(value) ? 84 : (Boolean.FALSE.equals(value) ? 70 : 0);
                    stream.writeByte(b);
                }
            };
        }
        if (clazz == Byte.class) {
            if (allowSignedByte) {
                final byte[] buf = new byte[1];
                final byte badVal = blankNum == null ? (byte)0 : blankNum.byteValue();
                return new ScalarColumnWriter('B', 1, nullableInt ? new Byte(badVal) : null){

                    public void writeValue(DataOutput stream, Object value) throws IOException {
                        byte b = value != null ? ((Number)value).byteValue() : badVal;
                        buf[0] = (byte)(b ^ 0xFFFFFF80);
                        stream.write(buf);
                    }

                    public double getZero() {
                        return -128.0;
                    }
                };
            }
            final short badVal = blankNum == null ? (short)-129 : (short)blankNum.shortValue();
            return new ScalarColumnWriter('I', 2, nullableInt ? new Short(badVal) : null){

                public void writeValue(DataOutput stream, Object value) throws IOException {
                    short sval = value != null ? ((Number)value).shortValue() : badVal;
                    stream.writeShort(sval);
                }
            };
        }
        if (clazz == Short.class) {
            final short badVal = blankNum == null ? (short)Short.MIN_VALUE : (short)blankNum.shortValue();
            return new ScalarColumnWriter('I', 2, nullableInt ? new Short(badVal) : null){

                public void writeValue(DataOutput stream, Object value) throws IOException {
                    short sval = value != null ? ((Number)value).shortValue() : badVal;
                    stream.writeShort(sval);
                }
            };
        }
        if (clazz == Integer.class) {
            final int badVal = blankNum == null ? Integer.MIN_VALUE : blankNum.intValue();
            return new ScalarColumnWriter('J', 4, nullableInt ? new Integer(badVal) : null){

                public void writeValue(DataOutput stream, Object value) throws IOException {
                    int ival = value != null ? ((Number)value).intValue() : badVal;
                    stream.writeInt(ival);
                }
            };
        }
        if (clazz == Long.class) {
            final long badVal = blankNum == null ? Long.MIN_VALUE : blankNum.longValue();
            return new ScalarColumnWriter('K', 8, nullableInt ? new Long(badVal) : null){

                public void writeValue(DataOutput stream, Object value) throws IOException {
                    long lval = value != null ? ((Number)value).longValue() : badVal;
                    stream.writeLong(lval);
                }
            };
        }
        if (clazz == Float.class) {
            return new ScalarColumnWriter('E', 4, null){

                public void writeValue(DataOutput stream, Object value) throws IOException {
                    float fval = value != null ? ((Number)value).floatValue() : Float.NaN;
                    stream.writeFloat(fval);
                }
            };
        }
        if (clazz == Double.class) {
            return new ScalarColumnWriter('D', 8, null){

                public void writeValue(DataOutput stream, Object value) throws IOException {
                    double dval = value != null ? ((Number)value).doubleValue() : Double.NaN;
                    stream.writeDouble(dval);
                }
            };
        }
        if (clazz == Character.class) {
            return new ScalarColumnWriter('A', 1, null){

                public void writeValue(DataOutput stream, Object value) throws IOException {
                    int cval = value != null ? (int)((Character)value).charValue() : 32;
                    stream.writeByte(cval);
                }
            };
        }
        return null;
    }
}

