/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.plastic;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;

class ErrorDialog
extends JDialog {
    private final JComponent holder_;
    private final String[] message_;
    private final Throwable error_;
    private final String title_;
    private JComponent summaryPanel_;
    private JComponent detailPanel_;

    public ErrorDialog(Frame frame, Throwable error, String title, String[] message) {
        super(frame, title == null ? "Error" : title, true);
        this.error_ = error;
        this.title_ = title;
        this.message_ = message == null ? new String[]{} : message;
        this.setDefaultCloseOperation(2);
        Border gapBorder = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        AbstractAction disposeAction = new AbstractAction("OK"){

            public void actionPerformed(ActionEvent evt) {
                ErrorDialog.this.dispose();
            }
        };
        Container main = this.getContentPane();
        this.holder_ = new JPanel(new CardLayout());
        JLabel iconLabel = new JLabel(UIManager.getIcon("OptionPane.errorIcon"));
        JPanel iconPanel = new JPanel(new BorderLayout());
        iconPanel.add(iconLabel);
        iconPanel.setBorder(gapBorder);
        main.add((Component)iconPanel, "West");
        JPanel holderBox = new JPanel(new BorderLayout());
        holderBox.setBorder(gapBorder);
        holderBox.add((Component)this.holder_, "Center");
        holderBox.add(Box.createHorizontalStrut(256), "South");
        holderBox.add(Box.createVerticalStrut(64), "West");
        main.add((Component)holderBox, "Center");
        Box buttonBox = Box.createHorizontalBox();
        JButton detailButton = new JButton(new DetailAction());
        buttonBox.add(Box.createHorizontalGlue());
        buttonBox.add(new JButton(disposeAction));
        buttonBox.add(Box.createHorizontalStrut(10));
        buttonBox.add(new JButton(new DetailAction()));
        buttonBox.add(Box.createHorizontalGlue());
        buttonBox.setBorder(gapBorder);
        main.add((Component)buttonBox, "South");
    }

    private JComponent getSummaryPanel() {
        if (this.summaryPanel_ == null) {
            ArrayList<String> lines = new ArrayList<String>(Arrays.asList(this.message_));
            String errmsg = this.error_.getMessage();
            if (errmsg != null) {
                String[] msgLines = errmsg.split("\n");
                for (int i = 0; i < msgLines.length; ++i) {
                    lines.add(msgLines[i]);
                }
            }
            if (lines.size() == 0) {
                lines.add(this.title_ == null ? this.error_.getClass().getName() : this.title_);
            }
            Box lineBox = Box.createVerticalBox();
            lineBox.add(Box.createVerticalGlue());
            Iterator it = lines.iterator();
            while (it.hasNext()) {
                String line = (String)it.next();
                lineBox.add(new JLabel(line, 2));
            }
            lineBox.add(Box.createVerticalGlue());
            this.summaryPanel_ = new JPanel(new BorderLayout());
            this.summaryPanel_.add(lineBox);
        }
        return this.summaryPanel_;
    }

    private JComponent getDetailPanel() {
        if (this.detailPanel_ == null) {
            StringWriter traceWriter = new StringWriter();
            this.error_.printStackTrace(new PrintWriter(traceWriter));
            String trace = traceWriter.toString();
            JTextArea ta = new JTextArea();
            ta.setLineWrap(false);
            ta.setEditable(false);
            ta.append(trace);
            ta.setCaretPosition(0);
            JScrollPane scroller = new JScrollPane(ta);
            this.detailPanel_ = scroller;
        }
        return this.detailPanel_;
    }

    public static void showError(Component parent, String title, Throwable error, String[] message) {
        Frame fparent = parent == null ? null : (Frame)SwingUtilities.getAncestorOfClass(Frame.class, parent);
        ErrorDialog dialog = new ErrorDialog(fparent, error, title, message);
        dialog.setLocationRelativeTo(parent);
        dialog.pack();
        dialog.setVisible(true);
    }

    public static void showError(Component parent, String title, Throwable error, String message) {
        ErrorDialog.showError(parent, title, error, new String[]{message});
    }

    public static void showError(Component parent, String title, Throwable error) {
        ErrorDialog.showError(parent, title, error, new String[0]);
    }

    public static void main(String[] args) {
        ErrorDialog.showError(null, "Error", (Throwable)new Error("Some trouble"), args);
        System.exit(0);
    }

    private class DetailAction
    extends AbstractAction {
        private boolean detail_;

        DetailAction() {
            this.setShowDetail(false);
            ErrorDialog.this.pack();
        }

        public void actionPerformed(ActionEvent evt) {
            this.setShowDetail(!this.detail_);
            Rectangle oldBounds = ErrorDialog.this.getBounds();
            int cx = oldBounds.x + oldBounds.width / 2;
            int cy = oldBounds.y + oldBounds.height / 2;
            Rectangle newBounds = ErrorDialog.this.getBounds();
            ErrorDialog.this.setLocation(new Point(cx - newBounds.width / 2, cy - newBounds.height / 2));
        }

        void setShowDetail(boolean detail) {
            if (detail) {
                if (ErrorDialog.this.detailPanel_ == null) {
                    ErrorDialog.this.holder_.add((Component)ErrorDialog.this.getDetailPanel(), "DETAIL");
                    Dimension size = ErrorDialog.this.holder_.getPreferredSize();
                    size.height = Math.min(size.height, 300);
                    size.width = Math.min(size.width, 500);
                    ErrorDialog.this.holder_.setPreferredSize(size);
                    ErrorDialog.this.pack();
                }
                ((CardLayout)ErrorDialog.this.holder_.getLayout()).show(ErrorDialog.this.holder_, "DETAIL");
                this.putValue("Name", "Hide Details");
            } else {
                if (ErrorDialog.this.summaryPanel_ == null) {
                    ErrorDialog.this.holder_.add((Component)ErrorDialog.this.getSummaryPanel(), "SUMMARY");
                }
                ((CardLayout)ErrorDialog.this.holder_.getLayout()).show(ErrorDialog.this.holder_, "SUMMARY");
                this.putValue("Name", "Show Details");
            }
            this.detail_ = detail;
        }
    }
}

