/*
 * Decompiled with CFR 0.152.
 */
package jsky.coords;

public class Trigod {
    static final double DOUBLE_MAX = 1.7E38;
    static final double DEG = 57.29577951308232;

    private static double fractionalPart(double d) {
        return Math.abs(d - (double)((int)d));
    }

    public static double cosd(double x) {
        boolean sign = false;
        double argument = Trigod.fractionalPart(x / 360.0);
        if (argument > 0.5) {
            argument = 1.0 - argument;
        }
        if (argument > 0.25) {
            argument = 0.5 - argument;
            sign = true;
        }
        argument = argument > 0.125 ? Math.sin(Math.PI * 2 * (0.25 - argument)) : Math.cos(Math.PI * 2 * argument);
        if (sign) {
            argument = -argument;
        }
        return argument;
    }

    public static double sind(double x) {
        boolean sign;
        double argument = Trigod.fractionalPart(x / 360.0);
        boolean bl = sign = !(x >= 0.0);
        if (argument > 0.5) {
            argument = 1.0 - argument;
            sign ^= true;
        }
        if (argument > 0.25) {
            argument = 0.5 - argument;
        }
        argument = argument > 0.125 ? Math.cos(Math.PI * 2 * (0.25 - argument)) : Math.sin(Math.PI * 2 * argument);
        if (sign) {
            argument = -argument;
        }
        return argument;
    }

    public static double tand(double x) {
        double argument = Trigod.fractionalPart(x / 180.0);
        argument = argument == 0.5 ? 1.7E38 : Math.tan(Math.PI * argument);
        return x > 0.0 ? argument : -argument;
    }

    public static double atand(double x) {
        return 57.29577951308232 * Math.atan(x);
    }

    public static double atan2d(double x, double y) {
        return 57.29577951308232 * Math.atan2(x, y);
    }

    public static double acosd(double x) {
        return 57.29577951308232 * Math.acos(x);
    }

    double asind(double x) {
        return 57.29577951308232 * Math.asin(x);
    }
}

