/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.commandcenter.gui;

import alma.acs.commandcenter.gui.DeploymentTreeController;
import alma.acs.commandcenter.gui.ErrorBox;
import alma.acs.commandcenter.meta.Firestarter;
import alma.acs.commandcenter.meta.GuiMaciSupervisor;
import alma.acs.commandcenter.meta.IMaciSupervisor;
import alma.acs.commandcenter.meta.MaciInfo;
import alma.acs.commandcenter.meta.MaciSupervisor;
import alma.acs.util.AcsLocations;
import alma.maciErrType.CannotGetComponentEx;
import alma.maciErrType.ComponentConfigurationNotFoundEx;
import alma.maciErrType.ComponentNotAlreadyActivatedEx;
import alma.maciErrType.NoPermissionEx;
import alma.maciErrType.wrappers.AcsJCannotDeactivateComponentEx;
import alma.maciErrType.wrappers.AcsJComponentDeactivationFailedEx;
import alma.maciErrType.wrappers.AcsJComponentDeactivationUncleanEx;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Equator;
import org.omg.CORBA.Object;
import si.ijs.maci.ClientInfo;
import si.ijs.maci.ComponentInfo;
import si.ijs.maci.ContainerInfo;

public class DeploymentTree
extends JTree {
    protected ContextMenu containerContextMenu;
    protected ContextMenu managerContextMenu;
    protected ContextMenu clientContextMenu;
    protected ContextMenu componentContextMenu;
    protected ContextMenu folderContextMenu;
    protected TreeEventForwarder treeEventForwarder;
    protected List<ModelConverter> modelConverters;
    protected Renderer cellRenderer;
    protected DefaultMutableTreeNode target;
    protected GuiMaciSupervisor selectedSupervisor;
    protected DeploymentTreeController ctrl;
    protected boolean isViewFrozen;
    protected final ManagerConnectionExceptionHandler mce = new ManagerConnectionExceptionHandler();

    public DeploymentTree(DeploymentTreeController ctrl) {
        this(ctrl, true);
    }

    public DeploymentTree(DeploymentTreeController ctrl, boolean allowControl) {
        super(new MaciInfo.SortingTreeNode("Deployment Info"));
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        ToolTipManager.sharedInstance().registerComponent(this);
        this.cellRenderer = new Renderer();
        this.setCellRenderer(this.cellRenderer);
        this.treeEventForwarder = new TreeEventForwarder(this.getTreeModel());
        this.modelConverters = new Vector<ModelConverter>();
        this.clientContextMenu = new ClientContextMenu(allowControl);
        this.managerContextMenu = new ManagerContextMenu(allowControl);
        this.containerContextMenu = new ContainerContextMenu(allowControl);
        this.componentContextMenu = new ComponentContextMenu(allowControl);
        this.folderContextMenu = new FolderContextMenu(allowControl);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (SwingUtilities.isRightMouseButton(evt)) {
                    DeploymentTree.this.showContextMenu(evt);
                }
            }
        });
        this.getSelectionModel().addTreeSelectionListener(new SelectionListener());
        this.ctrl = ctrl;
    }

    private void runSwingNow(Runnable r) {
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(r);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void showContextMenu(MouseEvent evt) {
        ContextMenu menu;
        TreePath targetPath = this.getClosestPathForLocation(evt.getX(), evt.getY());
        if (targetPath == null) {
            return;
        }
        this.setSelectionPath(targetPath);
        if (targetPath.getPathCount() == 1) {
            return;
        }
        this.selectedSupervisor = this.maciSupervisor((MaciInfo.SortingTreeNode)targetPath.getPathComponent(1));
        this.target = (MaciInfo.SortingTreeNode)targetPath.getLastPathComponent();
        java.lang.Object userObject = this.target.getUserObject();
        if (userObject instanceof IMaciSupervisor) {
            menu = this.managerContextMenu;
        } else if (userObject instanceof ContainerInfo) {
            menu = this.containerContextMenu;
        } else if (userObject instanceof ClientInfo) {
            menu = this.clientContextMenu;
        } else if (userObject instanceof ComponentInfo) {
            menu = this.componentContextMenu;
        } else if (userObject instanceof MaciInfo.FolderInfo) {
            menu = this.folderContextMenu;
        } else if (userObject instanceof MaciInfo.InfoDetail) {
            menu = new ContextMenu(false);
            int[] selectedHandles = ((MaciInfo.SortingTreeNode)this.target).representedHandles;
            if (selectedHandles.length > 0) {
                menu.add(new JLabel(" Scroll to ..."));
                menu.add(new JSeparator(0));
                MaciInfo.SortingTreeNode mgrNode = (MaciInfo.SortingTreeNode)this.target.getPath()[1];
                ArrayList<TreeNode> list = new ArrayList<TreeNode>();
                list.add(mgrNode);
                for (MaciInfo.SortingTreeNode top : mgrNode.childrens()) {
                    list.addAll(Collections.list(top.children()));
                }
                Iterator<MaciInfo.SortingTreeNode> iterator = list.iterator();
                while (iterator.hasNext()) {
                    MaciInfo.SortingTreeNode obj;
                    final MaciInfo.SortingTreeNode elem = obj = iterator.next();
                    for (int i = 0; i < selectedHandles.length; ++i) {
                        if (!elem.represents(selectedHandles[i])) continue;
                        java.lang.Object elemUserObject = elem.getUserObject();
                        String elemName = null;
                        if (elemUserObject instanceof ComponentInfo) {
                            elemName = ((ComponentInfo)elemUserObject).name;
                        } else if (elemUserObject instanceof ContainerInfo) {
                            elemName = ((ContainerInfo)elemUserObject).name;
                        } else if (elemUserObject instanceof ClientInfo) {
                            elemName = ((ClientInfo)elemUserObject).name;
                        } else if (elemUserObject instanceof MaciSupervisor) {
                            elemName = "Manager";
                        }
                        if (elemName == null) continue;
                        menu.add(new AbstractAction(selectedHandles[i] + " = " + elemName){

                            @Override
                            public void actionPerformed(ActionEvent evt) {
                                DeploymentTree.this.scrollPathToVisible(new TreePath(elem.getPath()));
                            }
                        });
                    }
                }
            }
        } else {
            return;
        }
        menu.show(this, evt.getX(), evt.getY());
    }

    protected GuiMaciSupervisor maciSupervisor(DefaultMutableTreeNode managerNode) {
        return (GuiMaciSupervisor)managerNode.getUserObject();
    }

    protected MaciInfo.SortingTreeNode getRoot() {
        return (MaciInfo.SortingTreeNode)super.getModel().getRoot();
    }

    protected DefaultTreeModel getTreeModel() {
        return (DefaultTreeModel)super.getModel();
    }

    protected GuiMaciSupervisor getMaciSupervisor(String managerLoc) throws Firestarter.OrbInitException {
        GuiMaciSupervisor mrf = this.ctrl.giveMaciSupervisor(managerLoc);
        mrf.setConnectsAutomatically(false);
        return mrf;
    }

    protected void startAndAddMaciSupervisor(GuiMaciSupervisor mrf) throws NoPermissionEx, IMaciSupervisor.CannotRetrieveManagerException, IMaciSupervisor.CorbaTransientException, IMaciSupervisor.CorbaNotExistException, IMaciSupervisor.UnknownErrorException {
        mrf.start();
        this.addManager(mrf);
    }

    public void addManager(GuiMaciSupervisor mrfotogen) throws NoPermissionEx, IMaciSupervisor.CorbaTransientException, IMaciSupervisor.CorbaNotExistException, IMaciSupervisor.UnknownErrorException {
        MaciInfo maciInfo = null;
        try {
            maciInfo = mrfotogen.getMaciInfo();
        }
        catch (IMaciSupervisor.NotConnectedToManagerException exc) {
            throw new AssertionError((java.lang.Object)("This supervisor has obviously not been started: " + mrfotogen));
        }
        final MaciInfo.SortingTreeNode managerNode = ((MaciInfo.SortingTreeNode)maciInfo.getRoot()).clone();
        managerNode.setUserObject(mrfotogen);
        DefaultTreeModel guiInfo = new DefaultTreeModel(managerNode);
        ModelConverter mc = new ModelConverter(maciInfo, guiInfo);
        this.modelConverters.add(mc);
        maciInfo.addTreeModelListener(mc);
        this.treeEventForwarder.addSource(guiInfo);
        this.getTreeModel().insertNodeInto(managerNode, this.getRoot(), this.getRoot().getChildCount());
        mc.convertCompleteModel();
        this.runSwingNow(new Runnable(){

            @Override
            public void run() {
                DeploymentTree.this.expandPath(new TreePath(new java.lang.Object[]{DeploymentTree.this.getRoot(), managerNode}));
                DeploymentTree.this.expandPath(new TreePath(new java.lang.Object[]{DeploymentTree.this.getRoot(), managerNode, managerNode.getChildAt(0)}));
                DeploymentTree.this.expandPath(new TreePath(new java.lang.Object[]{DeploymentTree.this.getRoot(), managerNode, managerNode.getChildAt(1)}));
                DeploymentTree.this.expandPath(new TreePath(new java.lang.Object[]{DeploymentTree.this.getRoot(), managerNode, managerNode.getChildAt(2)}));
            }
        });
    }

    public boolean removeManager(String managerLoc, boolean dismissManager) {
        DefaultMutableTreeNode managerNode = this.getManagerNode(managerLoc);
        if (managerNode == null) {
            return false;
        }
        GuiMaciSupervisor ms = this.maciSupervisor(managerNode);
        if (dismissManager) {
            ms.dismissManager();
        }
        for (ModelConverter mc : this.modelConverters) {
            if (this.maciSupervisor(mc.managerNode()) != ms) continue;
            mc.sourceModel.removeTreeModelListener(mc);
            this.modelConverters.remove(mc);
            break;
        }
        this.removeNode(managerNode);
        return true;
    }

    public void refreshManagers() {
        for (MaciInfo.SortingTreeNode managerNode : this.getRoot().childrens()) {
            this.shieldedRefreshManager(this.maciSupervisor(managerNode));
        }
    }

    protected DefaultMutableTreeNode getManagerNode(String managerLoc) {
        String toFind = managerLoc;
        for (MaciInfo.SortingTreeNode managerNode : this.getRoot().childrens()) {
            String managerLocation = this.maciSupervisor(managerNode).getManagerLocation();
            if (!managerLocation.equals(toFind)) continue;
            return managerNode;
        }
        return null;
    }

    protected boolean isMyself(DefaultMutableTreeNode node) {
        try {
            DefaultMutableTreeNode n = node;
            while (!((n = (DefaultMutableTreeNode)n.getParent()).getUserObject() instanceof IMaciSupervisor)) {
            }
            ClientInfo info = (ClientInfo)node.getUserObject();
            return this.maciSupervisor(n).myMaciHandle() == info.h;
        }
        catch (Exception e) {
            return false;
        }
    }

    protected void removeNode(DefaultMutableTreeNode node) {
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
        int index = parent.getIndex(node);
        parent.remove(node);
        this.getTreeModel().nodesWereRemoved(parent, new int[]{index}, new java.lang.Object[]{node});
    }

    protected void setBusy(boolean b) {
        int cursor = b ? 3 : 0;
        this.setCursor(Cursor.getPredefinedCursor(cursor));
    }

    public void setViewFrozen(boolean newValue) {
        this.isViewFrozen = newValue;
        if (!newValue) {
            for (ModelConverter mc : this.modelConverters) {
                mc.convertCompleteModelIfDirty();
            }
        }
    }

    public boolean isViewFrozen() {
        return this.isViewFrozen;
    }

    void applyFilters(DefaultTreeModel tm) {
        MaciInfo.SortingTreeNode mgrNode = (MaciInfo.SortingTreeNode)tm.getRoot();
        for (MaciInfo.SortingTreeNode folder : mgrNode.childrens()) {
            this.applyFilter(folder);
        }
    }

    void applyFilter(MaciInfo.SortingTreeNode folder) {
        MaciInfo.FolderInfo folderInfo = (MaciInfo.FolderInfo)folder.getUserObject();
        for (MaciInfo.SortingTreeNode entry : folder.childrens()) {
            String caption = this.cellRenderer.getCaptions(entry)[0];
            boolean passes = !folderInfo.hasFilter() || caption.contains(folderInfo.filter);
            Enumeration<TreeNode> subtree = entry.breadthFirstEnumeration();
            while (subtree.hasMoreElements()) {
                ((MaciInfo.SortingTreeNode)subtree.nextElement()).filtered = !passes;
            }
        }
    }

    public void shieldedRefreshManager(GuiMaciSupervisor supervisor) {
        try {
            supervisor.getMaciInfo();
        }
        catch (NoPermissionEx exc) {
            this.mce.handleException(supervisor, exc);
        }
        catch (IMaciSupervisor.NotConnectedToManagerException exc) {
            this.mce.handleException(supervisor, exc);
        }
        catch (IMaciSupervisor.CorbaTransientException exc) {
            this.mce.handleException(supervisor, exc);
        }
        catch (IMaciSupervisor.CorbaNotExistException exc) {
            this.mce.handleException(supervisor, exc);
        }
        catch (IMaciSupervisor.UnknownErrorException exc) {
            this.mce.handleException((IMaciSupervisor)supervisor, exc);
        }
    }

    public void shieldedAddManager(String managerLoc) {
        GuiMaciSupervisor supervisor = null;
        try {
            supervisor = this.getMaciSupervisor(managerLoc);
        }
        catch (Firestarter.OrbInitException exc1) {
            this.mce.handleException(exc1);
        }
        try {
            this.startAndAddMaciSupervisor(supervisor);
        }
        catch (IMaciSupervisor.CannotRetrieveManagerException exc) {
            this.mce.handleException(supervisor, exc);
        }
        catch (NoPermissionEx exc) {
            this.mce.handleException(supervisor, exc);
        }
        catch (IMaciSupervisor.CorbaTransientException exc) {
            this.mce.handleException(supervisor, exc);
        }
        catch (IMaciSupervisor.CorbaNotExistException exc) {
            this.mce.handleException(supervisor, exc);
        }
        catch (IMaciSupervisor.UnknownErrorException exc) {
            this.mce.handleException((IMaciSupervisor)supervisor, exc);
        }
    }

    public void shieldedPingManager(GuiMaciSupervisor supervisor) {
        try {
            supervisor.managerPing();
        }
        catch (IMaciSupervisor.NotConnectedToManagerException exc) {
            this.mce.handleException(supervisor, exc);
        }
        catch (IMaciSupervisor.CorbaTransientException exc) {
            this.mce.handleException(supervisor, exc);
        }
        catch (IMaciSupervisor.CorbaNotExistException exc) {
            this.mce.handleException(supervisor, exc);
        }
        catch (IMaciSupervisor.UnknownErrorException exc) {
            this.mce.handleException((IMaciSupervisor)supervisor, exc);
        }
    }

    public void shieldedShutdownManager(GuiMaciSupervisor supervisor) {
        try {
            supervisor.managerShutdown();
        }
        catch (IMaciSupervisor.NotConnectedToManagerException exc) {
            this.mce.handleException(supervisor, exc);
        }
        catch (IMaciSupervisor.CorbaNoPermissionException exc) {
            this.mce.handleException(supervisor, exc);
        }
        catch (IMaciSupervisor.CorbaTransientException exc) {
            this.mce.handleException(supervisor, exc);
        }
        catch (IMaciSupervisor.CorbaNotExistException exc) {
            this.mce.handleException(supervisor, exc);
        }
        catch (IMaciSupervisor.UnknownErrorException exc) {
            this.mce.handleException((IMaciSupervisor)supervisor, exc);
        }
    }

    public void shieldedLogoutContainer(GuiMaciSupervisor supervisor, ContainerInfo info) {
        try {
            supervisor.managerLogout(info);
        }
        catch (NoPermissionEx exc) {
            this.mce.handleException(supervisor, exc);
        }
        catch (IMaciSupervisor.NotConnectedToManagerException exc) {
            this.mce.handleException(supervisor, exc);
        }
        catch (IMaciSupervisor.CorbaTransientException exc) {
            this.mce.handleException(supervisor, exc);
        }
        catch (IMaciSupervisor.CorbaNotExistException exc) {
            this.mce.handleException(supervisor, exc);
        }
        catch (IMaciSupervisor.UnknownErrorException exc) {
            this.mce.handleException((IMaciSupervisor)supervisor, exc);
        }
    }

    public void shieldedLogoutClient(GuiMaciSupervisor supervisor, ClientInfo info) {
        try {
            supervisor.managerLogout(info);
        }
        catch (NoPermissionEx exc) {
            this.mce.handleException(supervisor, exc);
        }
        catch (IMaciSupervisor.NotConnectedToManagerException exc) {
            this.mce.handleException(supervisor, exc);
        }
        catch (IMaciSupervisor.CorbaTransientException exc) {
            this.mce.handleException(supervisor, exc);
        }
        catch (IMaciSupervisor.CorbaNotExistException exc) {
            this.mce.handleException(supervisor, exc);
        }
        catch (IMaciSupervisor.UnknownErrorException exc) {
            this.mce.handleException((IMaciSupervisor)supervisor, exc);
        }
    }

    public Object shieldedGetComponent(GuiMaciSupervisor supervisor, String curl) throws ComponentNotAlreadyActivatedEx, CannotGetComponentEx, ComponentConfigurationNotFoundEx {
        try {
            return supervisor.managerGetComponent(curl);
        }
        catch (NoPermissionEx exc) {
            this.mce.handleException(supervisor, exc);
        }
        catch (IMaciSupervisor.NotConnectedToManagerException exc) {
            this.mce.handleException(supervisor, exc);
        }
        catch (IMaciSupervisor.CorbaTransientException exc) {
            this.mce.handleException(supervisor, exc);
        }
        catch (IMaciSupervisor.CorbaNotExistException exc) {
            this.mce.handleException(supervisor, exc);
        }
        catch (IMaciSupervisor.UnknownErrorException exc) {
            this.mce.handleException((IMaciSupervisor)supervisor, exc);
        }
        return null;
    }

    public void shieldedReleaseComponents(GuiMaciSupervisor supervisor, String[] curls) {
        try {
            supervisor.managerReleaseComponents(curls);
        }
        catch (IMaciSupervisor.CorbaUnknownException corbaUnknownException) {
        }
        catch (NoPermissionEx exc) {
            this.mce.handleException(supervisor, exc);
        }
        catch (IMaciSupervisor.NotConnectedToManagerException exc) {
            this.mce.handleException(supervisor, exc);
        }
        catch (IMaciSupervisor.CorbaTransientException exc) {
            this.mce.handleException(supervisor, exc);
        }
        catch (IMaciSupervisor.CorbaNotExistException exc) {
            this.mce.handleException(supervisor, exc);
        }
        catch (IMaciSupervisor.UnknownErrorException exc) {
            this.mce.handleException((IMaciSupervisor)supervisor, exc);
        }
        catch (AcsJCannotDeactivateComponentEx ex) {
            this.mce.handleException(supervisor, ex);
        }
        catch (AcsJComponentDeactivationUncleanEx ex) {
            this.mce.handleException(supervisor, ex);
        }
        catch (AcsJComponentDeactivationFailedEx ex) {
            this.mce.handleException(supervisor, ex);
        }
    }

    public void shieldedForceReleaseComponent(GuiMaciSupervisor supervisor, String curl) {
        try {
            supervisor.managerForceReleaseComponent(curl);
        }
        catch (NoPermissionEx exc) {
            this.mce.handleException(supervisor, exc);
        }
        catch (IMaciSupervisor.NotConnectedToManagerException exc) {
            this.mce.handleException(supervisor, exc);
        }
        catch (IMaciSupervisor.CorbaTransientException exc) {
            this.mce.handleException(supervisor, exc);
        }
        catch (IMaciSupervisor.CorbaNotExistException exc) {
            this.mce.handleException(supervisor, exc);
        }
        catch (IMaciSupervisor.UnknownErrorException exc) {
            this.mce.handleException((IMaciSupervisor)supervisor, exc);
        }
    }

    protected class ManagerConnectionExceptionHandler {
        protected ManagerConnectionExceptionHandler() {
        }

        protected void handleException(Firestarter.OrbInitException exc) {
            String msg = "Failed to initialize local orb. This prevents all corba connectivity.";
            ErrorBox.showErrorDialog((Component)DeploymentTree.this, msg, exc);
        }

        protected void handleException(GuiMaciSupervisor ms, NoPermissionEx exc) {
            this.seemsManagerHasChangedOrHasCutConnection(ms);
        }

        protected void handleException(GuiMaciSupervisor ms, IMaciSupervisor.CorbaNoPermissionException exc) {
            this.seemsManagerHasChangedOrHasCutConnection(ms);
        }

        protected void handleException(GuiMaciSupervisor ms, IMaciSupervisor.NotConnectedToManagerException exc) {
            this.seemsWeHaveDisconnected(ms);
        }

        protected void handleException(GuiMaciSupervisor ms, IMaciSupervisor.CannotRetrieveManagerException exc) {
            this.seemsManagerDoesNotExist(ms);
        }

        protected void handleException(GuiMaciSupervisor ms, IMaciSupervisor.CorbaNotExistException exc) {
            this.seemsManagerDoesNotExist(ms);
        }

        protected void handleException(GuiMaciSupervisor ms, IMaciSupervisor.CorbaTransientException exc) {
            this.seemsManagerIsDown(ms);
        }

        protected void handleException(IMaciSupervisor ms, IMaciSupervisor.UnknownErrorException exc) {
            String msg = "Unforeseen error talking to manager! Please report this to the Acs team.";
            ErrorBox.showErrorDialog((Component)DeploymentTree.this, msg, exc);
        }

        protected void handleException(GuiMaciSupervisor ms, AcsJCannotDeactivateComponentEx exc) {
            this.seemsComponentDeactivationFailed(ms);
        }

        protected void handleException(GuiMaciSupervisor ms, AcsJComponentDeactivationUncleanEx exc) {
            this.seemsComponentDeactivationFailed(ms);
        }

        protected void handleException(GuiMaciSupervisor ms, AcsJComponentDeactivationFailedEx exc) {
            this.seemsComponentDeactivationFailed(ms);
        }

        protected void seemsManagerIsDown(GuiMaciSupervisor ms) {
            String managerLoc = ms.getManagerLocation();
            String msg = "Seems the manager at " + managerLoc + " is down.\nOk to remove it from the View?";
            int answer = JOptionPane.showConfirmDialog(DeploymentTree.this, msg, "Communication Failed", 0);
            try {
                if (answer == 0) {
                    DeploymentTree.this.removeManager(managerLoc, false);
                }
            }
            catch (Exception exc1) {
                ErrorBox.showErrorDialog((Component)DeploymentTree.this, "Failed to remove manager from view", exc1);
            }
        }

        protected void seemsManagerHasChangedOrHasCutConnection(GuiMaciSupervisor ms) {
            String managerLoc = ms.getManagerLocation();
            String msg = "Seems the manager at " + managerLoc + " has changed or\nhas cut the connection. Will try to reconnect.";
            JOptionPane.showMessageDialog(DeploymentTree.this, msg, "Communication Failed", 1);
            try {
                DeploymentTree.this.removeManager(managerLoc, true);
                ms.start();
                DeploymentTree.this.addManager(ms);
            }
            catch (Exception exc1) {
                ErrorBox.showMessageDialog(DeploymentTree.this, "Failed to reconnect to manager", false);
            }
        }

        protected void seemsWeHaveDisconnected(GuiMaciSupervisor ms) {
            String managerLoc = ms.getManagerLocation();
            String msg = "I have no connection to the manager at " + managerLoc + ".\nDo you want to connect now?";
            int answer = JOptionPane.showConfirmDialog(DeploymentTree.this, msg, "Communication Failed", 0);
            try {
                if (answer == 0) {
                    DeploymentTree.this.removeManager(managerLoc, true);
                    ms.start();
                    DeploymentTree.this.addManager(ms);
                }
            }
            catch (Exception exc1) {
                ErrorBox.showMessageDialog(DeploymentTree.this, "Failed to connect to manager", false);
            }
        }

        protected void seemsManagerDoesNotExist(GuiMaciSupervisor ms) {
            String managerLoc = ms.getManagerLocation();
            String msg = "No manager exists at " + managerLoc + ".\nDo you want to retry to connect?";
            while (true) {
                int answer = JOptionPane.showConfirmDialog(DeploymentTree.this, msg, "Communication Failed", 0);
                try {
                    if (answer != 0) break;
                    ms.start();
                    DeploymentTree.this.addManager(ms);
                }
                catch (Exception exc) {
                    continue;
                }
                break;
            }
        }

        private void seemsComponentDeactivationFailed(GuiMaciSupervisor ms) {
            String msg = "The manager reported a problem taking down the component.\nThe component may still be active.";
            ErrorBox.showMessageDialog(DeploymentTree.this, msg, true);
        }
    }

    protected class ComponentForceReleaseAction
    extends BackgroundAction {
        protected ComponentForceReleaseAction() {
            super("Force system-wide deactivation");
        }

        @Override
        public void actionPerformed() throws Exception {
            String name = ((ComponentInfo)DeploymentTree.this.target.getUserObject()).name;
            DeploymentTree.this.shieldedForceReleaseComponent(DeploymentTree.this.selectedSupervisor, name);
        }
    }

    protected class ComponentReleaseAction
    extends BackgroundAction {
        protected ComponentReleaseAction() {
            super("Release reference");
        }

        @Override
        public void actionPerformed() throws Exception {
            String name = ((ComponentInfo)DeploymentTree.this.target.getUserObject()).name;
            DeploymentTree.this.shieldedReleaseComponents(DeploymentTree.this.selectedSupervisor, new String[]{name});
        }
    }

    protected class ComponentRequestAction
    extends BackgroundAction {
        protected ComponentRequestAction() {
            super("Acquire reference ( Activate )");
        }

        @Override
        public void actionPerformed() throws Exception {
            String name = ((ComponentInfo)DeploymentTree.this.target.getUserObject()).name;
            DeploymentTree.this.shieldedGetComponent(DeploymentTree.this.selectedSupervisor, name);
        }
    }

    protected class ClientLogoutAction
    extends BackgroundAction {
        protected ClientLogoutAction() {
            super("Have logged out by Manager");
        }

        @Override
        public void actionPerformed() throws Exception {
            DeploymentTree.this.shieldedLogoutClient(DeploymentTree.this.selectedSupervisor, (ClientInfo)DeploymentTree.this.target.getUserObject());
        }
    }

    protected class ContainerLogoutAction
    extends BackgroundAction {
        protected ContainerLogoutAction() {
            super("Have logged out by Manager");
        }

        @Override
        public void actionPerformed() throws Exception {
            DeploymentTree.this.shieldedLogoutContainer(DeploymentTree.this.selectedSupervisor, (ContainerInfo)DeploymentTree.this.target.getUserObject());
        }
    }

    protected class ClientMessageAction
    extends BackgroundAction {
        protected ClientMessageAction() {
            super("Send Message...");
        }

        @Override
        public void actionPerformed() throws Exception {
            String msg = JOptionPane.showInputDialog(DeploymentTree.this, (java.lang.Object)"Enter message text:");
            if (msg != null) {
                DeploymentTree.this.selectedSupervisor.clientMessage((ClientInfo)DeploymentTree.this.target.getUserObject(), (short)20, msg);
            }
        }
    }

    protected class ClientDisconnectAction
    extends BackgroundAction {
        protected ClientDisconnectAction() {
            super("Send Disconnect Request");
        }

        @Override
        public void actionPerformed() throws Exception {
            DeploymentTree.this.selectedSupervisor.clientDisconnect((ClientInfo)DeploymentTree.this.target.getUserObject());
        }
    }

    protected class ContainerDisconnectAction
    extends BackgroundAction {
        protected ContainerDisconnectAction() {
            super("Send Disconnect Request");
        }

        @Override
        public void actionPerformed() throws Exception {
            DeploymentTree.this.selectedSupervisor.containerDisconnect((ContainerInfo)DeploymentTree.this.target.getUserObject());
        }
    }

    protected class ClientPingAction
    extends BackgroundAction {
        protected ClientPingAction() {
            super("Send Ping Request");
        }

        @Override
        public void actionPerformed() throws Exception {
            DeploymentTree.this.selectedSupervisor.clientPing((ClientInfo)DeploymentTree.this.target.getUserObject());
        }
    }

    protected class ContainerMessageAction
    extends BackgroundAction {
        protected ContainerMessageAction() {
            super("Send Message...");
        }

        @Override
        public void actionPerformed() throws Exception {
            String msg = JOptionPane.showInputDialog(DeploymentTree.this, (java.lang.Object)"Enter message text:");
            if (msg != null) {
                DeploymentTree.this.selectedSupervisor.containerMessage((ContainerInfo)DeploymentTree.this.target.getUserObject(), (short)20, msg);
            }
        }
    }

    protected class ContainerShutdownAction
    extends BackgroundAction {
        protected ContainerShutdownAction() {
            super("Send Shutdown Request");
        }

        @Override
        public void actionPerformed() throws Exception {
            DeploymentTree.this.selectedSupervisor.containerShutdown((ContainerInfo)DeploymentTree.this.target.getUserObject());
        }
    }

    protected class ContainerPingAction
    extends BackgroundAction {
        protected ContainerPingAction() {
            super("Send Ping Request");
        }

        @Override
        public void actionPerformed() throws Exception {
            DeploymentTree.this.selectedSupervisor.containerPing((ContainerInfo)DeploymentTree.this.target.getUserObject());
        }
    }

    protected class ManagerShutdownAction
    extends BackgroundAction {
        protected ManagerShutdownAction() {
            super("Send Shutdown Request");
        }

        @Override
        public void actionPerformed() throws Exception {
            DeploymentTree.this.shieldedShutdownManager(DeploymentTree.this.selectedSupervisor);
        }
    }

    protected class ManagerPingAction
    extends BackgroundAction {
        protected ManagerPingAction() {
            super("Send Ping Request");
        }

        @Override
        public void actionPerformed() {
            DeploymentTree.this.shieldedPingManager(DeploymentTree.this.selectedSupervisor);
        }
    }

    protected class ManagerRefreshAction
    extends BackgroundAction {
        protected ManagerRefreshAction() {
            super("Refresh Info");
        }

        @Override
        public void actionPerformed() {
            DeploymentTree.this.shieldedRefreshManager(DeploymentTree.this.selectedSupervisor);
        }
    }

    protected class RemoveFromViewAction
    extends SwingAction {
        protected RemoveFromViewAction() {
            super("Remove from View");
        }

        @Override
        public void actionPerformed() {
            DeploymentTree.this.removeNode(DeploymentTree.this.target);
        }
    }

    protected abstract class BackgroundAction
    extends AbstractAction {
        protected BackgroundAction(String name) {
            super(name);
        }

        @Override
        public final void actionPerformed(ActionEvent e) {
            DeploymentTree.this.ctrl.getBackgroundExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    DeploymentTree.this.setBusy(true);
                    try {
                        BackgroundAction.this.actionPerformed();
                    }
                    catch (Exception exc) {
                        ErrorBox.showErrorDialog((Component)DeploymentTree.this, "\"" + BackgroundAction.this.getValue("Name") + "\" failed", exc);
                    }
                    finally {
                        DeploymentTree.this.setBusy(false);
                    }
                }
            });
        }

        protected abstract void actionPerformed() throws Exception;
    }

    protected abstract class SwingAction
    extends AbstractAction {
        protected SwingAction(String name) {
            super(name);
        }

        @Override
        public final void actionPerformed(ActionEvent e) {
            try {
                this.actionPerformed();
            }
            catch (Exception exc) {
                ErrorBox.showErrorDialog((Component)DeploymentTree.this, "\"" + this.getValue("Name") + "\" failed", exc);
            }
        }

        protected abstract void actionPerformed();
    }

    protected class ComponentContextMenu
    extends ContextMenu {
        protected ComponentContextMenu(boolean allowControl) {
            super(allowControl);
            if (allowControl) {
                this.add(new ComponentRequestAction());
                this.add(new ComponentReleaseAction());
                this.add(new JPopupMenu.Separator());
                this.add(new ComponentForceReleaseAction());
            }
        }
    }

    protected class ClientContextMenu
    extends ContextMenu {
        protected ClientContextMenu(boolean allowControl) {
            super(allowControl);
            if (allowControl) {
                this.add(new ClientPingAction());
                this.add(new ClientMessageAction());
                this.add(new ClientDisconnectAction());
                this.add(new JPopupMenu.Separator());
                this.add(new ClientLogoutAction());
            }
        }
    }

    protected class ContainerContextMenu
    extends ContextMenu {
        protected ContainerContextMenu(boolean allowControl) {
            super(allowControl);
            if (allowControl) {
                this.add(new ContainerPingAction());
                this.add(new ContainerMessageAction());
                this.add(new ContainerDisconnectAction());
                this.add(new ContainerShutdownAction());
                this.add(new JPopupMenu.Separator());
                this.add(new ContainerLogoutAction());
            }
        }
    }

    protected class FolderContextMenu
    extends ContextMenu {
        protected JTextField txtFilter;

        protected FolderContextMenu(boolean allowControl) {
            super(allowControl);
            this.txtFilter = new JTextField(8);
            Box b = Box.createHorizontalBox();
            b.add(new JLabel(" Show only "));
            b.add(this.txtFilter);
            b.add(new JLabel(" "));
            this.add(b);
            this.add(new JSeparator(0));
            this.add(new AbstractAction("Apply"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ((MaciInfo.FolderInfo)DeploymentTree.this.target.getUserObject()).filter = FolderContextMenu.this.txtFilter.getText().trim();
                    DeploymentTree.this.applyFilter((MaciInfo.SortingTreeNode)DeploymentTree.this.target);
                    DeploymentTree.this.getTreeModel().reload(DeploymentTree.this.target);
                }
            });
            this.add(new AbstractAction("Reset"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FolderContextMenu.this.txtFilter.setText(null);
                    ((MaciInfo.FolderInfo)DeploymentTree.this.target.getUserObject()).filter = FolderContextMenu.this.txtFilter.getText().trim();
                    DeploymentTree.this.applyFilter((MaciInfo.SortingTreeNode)DeploymentTree.this.target);
                    DeploymentTree.this.getTreeModel().reload(DeploymentTree.this.target);
                }
            });
        }

        @Override
        protected void firePopupMenuWillBecomeVisible() {
            this.txtFilter.setText(((MaciInfo.FolderInfo)DeploymentTree.this.target.getUserObject()).filter);
            super.firePopupMenuWillBecomeVisible();
        }
    }

    protected class ManagerContextMenu
    extends ContextMenu {
        protected ManagerContextMenu(boolean allowControl) {
            super(allowControl);
            this.add(new ManagerRefreshAction());
            if (allowControl) {
                this.add(new JPopupMenu.Separator());
                this.add(new ManagerPingAction());
                this.add(new ManagerShutdownAction());
            }
        }
    }

    protected class ContextMenu
    extends JPopupMenu {
        protected ContextMenu(boolean allowControl) {
        }

        @Override
        public void show(Component invoker, int x, int y) {
            if (this.getComponentCount() == 0) {
                return;
            }
            super.show(invoker, x, y);
        }
    }

    protected class TreeEventForwarder
    implements TreeModelListener {
        protected DefaultTreeModel forwardTarget;

        public TreeEventForwarder(DefaultTreeModel forwardTarget) {
            this.forwardTarget = forwardTarget;
        }

        public void addSource(TreeModel source) {
            source.addTreeModelListener(this);
        }

        @Override
        public synchronized void treeStructureChanged(TreeModelEvent e) {
            TreeNode n = (TreeNode)e.getTreePath().getLastPathComponent();
            this.forwardTarget.nodeStructureChanged(n);
        }

        @Override
        public void treeNodesChanged(TreeModelEvent e) {
            TreeNode n = (TreeNode)e.getTreePath().getLastPathComponent();
            this.forwardTarget.nodesChanged(n, e.getChildIndices());
        }

        @Override
        public void treeNodesInserted(TreeModelEvent e) {
            TreeNode n = (TreeNode)e.getTreePath().getLastPathComponent();
            this.forwardTarget.nodesWereInserted(n, e.getChildIndices());
        }

        @Override
        public void treeNodesRemoved(TreeModelEvent e) {
            TreeNode n = (TreeNode)e.getTreePath().getLastPathComponent();
            this.forwardTarget.nodesWereRemoved(n, e.getChildIndices(), e.getChildren());
        }
    }

    protected class ModelConverter
    implements TreeModelListener {
        protected MaciInfo sourceModel;
        protected DefaultTreeModel targetModel;
        protected boolean isDirty;
        protected final TreeNodeMerger treemerger;
        private AtomicBoolean jmmFlushRefresh;

        public ModelConverter(MaciInfo sourceModel, DefaultTreeModel targetModel) {
            this.treemerger = new TreeNodeMerger();
            this.jmmFlushRefresh = new AtomicBoolean();
            this.sourceModel = sourceModel;
            this.targetModel = targetModel;
        }

        public DefaultMutableTreeNode managerNode() {
            return (DefaultMutableTreeNode)this.targetModel.getRoot();
        }

        protected void convertCompleteModelIfDirty() {
            if (this.isDirty) {
                this.isDirty = false;
                this.convertCompleteModel();
            }
        }

        @Override
        public void treeNodesChanged(TreeModelEvent e) {
        }

        @Override
        public void treeNodesInserted(TreeModelEvent e) {
        }

        @Override
        public void treeNodesRemoved(TreeModelEvent e) {
        }

        @Override
        public void treeStructureChanged(TreeModelEvent e) {
            if (DeploymentTree.this.isViewFrozen()) {
                this.isDirty = true;
                return;
            }
            this.convertCompleteModel();
            DeploymentTree.this.applyFilters(this.targetModel);
        }

        protected void convertCompleteModel() {
            this.treemerger.diff(this.targetModel, this.sourceModel);
            if (!this.treemerger.areEqual()) {
                this.jmmFlushRefresh.set(true);
                DeploymentTree.this.runSwingNow(new Runnable(){

                    @Override
                    public void run() {
                        ModelConverter.this.jmmFlushRefresh.get();
                        ModelConverter.this.treemerger.merge();
                    }
                });
            }
        }
    }

    protected class TreeNodeMerger {
        protected List<ListTreeNodeInfo> listdiff = new ArrayList<ListTreeNodeInfo>();
        protected boolean equal = true;
        protected DefaultTreeModel tmodel;
        protected DefaultTreeModel smodel;

        protected void clear() {
            this.listdiff.clear();
            this.tmodel = null;
            this.smodel = null;
            this.equal = true;
        }

        protected boolean areEqual() {
            return this.equal;
        }

        protected MutableTreeNode deepcopy(TreeNode tn) {
            MutableTreeNode copy = (MutableTreeNode)((DefaultMutableTreeNode)tn).clone();
            int i = 0;
            for (TreeNode treeNode : Collections.list(tn.children())) {
                copy.insert(this.deepcopy(treeNode), i++);
            }
            return copy;
        }

        protected void diff(DefaultTreeModel targetModel, DefaultTreeModel sourceModel) {
            this.clear();
            this.tmodel = targetModel;
            this.smodel = sourceModel;
            this.diff((TreeNode)targetModel.getRoot(), (TreeNode)sourceModel.getRoot());
            this.equal = this.listdiff.size() == 0;
        }

        protected void diff(TreeNode target, TreeNode source) {
            ArrayList<TreeNode> tchild = Collections.list(target.children());
            ArrayList<TreeNode> schild = Collections.list(source.children());
            ListTreeNodeInfo nodediff = new ListTreeNodeInfo(target, source, tchild, schild);
            nodediff.diff();
            if (!nodediff.areEqual()) {
                this.listdiff.add(nodediff);
            }
            for (TreeNode tn : nodediff.getUnchanged()) {
                this.diff(tn, nodediff.getDuplicate(tn));
            }
            for (TreeNode tn : nodediff.getUpdated()) {
                this.diff(tn, nodediff.getUpdate(tn));
            }
        }

        protected void merge() {
            for (ListTreeNodeInfo nodediff : this.listdiff) {
                MutableTreeNode tparent = (MutableTreeNode)nodediff.getTargetParent();
                MutableTreeNode sparent = (MutableTreeNode)nodediff.getSourceParent();
                int[] uindex = new int[nodediff.getUpdated().size()];
                int i = 0;
                for (TreeNode treeNode : nodediff.getUpdated()) {
                    uindex[i++] = tparent.getIndex(treeNode);
                    TreeNode sn = nodediff.getUpdate(treeNode);
                    ((DefaultMutableTreeNode)treeNode).setUserObject(((DefaultMutableTreeNode)sn).getUserObject());
                    if (!(treeNode instanceof MaciInfo.SortingTreeNode) || !(sn instanceof MaciInfo.SortingTreeNode)) continue;
                    ((MaciInfo.SortingTreeNode)treeNode).representedHandles = ((MaciInfo.SortingTreeNode)sn).representedHandles;
                }
                if (nodediff.getUpdated().size() > 0) {
                    this.tmodel.nodesChanged(tparent, uindex);
                }
                int[] rindex = new int[nodediff.getRemoved().size()];
                i = 0;
                for (TreeNode tn3 : nodediff.getRemoved()) {
                    rindex[i++] = tparent.getIndex(tn3);
                    ((MutableTreeNode)tn3).removeFromParent();
                }
                if (nodediff.getRemoved().size() > 0) {
                    this.tmodel.nodesWereRemoved(tparent, rindex, nodediff.getRemoved().toArray());
                }
                ArrayList arrayList = new ArrayList();
                int[] aindex = new int[nodediff.getAdded().size()];
                i = 0;
                for (TreeNode tn4 : nodediff.getAdded()) {
                    aindex[i++] = sparent.getIndex(tn4);
                    tparent.insert(this.deepcopy(tn4), aindex[i - 1]);
                }
                if (nodediff.getAdded().size() <= 0) continue;
                this.tmodel.nodesWereInserted(tparent, aindex);
            }
            this.clear();
        }
    }

    protected class ListTreeNodeInfo {
        protected TreeNode tparent = null;
        protected TreeNode sparent = null;
        protected List<TreeNode> tchilds = null;
        protected List<TreeNode> schilds = null;
        protected List<TreeNode> added = new ArrayList<TreeNode>();
        protected List<TreeNode> updated = new ArrayList<TreeNode>();
        protected List<TreeNode> updates = new ArrayList<TreeNode>();
        protected List<TreeNode> removed = new ArrayList<TreeNode>();
        protected List<TreeNode> changed = new ArrayList<TreeNode>();
        protected List<TreeNode> unchanged = new ArrayList<TreeNode>();
        protected List<TreeNode> duplicates = new ArrayList<TreeNode>();
        protected boolean equal = true;
        protected final Equator<TreeNode> treeIdentify = new Equator<TreeNode>(){

            public boolean equate(TreeNode tn1, TreeNode tn2) {
                return ListTreeNodeInfo.this.identify(tn1).equals(ListTreeNodeInfo.this.identify(tn2));
            }

            public int hash(TreeNode tn) {
                int hash = 7;
                hash = 31 * hash + ListTreeNodeInfo.this.identify(tn).hashCode();
                return hash;
            }
        };
        protected final Equator<TreeNode> treeUpdate = new Equator<TreeNode>(){

            public boolean equate(TreeNode tn1, TreeNode tn2) {
                if (!ListTreeNodeInfo.this.identify(tn1).equals(ListTreeNodeInfo.this.identify(tn2))) {
                    return false;
                }
                if (tn1.getChildCount() != tn2.getChildCount()) {
                    return true;
                }
                return !String.valueOf(tn1).equals(String.valueOf(tn2));
            }

            public int hash(TreeNode tn) {
                int hash = 7;
                hash = 31 * hash + ListTreeNodeInfo.this.identify(tn).hashCode();
                return hash;
            }
        };

        public ListTreeNodeInfo(TreeNode tparent, TreeNode sparent, List<TreeNode> tchilds, List<TreeNode> schilds) {
            this.tparent = tparent;
            this.sparent = sparent;
            this.tchilds = tchilds;
            this.schilds = schilds;
        }

        protected String identify(TreeNode tn) {
            java.lang.Object obj = ((DefaultMutableTreeNode)tn).getUserObject();
            if (obj instanceof ComponentInfo) {
                return ((ComponentInfo)obj).name;
            }
            if (obj instanceof ClientInfo) {
                return String.valueOf(((ClientInfo)obj).h);
            }
            if (obj instanceof ContainerInfo) {
                return ((ContainerInfo)obj).name;
            }
            if (obj instanceof MaciInfo.FolderInfo) {
                return ((MaciInfo.FolderInfo)obj).name;
            }
            return tn.toString();
        }

        protected void clear() {
            this.added.clear();
            this.updated.clear();
            this.updates.clear();
            this.removed.clear();
            this.changed.clear();
            this.unchanged.clear();
            this.duplicates.clear();
            this.equal = true;
        }

        public boolean areEqual() {
            return this.equal;
        }

        protected void diff() {
            this.clear();
            this.added = new ArrayList<TreeNode>(CollectionUtils.removeAll(this.schilds, this.tchilds, this.treeIdentify));
            this.removed = new ArrayList<TreeNode>(CollectionUtils.removeAll(this.tchilds, this.schilds, this.treeIdentify));
            this.updated = new ArrayList<TreeNode>(CollectionUtils.retainAll(this.tchilds, this.schilds, this.treeUpdate));
            this.updates = new ArrayList<TreeNode>(CollectionUtils.retainAll(this.schilds, this.updated, this.treeIdentify));
            this.changed = new ArrayList<TreeNode>(this.removed);
            this.changed.addAll(this.updated);
            this.unchanged = new ArrayList<TreeNode>(CollectionUtils.removeAll(this.tchilds, this.changed, this.treeIdentify));
            this.duplicates = new ArrayList<TreeNode>(CollectionUtils.retainAll(this.schilds, this.unchanged, this.treeIdentify));
            this.equal = this.added.size() + this.changed.size() == 0;
        }

        public TreeNode getTargetParent() {
            return this.tparent;
        }

        public TreeNode getSourceParent() {
            return this.sparent;
        }

        public List<TreeNode> getUnchanged() {
            return this.unchanged;
        }

        public List<TreeNode> getDuplicates() {
            return this.duplicates;
        }

        public List<TreeNode> getUpdated() {
            return this.updated;
        }

        public List<TreeNode> getUpdates() {
            return this.updates;
        }

        public List<TreeNode> getAdded() {
            return this.added;
        }

        public List<TreeNode> getRemoved() {
            return this.removed;
        }

        public TreeNode getDuplicate(TreeNode tn) {
            for (TreeNode sn : this.duplicates) {
                if (!this.identify(tn).equals(this.identify(sn))) continue;
                return sn;
            }
            return null;
        }

        public TreeNode getUpdate(TreeNode tn) {
            for (TreeNode sn : this.updates) {
                if (!this.identify(tn).equals(this.identify(sn))) continue;
                return sn;
            }
            return null;
        }
    }

    protected class SelectionListener
    implements TreeSelectionListener {
        protected SelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            java.lang.Object node = e.getPath().getLastPathComponent();
            if (node instanceof MaciInfo.SortingTreeNode && !((MaciInfo.SortingTreeNode)node).filtered) {
                DeploymentTree.this.cellRenderer.currentlySelectedHandles = ((MaciInfo.SortingTreeNode)node).representedHandles;
            }
            DeploymentTree.this.repaint();
        }
    }

    protected class Renderer
    extends DefaultTreeCellRenderer {
        Border bluelineBorder = new LineBorder(Color.blue, 1);
        Border graylineBorder = new LineBorder(Color.gray, 1);
        Border emptyBorder = new EmptyBorder(1, 1, 1, 1);
        Color grayBackground = Color.lightGray;
        int[] currentlySelectedHandles = new int[0];
        Component hiddenNode = Box.createRigidArea(new Dimension(0, 0));

        protected Renderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, java.lang.Object value, boolean sel, boolean expand, boolean leaf, int row, boolean foc) {
            super.getTreeCellRendererComponent(tree, value, sel, expand, leaf, row, foc);
            this.setIcon(null);
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            String[] captions = this.getCaptions(node);
            String text = captions[0];
            String tooltip = captions[1];
            this.setText(text);
            this.setToolTipText(tooltip);
            if (node instanceof MaciInfo.SortingTreeNode && ((MaciInfo.SortingTreeNode)node).filtered) {
                return this.hiddenNode;
            }
            Border border = null;
            if (sel) {
                border = this.bluelineBorder;
                if (node instanceof MaciInfo.SortingTreeNode) {
                    this.currentlySelectedHandles = ((MaciInfo.SortingTreeNode)node).representedHandles;
                }
            } else {
                Color backgroundNonSelectionColor = null;
                if (node instanceof MaciInfo.SortingTreeNode) {
                    MaciInfo.SortingTreeNode casted = (MaciInfo.SortingTreeNode)node;
                    for (int i = 0; i < this.currentlySelectedHandles.length; ++i) {
                        if (!casted.represents(this.currentlySelectedHandles[i])) continue;
                        border = this.graylineBorder;
                        backgroundNonSelectionColor = this.grayBackground;
                        break;
                    }
                }
                this.setBackgroundNonSelectionColor(backgroundNonSelectionColor);
                if (border == null) {
                    border = this.emptyBorder;
                }
            }
            this.setBorder(border);
            return this;
        }

        String[] getCaptions(DefaultMutableTreeNode node) {
            java.lang.Object text;
            String tooltip = null;
            java.lang.Object userObject = node.getUserObject();
            if (userObject == null) {
                text = "empty node (strange)";
            } else if (userObject instanceof IMaciSupervisor) {
                String mgrLoc = DeploymentTree.this.maciSupervisor(node).getManagerLocation();
                String[] mgr = AcsLocations.convert((String)mgrLoc);
                text = "Manager on " + mgr[0] + ":" + mgr[1];
            } else if (userObject instanceof ContainerInfo) {
                ContainerInfo casted = (ContainerInfo)userObject;
                int nCOBs = casted.components != null ? casted.components.length : -1;
                text = "'" + casted.name + "' [id " + casted.h + "] : " + nCOBs + " component" + (nCOBs == 1 ? "" : "s");
            } else if (userObject instanceof ClientInfo) {
                ClientInfo casted = (ClientInfo)userObject;
                text = "'" + casted.name + "' [id " + casted.h + "]";
                text = (String)text + (DeploymentTree.this.isMyself(node) ? " (myself)" : "");
            } else if (userObject instanceof ComponentInfo) {
                ComponentInfo casted = (ComponentInfo)userObject;
                int nClients = casted.clients != null ? casted.clients.length : -1;
                text = "'" + casted.name + "' [id " + casted.h + "] : " + nClients + " client" + (nClients == 1 ? "" : "s");
            } else if (userObject instanceof MaciInfo.InfoDetail) {
                MaciInfo.InfoDetail casted = (MaciInfo.InfoDetail)userObject;
                text = casted.key.equals("container_name") ? "needs: " + casted.value : (casted.key.equals("reference") ? "reference: " + (casted.value.equals("null") ? "invalid" : "ok") : (casted.key.equals("container") ? "hosted by: " + (casted.value.equals("0") ? "no container" : casted.value) : (casted.key.equals("access") ? "access: " + (casted.value.equals("0") ? "unrestricted" : casted.value) : casted.key + ": " + casted.value)));
                if (node instanceof MaciInfo.SortingTreeNode && ((MaciInfo.SortingTreeNode)node).representedHandles.length > 0) {
                    tooltip = "Right-Click for Navigation";
                }
            } else if (userObject instanceof MaciInfo.FolderInfo) {
                MaciInfo.FolderInfo info = (MaciInfo.FolderInfo)userObject;
                text = info.name;
                text = (String)text + " (" + node.getChildCount() + ")";
                if (info.hasFilter()) {
                    text = (String)text + ", showing only '" + info.filter + "'";
                }
                tooltip = "Right-Click for Filtering";
            } else {
                text = String.valueOf(node);
            }
            return new String[]{text, tooltip};
        }
    }
}

