/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.commandcenter.engine;

import alma.ACSErr.Completion;
import alma.acs.commandcenter.engine.NativeCommand;
import alma.acs.commandcenter.meta.Firestarter;
import alma.acs.commandcenter.trace.Flow;
import alma.acs.commandcenter.util.MiscUtils;
import alma.acs.commandcenter.util.PreparedString;
import alma.acs.commandcenter.util.StringRingBuffer;
import alma.acs.container.corba.AcsCorba;
import alma.acs.exceptions.AcsJCompletion;
import alma.acs.exceptions.AcsJException;
import alma.acs.util.AcsLocations;
import alma.acsdaemon.ContainerDaemon;
import alma.acsdaemon.ContainerDaemonHelper;
import alma.acsdaemon.DaemonSequenceCallback;
import alma.acsdaemon.DaemonSequenceCallbackHelper;
import alma.acsdaemon.DaemonSequenceCallbackPOA;
import alma.acsdaemon.ServicesDaemon;
import alma.acsdaemon.ServicesDaemonHelper;
import com.trilead.ssh2.Connection;
import com.trilead.ssh2.Session;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.StringHolder;
import org.omg.PortableServer.Servant;

public class Executor {
    public static boolean disableRemote = false;
    public static final String SYSPROP_COMMAND_NATIVE_SSH = "AcsCommandCenter.commandNativeSSH";
    public static RemoteFlow remoteFlow = new RemoteFlow();
    public static LocalInProcFlow localInProcFlow = new LocalInProcFlow();
    public static LocalOutProcFlow localOutProcFlow = new LocalOutProcFlow();
    public static SingleStepFlow singleStepFlow = new SingleStepFlow();
    public static RemoteServicesDaemonFlow remoteServicesDaemonFlow = new RemoteServicesDaemonFlow();
    public static RemoteContainerDaemonFlow remoteContainerDaemonFlow = new RemoteContainerDaemonFlow();
    private static Logger log = MiscUtils.getPackageLogger(Executor.class);
    protected static Vector<Connection> connections = new Vector();
    protected static Vector<Session> sessions = new Vector();
    private static Vector<NativeCommand> remoteNativeTasks = new Vector();
    private static Firestarter firestarter;
    public static int remoteDaemonForContainersCompletionDelay;

    public static boolean remote(boolean nativeSSH, String username, String password, String command, String endMark, NativeCommand.Listener listener, String host) throws Throwable {
        if (nativeSSH) {
            return Executor.remoteNative(username, password, command, endMark, listener, host);
        }
        return Executor.remotePortable(username, password, command, endMark, listener, host);
    }

    public static void remoteDownAll() {
        Executor.remoteDownAllNative();
        Executor.remoteDownAllPortable();
    }

    private static boolean remotePortable(String username, String password, String command, String endMark, NativeCommand.Listener listener, String host) throws IOException {
        if (listener == null) {
            listener = new NativeCommand.ListenerAdapter();
        }
        try {
            block10: {
                remoteFlow.reset(null);
                Connection conn = new Connection(host);
                connections.add(conn);
                conn.connect();
                remoteFlow.success("Connect");
                boolean isAuthenticated = conn.authenticateWithPassword(username, password);
                if (!isAuthenticated) {
                    throw new IOException("Authentication failed");
                }
                remoteFlow.success("Log In");
                Session sess = conn.openSession();
                sessions.add(sess);
                command = ". ~/.bash_profile ; " + (String)command;
                log.info("Now sending: '" + (String)command + "'");
                sess.execCommand((String)command);
                remoteFlow.success("Send Command");
                SearchBuffer searchStdout = null;
                SearchBuffer searchStderr = null;
                if (endMark != null) {
                    searchStdout = new SearchBuffer(endMark);
                    searchStderr = new SearchBuffer(endMark);
                }
                InputStream stdout = sess.getStdout();
                InputStream stderr = sess.getStderr();
                byte[] buffer = new byte[8192];
                while (true) {
                    int len;
                    if (stdout.available() == 0 && stderr.available() == 0) {
                        int conditions = sess.waitForCondition(28, 10000L);
                        if ((conditions & 1) != 0) {
                            throw new IOException("Timeout while waiting for data from peer");
                        }
                        if ((conditions & 0x10) != 0 && (conditions & 0xC) == 0) break block10;
                    }
                    if (stdout.available() > 0) {
                        len = stdout.read(buffer);
                        listener.stdoutWritten(null, new String(buffer, 0, len));
                        if (searchStdout != null && searchStdout.add(buffer, 0, len)) {
                            remoteFlow.success("Command Completion");
                            break block10;
                        }
                    }
                    if (stderr.available() <= 0) continue;
                    len = stderr.read(buffer);
                    listener.stdoutWritten(null, new String(buffer, 0, len));
                    if (searchStderr != null && searchStderr.add(buffer, 0, len)) break;
                }
                remoteFlow.success("Command Completion");
            }
            return true;
        }
        catch (IOException exc) {
            remoteFlow.failure(exc);
            return false;
        }
    }

    private static void remoteDownAllPortable() {
        for (Session sess : sessions) {
            try {
                sess.close();
                log.fine("closed " + sess);
            }
            catch (Exception exc) {
                log.fine("could not close " + sess);
            }
        }
        for (Connection conn : connections) {
            try {
                conn.close();
                log.fine("closed " + conn);
            }
            catch (Exception exc) {
                log.fine("could not close " + conn);
            }
        }
    }

    private static boolean remoteNative(String username, String password, String command, String endMark, NativeCommand.Listener listener, String host) throws Throwable {
        localOutProcFlow.reset(null);
        if (listener == null) {
            listener = new NativeCommand.ListenerAdapter();
        }
        String sshPatternDefault = "ssh -X -t -l ? ? /bin/bash --login -c \"?\"";
        String sshPattern = System.getProperty(SYSPROP_COMMAND_NATIVE_SSH, sshPatternDefault);
        PreparedString prep = new PreparedString(sshPattern);
        String sshCommand = prep.toString(new String[]{username, host, command});
        boolean foreground = true;
        long maxExecutionTime = -1L;
        endMark = ".*" + (String)endMark + ".*";
        NativeCommand task = new NativeCommand(sshCommand, foreground, maxExecutionTime, (String)endMark);
        remoteNativeTasks.add(task);
        task.addListener(listener);
        task.addListener(new NativeCommand.ListenerAdapter(){

            @Override
            public void statusChanged(NativeCommand task, String oldStatus) {
                if (task.getStatus() == "running") {
                    localOutProcFlow.success("Process Launch");
                }
            }
        });
        task.run();
        Throwable latestExc = task.getLatestException();
        log.info("Process invoked. Process is now: " + task.getStatus() + ". Exitcode: " + (task.getExitValue() != null ? task.getExitValue().toString() : "none (yet)") + ". Command was '" + command + "'");
        if (latestExc != null) {
            log.fine("During process invocation (at least) one error occurred: " + latestExc);
            remoteFlow.failure(latestExc);
            throw latestExc;
        }
        localOutProcFlow.success("Process Completion");
        return true;
    }

    private static void remoteDownAllNative() {
        Enumeration<NativeCommand> en = remoteNativeTasks.elements();
        while (en.hasMoreElements()) {
            NativeCommand t = null;
            try {
                t = en.nextElement();
                t.process.destroy();
            }
            catch (Exception e) {
                log.finer("Failed to destroy native-ssh task " + t);
            }
        }
    }

    public static void localInProc(Properties properties, String pexpect, NativeCommand.Listener listener, final RunMain runMain) {
        if (listener == null) {
            listener = new NativeCommand.ListenerAdapter();
        }
        localInProcFlow.reset(null);
        System.getProperties().putAll((Map<?, ?>)properties);
        LocalInProcStream outstream = new LocalInProcStream();
        outstream.setListener(listener);
        outstream.setConsumer(Thread.currentThread(), pexpect);
        System.setOut(new PrintStream(outstream));
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    runMain.runMain();
                }
                catch (Throwable exc) {
                    localInProcFlow.failure(exc);
                }
            }
        };
        t.start();
        localInProcFlow.success("Thread Start");
        try {
            Thread.sleep(Long.MAX_VALUE);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        localInProcFlow.success("Delegate Up");
    }

    public static void local(RunMain runMain) {
        singleStepFlow.reset(null);
        try {
            runMain.runMain();
        }
        catch (Throwable exc) {
            singleStepFlow.failure(exc);
        }
        singleStepFlow.success("Task completion");
    }

    public static void localOutProc(String command, boolean foreground, long maxExecutionTime, String endMark, NativeCommand.Listener listener) throws Throwable {
        Executor.localOutProc(command, null, foreground, maxExecutionTime, endMark, listener);
    }

    public static void localOutProc(String command, String environ, boolean foreground, long maxExecutionTime, String endMark, NativeCommand.Listener listener) throws Throwable {
        if (listener == null) {
            listener = new NativeCommand.ListenerAdapter();
        }
        localOutProcFlow.reset(null);
        log.fine("Now executing: '" + command + "'");
        NativeCommand task = new NativeCommand(command, environ, foreground, maxExecutionTime, ".*" + endMark + ".*");
        task.addListener(listener);
        task.addListener(new NativeCommand.ListenerAdapter(){

            @Override
            public void statusChanged(NativeCommand task, String oldStatus) {
                if (task.getStatus() == "running") {
                    localOutProcFlow.success("Process Launch");
                }
            }
        });
        task.run();
        Throwable latestExc = task.getLatestException();
        log.info("Process invoked. Process is now: " + task.getStatus() + ". Exitcode: " + (task.getExitValue() != null ? task.getExitValue().toString() : "none (yet)") + ". Command was '" + command + "'");
        if (latestExc != null) {
            log.fine("During process invocation (at least) one error occurred: " + latestExc);
            localOutProcFlow.failure(latestExc);
            throw latestExc;
        }
        localOutProcFlow.success("Process Completion");
    }

    public static void remoteDaemonEnable(Firestarter fs) {
        firestarter = fs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Exception remoteDaemonForServices(String host, int instance, boolean startStop, String cmdFlags, NativeCommand.Listener listener) {
        if (listener != null) {
            listener.stdoutWritten(null, "\nIn daemon mode, output cannot be displayed.\nSee logs in <daemon-owner>/.acs/commandcenter on host " + host + "\n");
        }
        String info = (startStop ? "Starting" : "Stopping") + " Acs Suite on host '" + host + "' (instance " + instance + ")";
        remoteServicesDaemonFlow.reset(info);
        ServicesDaemon daemon = null;
        String step = "";
        try {
            AcsCorba acsCorba = null;
            remoteServicesDaemonFlow.trying("Assert corba connectivity");
            step = "access acs-corba object";
            acsCorba = firestarter.giveAcsCorba();
            step = "access orb";
            ORB orb = acsCorba.getORB();
            remoteServicesDaemonFlow.success("Assert corba connectivity");
            remoteServicesDaemonFlow.trying("Connect to acsservicesdaemon");
            step = "convert host name to daemon address";
            String daemonLoc = AcsLocations.convertToServicesDaemonLocation((String)host);
            step = "convert daemon address to corba reference";
            Object object = orb.string_to_object(daemonLoc);
            step = "narrow corba reference to daemon object";
            daemon = ServicesDaemonHelper.narrow((Object)object);
            step = "sanity check daemon object";
            if (daemon == null) {
                throw new NullPointerException("received null trying to retrieve acsdaemon " + daemonLoc);
            }
            try {
                if (daemon._non_existent()) {
                    log.log(Level.INFO, "acsdaemon '" + daemonLoc + "' reported as non_existent, trying to use it nonetheless.");
                }
            }
            catch (Exception exc) {
                log.log(Level.INFO, "problem verifying acsdaemon " + daemonLoc + " exists, trying to use it anyhow.", exc);
            }
            remoteServicesDaemonFlow.success("Connect to acsservicesdaemon");
            remoteServicesDaemonFlow.trying("Send command to daemon");
            final ArrayBlockingQueue sync = new ArrayBlockingQueue(1);
            DaemonSequenceCallbackPOA daemonCallbackImpl = new DaemonSequenceCallbackPOA(){

                public void done(Completion comp) {
                    sync.add(comp);
                }

                public void working(String service, String host, short instance_number, Completion comp) {
                }
            };
            step = "create daemon callback";
            DaemonSequenceCallback daemonCallback = DaemonSequenceCallbackHelper.narrow((Object)acsCorba.activateOffShoot((Servant)daemonCallbackImpl, acsCorba.getRootPOA()));
            step = "send request to daemon";
            if (startStop) {
                daemon.start_acs(daemonCallback, (short)instance, cmdFlags);
            } else {
                daemon.stop_acs(daemonCallback, (short)instance, cmdFlags);
            }
            remoteServicesDaemonFlow.success("Send command to daemon");
            remoteServicesDaemonFlow.trying("Receive remote response");
            step = "poll on reply queue";
            long timeout = 10L;
            TimeUnit timeoutUnit = TimeUnit.MINUTES;
            Completion daemonReplyRaw = (Completion)sync.poll(timeout, timeoutUnit);
            if (daemonReplyRaw == null) {
                throw new RuntimeException("Timeout: Acs daemon did not " + (startStop ? "start" : "stop") + " Acs within " + timeout + " " + timeoutUnit);
            }
            step = "deserialize daemon response";
            AcsJCompletion daemonReply = AcsJCompletion.fromCorbaCompletion((Completion)daemonReplyRaw);
            if (daemonReply.isError()) {
                AcsJException exc = daemonReply.getAcsJException();
                throw new Exception("daemon responded with error " + exc.getMessage(), (Throwable)exc);
            }
            remoteServicesDaemonFlow.success("Receive remote response");
            Exception exception = null;
            return exception;
        }
        catch (Exception exc) {
            remoteServicesDaemonFlow.failure(exc);
            Exception exception = new Exception(remoteServicesDaemonFlow.current() + ":" + step + ": " + exc.getMessage(), exc);
            return exception;
        }
        finally {
            if (daemon != null) {
                try {
                    daemon._release();
                }
                catch (Exception exc) {
                    log.log(Level.INFO, "failure releasing internal resources for daemon, ignoring: " + exc.getMessage(), exc);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Exception remoteDaemonForContainers(String host, int instance, boolean startStop, String contName, String contType, String[] contTypeMods, String cmdFlags, NativeCommand.Listener listener) {
        if (listener != null) {
            listener.stdoutWritten(null, "\nIn daemon mode, output cannot be displayed.\nSee logs in <daemon-owner>/.acs/commandcenter on host " + host + "\n");
        }
        String info = (startStop ? "Starting" : "Stopping") + " container " + contName + " on host '" + host + "' (instance " + instance + ")";
        remoteContainerDaemonFlow.reset(info);
        ContainerDaemon daemon = null;
        String step = "";
        try {
            ORB orb = null;
            remoteContainerDaemonFlow.trying("Assert corba connectivity");
            step = "access orb";
            orb = firestarter.giveOrb();
            if (orb == null) {
                throw new NullPointerException("received null when trying to access local orb");
            }
            remoteContainerDaemonFlow.success("Assert corba connectivity");
            remoteContainerDaemonFlow.trying("Connect to acscontainerdaemon");
            step = "convert host name to daemon address";
            String daemonLoc = AcsLocations.convertToContainerDaemonLocation((String)host);
            step = "convert daemon address to corba reference";
            Object object = orb.string_to_object(daemonLoc);
            step = "narrow corba reference to daemon object";
            daemon = ContainerDaemonHelper.narrow((Object)object);
            step = "sanity check daemon object";
            if (daemon == null) {
                throw new NullPointerException("received null trying to retrieve acsdaemon " + daemonLoc);
            }
            try {
                if (daemon._non_existent()) {
                    log.log(Level.INFO, "acsdaemon '" + daemonLoc + "' reported as non_existent, trying to use it nonetheless.");
                }
            }
            catch (Exception exc) {
                log.log(Level.INFO, "problem verifying acsdaemon " + daemonLoc + " exists, trying to use it anyhow.", exc);
            }
            remoteContainerDaemonFlow.success("Connect to acscontainerdaemon");
            remoteContainerDaemonFlow.trying("Send command to daemon");
            step = "send request to daemon";
            if (startStop) {
                daemon.start_container(contType, contName, (short)instance, contTypeMods, cmdFlags);
            } else {
                daemon.stop_container(contName, (short)instance, cmdFlags);
            }
            step = "wait for completion";
            try {
                Thread.sleep(remoteDaemonForContainersCompletionDelay);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            remoteContainerDaemonFlow.success("Send command to daemon");
            Exception exception = null;
            return exception;
        }
        catch (Exception exc) {
            remoteContainerDaemonFlow.failure(exc);
            Exception exception = new Exception(remoteContainerDaemonFlow.current() + ":" + step + ": " + exc.getMessage(), exc);
            return exception;
        }
        finally {
            if (daemon != null) {
                try {
                    daemon._release();
                }
                catch (Exception exc) {
                    log.log(Level.INFO, "failure releasing internal resources for daemon, ignoring: " + exc.getMessage(), exc);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Exception remoteDaemonForContainersStacktraceOrCoredump(String host, int instance, boolean stacktraceCoredump, String contName, String contType, String[] contTypeMods, String cmdFlags, NativeCommand.Listener listener) {
        if (listener != null) {
            listener.stdoutWritten(null, "\nIn daemon mode, output cannot be displayed.\nSee logs in <daemon-owner>/.acs/commandcenter on host " + host + "\n");
        }
        String info = (stacktraceCoredump ? "stacktrace" : "coredump") + " container " + contName + " on host '" + host + "' (instance " + instance + ")";
        remoteContainerDaemonFlow.reset(info);
        ContainerDaemon daemon = null;
        String step = "";
        try {
            ORB orb = null;
            remoteContainerDaemonFlow.trying("Assert corba connectivity");
            step = "access orb";
            orb = firestarter.giveOrb();
            if (orb == null) {
                throw new NullPointerException("received null when trying to access local orb");
            }
            remoteContainerDaemonFlow.success("Assert corba connectivity");
            remoteContainerDaemonFlow.trying("Connect to acscontainerdaemon");
            step = "convert host name to daemon address";
            String daemonLoc = AcsLocations.convertToContainerDaemonLocation((String)host);
            step = "convert daemon address to corba reference";
            Object object = orb.string_to_object(daemonLoc);
            step = "narrow corba reference to daemon object";
            daemon = ContainerDaemonHelper.narrow((Object)object);
            step = "sanity check daemon object";
            if (daemon == null) {
                throw new NullPointerException("received null trying to retrieve acsdaemon " + daemonLoc);
            }
            try {
                if (daemon._non_existent()) {
                    log.log(Level.INFO, "acsdaemon '" + daemonLoc + "' reported as non_existent, trying to use it nonetheless.");
                }
            }
            catch (Exception exc) {
                log.log(Level.INFO, "problem verifying acsdaemon " + daemonLoc + " exists, trying to use it anyhow.", exc);
            }
            remoteContainerDaemonFlow.success("Connect to acscontainerdaemon");
            remoteContainerDaemonFlow.trying("Send command to daemon");
            step = "send request to daemon";
            StringHolder output = new StringHolder();
            if (stacktraceCoredump) {
                daemon.get_container_stacktrace(contName, contType, output);
            } else {
                daemon.get_container_coredump(contName, contType, output);
            }
            step = "wait for completion";
            try {
                Thread.sleep(remoteDaemonForContainersCompletionDelay);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            remoteContainerDaemonFlow.success("Send command to daemon");
            Exception exception = null;
            return exception;
        }
        catch (Exception exc) {
            remoteContainerDaemonFlow.failure(exc);
            Exception exception = new Exception(remoteContainerDaemonFlow.current() + ":" + step + ": " + exc.getMessage(), exc);
            return exception;
        }
        finally {
            if (daemon != null) {
                try {
                    daemon._release();
                }
                catch (Exception exc) {
                    log.log(Level.INFO, "failure releasing internal resources for daemon, ignoring: " + exc.getMessage(), exc);
                }
            }
        }
    }

    static {
        remoteDaemonForContainersCompletionDelay = 2500;
    }

    static class SearchBuffer {
        byte[] search;
        byte[] data;
        int next = 0;
        boolean isFillingUp = true;

        SearchBuffer(String searched) {
            this.search = searched.getBytes();
            this.data = new byte[this.search.length];
        }

        boolean add(byte[] bytes, int off, int len) {
            for (int i = off; i < off + len; ++i) {
                if (!this.add(bytes[i])) continue;
                return true;
            }
            return false;
        }

        boolean add(byte b) {
            this.data[this.next] = b;
            ++this.next;
            if (this.next == this.data.length) {
                this.next = 0;
            }
            if (this.isFillingUp && this.next == 0) {
                this.isFillingUp = false;
            }
            if (this.isFillingUp) {
                return false;
            }
            int otherIdx = 0;
            int idx = this.next;
            while (idx < this.data.length) {
                if (this.data[idx] != this.search[otherIdx]) {
                    return false;
                }
                ++idx;
                ++otherIdx;
            }
            idx = 0;
            while (idx < this.next) {
                if (this.data[idx] != this.search[otherIdx]) {
                    return false;
                }
                ++idx;
                ++otherIdx;
            }
            return true;
        }
    }

    public static class RemoteContainerDaemonFlow
    extends Flow {
        static final String INIT_CORBA = "Assert corba connectivity";
        static final String CONNECT_DAEMON = "Connect to acscontainerdaemon";
        static final String SEND_COMMAND = "Send command to daemon";

        public RemoteContainerDaemonFlow() {
            this.consistsOf(null, new String[]{INIT_CORBA, CONNECT_DAEMON, SEND_COMMAND});
        }
    }

    public static class RemoteServicesDaemonFlow
    extends Flow {
        static final String INIT_CORBA = "Assert corba connectivity";
        static final String CONNECT_DAEMON = "Connect to acsservicesdaemon";
        static final String SEND_COMMAND = "Send command to daemon";
        static final String AWAIT_RESPONSE = "Receive remote response";

        public RemoteServicesDaemonFlow() {
            this.consistsOf(null, new String[]{INIT_CORBA, CONNECT_DAEMON, SEND_COMMAND, AWAIT_RESPONSE});
        }
    }

    public static class LocalOutProcFlow
    extends Flow {
        static final String RUN = "Process Launch";
        static final String COMPLETE = "Process Completion";

        public LocalOutProcFlow() {
            this.consistsOf(null, new String[]{RUN, COMPLETE});
        }
    }

    public static class SingleStepFlow
    extends Flow {
        static final String DONE = "Task completion";

        public SingleStepFlow() {
            this.consistsOf(null, new String[]{DONE});
        }
    }

    public static class LocalInProcFlow
    extends Flow {
        static final String START = "Thread Start";
        static final String ALIVE = "Delegate Up";

        public LocalInProcFlow() {
            this.consistsOf(null, new String[]{START, ALIVE});
        }
    }

    public static interface RunMain {
        public void runMain() throws Throwable;
    }

    protected static class LocalInProcStream
    extends OutputStream {
        String search;
        Thread consumer;
        StringRingBuffer searchBuff;
        NativeCommand.Listener listener;
        StringBuffer lineBuffer = new StringBuffer(512);

        protected LocalInProcStream() {
        }

        void setListener(NativeCommand.Listener listener) {
            this.listener = listener;
        }

        void setConsumer(Thread consumer, String search) {
            this.consumer = consumer;
            this.search = search;
            if (search != null) {
                this.searchBuff = new StringRingBuffer(search.length());
            }
        }

        @Override
        public void write(int b) throws IOException {
            char c = (char)b;
            if (this.listener != null) {
                this.lineBuffer.append(c);
                if (c == '\n') {
                    this.listener.stdoutWritten(null, this.lineBuffer.toString());
                    this.lineBuffer.setLength(0);
                }
            }
            if (this.search != null && this.searchBuff != null) {
                this.searchBuff.add(c);
                if (this.searchBuff.equals(this.search)) {
                    this.consumer.interrupt();
                }
            }
        }
    }

    public static class RemoteFlow
    extends Flow {
        static final String CONNECT = "Connect";
        static final String LOG_IN = "Log In";
        static final String SEND_COMMAND = "Send Command";
        static final String COMPLETE = "Command Completion";

        public RemoteFlow() {
            this.consistsOf(null, new String[]{CONNECT, LOG_IN, SEND_COMMAND, COMPLETE});
        }
    }
}

